library(logcondiscr)
library(MASS)
library(VGAM)
source("double_log.R")
source("unimodal_nonconvex.R")


#------------------------------------------------
# CASE THREE: negative binomial

supp		<-	0:100
r			<-	6
p0			<-	0.3	
true		<-	dnbinom(supp, size=r, prob=p0)
sum(true)

B			<-	1000
n			<-	50
res1		<-	rep(0,B)
res2		<-	rep(0,B)
res3		<-	rep(0,B)

set.seed(7223924)

for(i in 1:B){
	
	x			<-	rnbinom(n, size=r, prob=p0)
		
	fit1		<-	rep(0,length(supp))
	loc1		<-	which(supp==min(x))+sort(unique(x))-min(x)
	fit1[loc1]	<-	as.vector(table(x))/n
	fit2		<-	rep(0,length(supp))
	mle2		<-	findNCMLE(x)
	loc2		<-	which(supp==min(mle2$supp))+mle2$supp-min(mle2$supp)
	fit2[loc2]	<-	mle2$mle
	fit3		<-	rep(0,length(supp))
	mle3		<-	logConDiscrMLE(x)
	loc3		<-	which(supp==min(mle3$xSupp))+mle3$xSupp-min(mle3$xSupp)
	fit3[loc3]	<-	exp(mle3$psiSupp)
	
	res1[i]		<-	sqrt(sum((fit1-true)^2))
	res2[i]		<-	sqrt(sum((fit2-true)^2))
	res3[i]		<-	sqrt(sum((fit3-true)^2))

	print(i)
		
}

nbin50		<-	c(res1, res2, res3)



B			<-	1000
n			<-	200
res1		<-	rep(0,B)
res2		<-	rep(0,B)
res3		<-	rep(0,B)

set.seed(7223924)

for(i in 1:B){
	
	x			<-	rnbinom(n, size=r, prob=p0)
		
	fit1		<-	rep(0,length(supp))
	loc1		<-	which(supp==min(x))+sort(unique(x))-min(x)
	fit1[loc1]	<-	as.vector(table(x))/n
	fit2		<-	rep(0,length(supp))
	mle2		<-	findNCMLE(x)
	loc2		<-	which(supp==min(mle2$supp))+mle2$supp-min(mle2$supp)
	fit2[loc2]	<-	mle2$mle
	fit3		<-	rep(0,length(supp))
	mle3		<-	logConDiscrMLE(x)
	loc3		<-	which(supp==min(mle3$xSupp))+mle3$xSupp-min(mle3$xSupp)
	fit3[loc3]	<-	exp(mle3$psiSupp)
	
	res1[i]		<-	sqrt(sum((fit1-true)^2))
	res2[i]		<-	sqrt(sum((fit2-true)^2))
	res3[i]		<-	sqrt(sum((fit3-true)^2))

	print(i)
		
}

nbin200		<-	c(res1, res2, res3)

B			<-	1000
n			<-	500
res1		<-	rep(0,B)
res2		<-	rep(0,B)
res3		<-	rep(0,B)

set.seed(7223924)

for(i in 1:B){
	
	x			<-	rnbinom(n, size=r, prob=p0)
		
	fit1		<-	rep(0,length(supp))
	loc1		<-	which(supp==min(x))+sort(unique(x))-min(x)
	fit1[loc1]	<-	as.vector(table(x))/n
	fit2		<-	rep(0,length(supp))
	mle2		<-	findNCMLE(x)
	loc2		<-	which(supp==min(mle2$supp))+mle2$supp-min(mle2$supp)
	fit2[loc2]	<-	mle2$mle
	fit3		<-	rep(0,length(supp))
	mle3		<-	logConDiscrMLE(x)
	loc3		<-	which(supp==min(mle3$xSupp))+mle3$xSupp-min(mle3$xSupp)
	fit3[loc3]	<-	exp(mle3$psiSupp)
	
	res1[i]		<-	sqrt(sum((fit1-true)^2))
	res2[i]		<-	sqrt(sum((fit2-true)^2))
	res3[i]		<-	sqrt(sum((fit3-true)^2))

	print(i)
		
}

nbin500		<-	c(res1, res2, res3)


postscript("box_nbinom_largen.eps", horizontal=FALSE, height=6, width=6, pointsize=13)
pdf("box_nbinom_largen.pdf", onefile=FALSE, height=6, width=6, pointsize=13)

xx			<-	c("(1)","(2)","(3)")
par(mar = c(2, 2.75, 2, 1), las=1)
boxplot(nbin50~rep(xx, each=B), col=gray(0.4), xlim=c(0,12), range=0, main="negative binomial", ylim=c(0, 0.25))
boxplot(nbin200~rep(xx, each=B), col=gray(0.7), at=5:7, add=TRUE, range=0)
boxplot(nbin500~rep(xx, each=B), col=gray(0.95), at=9:11, add=TRUE, range=0)
legend("topright", c("n=50", "n=200", "n=500"), pch = c(15, 15), col = c(grey(0.4), gray(0.7), gray(0.95)), bty="n")

dev.off()

