library(logcondiscr)
library(MASS)
library(VGAM)
source("double_log.R")
source("unimodal_nonconvex.R")

rdunif 	<- 	function(n, k)	sample(1:k, n, replace=TRUE)
ddunif	<-	function(x, k)	ifelse(x>=1 & x<=k & round(x)==x, 1/k, 0)


supp		<-	1:50
p1			<-	ddunif(supp, k=10)
p2			<-	ddunif(supp, k=40)
p3			<-	ddunif(supp, k=50)	
true		<-	(1/3)*p1+(1/3)*p2+(1/3)*p3
sum(true)



# how non log-concave is this pmf?
KL			<-	logConDiscrMLE(x=supp, w=true)
plot(supp, true, type="l", ylim=c(0,0.1))
lines(supp, exp(KL$psiSupp), col="red")
sqrt(sum((exp(KL$psiSupp)-true)^2))


B			<-	1000
n			<-	50
res1		<-	rep(0,B)
res2		<-	rep(0,B)
res3		<-	rep(0,B)

set.seed(7223924)

for(i in 1:B){
	
	x			<-	sample(supp, size=n, replace=TRUE, prob=true)
		
	fit1		<-	rep(0,length(supp))
	loc1		<-	which(supp==min(x))+sort(unique(x))-min(x)
	fit1[loc1]	<-	as.vector(table(x))/n
	fit2		<-	rep(0,length(supp))
	mle2		<-	findNCMLE(x)
	loc2		<-	which(supp==min(mle2$supp))+mle2$supp-min(mle2$supp)
	fit2[loc2]	<-	mle2$mle
	fit3		<-	rep(0,length(supp))
	mle3		<-	logConDiscrMLE(x)
	loc3		<-	which(supp==min(mle3$xSupp))+mle3$xSupp-min(mle3$xSupp)
	fit3[loc3]	<-	exp(mle3$psiSupp)
	
	res1[i]		<-	sqrt(sum((fit1-true)^2))
	res2[i]		<-	sqrt(sum((fit2-true)^2))
	res3[i]		<-	sqrt(sum((fit3-true)^2))

	print(i)
		
}

piecewise50		<-	c(res1, res2, res3)



B			<-	1000
n			<-	200
res1		<-	rep(0,B)
res2		<-	rep(0,B)
res3		<-	rep(0,B)

set.seed(7223924)

for(i in 1:B){
	
	x			<-	sample(supp, size=n, replace=TRUE, prob=true)
		
	fit1		<-	rep(0,length(supp))
	loc1		<-	which(supp==min(x))+sort(unique(x))-min(x)
	fit1[loc1]	<-	as.vector(table(x))/n
	fit2		<-	rep(0,length(supp))
	mle2		<-	findNCMLE(x)
	loc2		<-	which(supp==min(mle2$supp))+mle2$supp-min(mle2$supp)
	fit2[loc2]	<-	mle2$mle
	fit3		<-	rep(0,length(supp))
	mle3		<-	logConDiscrMLE(x)
	loc3		<-	which(supp==min(mle3$xSupp))+mle3$xSupp-min(mle3$xSupp)
	fit3[loc3]	<-	exp(mle3$psiSupp)
	
	res1[i]		<-	sqrt(sum((fit1-true)^2))
	res2[i]		<-	sqrt(sum((fit2-true)^2))
	res3[i]		<-	sqrt(sum((fit3-true)^2))

	print(i)
		
}

piecewise200		<-	c(res1, res2, res3)



B			<-	1000
n			<-	500
res1		<-	rep(0,B)
res2		<-	rep(0,B)
res3		<-	rep(0,B)

set.seed(7223924)

for(i in 1:B){
	
	x			<-	sample(supp, size=n, replace=TRUE, prob=true)
		
	fit1		<-	rep(0,length(supp))
	loc1		<-	which(supp==min(x))+sort(unique(x))-min(x)
	fit1[loc1]	<-	as.vector(table(x))/n
	fit2		<-	rep(0,length(supp))
	mle2		<-	findNCMLE(x)
	loc2		<-	which(supp==min(mle2$supp))+mle2$supp-min(mle2$supp)
	fit2[loc2]	<-	mle2$mle
	fit3		<-	rep(0,length(supp))
	mle3		<-	logConDiscrMLE(x)
	loc3		<-	which(supp==min(mle3$xSupp))+mle3$xSupp-min(mle3$xSupp)
	fit3[loc3]	<-	exp(mle3$psiSupp)
	
	res1[i]		<-	sqrt(sum((fit1-true)^2))
	res2[i]		<-	sqrt(sum((fit2-true)^2))
	res3[i]		<-	sqrt(sum((fit3-true)^2))

	print(i)
		
}

piecewise500		<-	c(res1, res2, res3)



postscript("box_mixture2_largen.eps", horizontal=FALSE, height=6, width=6, pointsize=13)
pdf("box_mixture2_largen.pdf", onefile=FALSE, height=6, width=6, pointsize=13)

xx			<-	c("(1)","(2)","(3)")
par(mar = c(2, 2.75, 2, 1), las=1)
boxplot(piecewise50~rep(xx, each=B), col=gray(0.4), xlim=c(0,12), range=0, main="uniform mixture", ylim=c(0, 0.25))
boxplot(piecewise200~rep(xx, each=B), col=gray(0.7), at=5:7, add=TRUE, range=0)
boxplot(piecewise500~rep(xx, each=B), col=gray(0.95), at=9:11, add=TRUE, range=0)
legend("topright", c("n=50", "n=200", "n=500"), pch = c(15, 15), col = c(grey(0.4), gray(0.7), gray(0.95)), bty="n")

dev.off()


