library(MASS)
library(VGAM)
source("double_log.R")
source("unimodal.R")
source("unimodal_nonconvex.R")


#------------------------------------------------
# CASE FIVE: Poisson mixture

supp		<-	0:30
p1			<-	dpois(supp, lambda=1)
p2			<-	dpois(supp, lambda=3)
p3			<-	dpois(supp, lambda=8)	
true		<-	(1/4)*p1+(1/8)*p2+(5/8)*p3
sum(true)

# how non log-concave is this pmf?
KL			<-	logConDiscrMLE(x=supp, w=true)
plot(supp, true, type="l")
lines(supp, exp(KL$psiSupp), col="red")
sqrt(sum((exp(KL$psiSupp)-true)^2))


rtrue		<-	function(n){
	
	x1		<-	rpois(n, lambda=1)
	x2		<-	rpois(n, lambda=3)
	x3		<-	rpois(n, lambda=8)
	uu		<-	sample(1:3, size=n, replace=TRUE, prob=c(1/4, 1/8, 5/8))
	x		<-	x1*(uu==1)+x2*(uu==2)+x3*(uu==3)
	
	return(x)
}

#x	<-	rtrue(100000)
#plot(ecdf(x))
#lines(supp,cumsum(true), col="red")

B			<-	1000
n			<-	50
res1		<-	rep(0,B)
res2		<-	rep(0,B)

set.seed(7223924)

for(i in 1:B){
	
	x			<-	rtrue(n)
		
	fit1		<-	rep(0,length(supp))
	mle1		<-	findMLE(x)
	loc1		<-	which(supp==min(mle1$supp))+mle1$supp-min(mle1$supp)
	fit1[loc1]	<-	mle1$mle
	fit2		<-	rep(0,length(supp))
	mle2		<-	findNCMLE(x)
	loc2		<-	which(supp==min(mle2$supp))+mle2$supp-min(mle2$supp)
	fit2[loc2]	<-	mle2$mle
	
	res1[i]		<-	sqrt(sum((fit1-true)^2))
	res2[i]		<-	sqrt(sum((fit2-true)^2))

	print(i)
		
}

res50		<-	c(res1, res2)



B			<-	1000
n			<-	200
res1		<-	rep(0,B)
res2		<-	rep(0,B)

set.seed(7223924)

for(i in 1:B){
	
	x			<-	rtrue(n)
		
	fit1		<-	rep(0,length(supp))
	mle1		<-	findMLE(x)
	loc1		<-	which(supp==min(mle1$supp))+mle1$supp-min(mle1$supp)
	fit1[loc1]	<-	mle1$mle
	fit2		<-	rep(0,length(supp))
	mle2		<-	findNCMLE(x)
	loc2		<-	which(supp==min(mle2$supp))+mle2$supp-min(mle2$supp)
	fit2[loc2]	<-	mle2$mle
	
	res1[i]		<-	sqrt(sum((fit1-true)^2))
	res2[i]		<-	sqrt(sum((fit2-true)^2))

	print(i)
		
}

res200		<-	c(res1, res2)

postscript("box_poisson_mix_support.eps", horizontal=FALSE, height=6, width=6, pointsize=13)
pdf("box_poisson_mix_support.pdf", onefile=FALSE, height=6, width=6, pointsize=13)

xx			<-	c("(a)","(b)")
par(mar = c(2, 2.75, 2, 1), las=1)
boxplot(res50~rep(xx, each=B), col=gray(0.4), xlim=c(0,6), range=0, main="Poisson mixture", ylim=c(0, 0.25))
boxplot(res200~rep(xx, each=B), col=gray(0.9), at=4:5, add=TRUE, range=0)
legend("topright", c("n=50", "n=200"), pch = c(15, 15), col = c(grey(0.4), gray(0.9)), bty="n")

dev.off()

