# June 14, 2013
# Comparison of the two support approaches (known vs unkown) for small/mid sample sizes


library(MASS)
library(VGAM)
source("double_log.R")
source("unimodal.R")
source("unimodal_nonconvex.R")



#------------------------------------------------
# CASE THREE: negative binomial

supp		<-	0:100
r			<-	6
p0			<-	0.3	
true		<-	dnbinom(supp, size=r, prob=p0)
sum(true)

B			<-	1000
n			<-	50
res1		<-	rep(0,B)
res2		<-	rep(0,B)

set.seed(7223924)

for(i in 1:B){
	
	x			<-	rnbinom(n, size=r, prob=p0)
		
	fit1		<-	rep(0,length(supp))
	mle1		<-	findMLE(x)
	loc1		<-	which(supp==min(mle1$supp))+mle1$supp-min(mle1$supp)
	fit1[loc1]	<-	mle1$mle
	fit2		<-	rep(0,length(supp))
	mle2		<-	findNCMLE(x)
	loc2		<-	which(supp==min(mle2$supp))+mle2$supp-min(mle2$supp)
	fit2[loc2]	<-	mle2$mle
	
	res1[i]		<-	sqrt(sum((fit1-true)^2))
	res2[i]		<-	sqrt(sum((fit2-true)^2))

	print(i)
		
}

nbin50supp		<-	c(res1, res2)



B			<-	1000
n			<-	200
res1		<-	rep(0,B)
res2		<-	rep(0,B)

set.seed(7223924)

for(i in 1:B){
	
	x			<-	rnbinom(n, size=r, prob=p0)
		
	fit1		<-	rep(0,length(supp))
	mle1		<-	findMLE(x)
	loc1		<-	which(supp==min(mle1$supp))+mle1$supp-min(mle1$supp)
	fit1[loc1]	<-	mle1$mle
	fit2		<-	rep(0,length(supp))
	mle2		<-	findNCMLE(x)
	loc2		<-	which(supp==min(mle2$supp))+mle2$supp-min(mle2$supp)
	fit2[loc2]	<-	mle2$mle
	
	res1[i]		<-	sqrt(sum((fit1-true)^2))
	res2[i]		<-	sqrt(sum((fit2-true)^2))

	print(i)
		
}

nbin200supp		<-	c(res1, res2)

postscript("box_nbinomial_supp.eps", horizontal=FALSE, height=6, width=6, pointsize=13)
pdf("box_nbinomial_supp.pdf", onefile=FALSE, height=6, width=6, pointsize=13)

xx			<-	c("(a)","(b)")
par(mar = c(2, 2.75, 2, 1), las=1)
boxplot(nbin50supp~rep(xx, each=B), col=gray(0.4), xlim=c(0,6), range=0, main="negative binomial", ylim=c(0, 0.25))
boxplot(nbin200supp~rep(xx, each=B), col=gray(0.9), at=4:5, add=TRUE, range=0)
legend("topright", c("n=50", "n=200"), pch = c(15, 15), col = c(grey(0.4), gray(0.9)), bty="n")

dev.off()


