# Hanna Jankowski, June 13, 2013
# modified June 14th, 2013 (to keep track of full LSE and MLE info)


findNCUP		<-	function(m.loc, emp){
	
					# find increasing part
					loc.up		<-	1:(m.loc-1)
					en			<-	length(loc.up)
					pts.y		<-	c(0,cumsum(emp[loc.up]),max(cumsum(emp[loc.up])))
					pts.x		<-	c(0:en,0)
					pts    		<-  cbind(pts.x, pts.y)
					hpts		<-	chull(pts)
					lcm			<-	sort(hpts)
					lcm			<-	lcm[-length(lcm)]
					yy			<-	pts.y[lcm]
					xx			<-	pts.x[lcm]
					mle.up		<-	diff(yy)/diff(xx)
					
					return(rep(mle.up, diff(xx)))
				
				}

findNCDOWN	<-	function(m.loc, emp){
	
					# find decreasing part
					loc.down	<-	m.loc:length(emp)
					en			<-	length(loc.down)
					pts.y		<-	c(0,cumsum(emp[loc.down]),0)
					pts.x		<-	c(0:en,en)
					pts    		<-  cbind(pts.x, pts.y)
					hpts		<-	chull(pts)
					lcm			<-	sort(hpts)
					lcm			<-	lcm[-length(lcm)]
					yy			<-	pts.y[lcm]
					xx			<-	pts.x[lcm]
					mle.down	<-	diff(yy)/diff(xx)
					
					return(rep(mle.down, diff(xx)))
	
				}


findNCMLE		<-	function(x){

# calculate empirical distribution
loc			<-	sort(unique(x))
supp		<-	1:length(loc)
emp			<-	as.vector(table(x))/length(x)

mle.search	<-	matrix(0, nrow=length(supp)+1, ncol=length(supp))
lik.search	<-	rep(0, length(supp))
lse.search	<-	rep(0, length(supp))

for(i in 1:(length(supp)+1)){
		
	m.loc	<-	i
	if(i==1){mle.up	<- numeric(0)} else {mle.up <- findNCUP(m.loc, emp)}
	if(i==(length(supp)+1)){mle.down <- numeric(0)} else {mle.down <- findNCDOWN(m.loc, emp)}
	
	mle		<- 	c(mle.up, mle.down)
	lik		<-	sum(log(mle)*emp)
	lse		<-	sqrt(sum((mle-emp)^2))
	mle.search[i,]	<-	mle
	lik.search[i]	<-	lik
	lse.search[i]	<-	lse
	
}

mle.loc	<-	min(which(lik.search==max(lik.search)))
mle		<-	mle.search[mle.loc,]
lik		<-	lik.search[mle.loc]

return(list(mle=mle, emp=emp, supp=loc, lik=lik, mle.search=mle.search, lik.search=lik.search, lse.search=lse.search, mle.loc=which(lik.search==max(lik.search))))
}

