library("MASS")

funCI	<-	function(x, mle, beta, B=100000){
	
	n		<-	length(x)
	phat	<-	mle$mle
	supp	<-	mle$supp
	SIGMA	<-	diag(phat^(1-2*beta), length(phat))-t(t(phat^(1-beta)))%*%t(phat^(1-beta))

	res		<-	mvrnorm(B, mu=rep(0,length(phat)), Sigma=SIGMA)
	res		<-	abs(res)
	res		<-	apply(res, 1, max)
	q0		<-	quantile(res, 0.95)
	
	upp		<-	phat+(phat^beta)*q0/sqrt(n)
	low		<-	phat-(phat^beta)*q0/sqrt(n)
	low		<-	pmax(0, low)

	return(list(low=low, upp=upp))
}



