# September 15th, 2014
# ebola data from http://www.nejm.org/doi/full/10.1056/NEJMp1410540?query=featured_home
# TIME OF ONSET of Ebola, based on transmission route in Zaire, 1976

source("unimodal.R")
source("ci_function.R")


#-------------------------------------------------#
# fitting unimodal PMFs and global confidence bands

xx		<-	1:21
beta	<-	0
set.seed(6220671)


# Injection  
emp1	<-	c(1,6,4,7,8,7,8,5,3,2,1,1,0,3,1,0,0,0,0,0,0)
n1		<-	sum(emp1)
emp1	<-	emp1/n1 
mle1	<-	findMLE(rep(xx, emp1*n1))
ci1		<-	funCI(rep(xx, emp1*n1), mle1, beta=beta)


# Person-to-Person contact  
emp2	<-	c(0,8,7,7,5,8,8,8,7,9,6,6,4,4,6,7,0,3,3,1,1)
n2		<-	sum(emp2)
emp2	<-	emp2/n2
mle2	<-	findMLE(rep(xx, emp2*n2))
ci2		<-	funCI(rep(xx, emp2*n2), mle2, beta=beta)


# plot injection infections
par(las = 1, oma = c(0, 0, 0, 0), cex = 0.9, mar = c(2, 3, 3, 1))
plot(0, 0, type = "n", xlim = c(0,22), xlab = "", xaxt = "n", ylim = c(0, 0.25), ylab = "", main = "infected from injection")
axis(1, at = 0:22, labels = 0:22)
off <- 0.45
rect(xleft = xx - off, ybottom = 0, xright = xx + off, ytop = emp1, col = grey(0.8), border = grey(0.8)) # empirical
points(mle1$supp, mle1$mle, type="b", lwd=2)   #  mle (known support)
points(mle1$supp, ci1$low, type="l", lty=3, lwd=2)   
points(mle1$supp, ci1$up, type="l", lty=3, lwd=2)   
legend("topright", c("empirical PMF", "unimodal MLE", "confidence band"), pch = c(15,1,-1), lty = c(-1,1,3), col = c(grey(0.8),1,1), bty = "n", lwd = c(-1,2,2))


# plot person-to-person infections
par(las = 1, oma = c(0, 0, 0, 0), cex = 0.9, mar = c(2, 3, 3, 1))
plot(0, 0, type = "n", xlim = c(0,22), xlab = "", xaxt = "n", ylim = c(0, 0.25), ylab = "", main = "infected from person-to-person contact")
axis(1, at = 0:22, labels = 0:22)
off <- 0.45
rect(xleft = xx - off, ybottom = 0, xright = xx + off, ytop = emp2, col = grey(0.8), border = grey(0.8)) # empirical
points(mle2$supp, mle2$mle, type="b", lwd=2)   #  mle (known support)
points(mle2$supp, ci2$low, type="l", lty=3, lwd=2)   
points(mle2$supp, ci2$up, type="l", lty=3, lwd=2)   
legend("topright", c("empirical PMF", "unimodal MLE", "confidence band"), pch = c(15,1,-1), lty = c(-1,1,3), col = c(grey(0.8),1,1), bty = "n", lwd = c(-1,2,2))





#-------------------------------------------------#
# Are the two distributions the same?


F1		<-	cumsum(emp1)
F2		<-	cumsum(emp2)
F1hat	<-	cumsum(mle1$mle)
F2hat	<-	cumsum(mle2$mle)

# plot the various CDFs
par(las = 1, oma = c(0, 0, 0, 0), cex = 0.9, mar = c(2, 3, 3, 1))
plot(0, 0, type = "n", xlim = c(0,22), xlab = "", xaxt = "n", ylim = c(0, 1), ylab = "", main = "")
axis(1, at = 0:22, labels = 0:22)
points(xx, F1, pch=19, cex=0.8)
segments(x0=0:21,y0=c(0,F1), x1=1:22, y1=c(0,F1), lwd=2)
lines(mle1$supp, F1hat, pch=19, cex=0.8, lty=3, lwd=2)
points(xx, F2, pch=19, cex=0.8, col=grey(0.5))
segments(x0=0:21,y0=c(0,F2), x1=1:22, y1=c(0,F2), lwd=2, col=grey(0.5))
lines(mle2$supp, F2hat, pch=19, cex=0.8, col=grey(0.5), lty=3, lwd=2)
legend("bottomright", c("empirical CDF (injection)", "empirical CDF (person-to-person)", "unimodal CDF (injection)", "unimodal CDF (person-to-person)"), lty = c(1,1,3,3), col = c(1, grey(0.5), 1, grey(0.5)), lwd=2, inset=0.05, bty="n")



# permutation test 

D	<-	max(abs(F1-F2))
zz	<-	c(rep(xx, emp1*n1),rep(xx, emp2*n2))
B	<-	10000
res	<-	rep(0,B)
set.seed(2147388)
for(i in 1:B){
	zz		<-	sample(zz)
	zz1		<-	zz[1:n1]
	zz2		<-	zz[(n1+1):n2]
	res[i]	<-	ks.test(zz1, zz2)$statistic	
}
(sum(res>D)+1)/(B+1)
