# August 25, 2014
# pictures of confidence bands


library(VGAM)
source("ci_function.R")
source("double_log.R")


set.seed(519829)

n		<-	100
x		<-	rlogdouble(n, p=0.9)
mle		<-	findMLE(x)
ci0		<-	funCI(x, mle, beta=0)
emp		<-	table(x)/n

postscript("dlog_ci100.eps", onefile=FALSE, horizontal=FALSE, height=5, width=13, pointsize=13)
pdf("dlog_ci100.pdf", height=5, width=13, pointsize=13)

rr	<-	-27:27
par(las = 1, oma = c(0, 0, 0, 0), cex = 0.9, mar = c(2.5, 3, 1, 1))
plot(0, 0, type = "n", xlim=range(rr), xlab = "", xaxt = "n", ylim = c(0, 0.4), ylab = "", main = "")
axis(1, at = rr, labels = rr)
off <- 0.35
rect(xleft=mle$supp-off, ybottom=ci0$low, xright=mle$supp+off, ytop = ci0$upp, col = grey(0.8), border = grey(0.8)) 
points(mle$supp, mle$mle, pch=1, lwd = 2)
lines(rr, dlogdouble(rr, p=0.9), lwd=2, lty=1)
legend("topright", c("truth", "MLE", "conf. band"), pch = c(-1,1,15), lty = c(1,-1,-1), col = c(1,1,grey(0.8)), bty = "n", lwd = c(2,2,-1))

dev.off()



set.seed(519829)

n		<-	1000
x		<-	rlogdouble(n, p=0.9)
mle		<-	findMLE(x)
ci0		<-	funCI(x, mle, beta=0)
emp		<-	table(x)/n

postscript("dlog_ci1000.eps", onefile=FALSE, horizontal=FALSE, height=5, width=13, pointsize=13)
pdf("dlog_ci1000.pdf", height=5, width=13, pointsize=13)

rr	<-	-27:27
par(las = 1, oma = c(0, 0, 0, 0), cex = 0.9, mar = c(2.5, 3, 1, 1))
plot(0, 0, type = "n", xlim=range(rr), xlab = "", xaxt = "n", ylim = c(0, 0.4), ylab = "", main = "")
axis(1, at = rr, labels = rr)
off <- 0.35
rect(xleft=mle$supp-off, ybottom=ci0$low, xright=mle$supp+off, ytop = ci0$upp, col = grey(0.8), border = grey(0.8)) 
points(mle$supp, mle$mle, pch=1, lwd = 2)
lines(rr, dlogdouble(rr, p=0.9), lwd=2, lty=1)
legend("topright", c("truth", "MLE", "conf. band"), pch = c(-1,1,15), lty = c(1,-1,-1), col = c(1,1,grey(0.8)), bty = "n", lwd = c(2,2,-1))

dev.off()

