# June 14, 2013
# HKJ
# double logarithmic distribution


dlogdouble	<-	function(x, p, pzero= p/(p - log(1-p))){
	
				xdown	<-	x[x<0]
				xzero	<-	x[x==0]
				xup		<-	x[x>0]

				locdown	<-	which(x<0)
				loczero	<-	which(x==0)
				locup	<-	which(x>0)
	
				pmf				<-	rep(0, length(x))
				pmf[locdown]	<-	dlog(-xdown,p)*(1-pzero)/2	
				pmf[loczero]	<-	rep(pzero, length(loczero))	
				pmf[locup]		<-	dlog(xup,p)*(1-pzero)/2	
	
				return(pmf)	
}

rlogdouble	<-	function(n, p, pzero= p/(p - log(1-p))){
	
				pdown	<-	(1-pzero)/2
				pzero	<-	pzero
#				pup		<-	(1-pzero)/2
				
				u		<-	runif(n)
				xup		<-	rlog(n, prob=p)
				xdown	<-	-rlog(n, prob=p)
				sample	<-	rep(0, length(n))
				sample	<-	xdown*(u<pdown)+xup*(u>pdown+pzero)	
	
				return(sample)		
}


