source("unimodalLSE.R")
source("unimodal_lse2.R")
library("MASS")
library(VGAM)
source("ci_function.R")
source("double_log.R")
rdunif 	<- 	function(n, k)	sample(1:k, n, replace=TRUE)
ddunif	<-	function(x, k)	ifelse(x>=1 & x<=k & round(x)==x, 1/k, 0)

supp		<-	1:50
p1			<-	ddunif(supp, k=10)
p2			<-	ddunif(supp, k=40)
p3			<-	ddunif(supp, k=50)	
true		<-	(1/3)*p1+(1/3)*p2+(1/3)*p3
sum(true)


REP			<-	1000
resCB1		<-	rep(0, REP)
resCB2		<-	rep(0, REP)
resCB105	<-	rep(0, REP)
resCB205	<-	rep(0, REP)


set.seed(9607669)

for(i in 1:REP){
	
	n			<-	5000
	x			<-	sample(supp, size=n, replace=TRUE, prob=true)

	mle			<-	findMLE(x)
	suppn		<-	mle$supp

	CB0			<-	funCI(x, mle, beta=0, B=100000)
	CB05		<-	funCI(x, mle, beta=0.5, B=100000)

	# results on observed support only for beta=0
	p0			<-	true[suppn]
	resCB1[i]	<-	min((CB0$low<=p0)*(p0<=CB0$upp))

	# results on full support for beta=0
	low			<-	rep(0, length(supp))
	upp			<-	rep(0, length(supp))
	low[suppn]	<-	CB0$low
	upp[suppn]	<-	CB0$upp
	resCB2[i]	<-	min((low<=true)*(true<=upp))

	# results on observed support only for beta=0.5
	p0			<-	true[suppn]
	resCB105[i]	<-	min((CB05$low<=p0)*(p0<=CB05$upp))

	# results on full support for beta=0.5
	low			<-	rep(0, length(supp))
	upp			<-	rep(0, length(supp))
	low[suppn]	<-	CB05$low
	upp[suppn]	<-	CB05$upp
	resCB205[i]	<-	min((low<=true)*(true<=upp))
		
	print(i)

}

mean(resCB1)
mean(resCB2)
mean(resCB105)
mean(resCB205)