source("unimodalLSE.R")
source("unimodal_lse2.R")
library("MASS")
library(VGAM)
source("ci_function.R")
source("double_log.R")
rdunif 	<- 	function(n, k)	sample(1:k, n, replace=TRUE)
ddunif	<-	function(x, k)	ifelse(x>=1 & x<=k & round(x)==x, 1/k, 0)

R			<-	-11:11
sum(dlogdouble(R, p=0.9))
trueR		<-	dlogdouble(R, p=0.9)


supp		<-	-200:200
true		<-	dlogdouble(supp, p=0.9)
sum(true)





REP			<-	1000
resCB1		<-	rep(0, REP)
resCB2		<-	rep(0, REP)
resCB105	<-	rep(0, REP)
resCB205	<-	rep(0, REP)


set.seed(9607669)

for(i in 1:REP){
	
	n			<-	5000
	x			<-	rlogdouble(n, p=0.9)

	mle			<-	findMLE(x)
	suppn		<-	mle$supp
	locn		<-	which(supp %in% suppn)
	locR		<-	which(suppn %in% R)
	nlocR		<-	which(R %in% suppn)
	

	CB0			<-	funCI(x, mle, beta=0, B=100000)
	CB05		<-	funCI(x, mle, beta=0.5, B=100000)

	# results on observed support only for beta=0
	p0			<-	true[locn]
	resCB1[i]	<-	min((CB0$low<=p0)*(p0<=CB0$upp))

	# results on full support for beta=0
	low			<-	rep(0, length(R))
	upp			<-	rep(0, length(R))
	low[nlocR]	<-	CB0$low[locR]
	upp[nlocR]	<-	CB0$upp[locR]
	resCB2[i]	<-	min((low<=trueR)*(trueR<=upp))

	# results on observed support only for beta=0.5
	p0			<-	true[locn]
	resCB105[i]	<-	min((CB05$low<=p0)*(p0<=CB05$upp))

	# results on full support for beta=0.5
	low			<-	rep(0, length(R))
	upp			<-	rep(0, length(R))
	low[nlocR]	<-	CB05$low[locR]
	upp[nlocR]	<-	CB05$upp[locR]
	resCB205[i]	<-	min((low<=trueR)*(trueR<=upp))
		
	print(i)

}

mean(resCB1)
mean(resCB2)
mean(resCB105)
mean(resCB205)