# Hanna Jankowski, June 13, 2013
# modified June 14th, 2013 (to keep track of full LSE and MLE info)
# modified November 13th, 2013 (to deal with Gaussian data)


findLSEup		<-	function(m.loc, x){
	
					# find increasing part
					loc.up		<-	1:(m.loc-1)
					xup			<-	x[loc.up]
					xup			<-	xup[length(xup):1]
					res			<-	findLSEdown(1, xup)
					res			<-	res[length(res):1]						
						
					return(res)
				
				}
				
				
findLSEdown		<-	function(m.loc, x){
	
					# find decreasing part
					loc.down	<-	m.loc:length(x)
					en			<-	length(loc.down)
					sumx		<-	sum(x[loc.down])
					pts.y		<-	c(0,cumsum(x[loc.down]))
					pts.y		<-	pmax(pts.y,sumx*(0:en)/en)
					pts.x		<-	c(0:en)
					pts    		<-  cbind(pts.x, pts.y)
					hpts		<-	chull(pts)
					lcm			<-	sort(hpts)
					if(max(lcm)>en+1) lcm			<-	lcm[-length(lcm)]
					yy			<-	pts.y[lcm]
					xx			<-	pts.x[lcm]
					lse.down	<-	diff(yy)/diff(xx)
					
					return(rep(lse.down, diff(xx)))
	
				}
				
#plot(pts, pch=19)
#lines(pts[lcm,], col="red")
#lines(0:en, c(0, cumsum(rep(lse.down, diff(xx)))), col="red")



findLSE		<-	function(x){

lse.vals			<-	matrix(0, length(x), length(x))
lse.search			<-	rep(0, length(x))

for(i in 1:length(x)){
		
	m.loc			<-	i
	if(i==1){lse.up	<- numeric(0)} else {lse.up <- findLSEup(m.loc, x)}
	if(i==(length(x)+1)){lse.down <- numeric(0)} else {lse.down <- findLSEdown(m.loc, x)}
	
	lse				<- 	c(lse.up, lse.down)
	lse.vals[i,]	<-	lse
	lse.search[i]	<-	sum((lse-x)^2)
	
}

lse.loc				<-	which(lse.search==min(lse.search))
lse					<-	lse.vals[min(lse.loc),]

del					<-	0
if(length(lse.loc)==2){
	lse2			<-	lse.vals[max(lse.loc),]
	del				<-	sum((lse-lse2)^2)	
}

return(list(lse=lse, loc=lse.loc, search=lse.search, diff=del))
}

