/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.JOptionPane;

class Configuration {
    String appName;
    String[] parameters;

    Configuration(String appNameArg, String[] parametersArg) {
        this.appName = appNameArg;
        this.parameters = new String[parametersArg.length];
        System.arraycopy(parametersArg, 0, this.parameters, 0, parametersArg.length);
    }

    void setConfigurationParameter(int idx, String par) {
        this.parameters[idx] = par;
    }

    String getConfigurationParameter(int idx) {
        return this.parameters[idx];
    }

    String[] toArray() {
        return this.parameters;
    }

    public static Configuration readConfigurationData(String appNameArg, String[] defaultParametersArg, String[] otherFilesArg) {
        String appName = appNameArg;
        String[] defaultParameters = defaultParametersArg;
        String[] otherFiles = otherFilesArg;
        Scanner inFile = null;
        String fileName = String.valueOf(appName) + ".cfg";
        String line = "";
        File cfgFile = new File(fileName);
        if (!cfgFile.exists()) {
            String msg = "The " + fileName + " file was not found. Would you\n" + "like a default configuration file to be created for you?";
            int resp = JOptionPane.showConfirmDialog(null, msg, "Missing Configuration File", 0);
            if (resp == 0) {
                try {
                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(appName) + ".cfg")));
                    out.print(new Configuration(appName, defaultParameters).toString());
                    out.flush();
                    out.close();
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(null, "Unable to save config to " + appName + ".cfg\n" + "Please ensure the file is writable.", "I/O Error", 0);
                }
            } else {
                System.exit(0);
            }
        }
        int i = 0;
        while (otherFiles != null && i < otherFiles.length) {
            if (!new File(otherFiles[i]).exists()) {
                Configuration.copyFile(appName, otherFiles[i]);
            }
            ++i;
        }
        try {
            inFile = new Scanner(new FileReader(cfgFile));
        }
        catch (FileNotFoundException e) {
            Configuration.showError("Configuration file not found: " + fileName);
            System.exit(1);
        }
        ArrayList<String> tmp = new ArrayList<String>();
        while (inFile.hasNextLine()) {
            line = inFile.nextLine();
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            tmp.add(line);
        }
        String[] parameters = new String[tmp.size()];
        parameters = tmp.toArray(parameters);
        Configuration c = new Configuration(appName, parameters);
        return c;
    }

    private static void showError(String msg) {
        JOptionPane.showMessageDialog(null, msg, "I/O Error", 0);
    }

    private static void copyFile(String appNameArg, String fileNameArg) {
        String appName = appNameArg;
        String fileName = fileNameArg;
        Class<?> appClass = null;
        try {
            appClass = Class.forName(appName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        InputStream inputStream = appClass.getResourceAsStream(fileName);
        if (inputStream == null) {
            Configuration.showError("Setup Error! Can't find file: " + fileName);
            System.exit(1);
        }
        Scanner in = new Scanner(appClass.getResourceAsStream(fileName));
        PrintStream out = null;
        try {
            out = new PrintStream(fileName);
        }
        catch (IOException e) {
            System.out.println("Setup Error! Can't copy file: " + fileName);
            System.exit(1);
        }
        while (in.hasNextLine()) {
            out.println(in.nextLine());
        }
        out.flush();
        out.close();
        in.close();
    }

    public String toString() {
        String title = "Configuration parameters for " + this.appName + "\n";
        StringBuilder sb = new StringBuilder(700);
        sb.append("# ");
        int i = 0;
        while (i < title.length() - 1) {
            sb.append("=");
            ++i;
        }
        sb.append("\n");
        sb.append("# " + title);
        sb.append("# ");
        i = 0;
        while (i < title.length() - 1) {
            sb.append("=");
            ++i;
        }
        sb.append("\n");
        sb.append("\n");
        i = 0;
        while (i < this.parameters.length) {
            sb.append("# -----\n");
            sb.append("# Parameter #" + (i + 1) + " (as per setup dialog)\n");
            sb.append(String.valueOf(this.parameters[i]) + "\n");
            sb.append("\n");
            ++i;
        }
        sb.append("# --- end ---\n");
        return sb.toString();
    }
}

