/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;
import java.util.Vector;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

class H4WriterExperimentGUI
extends JFrame
implements KeyListener,
MouseListener {
    static final long serialVersionUID = 42L;
    static final String[] KEY_MAP = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private BufferedWriter sd1File;
    private BufferedWriter sd2File;
    private Vector<Sample> samples;
    private String phrasesFile;
    private boolean showPresented;
    private boolean lowercaseOnly;
    private boolean showKeyboard;
    private boolean showSymbols;
    private boolean h4WriterSpecial;
    private Random r = new Random();
    private JTextField presentedText;
    private JTextField transcribedText;
    private String[] phrases;
    private String pPhrase;
    private long t1;
    private long t2;
    private int count;
    private int phraseCount;
    private String[][] huffmanCodes;
    private String[][] huffmanLetterCodes;
    private String[][] huffmanSymbolCodes;
    private JTextArea[] huffmanKey;
    private JTextField keys;
    private String huffmanStem;
    private String huffmanStemPlusOne;
    private String huffmanLetterFile;
    private String huffmanSymbolFile;
    Clip tickClip;
    Clip typewriterClip;
    Clip missClip;
    Clip enterClip;
    Clip redoClip;
    boolean capsMode = false;
    boolean capsLockMode = false;
    boolean symbolMode = false;
    boolean symbolLockMode = false;
    private Font BIG = new Font("monospaced", 1, 20);
    private Color BACKGROUND = new Color(254, 254, 218);
    private Color FOREGROUND = new Color(11, 11, 109);
    final String SPACE = "[Space]";
    final String BACKSPACE = "[Bksp]";
    final String ENTER = "[Enter]";
    final String CAPS = "[Cap]";
    final String CAPS_LOCK = "[CapsLock]";
    final String SYMBOL_MODE = "[Symbol]";
    final String SYMBOL_LOCK = "[SymLock]";
    Configuration c;
    String codeBase;
    double[] blockWPM;
    double[] blockER;
    double[] blockEfficiency;
    int phraseIdx;
    JTextArea blockSummary;
    JDialog resultsDialog;
    JOptionPane resultsPane;
    JTextArea resultsArea;
    String participantCode;
    String conditionCode;
    String sessionCode;
    String blockCode;
    String sd2Header;

    H4WriterExperimentGUI(Configuration cArg) {
        String[] s;
        this.c = cArg;
        this.participantCode = this.c.getConfigurationParameter(0);
        this.conditionCode = this.c.getConfigurationParameter(1);
        this.sessionCode = this.c.getConfigurationParameter(2);
        this.phraseCount = Integer.parseInt(this.c.getConfigurationParameter(3));
        this.phrasesFile = this.c.getConfigurationParameter(4);
        this.showPresented = Boolean.valueOf(this.c.getConfigurationParameter(5));
        this.lowercaseOnly = Boolean.valueOf(this.c.getConfigurationParameter(6));
        this.showKeyboard = Boolean.valueOf(this.c.getConfigurationParameter(7));
        this.showSymbols = Boolean.valueOf(this.c.getConfigurationParameter(8));
        this.codeBase = this.c.getConfigurationParameter(9);
        this.h4WriterSpecial = Boolean.valueOf(this.c.getConfigurationParameter(10));
        this.blockWPM = new double[this.phraseCount];
        this.blockER = new double[this.phraseCount];
        this.phraseIdx = 0;
        this.blockEfficiency = new double[this.phraseCount];
        this.sd2Header = "App,Participant,Condition,Session,Block,Min_keystrokes,Keystrokes,Presented_characters,Transcribed_characters,Time,MSD,WPM,ER,KSPC,Efficiency\n";
        Scanner inFile = null;
        try {
            inFile = new Scanner(new File(this.phrasesFile));
        }
        catch (FileNotFoundException e) {
            this.showError("\nPhrases file not found - " + this.phrasesFile);
            System.exit(1);
        }
        ArrayList<String> phrasesArrayList = new ArrayList<String>();
        while (inFile.hasNextLine()) {
            phrasesArrayList.add(inFile.nextLine().toLowerCase());
        }
        this.phrases = phrasesArrayList.toArray(new String[phrasesArrayList.size()]);
        inFile.close();
        this.tickClip = this.initSound("click1.wav");
        this.typewriterClip = this.initSound("typewriter.wav");
        this.missClip = this.initSound("miss.wav");
        this.enterClip = this.initSound("blip1.wav");
        this.redoClip = this.initSound("undo.wav");
        this.huffmanStem = "";
        this.huffmanStemPlusOne = "";
        this.huffmanLetterFile = "h" + this.codeBase + ".txt";
        this.huffmanSymbolFile = "h" + this.codeBase + "-sym.txt";
        try {
            inFile = new Scanner(new File(this.huffmanLetterFile));
        }
        catch (FileNotFoundException e) {
            this.showError("Huffman letter code file not found - " + this.huffmanLetterFile);
            System.exit(1);
        }
        ArrayList<String> charArray = new ArrayList<String>();
        ArrayList<String> codeArray = new ArrayList<String>();
        while (inFile.hasNextLine()) {
            s = inFile.nextLine().trim().split("\\s+");
            if (s.length != 2) {
                this.showError("Format error in Huffman letter code file: " + this.huffmanLetterFile);
                System.exit(1);
            }
            charArray.add(s[0]);
            codeArray.add(s[1]);
        }
        inFile.close();
        this.huffmanLetterCodes = new String[2][charArray.size()];
        this.huffmanLetterCodes[0] = charArray.toArray(this.huffmanLetterCodes[0]);
        this.huffmanLetterCodes[1] = codeArray.toArray(this.huffmanLetterCodes[1]);
        try {
            inFile = new Scanner(new File(this.huffmanSymbolFile));
        }
        catch (FileNotFoundException e) {
            this.showError("Huffman symbol code file not found - " + this.huffmanSymbolFile);
            System.exit(1);
        }
        charArray = new ArrayList();
        codeArray = new ArrayList();
        while (inFile.hasNextLine()) {
            s = inFile.nextLine().trim().split("\\s+");
            if (s.length != 2) {
                this.showError("Format error in Huffman symbol code file: " + s);
                System.exit(1);
            }
            charArray.add(s[0]);
            codeArray.add(s[1]);
        }
        inFile.close();
        this.huffmanSymbolCodes = new String[2][charArray.size()];
        this.huffmanSymbolCodes[0] = charArray.toArray(this.huffmanSymbolCodes[0]);
        this.huffmanSymbolCodes[1] = codeArray.toArray(this.huffmanSymbolCodes[1]);
        this.huffmanCodes = this.huffmanLetterCodes;
        this.blockCode = "";
        int blockCodeNumber = 0;
        String outputFile = "H4WriterExperiment-" + this.participantCode + "-" + this.conditionCode + "-" + this.sessionCode;
        String s1 = "";
        String s2 = "";
        do {
            this.blockCode = ++blockCodeNumber < 10 ? "B0" + blockCodeNumber : "B" + blockCodeNumber;
            s1 = String.valueOf(outputFile) + "-" + this.blockCode + ".sd1";
            s2 = String.valueOf(outputFile) + "-" + this.blockCode + ".sd2";
        } while (new File(s1).exists());
        try {
            this.sd1File = new BufferedWriter(new FileWriter(s1));
            this.sd2File = new BufferedWriter(new FileWriter(s2));
            this.sd2File.write(this.sd2Header, 0, this.sd2Header.length());
            this.sd2File.flush();
        }
        catch (IOException e) {
            System.err.println("ERROR WRITING HEADER LINE TO SD2 FILE!\n" + e);
            System.exit(1);
        }
        this.resultsArea = new JTextArea(9, 40);
        this.resultsArea.setFont(new Font("sansserif", 0, 18));
        this.resultsArea.setBackground(new JButton().getBackground());
        this.resultsPane = new JOptionPane(this.resultsArea, 1);
        this.resultsPane.setFont(new Font("sansserif", 0, 18));
        this.resultsDialog = this.resultsPane.createDialog(this, "Information");
        this.blockSummary = new JTextArea(5, 25);
        this.blockSummary.setFont(new Font("monospaced", 1, 24));
        this.blockSummary.setBackground(new Color(255, 222, 222));
        this.blockSummary.setBorder(new EtchedBorder());
        this.presentedText = new JTextField(50);
        this.presentedText.setFocusable(false);
        this.presentedText.setFont(this.BIG);
        this.presentedText.setBackground(new Color(254, 254, 218));
        this.presentedText.setForeground(new Color(11, 11, 109));
        JLabel text1Label = new JLabel("  Presented:");
        text1Label.setFont(this.BIG);
        this.transcribedText = new JTextField(50);
        this.transcribedText.setFont(this.BIG);
        this.transcribedText.setBackground(this.BACKGROUND);
        this.transcribedText.setForeground(this.FOREGROUND);
        JLabel text2Label = new JLabel("Transcribed:");
        text2Label.setFont(this.BIG);
        this.transcribedText.setEditable(true);
        this.transcribedText.addKeyListener(this);
        this.keys = new JTextField(50);
        this.keys.setFocusable(false);
        this.keys.setFont(this.BIG);
        this.keys.setBackground(new Color(212, 208, 200));
        JLabel keysLabel = new JLabel("       Keys:");
        keysLabel.setFont(this.BIG);
        JPanel leftPanel = new JPanel(new GridLayout(0, 1, 0, 10));
        leftPanel.add(text1Label);
        leftPanel.add(text2Label);
        leftPanel.add(keysLabel);
        JPanel rightPanel = new JPanel(new GridLayout(0, 1, 0, 10));
        rightPanel.add(this.presentedText);
        rightPanel.add(this.transcribedText);
        rightPanel.add(this.keys);
        JPanel topPanel = new JPanel(new FlowLayout(1));
        topPanel.add((Component)leftPanel, "West");
        topPanel.add((Component)rightPanel, "East");
        this.pPhrase = this.phrases[this.r.nextInt(this.phrases.length)];
        this.presentedText.setText(this.pPhrase);
        this.transcribedText.setText("");
        this.t1 = 0L;
        this.count = 0;
        this.samples = new Vector();
        JPanel huffmanPanel = new JPanel();
        huffmanPanel.setBorder(new EtchedBorder());
        int codeBaseInt = Integer.parseInt(this.codeBase);
        if (codeBaseInt != 4 || codeBaseInt == 4 && !this.h4WriterSpecial) {
            huffmanPanel.setLayout(new GridLayout(1, codeBaseInt));
        } else {
            huffmanPanel.setLayout(new GridLayout(3, 3));
        }
        LineBorder lb = new LineBorder(Color.red, 2);
        CompoundBorder cb = new CompoundBorder(new EtchedBorder(), lb);
        this.huffmanKey = new JTextArea[codeBaseInt];
        TitledBorder[] keyBorder = new TitledBorder[codeBaseInt];
        int i = 0;
        while (i < codeBaseInt) {
            this.huffmanKey[i] = new JTextArea(4, 15);
            this.huffmanKey[i].setFocusable(false);
            this.huffmanKey[i].setLineWrap(true);
            this.huffmanKey[i].setWrapStyleWord(true);
            this.huffmanKey[i].setFont(new Font("monospaced", 1, 18));
            this.huffmanKey[i].setBackground(new Color(254, 254, 218));
            this.huffmanKey[i].addMouseListener(this);
            this.huffmanKey[i].setEditable(false);
            keyBorder[i] = new TitledBorder(cb);
            keyBorder[i].setTitleFont(this.BIG);
            this.huffmanKey[i].setBorder(keyBorder[i]);
            if (codeBaseInt != 4 || codeBaseInt == 4 && !this.h4WriterSpecial) {
                huffmanPanel.add(this.huffmanKey[i]);
            }
            ++i;
        }
        if (codeBaseInt == 4 && this.h4WriterSpecial) {
            huffmanPanel.add(new JLabel(" "));
            huffmanPanel.add(this.huffmanKey[1]);
            huffmanPanel.add(new JLabel(" "));
            huffmanPanel.add(this.huffmanKey[0]);
            huffmanPanel.add(new JLabel(" "));
            huffmanPanel.add(this.huffmanKey[2]);
            huffmanPanel.add(new JLabel(" "));
            huffmanPanel.add(this.huffmanKey[3]);
            huffmanPanel.add(new JLabel(" "));
        }
        this.updateHuffmanKeys(this.huffmanStem);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        p.setLayout(new BoxLayout(p, 1));
        p.add(topPanel);
        p.add(Box.createRigidArea(new Dimension(0, 10)));
        if (this.showKeyboard) {
            p.add(huffmanPanel);
            p.add(Box.createRigidArea(new Dimension(0, 10)));
        } else {
            p.add(Box.createRigidArea(new Dimension(0, 50)));
        }
        this.setContentPane(p);
    }

    void showError(String msg) {
        JOptionPane.showMessageDialog(null, msg, "I/O Error", 0);
    }

    private char getKeyCharFromMap(String keyTextArg) {
        boolean found = false;
        char c = '0';
        int i = 0;
        while (i < KEY_MAP.length) {
            if (KEY_MAP[i].equals(keyTextArg)) {
                c = (char)(48 + i);
                found = true;
                break;
            }
            ++i;
        }
        return c;
    }

    private String getSymbolsForKey(int key, String stemArg) {
        String stem = String.valueOf(stemArg) + key;
        String s = "";
        int i = 0;
        while (i < this.huffmanCodes[0].length) {
            if (this.huffmanCodes[1][i].indexOf(stem) == 0) {
                s = String.valueOf(s) + this.huffmanCodes[0][i] + " ";
            }
            ++i;
        }
        return s.trim();
    }

    private void updateHuffmanKeys(String stem) {
        if (!this.showSymbols && !this.symbolMode) {
            return;
        }
        int i = 0;
        while (i < this.huffmanKey.length) {
            this.huffmanKey[i].setText(this.getSymbolsForKey(i, stem));
            ++i;
        }
    }

    private boolean isPrefix(String stem) {
        int i = 0;
        while (i < this.huffmanCodes[0].length) {
            if (this.huffmanCodes[1][i].equals(stem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int sizeOfCode(String symbol, String[][] huffmanCodes) {
        int count = 0;
        int i = 0;
        while (i < huffmanCodes[1].length) {
            if (symbol.equals(huffmanCodes[0][i])) {
                count += huffmanCodes[1][i].length();
                break;
            }
            ++i;
        }
        if (count > 0) {
            return count;
        }
        System.out.println("Not found: " + symbol);
        return -1;
    }

    private int minimumKeystrokes(String phrase) {
        int count = 0;
        int i = 0;
        while (i < phrase.length()) {
            Character c = new Character(phrase.charAt(i));
            String s = "" + c;
            if (Character.isSpaceChar(c.charValue())) {
                s = "[Space]";
            }
            if (Character.isUpperCase(c.charValue())) {
                count += this.sizeOfCode("[Cap]", this.huffmanLetterCodes);
                s = s.toLowerCase();
            }
            if (Character.isLetter(c.charValue()) || Character.isSpaceChar(c.charValue()) || s.equals(".") || s.equals(",")) {
                count += this.sizeOfCode(s, this.huffmanLetterCodes);
            } else {
                count += this.sizeOfCode("[Symbol]", this.huffmanLetterCodes);
                count += this.sizeOfCode(s, this.huffmanSymbolCodes);
            }
            ++i;
        }
        if (count > 0) {
            return count;
        }
        System.out.println("Oops!");
        return -1;
    }

    private boolean valid(String stem) {
        int i = 0;
        while (i < this.huffmanCodes[0].length) {
            if (this.huffmanCodes[1][i].indexOf(stem) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getHuffmanSymbol(String stem) {
        int i = 0;
        while (i < this.huffmanCodes[0].length) {
            if (this.huffmanCodes[1][i].equals(stem)) {
                return this.huffmanCodes[0][i];
            }
            ++i;
        }
        return null;
    }

    public Clip initSound(String soundFile) {
        Clip c = null;
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(this.getClass().getResourceAsStream(soundFile)));
            c = AudioSystem.getClip();
            c.open(audioInputStream);
        }
        catch (Exception e) {
            System.out.println("ERROR: Unable to load " + soundFile);
        }
        return c;
    }

    public void playSound(Clip c) {
        if (c != null) {
            c.setFramePosition(0);
            c.start();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        if (ke.getKeyChar() == 'r') {
            ke.consume();
            this.playSound(this.redoClip);
            this.prepareForNextPhrase();
            return;
        }
        int temp = ke.getKeyChar();
        if (temp == 106) {
            temp = 48;
        }
        if (temp == 107) {
            temp = 49;
        }
        if (temp == 108) {
            temp = 50;
        }
        if (temp == 59) {
            temp = 51;
        }
        char c = this.getKeyCharFromMap(KeyEvent.getKeyText(temp));
        c = (char)(c - '\u0001');
        String key = "" + c;
        ke.consume();
        this.processKey(key);
    }

    public void processKey(String keyArg) {
        String key = keyArg;
        String symbol = "";
        this.huffmanStem = String.valueOf(this.huffmanStem) + key;
        this.huffmanStemPlusOne = String.valueOf(this.huffmanStemPlusOne) + (char)(key.charAt(0) + '\u0001');
        ++this.count;
        if (this.t1 == 0L) {
            this.t1 = System.currentTimeMillis();
            if (!this.showPresented) {
                this.presentedText.setText("");
            }
        }
        if (!this.valid(this.huffmanStem)) {
            this.playSound(this.missClip);
            this.huffmanStem = this.huffmanStem.substring(0, this.huffmanStem.length() - 1);
            this.huffmanStemPlusOne = this.huffmanStemPlusOne.substring(0, this.huffmanStemPlusOne.length() - 1);
        } else if (this.isPrefix(this.huffmanStem)) {
            symbol = this.getHuffmanSymbol(this.huffmanStem);
            String t = this.transcribedText.getText();
            if (symbol.equals("[Space]")) {
                this.transcribedText.setText(String.valueOf(t) + " ");
                this.playSound(this.typewriterClip);
            } else if (symbol.equals("[Bksp]")) {
                if (t.length() >= 1) {
                    this.transcribedText.setText(t.substring(0, t.length() - 1));
                    this.playSound(this.typewriterClip);
                } else {
                    this.playSound(this.missClip);
                }
            } else if (symbol.equals("[Cap]")) {
                this.capsMode = true;
                this.playSound(this.typewriterClip);
            } else if (symbol.equals("[CapsLock]")) {
                this.capsLockMode = !this.capsLockMode;
                this.playSound(this.typewriterClip);
            } else if (symbol.equals("[Symbol]")) {
                this.symbolMode = true;
                this.huffmanCodes = this.huffmanSymbolCodes;
                this.playSound(this.typewriterClip);
            } else if (symbol.equals("[SymLock]")) {
                this.symbolMode = false;
                this.symbolLockMode = !this.symbolLockMode;
                this.huffmanCodes = this.symbolLockMode ? this.huffmanSymbolCodes : this.huffmanLetterCodes;
                this.playSound(this.typewriterClip);
            } else if (!symbol.equals("[Enter]")) {
                if (this.symbolMode) {
                    this.symbolMode = false;
                    this.huffmanCodes = this.huffmanLetterCodes;
                }
                if (this.capsMode || this.capsLockMode) {
                    symbol = symbol.toUpperCase();
                    this.capsMode = false;
                }
                this.transcribedText.setText(String.valueOf(t) + symbol);
                this.playSound(this.typewriterClip);
            }
            this.huffmanStem = "";
            this.huffmanStemPlusOne = "";
            this.keys.setText(this.huffmanStemPlusOne);
            this.updateHuffmanKeys(this.huffmanStem);
        } else {
            symbol = "";
            this.keys.setText(this.huffmanStemPlusOne);
            symbol = "";
            this.updateHuffmanKeys(this.huffmanStem);
            this.playSound(this.tickClip);
        }
        this.t2 = System.currentTimeMillis() - this.t1;
        this.samples.addElement(new Sample(this.t2, key, symbol));
        if (symbol.equals("[Enter]")) {
            this.playSound(this.enterClip);
            this.count -= this.sizeOfCode("[Enter]", this.huffmanLetterCodes);
            int backup = this.sizeOfCode("[Enter]", this.huffmanLetterCodes);
            this.t2 = this.samples.elementAt(this.samples.size() - (backup + 1)).time;
            String s1 = this.pPhrase;
            String s2 = this.transcribedText.getText();
            if (this.lowercaseOnly) {
                s1 = s1.toLowerCase();
                s2 = s2.toLowerCase();
            }
            MSD s1s2 = new MSD(s1, s2);
            int msd = s1s2.getMSD();
            int min = this.minimumKeystrokes(this.pPhrase);
            double kspc = (double)this.count / (double)s2.length();
            double kspcmin = (double)min / (double)s1.length();
            double efficiency = kspcmin / kspc * 100.0;
            String resultsString = "Thank you!\n\n";
            resultsString = String.valueOf(resultsString) + String.format("Presented text:\t%s\n", s1);
            resultsString = String.valueOf(resultsString) + String.format("Transcribed text:\t%s\n", s2);
            resultsString = String.valueOf(resultsString) + String.format("Entry speed:\t\t%.2f wpm\n", H4WriterExperimentGUI.wpm(s2, this.t2));
            resultsString = String.valueOf(resultsString) + String.format("Error rate:\t\t%.2f%%\n", s1s2.getErrorRateNew());
            resultsString = String.valueOf(resultsString) + String.format("Efficiency:\t\t%.2f%%", efficiency);
            this.resultsArea.setText(resultsString);
            this.resultsDialog.setVisible(true);
            String sd2Stuff = "H4WriterExperiment," + this.participantCode + "," + this.conditionCode + "," + this.sessionCode + "," + this.blockCode + ",";
            sd2Stuff = String.valueOf(sd2Stuff) + min + ",";
            sd2Stuff = String.valueOf(sd2Stuff) + this.count + ",";
            sd2Stuff = String.valueOf(sd2Stuff) + s1.length() + ",";
            sd2Stuff = String.valueOf(sd2Stuff) + s2.length() + ",";
            sd2Stuff = String.valueOf(sd2Stuff) + String.format("%f,", (double)this.t2 / 1000.0);
            sd2Stuff = String.valueOf(sd2Stuff) + msd + ",";
            sd2Stuff = String.valueOf(sd2Stuff) + String.format("%f,", H4WriterExperimentGUI.wpm(s2, this.t2));
            sd2Stuff = String.valueOf(sd2Stuff) + String.format("%f,", s1s2.getErrorRateNew());
            sd2Stuff = String.valueOf(sd2Stuff) + kspc + ",";
            sd2Stuff = String.valueOf(sd2Stuff) + efficiency + "\n";
            String sd1Stuff = String.valueOf(this.pPhrase) + "\n" + s2 + "\n";
            int i = 0;
            while (i < this.samples.size() - backup) {
                sd1Stuff = String.valueOf(sd1Stuff) + this.samples.elementAt(i) + "\n";
                ++i;
            }
            sd1Stuff = String.valueOf(sd1Stuff) + "#\n";
            try {
                this.sd1File.write(sd1Stuff, 0, sd1Stuff.length());
                this.sd1File.flush();
                this.sd2File.write(sd2Stuff, 0, sd2Stuff.length());
                this.sd2File.flush();
            }
            catch (IOException e) {
                System.err.println("ERROR WRITING TO DATA FILE!\n" + e);
                System.exit(1);
            }
            this.blockWPM[this.phraseIdx] = H4WriterExperimentGUI.wpm(s2, this.t2);
            this.blockER[this.phraseIdx] = s1s2.getErrorRateNew();
            this.blockEfficiency[this.phraseIdx] = efficiency;
            ++this.phraseIdx;
            if (--this.phraseCount == 0) {
                String s = " Block summary\n";
                s = String.valueOf(s) + " =============\n";
                s = String.valueOf(s) + String.format(" Entry speed = %.1f wpm\n", H4WriterExperimentGUI.mean(this.blockWPM));
                s = String.valueOf(s) + String.format(" Error rate  = %.1f%%\n", H4WriterExperimentGUI.mean(this.blockER));
                s = String.valueOf(s) + String.format(" Efficiency  = %.1f%%", H4WriterExperimentGUI.mean(this.blockEfficiency));
                this.blockSummary.setText(s);
                JOptionPane.showMessageDialog(this, this.blockSummary);
                try {
                    this.sd1File.close();
                    this.sd2File.close();
                }
                catch (IOException e) {
                    System.err.println("ERROR CLOSING DATA FILES!\n" + e);
                    System.exit(1);
                }
                System.exit(0);
            }
            this.prepareForNextPhrase();
        }
    }

    public static double mean(double[] n) {
        double mean = 0.0;
        int j = 0;
        while (j < n.length) {
            mean += n[j];
            ++j;
        }
        return mean / (double)n.length;
    }

    void prepareForNextPhrase() {
        this.samples = new Vector();
        this.pPhrase = this.phrases[this.r.nextInt(this.phrases.length)];
        this.presentedText.setText(this.pPhrase);
        this.transcribedText.setText("");
        this.t1 = 0L;
        this.count = 0;
        this.capsLockMode = false;
        this.capsMode = false;
    }

    public static double wpm(String text, long msTime) {
        double speed = text.length();
        speed = speed / ((double)msTime / 1000.0) * 12.0;
        return speed;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        int i = -1;
        i = 0;
        while (i < this.huffmanKey.length) {
            if (me.getSource() == this.huffmanKey[i]) break;
            ++i;
        }
        this.processKey("" + i);
    }

    private class Sample {
        private long time;
        private String key;
        private String symbol;

        Sample(long timeArg, String keyArg, String symbolArg) {
            this.time = timeArg;
            this.key = keyArg;
            this.symbol = symbolArg;
        }

        public String toString() {
            return String.valueOf(this.time) + " " + this.key + " " + this.symbol;
        }
    }
}

