/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import javax.swing.UIManager;

public class LetterGuessingExperiment {
    static final String APP_NAME = "LetterGuessingExperiment";
    static final int PARAMETERS = 6;
    static final String[] PARTICIPANT_CODES = new String[]{"P00", "P01", "P02", "P03", "P04", "P05", "P06", "P07", "P08", "P09", "P10", "P11", "P12", "P13", "P14", "P15", "P16", "P17", "P18", "P19", "P20", "P21", "P22", "P23", "P24", "P25", "P26", "P27", "P28", "P29", "P30"};
    static final String[] CONDITION_CODE = new String[]{"C00"};
    static final String[] NUMBER_OF_PHRASES = new String[]{"5"};
    static final String[] PHRASES_FILE = new String[]{"phrases2.txt"};
    static final String[] BEEP_ON_ERROR = new String[]{"true"};
    static final String[] GUESS_MODE = new String[]{"One guess", "Guess until correct"};
    static final String[] OTHER_FILES = new String[]{"phrases2.txt", "d1-digramfreq.txt", "d1-letterfreq.txt", "d1-quadgramfreq.txt", "d1-trigramfreq.txt"};
    static final int ONE_GUESS = 100;
    static final int GUESS_UNTIL_CORRECT = 200;

    public static void main(String[] args) throws IOException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] defaultParameters = new String[]{PARTICIPANT_CODES[0], CONDITION_CODE[0], NUMBER_OF_PHRASES[0], PHRASES_FILE[0], BEEP_ON_ERROR[0], GUESS_MODE[0]};
        Configuration c = Configuration.readConfigurationData(APP_NAME, defaultParameters, OTHER_FILES);
        if (c == null) {
            System.out.println("Error reading configuration data from LetterGuessingExperiment.cfg!");
            System.exit(0);
        }
        SetupItemInfo[] sii = new SetupItemInfo[]{new SetupItemInfo(100, "Participant code ", PARTICIPANT_CODES), new SetupItemInfo(200, "Condition code ", CONDITION_CODE), new SetupItemInfo(200, "Number of phrases", NUMBER_OF_PHRASES), new SetupItemInfo(200, "Phrases file ", PHRASES_FILE), new SetupItemInfo(300, "Beep on error  ", BEEP_ON_ERROR), new SetupItemInfo(100, "Guessing mode ", GUESS_MODE)};
        Setup s = new Setup(null, c, APP_NAME, sii);
        s.showSetup(null);
        LetterGuessingExperimentGui screen = new LetterGuessingExperimentGui(c);
        screen.setDefaultCloseOperation(3);
        screen.setTitle(APP_NAME);
        screen.pack();
        int w = screen.getWidth();
        int h = screen.getHeight();
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension d = t.getScreenSize();
        screen.setLocation((d.width - w) / 2, (d.height - h) / 2);
        screen.setVisible(true);
    }
}

