/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class LetterGuessingExperimentGui
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    final String SD1_HEADER = "";
    final String SD2_HEADER = "App,Participant,Mode,Condition,Block,Phrase,Text,Reduced_text,Correct_guesses,Incorrect_guesses,KSPC,Time\n";
    String participantCode;
    String conditionCode;
    int numberOfPhrases;
    String phrasesFile;
    boolean beepOnError;
    int mode;
    String modeString;
    String blockCode;
    int phraseCount;
    String[] phraseArray;
    JTextField presentedTextField;
    JTextField reducedTextField;
    Random r = new Random();
    String[] phrases;
    BufferedWriter sd1File;
    BufferedWriter sd2File;
    Configuration c;
    final Font TEXT_FIELD_FONT = new Font("monospaced", 0, 20);
    final int MAX_LENGTH = 50;
    String m = "";
    String textToGuess = "";
    String presentedText = "";
    String reducedText = "";
    Clip errorSound;
    int letterCount;
    int guessCount;
    JDialog resultsDialog;
    JOptionPane resultsPane;
    JTextArea resultsArea;
    Keyboard k = new Keyboard(50, 45, this);
    StringBuilder s1Stuff;
    StringBuilder s2Stuff;
    StringBuilder mode2Guesses;
    long elapsedTime;
    long t;

    /*
     * Unable to fully structure code
     */
    LetterGuessingExperimentGui(Configuration cArg) {
        super();
        this.k.setAlignmentX(0.5f);
        this.letterCount = 0;
        this.phraseCount = 0;
        this.c = cArg;
        this.participantCode = this.c.getConfigurationParameter(0);
        this.conditionCode = this.c.getConfigurationParameter(1);
        this.numberOfPhrases = Integer.parseInt(this.c.getConfigurationParameter(2));
        this.phrasesFile = this.c.getConfigurationParameter(3);
        this.beepOnError = Boolean.valueOf(this.c.getConfigurationParameter(4));
        this.mode = -1;
        this.modeString = "";
        if (this.c.getConfigurationParameter(5).equals("One guess")) {
            this.mode = 100;
            this.modeString = "One_guess";
        } else {
            this.mode = 200;
            this.modeString = "Correct_guess";
        }
        this.errorSound = this.initSound("miss.wav");
        inFile = null;
        try {
            inFile = new Scanner(new File(this.phrasesFile));
        }
        catch (FileNotFoundException e) {
            this.showError("\nPhrases file not found - " + this.phrasesFile);
            System.exit(1);
        }
        arrayList = new ArrayList<String>();
        while (inFile.hasNextLine()) {
            arrayList.add(inFile.nextLine());
        }
        this.phrases = arrayList.toArray(new String[arrayList.size()]);
        this.phraseArray = new String[this.numberOfPhrases];
        i = 0;
        while (i < this.phraseArray.length) {
            r = new Random();
            this.phraseArray[i] = this.phrases[r.nextInt(this.phrases.length)];
            j = 0;
            ** GOTO lbl54
            {
                this.phraseArray[i] = this.phrases[r.nextInt(this.phrases.length)];
                do {
                    if (this.phraseArray[i].equals(this.phraseArray[j])) continue block8;
                    ++j;
lbl54:
                    // 2 sources

                } while (j < i);
            }
            ++i;
        }
        inFile.close();
        this.blockCode = "";
        blockCodeNumber = 0;
        base = "LetterGuessingExperiment-" + this.participantCode + "-" + this.modeString + "-" + this.conditionCode;
        s1 = "";
        s2 = "";
        do {
            this.blockCode = ++blockCodeNumber < 10 ? "B0" + blockCodeNumber : "B" + blockCodeNumber;
            s1 = String.valueOf(base) + "-" + this.blockCode + ".sd1";
            s2 = String.valueOf(base) + "-" + this.blockCode + ".sd2";
        } while (new File(s1).exists());
        try {
            this.sd1File = new BufferedWriter(new FileWriter(s1));
            this.sd2File = new BufferedWriter(new FileWriter(s2));
        }
        catch (IOException e) {
            System.out.println("I/O error: can't open sd1/sd2 data files");
            System.exit(0);
        }
        try {
            this.sd1File.write("", 0, "".length());
            this.sd1File.flush();
            this.sd2File.write("App,Participant,Mode,Condition,Block,Phrase,Text,Reduced_text,Correct_guesses,Incorrect_guesses,KSPC,Time\n", 0, "App,Participant,Mode,Condition,Block,Phrase,Text,Reduced_text,Correct_guesses,Incorrect_guesses,KSPC,Time\n".length());
            this.sd2File.flush();
        }
        catch (IOException e) {
            System.err.println("ERROR WRITING TO DATA FILE!\n" + e);
            System.exit(1);
        }
        this.presentedTextField = new JTextField(50);
        this.presentedTextField.setFont(this.TEXT_FIELD_FONT);
        this.presentedTextField.setEditable(false);
        this.presentedTextField.setForeground(new Color(0, 0, 128));
        this.presentedTextField.setBackground(Color.WHITE);
        this.reducedTextField = new JTextField(50);
        this.reducedTextField.setFont(this.TEXT_FIELD_FONT);
        this.reducedTextField.setEditable(true);
        this.reducedTextField.setForeground(new Color(0, 0, 128));
        this.reducedTextField.setBackground(Color.WHITE);
        this.resultsArea = new JTextArea(9, 20);
        this.resultsArea.setFont(new Font("sansserif", 0, 18));
        this.resultsArea.setBackground(new JButton().getBackground());
        this.resultsPane = new JOptionPane(this.resultsArea, 1);
        this.resultsPane.setFont(new Font("sansserif", 0, 18));
        this.resultsDialog = this.resultsPane.createDialog(this, "Information");
        this.newTrial();
        p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 1));
        p2.add(Box.createRigidArea(new Dimension(0, 10)));
        p2.add(this.presentedTextField);
        p2.add(Box.createRigidArea(new Dimension(0, 10)));
        p2.add(this.reducedTextField);
        p2.add(Box.createRigidArea(new Dimension(0, 10)));
        p3 = new JPanel();
        p3.add(this.k);
        p4 = new JPanel(new BorderLayout());
        p4.add("North", p2);
        p4.add("South", p3);
        p4.add(Box.createRigidArea(new Dimension(0, 10)));
        p4.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        this.setContentPane(p4);
    }

    void showError(String msg) {
        JOptionPane.showMessageDialog(null, msg, "I/O Error", 0);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        char c2;
        JButton jb = (JButton)ae.getSource();
        String s = jb.getText();
        char c = s.toLowerCase().charAt(0);
        long now = System.currentTimeMillis();
        this.elapsedTime += now - this.t;
        this.t = now;
        if (this.letterCount == this.textToGuess.length()) {
            return;
        }
        char c1 = this.textToGuess.charAt(this.letterCount);
        if (c1 == ' ') {
            c1 = '_';
        }
        char c3 = c2 = c == ' ' ? (char)'_' : (char)c;
        if (this.mode == 100) {
            this.s1Stuff.append(c1).append(',');
            this.s1Stuff.append(c2).append(',');
            this.s1Stuff.append(this.elapsedTime).append('\n');
            if (c != this.textToGuess.charAt(this.letterCount)) {
                if (this.beepOnError) {
                    this.playSound(this.errorSound);
                }
                this.reducedText = String.valueOf(this.reducedText) + this.textToGuess.charAt(this.letterCount);
            } else {
                this.reducedText = String.valueOf(this.reducedText) + "-";
            }
            ++this.letterCount;
            this.presentedText = String.valueOf(this.textToGuess.substring(0, this.letterCount)) + this.presentedText.substring(this.letterCount);
            this.presentedTextField.setText(this.presentedText);
            this.reducedTextField.setText(this.reducedText);
            this.reducedTextField.requestFocus();
        } else {
            this.mode2Guesses.append(c2);
            ++this.guessCount;
            if (this.guessCount == 1) {
                this.reducedText = String.valueOf(this.reducedText) + this.guessCount;
            } else {
                this.reducedText = this.reducedText.substring(0, this.reducedText.length() - 1);
                this.reducedText = String.valueOf(this.reducedText) + (this.guessCount < 10 ? Integer.valueOf(this.guessCount) : "" + (char)(this.guessCount - 10 + 65));
            }
            if (c != this.textToGuess.charAt(this.letterCount)) {
                this.k.disableKey(jb, this);
                if (this.beepOnError) {
                    this.playSound(this.errorSound);
                }
            } else {
                this.s1Stuff.append(c1).append(',');
                this.s1Stuff.append((CharSequence)this.mode2Guesses).append(',');
                this.s1Stuff.append(this.elapsedTime).append('\n');
                this.mode2Guesses = new StringBuilder();
                ++this.letterCount;
                this.guessCount = 0;
                this.k.enableKeys(this);
            }
            this.presentedText = String.valueOf(this.textToGuess.substring(0, this.letterCount)) + this.presentedText.substring(this.letterCount);
            this.presentedTextField.setText(this.presentedText);
            this.reducedTextField.setText(this.reducedText);
            this.reducedTextField.requestFocus();
        }
        if (this.letterCount == this.presentedText.length()) {
            int i;
            int correct = 0;
            int incorrect = 0;
            double kspc = 0.0;
            if (this.mode == 100) {
                i = 0;
                while (i < this.reducedText.length()) {
                    if (this.reducedText.charAt(i) == '-') {
                        ++correct;
                    } else {
                        ++incorrect;
                    }
                    ++i;
                }
                kspc = 1.0;
            } else {
                correct = this.reducedText.length();
                i = 0;
                while (i < this.reducedText.length()) {
                    char tmp = this.reducedText.charAt(i);
                    int n = tmp >= '0' && tmp <= '9' ? tmp - 48 : tmp - 65 + 10;
                    incorrect += n - 1;
                    kspc += (double)(n - 1 + 1);
                    ++i;
                }
                kspc /= (double)this.reducedText.length();
            }
            this.s1Stuff.append('#').append('\n');
            String modeString = this.mode == 100 ? "One_guess" : "Correct_guess";
            this.s2Stuff.append("LetterGuessingExperiment").append(',');
            this.s2Stuff.append(this.participantCode).append(',');
            this.s2Stuff.append(modeString).append(',');
            this.s2Stuff.append(this.conditionCode).append(',');
            this.s2Stuff.append(this.blockCode).append(',');
            this.s2Stuff.append(this.phraseCount + 1).append(',');
            this.s2Stuff.append(this.textToGuess).append(',');
            this.s2Stuff.append(this.reducedText).append(',');
            this.s2Stuff.append(correct).append(',');
            this.s2Stuff.append(incorrect).append(',');
            this.s2Stuff.append(kspc).append(',');
            this.s2Stuff.append(this.elapsedTime).append('\n');
            try {
                this.sd1File.write(this.s1Stuff.toString(), 0, this.s1Stuff.length());
                this.sd1File.flush();
                this.sd2File.write(this.s2Stuff.toString(), 0, this.s2Stuff.length());
                this.sd2File.flush();
            }
            catch (IOException e) {
                this.showError("ERROR WRITING TO DATA FILE!\n" + e);
                System.exit(1);
            }
            StringBuilder resultsString = new StringBuilder();
            resultsString.append("Thank you!").append('\n').append('\n');
            resultsString.append(String.format("Number of letters:\t%d\n", this.reducedText.length()));
            resultsString.append(String.format("Correct guesses:\t%d\n", correct));
            resultsString.append(String.format("Incorrect guesses:\t%d\n", incorrect));
            resultsString.append(String.format("KSPC:\t\t%.2f\n\n", kspc));
            resultsString.append("Click OK to continue");
            this.resultsArea.setText(resultsString.toString());
            this.resultsDialog.setVisible(true);
            ++this.phraseCount;
            if (this.phraseCount == this.numberOfPhrases) {
                JLabel thankYou = new JLabel("End of block. Thank you.");
                thankYou.setFont(new Font("sansserif", 0, 16));
                JOptionPane.showMessageDialog(this, thankYou);
                try {
                    this.sd1File.close();
                    this.sd2File.close();
                }
                catch (IOException e) {
                    this.showError("ERROR CLOSING DATA FILE!\n" + e);
                    System.exit(1);
                }
                System.exit(0);
            } else {
                this.newTrial();
            }
        }
    }

    double entropy(String reducedTextArg, int mode) {
        String s = reducedTextArg;
        double entropy = 0.0;
        double LOG2_27 = Math.log(27.0) / Math.log(2.0);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (mode == 100) {
                entropy += c == '-' ? 0.0 : LOG2_27;
            } else {
                int n = c <= '9' ? c - 48 : c - 65 + 10;
                entropy += --n == 0 ? 0.0 : Math.log(2.0 * (double)n) / Math.log(2.0);
            }
            ++i;
        }
        return entropy /= (double)s.length();
    }

    void newTrial() {
        this.textToGuess = this.phraseArray[this.phraseCount].toLowerCase();
        this.presentedText = "";
        int i = 0;
        while (i < this.textToGuess.length()) {
            this.presentedText = String.valueOf(this.presentedText) + "*";
            ++i;
        }
        this.reducedText = "";
        this.letterCount = 0;
        this.guessCount = 0;
        this.presentedTextField.setText(this.presentedText);
        this.reducedTextField.setText("");
        this.reducedTextField.requestFocus();
        this.s1Stuff = new StringBuilder(this.textToGuess);
        this.s1Stuff.append('\n');
        this.s2Stuff = new StringBuilder();
        this.mode2Guesses = new StringBuilder();
        this.t = System.currentTimeMillis();
        this.elapsedTime = 0L;
    }

    public Clip initSound(String soundFile) {
        Clip c = null;
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(this.getClass().getResourceAsStream(soundFile)));
            c = AudioSystem.getClip();
            c.open(audioInputStream);
        }
        catch (Exception e) {
            this.showError("ERROR: Unable to load sound clip (" + soundFile + ")");
        }
        return c;
    }

    public void playSound(Clip c) {
        if (c != null) {
            c.setFramePosition(0);
            c.start();
        }
    }

    class Keyboard
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        final String keyLabel = "QWERTYUIOPASDFGHJKLZXCVBNM";
        JButton[] key;
        JButton spaceKey;
        int width;
        int height;
        ActionEvent ae;

        public Keyboard(int widthArg, int heightArg, ActionListener alArg) {
            this.width = widthArg;
            this.height = heightArg;
            this.key = new JButton["QWERTYUIOPASDFGHJKLZXCVBNM".length()];
            int i = 0;
            while (i < this.key.length) {
                this.key[i] = new JButton("QWERTYUIOPASDFGHJKLZXCVBNM".substring(i, i + 1));
                this.key[i].setBackground(Color.LIGHT_GRAY);
                this.key[i].setFont(new Font("sansserif", 1, 16));
                this.key[i].setPreferredSize(new Dimension(this.width, this.height));
                ++i;
            }
            this.spaceKey = new JButton(" ");
            this.spaceKey.setBackground(Color.LIGHT_GRAY);
            this.spaceKey.setPreferredSize(new Dimension(4 * this.width, this.height));
            i = 0;
            while (i < this.key.length) {
                this.key[i].addActionListener(alArg);
                ++i;
            }
            this.spaceKey.addActionListener(alArg);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setLayout(null);
            int i2 = 0;
            while (i2 < this.key.length) {
                int y;
                int x;
                if (i2 < 10) {
                    x = i2 * this.width;
                    y = 0;
                } else if (i2 < 19) {
                    x = (i2 - 10) * this.width + this.width / 3;
                    y = this.height;
                } else {
                    x = (i2 - 19) * this.width + 2 * (this.width / 3);
                    y = 2 * this.height;
                }
                this.add(this.key[i2]);
                this.key[i2].setBounds(x, y, this.width, this.height);
                ++i2;
            }
            this.add(this.spaceKey);
            this.spaceKey.setBounds(2 * this.width, 3 * this.height, 6 * this.width, this.height);
            this.setPreferredSize(new Dimension(10 * this.width, 4 * this.height));
            this.setMaximumSize(new Dimension(10 * this.width, 4 * this.height));
            this.setBorder(BorderFactory.createLineBorder(Color.gray));
        }

        public ActionEvent getActionEvent() {
            return this.ae;
        }

        public void setActionEvent(ActionEvent aeArg) {
            this.ae = aeArg;
        }

        public void disableKey(JButton keyArg, ActionListener alArg) {
            keyArg.setBackground(Color.DARK_GRAY);
            keyArg.setOpaque(true);
        }

        public void enableKeys(ActionListener alArg) {
            int i = 0;
            while (i < this.key.length) {
                this.key[i].setBackground(Color.LIGHT_GRAY);
                ++i;
            }
            this.spaceKey.setBackground(Color.LIGHT_GRAY);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.setActionEvent(ae);
        }
    }
}

