/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.Timer;

class ReactionTimeExpFrame
extends JFrame {
    private final String WORD_FILE = "d1-word.txt";
    private static final long serialVersionUID = 1L;
    SRDialog sr;
    PMDialog pm;
    NMDialog nm;
    CMDialog cm;
    VSDialog vs;
    String[] word;
    int numberOfItems;
    int maxTrials;
    String modeName;
    JDialog resultsDialog;
    JOptionPane resultsPane;
    JTextArea resultsArea;
    boolean begin = false;
    int[] time;
    char[] key;
    int[] match;
    int[] error;
    int count = 0;
    BufferedWriter bw1;
    BufferedWriter bw2;
    String mode;
    String participantCode;
    String blockCode;

    public ReactionTimeExpFrame(ReactionTimeExperimentConfiguration c) {
        String s;
        this.participantCode = c.getParticipantCode() < 10 ? "P0" + c.getParticipantCode() : "P" + c.getParticipantCode();
        this.blockCode = c.getBlockCode() < 10 ? "B0" + c.getBlockCode() : "B" + c.getBlockCode();
        this.maxTrials = c.getNumberOfTrials();
        if (this.maxTrials == 0) {
            this.showError("Oops! Try again with number_of_trials > 0");
            System.exit(0);
        }
        this.mode = c.getMode();
        this.modeName = c.getModeName();
        this.numberOfItems = c.getNumberOfItems();
        this.time = new int[this.maxTrials];
        this.key = new char[this.maxTrials];
        this.match = new int[this.maxTrials];
        this.error = new int[this.maxTrials];
        this.sr = new SRDialog(this);
        this.pm = new PMDialog(this);
        this.nm = new NMDialog(this);
        this.cm = new CMDialog(this);
        this.vs = new VSDialog(this, c.getNumberOfItems());
        Scanner inFile = null;
        try {
            inFile = new Scanner(new File("d1-word.txt"));
        }
        catch (FileNotFoundException e) {
            this.showError("File not found: d1-word.txt");
            System.exit(1);
        }
        ArrayList<String> wordArray = new ArrayList<String>();
        while (inFile.hasNextLine()) {
            s = inFile.nextLine().trim();
            if (s.length() != 5) continue;
            wordArray.add(s);
        }
        this.word = new String[wordArray.size()];
        this.word = wordArray.toArray(this.word);
        this.resultsArea = new JTextArea(9, 20);
        this.resultsArea.setFont(new Font("sansserif", 0, 18));
        this.resultsArea.setBackground(new JButton().getBackground());
        this.resultsPane = new JOptionPane(this.resultsArea, 1);
        this.resultsPane.setFont(new Font("sansserif", 0, 18));
        this.resultsDialog = this.resultsPane.createDialog(this, "Information");
        try {
            String base = "ReactionTimeExperiment-" + this.participantCode + "-" + this.blockCode + "-" + this.mode;
            if (this.mode.equals("VS")) {
                base = String.valueOf(base) + "-" + this.numberOfItems;
            }
            this.bw1 = new BufferedWriter(new FileWriter(String.valueOf(base) + ".sd1"));
            this.bw2 = new BufferedWriter(new FileWriter(String.valueOf(base) + ".sd2"));
            String header = "";
            if (this.mode.equals("SR")) {
                header = this.sr.SD2Header();
            } else if (this.mode.equals("PM")) {
                header = this.pm.SD2Header();
            } else if (this.mode.equals("CM")) {
                header = this.cm.SD2Header();
            } else if (this.mode.equals("VS")) {
                header = this.vs.SD2Header();
            }
            this.bw2.write(header, 0, header.length());
            this.bw2.flush();
        }
        catch (IOException e) {
            this.showError("I/O error: can't open output data file(s)");
            System.exit(0);
        }
        if (this.mode.equals("SR")) {
            this.sr.showSRDialog(this);
            try {
                s = this.sr.SD1Results();
                this.bw1.write(s, 0, s.length());
                this.bw1.flush();
                s = this.sr.SD2Results();
                this.bw2.write(s, 0, s.length());
                this.bw2.flush();
            }
            catch (IOException e) {
                this.showError("I/O error writing to output data file");
                System.exit(0);
            }
            this.showResults(this.modeName);
        } else if (this.mode.equals("PM")) {
            this.pm.showPMDialog(this);
            try {
                s = this.pm.SD1Results();
                this.bw1.write(s, 0, s.length());
                this.bw1.flush();
                s = this.pm.SD2Results();
                this.bw2.write(s, 0, s.length());
                this.bw2.flush();
            }
            catch (IOException e) {
                this.showError("I/O error writing to output data file");
                System.exit(0);
            }
            this.showResults(this.modeName);
        } else if (this.mode.equals("NM")) {
            this.nm.showNMDialog(this);
            try {
                s = this.nm.SD1Results();
                this.bw1.write(s, 0, s.length());
                this.bw1.flush();
                s = this.nm.SD2Results();
                this.bw2.write(s, 0, s.length());
                this.bw2.flush();
            }
            catch (IOException e) {
                this.showError("I/O error writing to output data file");
                System.exit(0);
            }
            this.showResults(this.modeName);
        } else if (this.mode.equals("CM")) {
            this.cm.showCMDialog(this);
            try {
                s = this.cm.SD1Results();
                this.bw1.write(s, 0, s.length());
                this.bw1.flush();
                s = this.cm.SD2Results();
                this.bw2.write(s, 0, s.length());
                this.bw2.flush();
            }
            catch (IOException e) {
                this.showError("I/O error writing to output data file");
                System.exit(0);
            }
            this.showResults(this.modeName);
        } else if (this.mode.equals("VS")) {
            this.vs.showVSDialog(this);
            try {
                s = this.vs.SD1Results();
                this.bw1.write(s, 0, s.length());
                this.bw1.flush();
                s = this.vs.SD2Results();
                this.bw2.write(s, 0, s.length());
                this.bw2.flush();
            }
            catch (IOException e) {
                this.showError("I/O error writing to output data file");
                System.exit(0);
            }
            this.showResults(this.modeName);
        }
        System.exit(0);
    }

    void showError(String msg) {
        JOptionPane.showMessageDialog(null, msg, "I/O Error", 0);
    }

    void showResults(String mode) {
        String s = "Thank you!\n\n";
        s = String.valueOf(s) + String.format("  *** %s ***\n", mode);
        s = String.valueOf(s) + String.format("  Mean RT = %1.1f ms\n", this.mean(this.time));
        s = String.valueOf(s) + String.format("  min = %d ms\n", this.min(this.time));
        s = String.valueOf(s) + String.format("  max = %d ms\n", this.max(this.time));
        s = String.valueOf(s) + String.format("  SD = %1.2f ms\n", this.sd(this.time));
        s = String.valueOf(s) + String.format("  Errors = %d", (int)(this.mean(this.error) * (double)this.error.length));
        this.resultsArea.setText(s);
        this.resultsDialog.setVisible(true);
    }

    Font getRandomFont() {
        Random r = new Random();
        String name = r.nextBoolean() ? "monospaced" : "sansserif";
        int style = r.nextBoolean() ? 0 : 1;
        int size = r.nextBoolean() ? 18 : 20;
        return new Font(name, style, size);
    }

    public double mean(int[] n) {
        double mean = 0.0;
        int j = 0;
        while (j < n.length) {
            mean += (double)n[j];
            ++j;
        }
        return mean / (double)n.length;
    }

    public double sd(int[] n) {
        double m = this.mean(n);
        double t = 0.0;
        int j = 0;
        while (j < n.length) {
            t += (m - (double)n[j]) * (m - (double)n[j]);
            ++j;
        }
        return Math.sqrt(t / ((double)n.length - 1.0));
    }

    public int min(int[] n) {
        int min = n[0];
        int j = 1;
        while (j < n.length) {
            if (n[j] < min) {
                min = n[j];
            }
            ++j;
        }
        return min;
    }

    public int max(int[] n) {
        int max = n[0];
        int j = 1;
        while (j < n.length) {
            if (n[j] > max) {
                max = n[j];
            }
            ++j;
        }
        return max;
    }

    private class CMDialog
    extends JDialog
    implements ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        Timer t;
        Random r;
        JPanel experimentPanel;
        JLabel s1Label;
        JLabel s2Label;
        JPanel sPanel;
        long t1;
        RandomBooleanArray rba;
        boolean armed;
        char c1;
        char c2;
        String letters;
        String numbers;
        boolean matchMode;
        boolean letterMode;

        CMDialog(Frame owner) {
            super(owner, "Class Matching", true);
            this.t1 = 0L;
            this.armed = false;
            this.letters = "ABCDEFGHJKLNMPQRSTUVWXWZ";
            this.numbers = "23456789";
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.t = new Timer(2000, this);
            this.r = new Random();
            this.rba = new RandomBooleanArray(ReactionTimeExpFrame.this.maxTrials);
            Font F18 = new Font("sansserif", 0, 18);
            Dimension D = new Dimension(30, 30);
            this.s1Label = new JLabel("  ", 0);
            this.s1Label.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.s1Label.setPreferredSize(D);
            this.s1Label.setMaximumSize(D);
            this.s1Label.setFont(F18);
            this.s2Label = new JLabel("  ", 0);
            this.s2Label.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.s2Label.setPreferredSize(D);
            this.s2Label.setMaximumSize(D);
            this.s2Label.setFont(F18);
            this.sPanel = new JPanel();
            this.sPanel.add(this.s1Label);
            this.sPanel.add(this.s2Label);
            this.experimentPanel = new JPanel();
            this.experimentPanel.setLayout(new BoxLayout(this.experimentPanel, 1));
            this.experimentPanel.setPreferredSize(new Dimension(200, 200));
            this.experimentPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.experimentPanel.add(Box.createVerticalGlue());
            this.experimentPanel.add(Box.createVerticalGlue());
            this.experimentPanel.add(this.sPanel);
            this.experimentPanel.add(Box.createVerticalGlue());
            this.addKeyListener(this);
            this.setContentPane(this.experimentPanel);
            this.pack();
        }

        public int showCMDialog(Frame f) {
            this.rba.shuffle();
            ReactionTimeExpFrame.this.count = 0;
            this.s1Label.setBackground(Color.gray);
            this.s2Label.setText("");
            this.setLocationRelativeTo(f);
            this.t.restart();
            this.s1Label.setText("");
            this.s2Label.setText("");
            this.setVisible(true);
            this.t.stop();
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!this.armed) {
                this.matchMode = this.rba.nextBooleanArrayEntry();
                this.letterMode = this.r.nextBoolean();
                this.c1 = this.letterMode ? this.letters.charAt(this.r.nextInt(this.letters.length())) : this.numbers.charAt(this.r.nextInt(this.numbers.length()));
                this.s1Label.setFont(ReactionTimeExpFrame.this.getRandomFont());
                this.s1Label.setText("" + this.c1);
                this.t.setInitialDelay(2000 + this.r.nextInt(3000));
                this.t.restart();
                this.armed = true;
            } else {
                this.t.stop();
                this.c2 = this.matchMode ? (this.letterMode ? this.letters.charAt(this.r.nextInt(this.letters.length())) : this.numbers.charAt(this.r.nextInt(this.numbers.length()))) : (this.letterMode ? this.numbers.charAt(this.r.nextInt(this.numbers.length())) : this.letters.charAt(this.r.nextInt(this.letters.length())));
                this.s2Label.setFont(ReactionTimeExpFrame.this.getRandomFont());
                this.s2Label.setText("" + this.c2);
                this.t1 = System.currentTimeMillis();
            }
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            ReactionTimeExpFrame.this.time[ReactionTimeExpFrame.this.count] = (int)(System.currentTimeMillis() - this.t1);
            ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] = Character.toLowerCase(ke.getKeyChar());
            ReactionTimeExpFrame.this.match[ReactionTimeExpFrame.this.count] = this.letters.indexOf(this.s1Label.getText()) >= 0 && this.letters.indexOf(this.s2Label.getText()) >= 0 || this.numbers.indexOf(this.s1Label.getText()) >= 0 && this.numbers.indexOf(this.s2Label.getText()) >= 0 ? 1 : 0;
            ReactionTimeExpFrame.this.error[ReactionTimeExpFrame.this.count] = ReactionTimeExpFrame.this.match[ReactionTimeExpFrame.this.count] == 1 && ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] != 'j' && ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] != 'f' || ReactionTimeExpFrame.this.match[ReactionTimeExpFrame.this.count] == 0 && (ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] == 'j' || ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] == 'f') ? 1 : 0;
            ++ReactionTimeExpFrame.this.count;
            if (ReactionTimeExpFrame.this.count == ReactionTimeExpFrame.this.maxTrials) {
                this.setVisible(false);
                this.rba = new RandomBooleanArray(ReactionTimeExpFrame.this.maxTrials);
            }
            this.t.setInitialDelay(2000);
            this.t.restart();
            this.s1Label.setText("");
            this.s2Label.setText("");
            this.armed = false;
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
        }

        public String SD1Results() {
            StringBuilder s = new StringBuilder();
            s.append("time");
            int i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(',').append(ReactionTimeExpFrame.this.time[i]);
                ++i;
            }
            s.append('\n');
            s.append("keys,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.key[i]).append(',');
                ++i;
            }
            s.append('\n');
            s.append("matches,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.match[i]).append(',');
                ++i;
            }
            s.append('\n');
            s.append("errors,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.error[i]).append(',');
                ++i;
            }
            s.append('\n');
            return s.toString();
        }

        public String SD2Results() {
            double meanMatchTime = 0.0;
            double meanNoMatchTime = 0.0;
            int nMatch = 0;
            int nNoMatch = 0;
            int nMatchError = 0;
            int nNoMatchError = 0;
            int i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                if (ReactionTimeExpFrame.this.match[i] == 1) {
                    if (ReactionTimeExpFrame.this.error[i] == 0) {
                        meanMatchTime += (double)ReactionTimeExpFrame.this.time[i];
                        ++nMatch;
                    } else {
                        ++nMatchError;
                    }
                } else if (ReactionTimeExpFrame.this.error[i] == 0) {
                    meanNoMatchTime += (double)ReactionTimeExpFrame.this.time[i];
                    ++nNoMatch;
                } else {
                    ++nNoMatchError;
                }
                ++i;
            }
            return String.valueOf(ReactionTimeExpFrame.this.participantCode) + "," + ReactionTimeExpFrame.this.blockCode + "," + ReactionTimeExpFrame.this.mode + "," + (meanMatchTime /= (double)nMatch) + "," + nMatch + "," + nMatchError + "," + (meanNoMatchTime /= (double)nNoMatch) + "," + nNoMatch + "," + nNoMatchError;
        }

        public String SD2Header() {
            return "Participant,Block,Mode,RT_match,n_match,error_match,RT_no-match,n_no-match,error_no-match\n";
        }
    }

    private class NMDialog
    extends JDialog
    implements ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        Timer t;
        Random r;
        JPanel experimentPanel;
        JLabel s1Label;
        JLabel s2Label;
        JPanel sPanel;
        long t1;
        RandomBooleanArray rba;
        boolean armed;
        String w1;
        String w2;

        NMDialog(Frame owner) {
            super(owner, "Name Matching", true);
            this.t1 = 0L;
            this.armed = false;
            this.w1 = "";
            this.w2 = "";
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.t = new Timer(2000, this);
            this.r = new Random();
            this.rba = new RandomBooleanArray(ReactionTimeExpFrame.this.maxTrials);
            Font F18 = new Font("sansserif", 0, 18);
            Dimension D = new Dimension(90, 30);
            this.s1Label = new JLabel("          ", 0);
            this.s1Label.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.s1Label.setPreferredSize(D);
            this.s1Label.setMaximumSize(D);
            this.s1Label.setFont(F18);
            this.s2Label = new JLabel("          ", 0);
            this.s2Label.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.s2Label.setPreferredSize(D);
            this.s2Label.setMaximumSize(D);
            this.s2Label.setFont(F18);
            this.sPanel = new JPanel();
            this.sPanel.add(this.s1Label);
            this.sPanel.add(this.s2Label);
            this.experimentPanel = new JPanel();
            this.experimentPanel.setLayout(new BoxLayout(this.experimentPanel, 1));
            this.experimentPanel.setPreferredSize(new Dimension(200, 200));
            this.experimentPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.experimentPanel.add(Box.createVerticalGlue());
            this.experimentPanel.add(Box.createVerticalGlue());
            this.experimentPanel.add(this.sPanel);
            this.experimentPanel.add(Box.createVerticalGlue());
            this.addKeyListener(this);
            this.setContentPane(this.experimentPanel);
            this.pack();
        }

        public int showNMDialog(Frame f) {
            this.rba.shuffle();
            ReactionTimeExpFrame.this.count = 0;
            this.s1Label.setBackground(Color.gray);
            this.setLocationRelativeTo(f);
            this.t.restart();
            this.s1Label.setText("");
            this.s2Label.setText("");
            this.setVisible(true);
            this.t.stop();
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!this.armed) {
                this.w1 = ReactionTimeExpFrame.this.word[this.r.nextInt(ReactionTimeExpFrame.this.word.length)];
                if (this.r.nextBoolean()) {
                    this.w1 = this.w1.toUpperCase();
                }
                this.s1Label.setFont(ReactionTimeExpFrame.this.getRandomFont());
                this.s1Label.setText(this.w1);
                this.t.setInitialDelay(2000 + this.r.nextInt(3000));
                this.t.restart();
                this.armed = true;
            } else {
                this.t.stop();
                this.w2 = ReactionTimeExpFrame.this.word[this.r.nextInt(ReactionTimeExpFrame.this.word.length)];
                if (this.r.nextBoolean()) {
                    this.w2 = this.w2.toUpperCase();
                }
                this.s2Label.setFont(ReactionTimeExpFrame.this.getRandomFont());
                if (this.rba.nextBooleanArrayEntry()) {
                    this.s2Label.setText(this.w1);
                } else {
                    this.s2Label.setText(this.w2);
                }
                this.t1 = System.currentTimeMillis();
            }
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            ReactionTimeExpFrame.this.time[ReactionTimeExpFrame.this.count] = (int)(System.currentTimeMillis() - this.t1);
            ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] = Character.toLowerCase(ke.getKeyChar());
            ReactionTimeExpFrame.this.match[ReactionTimeExpFrame.this.count] = this.s1Label.getText().equals(this.s2Label.getText()) ? 1 : 0;
            ReactionTimeExpFrame.this.error[ReactionTimeExpFrame.this.count] = ReactionTimeExpFrame.this.match[ReactionTimeExpFrame.this.count] == 1 && ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] != 'j' && ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] != 'f' || ReactionTimeExpFrame.this.match[ReactionTimeExpFrame.this.count] == 0 && (ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] == 'j' || ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] == 'f') ? 1 : 0;
            ++ReactionTimeExpFrame.this.count;
            if (ReactionTimeExpFrame.this.count == ReactionTimeExpFrame.this.maxTrials) {
                this.setVisible(false);
                this.rba = new RandomBooleanArray(ReactionTimeExpFrame.this.maxTrials);
            }
            this.t.setInitialDelay(2000);
            this.t.restart();
            this.s1Label.setText("");
            this.s2Label.setText("");
            this.armed = false;
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
        }

        public String SD1Results() {
            StringBuilder s = new StringBuilder();
            s.append("time");
            int i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(',').append(ReactionTimeExpFrame.this.time[i]);
                ++i;
            }
            s.append('\n');
            s.append("keys,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.key[i]).append(',');
                ++i;
            }
            s.append('\n');
            s.append("matches,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.match[i]).append(',');
                ++i;
            }
            s.append('\n');
            s.append("errors,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.error[i]).append(',');
                ++i;
            }
            s.append('\n');
            return s.toString();
        }

        public String SD2Results() {
            double meanMatchTime = 0.0;
            double meanNoMatchTime = 0.0;
            int nMatch = 0;
            int nNoMatch = 0;
            int nMatchError = 0;
            int nNoMatchError = 0;
            int i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                if (ReactionTimeExpFrame.this.match[i] == 1) {
                    if (ReactionTimeExpFrame.this.error[i] == 0) {
                        meanMatchTime += (double)ReactionTimeExpFrame.this.time[i];
                        ++nMatch;
                    } else {
                        ++nMatchError;
                    }
                } else if (ReactionTimeExpFrame.this.error[i] == 0) {
                    meanNoMatchTime += (double)ReactionTimeExpFrame.this.time[i];
                    ++nNoMatch;
                } else {
                    ++nNoMatchError;
                }
                ++i;
            }
            return String.valueOf(ReactionTimeExpFrame.this.participantCode) + "," + ReactionTimeExpFrame.this.blockCode + "," + ReactionTimeExpFrame.this.mode + "," + (meanMatchTime /= (double)nMatch) + "," + nMatch + "," + nMatchError + "," + (meanNoMatchTime /= (double)nNoMatch) + "," + nNoMatch + "," + nNoMatchError;
        }

        public String SD2Header() {
            return "Participant,Block,Mode,RT_match,n_match,error_match,RT_no-match,n_no-match,error_no-match\n";
        }
    }

    private class PMDialog
    extends JDialog
    implements ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        Timer t;
        Random r;
        JPanel experimentPanel;
        JLabel s1Label;
        JLabel s2Label;
        JPanel sPanel;
        long t1;
        RandomBooleanArray rba;
        boolean armed;
        String w1;
        String w2;

        PMDialog(Frame owner) {
            super(owner, "Physical Matching", true);
            this.t1 = 0L;
            this.armed = false;
            this.w1 = "";
            this.w2 = "";
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.rba = new RandomBooleanArray(ReactionTimeExpFrame.this.maxTrials);
            this.t = new Timer(2000, this);
            this.r = new Random();
            Font F18 = new Font("sansserif", 0, 18);
            Dimension D = new Dimension(90, 30);
            this.s1Label = new JLabel("          ", 0);
            this.s1Label.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.s1Label.setPreferredSize(D);
            this.s1Label.setMaximumSize(D);
            this.s1Label.setFont(F18);
            this.s2Label = new JLabel("          ", 0);
            this.s2Label.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.s2Label.setPreferredSize(D);
            this.s2Label.setMaximumSize(D);
            this.s2Label.setFont(F18);
            this.sPanel = new JPanel();
            this.sPanel.add(this.s1Label);
            this.sPanel.add(this.s2Label);
            this.experimentPanel = new JPanel();
            this.experimentPanel.setLayout(new BoxLayout(this.experimentPanel, 1));
            this.experimentPanel.setPreferredSize(new Dimension(200, 200));
            this.experimentPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.experimentPanel.add(Box.createVerticalGlue());
            this.experimentPanel.add(Box.createVerticalGlue());
            this.experimentPanel.add(this.sPanel);
            this.experimentPanel.add(Box.createVerticalGlue());
            this.addKeyListener(this);
            this.setContentPane(this.experimentPanel);
            this.pack();
        }

        public int showPMDialog(Frame f) {
            this.rba.shuffle();
            ReactionTimeExpFrame.this.count = 0;
            this.s1Label.setBackground(Color.gray);
            this.setLocationRelativeTo(f);
            this.t.restart();
            this.s1Label.setText("");
            this.s2Label.setText("");
            this.setVisible(true);
            this.t.stop();
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!this.armed) {
                this.w1 = ReactionTimeExpFrame.this.word[this.r.nextInt(ReactionTimeExpFrame.this.word.length)];
                this.s1Label.setText(this.w1);
                this.t.setInitialDelay(2000 + this.r.nextInt(3000));
                this.t.restart();
                this.armed = true;
            } else {
                this.t.stop();
                this.w2 = ReactionTimeExpFrame.this.word[this.r.nextInt(ReactionTimeExpFrame.this.word.length)];
                if (this.rba.nextBooleanArrayEntry()) {
                    this.s2Label.setText(this.w1);
                } else {
                    this.s2Label.setText(this.w2);
                }
                this.t1 = System.currentTimeMillis();
            }
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            ReactionTimeExpFrame.this.time[ReactionTimeExpFrame.this.count] = (int)(System.currentTimeMillis() - this.t1);
            ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] = Character.toLowerCase(ke.getKeyChar());
            ReactionTimeExpFrame.this.match[ReactionTimeExpFrame.this.count] = this.s1Label.getText().equals(this.s2Label.getText()) ? 1 : 0;
            ReactionTimeExpFrame.this.error[ReactionTimeExpFrame.this.count] = ReactionTimeExpFrame.this.match[ReactionTimeExpFrame.this.count] == 1 && ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] != 'j' && ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] != 'f' || ReactionTimeExpFrame.this.match[ReactionTimeExpFrame.this.count] == 0 && (ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] == 'j' || ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] == 'f') ? 1 : 0;
            ++ReactionTimeExpFrame.this.count;
            if (ReactionTimeExpFrame.this.count == ReactionTimeExpFrame.this.maxTrials) {
                this.setVisible(false);
                this.rba = new RandomBooleanArray(ReactionTimeExpFrame.this.maxTrials);
            }
            this.t.setInitialDelay(2000);
            this.t.restart();
            this.s1Label.setText("");
            this.s2Label.setText("");
            this.armed = false;
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
        }

        public String SD1Results() {
            StringBuilder s = new StringBuilder();
            s.append("time");
            int i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(',').append(ReactionTimeExpFrame.this.time[i]);
                ++i;
            }
            s.append('\n');
            s.append("keys,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.key[i]).append(',');
                ++i;
            }
            s.append('\n');
            s.append("matches,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.match[i]).append(',');
                ++i;
            }
            s.append('\n');
            s.append("errors,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.error[i]).append(',');
                ++i;
            }
            s.append('\n');
            return s.toString();
        }

        public String SD2Results() {
            double meanMatchTime = 0.0;
            double meanNoMatchTime = 0.0;
            int nMatch = 0;
            int nNoMatch = 0;
            int nMatchError = 0;
            int nNoMatchError = 0;
            int i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                if (ReactionTimeExpFrame.this.match[i] == 1) {
                    if (ReactionTimeExpFrame.this.error[i] == 0) {
                        meanMatchTime += (double)ReactionTimeExpFrame.this.time[i];
                        ++nMatch;
                    } else {
                        ++nMatchError;
                    }
                } else if (ReactionTimeExpFrame.this.error[i] == 0) {
                    meanNoMatchTime += (double)ReactionTimeExpFrame.this.time[i];
                    ++nNoMatch;
                } else {
                    ++nNoMatchError;
                }
                ++i;
            }
            return String.valueOf(ReactionTimeExpFrame.this.participantCode) + "," + ReactionTimeExpFrame.this.blockCode + "," + ReactionTimeExpFrame.this.mode + "," + (meanMatchTime /= (double)nMatch) + "," + nMatch + "," + nMatchError + "," + (meanNoMatchTime /= (double)nNoMatch) + "," + nNoMatch + "," + nNoMatchError;
        }

        public String SD2Header() {
            return "Participant,Block,Mode,RT_match,n_match,error_match,RT_no-match,n_no-match,error_no-match\n";
        }
    }

    private class RandomBooleanArray {
        int size;
        boolean[] booleanArray;
        int nextCounter;

        RandomBooleanArray(int sizeArg) {
            this.size = sizeArg;
            this.booleanArray = new boolean[this.size];
            int i = 0;
            while (i < this.size) {
                this.booleanArray[i] = i >= this.size / 2;
                ++i;
            }
            this.shuffle();
            this.nextCounter = 0;
        }

        void shuffle() {
            Random r = new Random();
            int i = 0;
            while (i < this.size / 2) {
                if (r.nextBoolean()) {
                    boolean temp = this.booleanArray[i];
                    this.booleanArray[i] = this.booleanArray[i + this.size / 2];
                    this.booleanArray[i + this.size / 2] = temp;
                }
                ++i;
            }
        }

        boolean nextBooleanArrayEntry() {
            return this.booleanArray[this.nextCounter++];
        }
    }

    private class SRDialog
    extends JDialog
    implements ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        Timer t;
        Random r;
        JPanel experimentPanel;
        JPanel stimulusPanel;
        long t1;
        boolean begin;

        SRDialog(Frame owner) {
            super(owner, "Simple Reaction Time", true);
            this.t1 = 0L;
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.t = new Timer(2000, this);
            this.r = new Random();
            this.begin = false;
            this.stimulusPanel = new JPanel();
            this.stimulusPanel.setBackground(Color.gray);
            this.stimulusPanel.setPreferredSize(new Dimension(50, 50));
            this.stimulusPanel.setMaximumSize(this.stimulusPanel.getPreferredSize());
            this.stimulusPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.experimentPanel = new JPanel();
            this.experimentPanel.setLayout(new BoxLayout(this.experimentPanel, 1));
            this.experimentPanel.setPreferredSize(new Dimension(200, 200));
            this.experimentPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.experimentPanel.add(Box.createVerticalGlue());
            this.experimentPanel.add(this.stimulusPanel);
            this.experimentPanel.add(Box.createVerticalGlue());
            this.addKeyListener(this);
            this.setContentPane(this.experimentPanel);
            this.pack();
        }

        public int showSRDialog(Frame f) {
            ReactionTimeExpFrame.this.count = 0;
            this.stimulusPanel.setBackground(Color.gray);
            this.setLocationRelativeTo(f);
            this.t.restart();
            this.begin = false;
            this.setVisible(true);
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.stimulusPanel.setBackground(Color.red);
            this.t1 = System.currentTimeMillis();
            this.begin = true;
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            if (!this.begin) {
                ke.consume();
                return;
            }
            ReactionTimeExpFrame.this.time[ReactionTimeExpFrame.this.count++] = (int)(System.currentTimeMillis() - this.t1);
            if (ReactionTimeExpFrame.this.count == ReactionTimeExpFrame.this.maxTrials) {
                this.begin = false;
                this.stimulusPanel.setBackground(Color.gray);
                this.setVisible(false);
            } else {
                this.t.setInitialDelay(2000 + this.r.nextInt(3000));
                this.t.restart();
                this.stimulusPanel.setBackground(Color.gray);
                this.begin = false;
            }
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
        }

        public String SD1Results() {
            StringBuilder s = new StringBuilder("time");
            int i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(',').append(ReactionTimeExpFrame.this.time[i]);
                ++i;
            }
            s.append('\n');
            return s.toString();
        }

        public String SD2Results() {
            return String.format("%s,%s,%s,%f,%d,%d,%f", ReactionTimeExpFrame.this.participantCode, ReactionTimeExpFrame.this.blockCode, ReactionTimeExpFrame.this.mode, ReactionTimeExpFrame.this.mean(ReactionTimeExpFrame.this.time), ReactionTimeExpFrame.this.min(ReactionTimeExpFrame.this.time), ReactionTimeExpFrame.this.max(ReactionTimeExpFrame.this.time), ReactionTimeExpFrame.this.sd(ReactionTimeExpFrame.this.time));
        }

        public String SD2Header() {
            return "Participant,Block,Mode,mean,min,max,sd\n";
        }
    }

    private class VSDialog
    extends JDialog
    implements ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        Timer t;
        Random r;
        JPanel experimentPanel;
        JLabel s1Label;
        JLabel[] s2Label;
        JPanel sPanel;
        long t1;
        int numberOfItems;
        RandomBooleanArray rba;
        boolean armed;
        boolean matchMode;
        String c1;

        VSDialog(Frame owner, int numberOfChoicesArg) {
            super(owner, "Visual Search", true);
            this.t1 = 0L;
            this.armed = false;
            this.matchMode = false;
            this.c1 = "";
            this.numberOfItems = numberOfChoicesArg;
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.t = new Timer(2000, this);
            this.r = new Random();
            this.rba = new RandomBooleanArray(ReactionTimeExpFrame.this.maxTrials);
            Font F18 = new Font("sansserif", 0, 18);
            Dimension D = new Dimension(30, 30);
            this.s1Label = new JLabel(" ", 0);
            this.s1Label.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.s1Label.setPreferredSize(D);
            this.s1Label.setMaximumSize(D);
            this.s1Label.setFont(F18);
            this.s2Label = new JLabel[this.numberOfItems];
            JPanel s2Panel = null;
            if (this.numberOfItems == 1) {
                s2Panel = new JPanel(new GridLayout(1, 1));
            } else if (this.numberOfItems == 2) {
                s2Panel = new JPanel(new GridLayout(2, 1));
            } else if (this.numberOfItems == 4) {
                s2Panel = new JPanel(new GridLayout(2, 2));
            } else if (this.numberOfItems == 8) {
                s2Panel = new JPanel(new GridLayout(2, 4));
            } else if (this.numberOfItems == 16) {
                s2Panel = new JPanel(new GridLayout(4, 4));
            } else if (this.numberOfItems == 32) {
                s2Panel = new JPanel(new GridLayout(4, 8));
            } else if (this.numberOfItems == 64) {
                s2Panel = new JPanel(new GridLayout(8, 8));
            } else if (this.numberOfItems == 128) {
                s2Panel = new JPanel(new GridLayout(8, 16));
            }
            int i = 0;
            while (i < this.s2Label.length) {
                this.s2Label[i] = new JLabel(" ", 0);
                this.s2Label[i].setBorder(BorderFactory.createLineBorder(Color.gray));
                this.s2Label[i].setPreferredSize(D);
                this.s2Label[i].setMaximumSize(D);
                this.s2Label[i].setFont(F18);
                s2Panel.add(this.s2Label[i]);
                ++i;
            }
            this.sPanel = new JPanel();
            this.sPanel.add(this.s1Label);
            this.sPanel.add(s2Panel);
            this.experimentPanel = new JPanel();
            this.experimentPanel.setLayout(new BoxLayout(this.experimentPanel, 1));
            this.experimentPanel.setPreferredSize(new Dimension(600, 600));
            this.experimentPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.experimentPanel.add(Box.createVerticalGlue());
            this.experimentPanel.add(Box.createVerticalGlue());
            this.experimentPanel.add(this.sPanel);
            this.experimentPanel.add(Box.createVerticalGlue());
            this.addKeyListener(this);
            this.setContentPane(this.experimentPanel);
            this.pack();
        }

        public int showVSDialog(Frame f) {
            this.rba.shuffle();
            ReactionTimeExpFrame.this.count = 0;
            this.s1Label.setBackground(Color.gray);
            int i = 0;
            while (i < this.s2Label.length) {
                this.s2Label[i].setText("");
                ++i;
            }
            this.setLocationRelativeTo(f);
            this.t.restart();
            this.s1Label.setText("");
            i = 0;
            while (i < this.numberOfItems) {
                this.s2Label[i].setText("");
                ++i;
            }
            this.setVisible(true);
            this.t.stop();
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!this.armed) {
                this.matchMode = this.rba.nextBooleanArrayEntry();
                this.c1 = Character.toString((char)(65 + this.r.nextInt(26)));
                this.s1Label.setText(this.c1);
                this.t.setInitialDelay(2000 + this.r.nextInt(3000));
                this.t.restart();
                this.armed = true;
            } else {
                this.t.stop();
                int location = this.r.nextInt(this.numberOfItems);
                int i = 0;
                while (i < this.numberOfItems) {
                    String c2 = Character.toString((char)(65 + this.r.nextInt(26)));
                    while (c2.equals(this.c1)) {
                        c2 = Character.toString((char)(65 + this.r.nextInt(26)));
                    }
                    if (this.matchMode && location == i) {
                        this.s2Label[i].setText(this.c1);
                    } else {
                        this.s2Label[i].setText(c2);
                    }
                    ++i;
                }
                this.t1 = System.currentTimeMillis();
            }
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            ReactionTimeExpFrame.this.time[ReactionTimeExpFrame.this.count] = (int)(System.currentTimeMillis() - this.t1);
            ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] = Character.toLowerCase(ke.getKeyChar());
            ReactionTimeExpFrame.this.match[ReactionTimeExpFrame.this.count] = this.matchMode ? 1 : 0;
            ReactionTimeExpFrame.this.error[ReactionTimeExpFrame.this.count] = this.matchMode && ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] != 'j' && ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] != 'f' || !this.matchMode && (ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] == 'j' || ReactionTimeExpFrame.this.key[ReactionTimeExpFrame.this.count] == 'f') ? 1 : 0;
            ++ReactionTimeExpFrame.this.count;
            if (ReactionTimeExpFrame.this.count == ReactionTimeExpFrame.this.maxTrials) {
                this.setVisible(false);
                this.rba = new RandomBooleanArray(ReactionTimeExpFrame.this.maxTrials);
            }
            this.t.setInitialDelay(2000);
            this.t.restart();
            this.s1Label.setText("");
            int i = 0;
            while (i < this.numberOfItems) {
                this.s2Label[i].setText("");
                ++i;
            }
            this.armed = false;
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
        }

        public String SD1Results() {
            StringBuilder s = new StringBuilder();
            s.append("time");
            int i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(',').append(ReactionTimeExpFrame.this.time[i]);
                ++i;
            }
            s.append('\n');
            s.append("keys,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.key[i]).append(',');
                ++i;
            }
            s.append('\n');
            s.append("matches,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.match[i]).append(',');
                ++i;
            }
            s.append('\n');
            s.append("errors,");
            i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                s.append(ReactionTimeExpFrame.this.error[i]).append(',');
                ++i;
            }
            s.append('\n');
            return s.toString();
        }

        public String SD2Results() {
            double totalTime = 0.0;
            int totalErrors = 0;
            double totalMatchTime = 0.0;
            int nMatch = 0;
            int nMatchErrors = 0;
            double totalNoMatchTime = 0.0;
            int nNoMatch = 0;
            int nNoMatchErrors = 0;
            int i = 0;
            while (i < ReactionTimeExpFrame.this.time.length) {
                totalTime += (double)ReactionTimeExpFrame.this.time[i];
                totalErrors += ReactionTimeExpFrame.this.error[i];
                if (ReactionTimeExpFrame.this.match[i] == 1) {
                    totalMatchTime += (double)ReactionTimeExpFrame.this.time[i];
                    ++nMatch;
                    nMatchErrors += ReactionTimeExpFrame.this.error[i];
                } else {
                    totalNoMatchTime += (double)ReactionTimeExpFrame.this.time[i];
                    ++nNoMatch;
                    nNoMatchErrors += ReactionTimeExpFrame.this.error[i];
                }
                ++i;
            }
            return String.valueOf(ReactionTimeExpFrame.this.participantCode) + "," + ReactionTimeExpFrame.this.blockCode + "," + ReactionTimeExpFrame.this.mode + "," + this.numberOfItems + "," + totalTime + "," + totalErrors + "," + totalMatchTime + "," + nMatch + "," + nMatchErrors + "," + totalNoMatchTime + "," + nNoMatch + "," + nNoMatchErrors;
        }

        public String SD2Header() {
            return "Participant,Block,Mode,Number_of_Items,total_time,total_errors,total_match_time,n_match,n_match_errors,total_no-match_time,n_no-match,n_no-match_errors\n";
        }
    }
}

