/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class ReactionTimeExperimentSetup
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 42L;
    ReactionTimeExperimentConfiguration c;
    ReactionTimeExperimentConfiguration cSave;
    JLabel banner;
    JTextArea modeDescription;
    JComboBox<String> participantCode;
    JComboBox<String> blockCode;
    JComboBox<String> numberOfTrials;
    JRadioButton srButton;
    JRadioButton pmButton;
    JRadioButton nmButton;
    JRadioButton cmButton;
    JRadioButton vsButton;
    JRadioButton vs1Button;
    JRadioButton vs2Button;
    JRadioButton vs4Button;
    JRadioButton vs8Button;
    JRadioButton vs16Button;
    JRadioButton vs32Button;
    JRadioButton vs64Button;
    JRadioButton vs128Button;
    JButton okButton;
    JButton resetButton;
    JButton exitButton;
    final Font F16 = new Font("sansserif", 0, 16);
    final String[] NUMBERS = new String[]{"0                      ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25"};

    ReactionTimeExperimentSetup(Frame owner, ReactionTimeExperimentConfiguration cArg) {
        super(owner, "Reaction Time Experiment", true);
        this.c = cArg;
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.banner = new JLabel("Setup", 0);
        this.banner.setFont(new Font("sansserif", 0, 24));
        this.banner.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        this.participantCode = new JComboBox<String>(this.NUMBERS);
        this.participantCode.setFont(this.F16);
        this.participantCode.addActionListener(this);
        this.blockCode = new JComboBox<String>(this.NUMBERS);
        this.blockCode.setFont(this.F16);
        this.blockCode.addActionListener(this);
        this.numberOfTrials = new JComboBox<String>(this.NUMBERS);
        this.numberOfTrials.setSelectedIndex(10);
        this.numberOfTrials.setFont(this.F16);
        this.numberOfTrials.addActionListener(this);
        this.srButton = new JRadioButton("Simple Reaction");
        this.pmButton = new JRadioButton("Physical Matching");
        this.nmButton = new JRadioButton("Name Matching");
        this.cmButton = new JRadioButton("Class Matching");
        this.vsButton = new JRadioButton("Visual Search");
        this.srButton.setActionCommand("SR");
        this.pmButton.setActionCommand("PM");
        this.nmButton.setActionCommand("NM");
        this.cmButton.setActionCommand("CM");
        this.vsButton.setActionCommand("VS");
        this.vs1Button = new JRadioButton("1");
        this.vs2Button = new JRadioButton("2");
        this.vs4Button = new JRadioButton("4");
        this.vs8Button = new JRadioButton("8");
        this.vs16Button = new JRadioButton("16");
        this.vs32Button = new JRadioButton("32");
        this.vs64Button = new JRadioButton("64");
        this.vs128Button = new JRadioButton("128");
        this.srButton.setFont(this.F16);
        this.nmButton.setFont(this.F16);
        this.pmButton.setFont(this.F16);
        this.cmButton.setFont(this.F16);
        this.vsButton.setFont(this.F16);
        this.vs1Button.setFont(this.F16);
        this.vs2Button.setFont(this.F16);
        this.vs4Button.setFont(this.F16);
        this.vs8Button.setFont(this.F16);
        this.vs16Button.setFont(this.F16);
        this.vs32Button.setFont(this.F16);
        this.vs64Button.setFont(this.F16);
        this.vs128Button.setFont(this.F16);
        this.disableNumbers();
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.srButton);
        bg1.add(this.pmButton);
        bg1.add(this.nmButton);
        bg1.add(this.cmButton);
        bg1.add(this.vsButton);
        this.srButton.setSelected(true);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.vs1Button);
        bg2.add(this.vs2Button);
        bg2.add(this.vs4Button);
        bg2.add(this.vs8Button);
        bg2.add(this.vs16Button);
        bg2.add(this.vs32Button);
        bg2.add(this.vs64Button);
        bg2.add(this.vs128Button);
        this.vs1Button.setSelected(true);
        JPanel rightButtonPanel = new JPanel();
        rightButtonPanel.setLayout(new BoxLayout(rightButtonPanel, 1));
        rightButtonPanel.add(this.srButton);
        rightButtonPanel.add(this.pmButton);
        rightButtonPanel.add(this.nmButton);
        rightButtonPanel.add(this.cmButton);
        rightButtonPanel.add(this.vsButton);
        this.modeDescription = new JTextArea();
        this.modeDescription.setLineWrap(true);
        this.modeDescription.setWrapStyleWord(true);
        this.modeDescription.setBackground(rightButtonPanel.getBackground());
        this.setModeDescription(this.c.getMode());
        JPanel modeButtonPanel = new JPanel(new GridLayout(1, 2));
        modeButtonPanel.add(this.modeDescription);
        modeButtonPanel.add(rightButtonPanel);
        JPanel itemsButtonPanel = new JPanel();
        itemsButtonPanel.add(this.vs1Button);
        itemsButtonPanel.add(this.vs2Button);
        itemsButtonPanel.add(this.vs4Button);
        itemsButtonPanel.add(this.vs8Button);
        itemsButtonPanel.add(this.vs16Button);
        itemsButtonPanel.add(this.vs32Button);
        itemsButtonPanel.add(this.vs64Button);
        itemsButtonPanel.add(this.vs128Button);
        this.srButton.addActionListener(this);
        this.pmButton.addActionListener(this);
        this.nmButton.addActionListener(this);
        this.cmButton.addActionListener(this);
        this.vsButton.addActionListener(this);
        this.vs1Button.addActionListener(this);
        this.vs2Button.addActionListener(this);
        this.vs4Button.addActionListener(this);
        this.vs8Button.addActionListener(this);
        this.vs16Button.addActionListener(this);
        this.vs32Button.addActionListener(this);
        this.vs64Button.addActionListener(this);
        this.vs128Button.addActionListener(this);
        JPanel modePanel = new JPanel();
        modePanel.setLayout(new BoxLayout(modePanel, 1));
        modePanel.add(modeButtonPanel);
        modePanel.add(itemsButtonPanel);
        modePanel.setBorder(new TitledBorder(new EtchedBorder(), "Mode"));
        this.okButton = new JButton("OK");
        this.okButton.setFont(this.F16);
        this.okButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.setFont(this.F16);
        this.resetButton.addActionListener(this);
        this.exitButton = new JButton("Exit");
        this.exitButton.setFont(this.F16);
        this.exitButton.addActionListener(this);
        this.okButton.setPreferredSize(this.resetButton.getPreferredSize());
        this.exitButton.setPreferredSize(this.resetButton.getPreferredSize());
        this.setDefaults();
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1, 0, 10));
        JLabel l5 = new JLabel("Participant code ", 4);
        l5.setFont(this.F16);
        labelPanel.add(l5);
        JLabel l6 = new JLabel("Block code ", 4);
        l6.setFont(this.F16);
        labelPanel.add(l6);
        JLabel l6a = new JLabel("Number of trials ", 4);
        l6a.setFont(this.F16);
        labelPanel.add(l6a);
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout(new GridLayout(0, 1, 0, 10));
        paramPanel.add(this.participantCode);
        paramPanel.add(this.blockCode);
        paramPanel.add(this.numberOfTrials);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)paramPanel, "East");
        centerPanel.add((Component)labelPanel, "West");
        centerPanel.setBorder(new TitledBorder(new EtchedBorder(), "Parameters"));
        JPanel OKExitPanel = new JPanel();
        OKExitPanel.add(this.okButton);
        OKExitPanel.add(this.resetButton);
        OKExitPanel.add(this.exitButton);
        OKExitPanel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        JPanel pp = new JPanel();
        pp.setLayout(new BorderLayout());
        pp.add("North", centerPanel);
        pp.add("South", modePanel);
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        top.add("North", this.banner);
        top.add("Center", pp);
        top.add("South", OKExitPanel);
        top.add("West", new JLabel("            "));
        top.add("East", new JLabel("            "));
        this.setContentPane(top);
        this.pack();
        this.okButton.requestFocus();
    }

    void enableNumbers() {
        this.vs1Button.setEnabled(true);
        this.vs2Button.setEnabled(true);
        this.vs4Button.setEnabled(true);
        this.vs8Button.setEnabled(true);
        this.vs16Button.setEnabled(true);
        this.vs32Button.setEnabled(true);
        this.vs64Button.setEnabled(true);
        this.vs128Button.setEnabled(true);
    }

    void disableNumbers() {
        this.vs1Button.setEnabled(false);
        this.vs2Button.setEnabled(false);
        this.vs4Button.setEnabled(false);
        this.vs8Button.setEnabled(false);
        this.vs16Button.setEnabled(false);
        this.vs32Button.setEnabled(false);
        this.vs64Button.setEnabled(false);
        this.vs128Button.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.exitButton) {
            System.exit(0);
        } else if (source == this.resetButton) {
            this.setDefaults();
        } else if (source == this.okButton) {
            this.setVisible(false);
        } else if (source == this.participantCode) {
            this.c.setParticipantCode(this.participantCode.getSelectedIndex());
        } else if (source == this.blockCode) {
            this.c.setBlockCode(this.blockCode.getSelectedIndex());
        } else if (source == this.numberOfTrials) {
            this.c.setNumberOfTrials(this.numberOfTrials.getSelectedIndex());
        } else if (source == this.srButton || source == this.pmButton || source == this.nmButton || source == this.cmButton || source == this.vsButton) {
            this.c.setMode(((JRadioButton)source).getActionCommand());
            this.setModeDescription(this.c.getMode());
            if (source == this.vsButton) {
                this.enableNumbers();
            } else {
                this.disableNumbers();
            }
        } else if (source == this.vs1Button || source == this.vs2Button || source == this.vs4Button || source == this.vs8Button || source == this.vs16Button || source == this.vs32Button || source == this.vs64Button || source == this.vs128Button) {
            int n = Integer.parseInt(((JRadioButton)source).getText());
            this.c.setNumberOfItems(n);
        }
    }

    private void setModeDescription(String mode) {
        String description = "";
        if (mode.equals("SR")) {
            description = "Press any key after the box turns red.";
        } else if (mode.equals("PM")) {
            description = "Press F or J if the word pairs match. Press D or K if they do not match.";
        } else if (mode.equals("NM")) {
            description = "Press F or J if the words are the same, regardless of appearence. Press D or K if they are not the same.";
        } else if (mode.equals("CM")) {
            description = "Press F or J if the characters are both letters or are both digits, regardless of appearence. Press D or K otherwise.";
        } else if (mode.equals("VS")) {
            description = "Press F or J if the letter also appears in the grid. Press D or K otherwise. Select the grid size below.";
        }
        this.modeDescription.setText(description);
    }

    private void setDefaults() {
        this.c.setParticipantCode(0);
        this.c.setBlockCode(0);
        this.c.setNumberOfTrials(10);
        this.c.setMode("SR");
        this.c.setNumberOfItems(1);
    }

    public boolean showLetterGuessingExperimentSetup(Frame f) {
        this.setLocationRelativeTo(f);
        this.setVisible(true);
        return true;
    }
}

