/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import javax.swing.JOptionPane;

public class EncodedWord
extends Word {
    static final int MAX = 100;
    public String code;
    private static String alphabet = "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6";
    private static String keys = "2223334445556667777888999926";
    private static String keystrokes = "1231231231231231234123123455";

    public EncodedWord(String s, int n) {
        super(s, n);
        this.code = EncodedWord.encodeWord(s);
    }

    public EncodedWord(String s, int n, String cde) {
        super(s, n);
        this.code = cde;
    }

    public EncodedWord(String s) {
        super(s, 0);
        this.code = s;
    }

    @Override
    public String getWord() {
        return this.word;
    }

    @Override
    public int getFreq() {
        return this.freq;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String cde) {
        this.code = cde;
    }

    @Override
    public String toString() {
        return String.valueOf(this.word) + " " + this.code + " " + this.freq;
    }

    public static String encodeWord(String s1) {
        String s2 = "";
        int i = 0;
        while (i < s1.length()) {
            char c = Character.toLowerCase(s1.charAt(i));
            s2 = String.valueOf(s2) + EncodedWord.encodeLetter(c);
            ++i;
        }
        return s2;
    }

    public static char encodeLetter(char c) {
        return keys.charAt(alphabet.indexOf(c));
    }

    public static EncodedWord[] loadCodedDictionary(String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.exists()) {
            System.out.println("File not found - " + fileName);
            EncodedWord.showError("File not found - " + fileName);
            System.exit(1);
        }
        Scanner inputFile = new Scanner(new File(fileName));
        ArrayList<EncodedWord> dictionary = new ArrayList<EncodedWord>();
        while (inputFile.hasNext()) {
            String line = inputFile.nextLine();
            String[] tokens = line.trim().split("[, \t]+");
            if (tokens.length != 3) {
                System.out.println("Dictionary format error");
                System.out.println("line=" + line);
                EncodedWord.showError("Dictionary format error on line " + line);
                System.exit(0);
            }
            String newWord = tokens[0];
            int newFreq = Integer.parseInt(tokens[1]);
            String newCode = tokens[2];
            dictionary.add(new EncodedWord(newWord, newFreq, newCode));
        }
        inputFile.close();
        EncodedWord[] dict = dictionary.toArray(new EncodedWord[0]);
        Arrays.sort(dict, new ByCode());
        return dict;
    }

    private static void showError(String msg) {
        JOptionPane.showMessageDialog(null, msg, "I/O Error", 0);
    }

    /*
     * Unable to fully structure code
     */
    public static String[] getUnique(String code, EncodedWord[] dict) {
        words = null;
        if (code == "") {
            return words;
        }
        n1 = Arrays.binarySearch(dict, new EncodedWord(code), new ByCode());
        if (n1 >= 0) ** GOTO lbl8
        return words;
lbl-1000:
        // 1 sources

        {
            --n1;
lbl8:
            // 2 sources

            ** while (n1 > 0 && dict[n1].getCode().compareTo((String)dict[n1 - 1].getCode()) == 0)
        }
lbl9:
        // 1 sources

        n2 = n1;
        while (n2 < dict.length && dict[n1].getCode().equals(dict[n2].getCode())) {
            ++n2;
        }
        ew = new EncodedWord[n2 - n1];
        i = n1;
        j = 0;
        while (i < n2) {
            ew[j] = dict[i];
            ++i;
            ++j;
        }
        Arrays.sort(ew, new WordByFreq());
        words = new String[ew.length];
        i = 0;
        while (i < words.length) {
            words[i] = ew[i].getWord();
            ++i;
        }
        return words;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] getTentative(String code, EncodedWord[] dict) {
        block6: {
            if (code == "") {
                return null;
            }
            n1 = Arrays.binarySearch(dict, new EncodedWord(code), new ByCode());
            if (n1 >= 0) break block6;
            n1 = -n1 - 1;
            ** GOTO lbl12
        }
        if (n1 < dict.length) ** GOTO lbl12
        return null;
        while ((s = dict[n1 - 1].code).length() >= code.length() && s.substring(0, code.length()).compareTo(code) == 0) {
            --n1;
lbl12:
            // 3 sources

            if (n1 > 0) continue;
        }
        n2 = n1;
        while (n2 < dict.length) {
            s = dict[n2].getCode();
            if (s.length() < code.length() || s.substring(0, code.length()).compareTo(code) != 0) break;
            ++n2;
        }
        if (n1 == n2) {
            return null;
        }
        ew = new EncodedWord[n2 - n1];
        i = n1;
        j = 0;
        while (i < n2) {
            ew[j] = dict[i];
            ++i;
            ++j;
        }
        Arrays.sort(ew, new WordByFreq());
        n = ew.length > 100 ? 100 : ew.length;
        words = new String[n];
        i = 0;
        while (i < n) {
            words[i] = ew[i].word;
            ++i;
        }
        return words;
    }

    public static String[] getMostFrequent(int n, EncodedWord[] dict) {
        EncodedWord[] ew = new EncodedWord[dict.length];
        int i = 0;
        while (i < ew.length) {
            ew[i] = dict[i];
            ++i;
        }
        Arrays.sort(ew, new WordByFreq());
        String[] s = new String[n];
        int i2 = 0;
        while (i2 < s.length) {
            s[i2] = ew[i2].getWord();
            ++i2;
        }
        return s;
    }

    public static String[] getQuery(String code, EncodedWord[] dict) {
        String[] query = null;
        if (code == "") {
            return query;
        }
        String[] unique = EncodedWord.getUnique(code, dict);
        String[] tentative = EncodedWord.getTentative(code, dict);
        if (unique == null && tentative == null) {
            return query;
        }
        if (unique == null && tentative != null) {
            return tentative;
        }
        if (unique != null && tentative == null) {
            return unique;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = unique;
        int n = unique.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            arrayList.add(s);
            ++n2;
        }
        int i = 0;
        while (i < tentative.length) {
            if (!arrayList.contains(tentative[i])) {
                arrayList.add(tentative[i]);
            }
            ++i;
        }
        return arrayList.toArray(new String[0]);
    }

    public static void printEncodedWord(EncodedWord[] ew) {
        int i = 0;
        while (i < ew.length) {
            System.out.println(ew[i]);
            ++i;
        }
    }

    public static void printStringArray(String[] s) {
        if (s == null) {
            System.out.println("sorry!");
        } else {
            int i = 0;
            while (i < s.length) {
                System.out.print(String.valueOf(s[i]) + " ");
                ++i;
            }
            System.out.println();
        }
    }

    public static String encodeWordMultitap(String word) {
        String ks = "";
        int i = 0;
        while (i < word.length()) {
            char c = Character.toLowerCase(word.charAt(i));
            int repeats = keystrokes.charAt(alphabet.indexOf(c)) - 48;
            int j = 0;
            while (j < repeats) {
                ks = String.valueOf(ks) + keys.charAt(alphabet.indexOf(c));
                ++j;
            }
            if (i < word.length() - 1) {
                char b;
                char cNext = Character.toLowerCase(word.charAt(i + 1));
                char a = keys.charAt(alphabet.indexOf(c));
                if (a == (b = keys.charAt(alphabet.indexOf(cNext)))) {
                    ks = String.valueOf(ks) + "N";
                }
            }
            ++i;
        }
        return ks;
    }

    public static void main(String[] args) throws IOException {
        String code;
        String[] top10;
        if (args.length == 0 || args.length > 2) {
            System.out.println("usage: java EncodedWord dictionary");
            return;
        }
        System.out.print("Load and sort coded dictionary...");
        EncodedWord[] ew = EncodedWord.loadCodedDictionary(args[0]);
        System.out.println("(done)");
        System.out.println("Coded dictionary contains " + ew.length + " words");
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in), 1);
        System.out.println("*** Test the 'encode' methods ***");
        System.out.println("Enter a word...");
        String wrd = stdin.readLine();
        System.out.println("Phone keypad code: " + EncodedWord.encodeWord(wrd));
        System.out.println("Multitap code: " + EncodedWord.encodeWordMultitap(wrd));
        System.out.println("*** Text the getMostFrequeny method ***");
        System.out.println("10 most frequent words in dictionary...");
        String[] stringArray = top10 = EncodedWord.getMostFrequent(10, ew);
        int n = top10.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = stringArray[n2];
            System.out.print(String.valueOf(tmp) + " ");
            ++n2;
        }
        System.out.println();
        System.out.println("*** Test the get methods ***");
        System.out.println("Enter codes... (^z to exit)");
        while ((code = stdin.readLine()) != null) {
            String[] s = EncodedWord.getUnique(code, ew);
            System.out.println("\nResults of getUnique()...");
            EncodedWord.printStringArray(s);
            s = EncodedWord.getTentative(code, ew);
            System.out.println("\nResults of getTentative()...");
            EncodedWord.printStringArray(s);
            s = EncodedWord.getQuery(code, ew);
            System.out.println("\nResults of getQuery()...");
            EncodedWord.printStringArray(s);
        }
    }
}

