/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class Setup
extends JDialog
implements SetupItem.SetupItemListener,
ActionListener {
    static final long serialVersionUID = 42L;
    Configuration c;
    Configuration cSave;
    String appName;
    JLabel banner;
    SetupItem[] items;
    SetupItemInfo[] itemInfo;
    JButton okButton;
    JButton saveButton;
    JButton resetButton;
    JButton exitButton;
    boolean ok;
    JFileChooser fc;
    final Font BIG = new Font("sansserif", 0, 14);

    public Setup(Frame owner, Configuration cArg, String appNameArg, SetupItemInfo[] itemInfoArg) {
        super(owner, "Configure " + appNameArg, true);
        this.c = cArg;
        this.appName = appNameArg;
        this.itemInfo = itemInfoArg;
        this.cSave = new Configuration(this.appName, this.c.toArray());
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.fc = new JFileChooser(new File("."));
        this.banner = new JLabel("Setup", 0);
        this.banner.setFont(new Font("sansserif", 0, 18));
        this.banner.setBorder(BorderFactory.createEmptyBorder(15, 30, 15, 30));
        this.items = new SetupItem[this.itemInfo.length];
        int i = 0;
        while (i < this.itemInfo.length) {
            this.items[i] = new SetupItem(this.itemInfo[i].itemType, this.itemInfo[i].itemLabel, this.itemInfo[i].itemValues);
            this.items[i].addSetupItemListener(this);
            ++i;
        }
        this.okButton = new JButton("OK");
        this.okButton.setFont(this.BIG);
        this.okButton.addActionListener(this);
        this.saveButton = new JButton("Save");
        this.saveButton.setFont(this.BIG);
        this.saveButton.addActionListener(this);
        this.resetButton = new JButton("Reset");
        this.resetButton.setFont(this.BIG);
        this.resetButton.addActionListener(this);
        this.exitButton = new JButton("Exit");
        this.exitButton.setFont(this.BIG);
        this.exitButton.addActionListener(this);
        this.okButton.setPreferredSize(this.resetButton.getPreferredSize());
        this.saveButton.setPreferredSize(this.resetButton.getPreferredSize());
        this.exitButton.setPreferredSize(this.resetButton.getPreferredSize());
        this.setDefaults();
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        int preferredLeftWidth = 0;
        int preferredRightWidth = 0;
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout(new BoxLayout(paramPanel, 1));
        int i2 = 0;
        while (i2 < this.items.length) {
            paramPanel.add(this.items[i2]);
            if (this.items[i2].getPreferredLeftWidth() > preferredLeftWidth) {
                preferredLeftWidth = this.items[i2].getPreferredLeftWidth();
            }
            if (this.items[i2].getPreferredRightWidth() > preferredRightWidth) {
                preferredRightWidth = this.items[i2].getPreferredRightWidth();
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.items.length) {
            this.items[i2].setPreferredItemWidth(preferredLeftWidth, preferredRightWidth);
            ++i2;
        }
        paramPanel.setBorder(new TitledBorder(new EtchedBorder(), "Parameters"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.saveButton);
        buttonPanel.add(this.resetButton);
        buttonPanel.add(this.exitButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        top.add("North", this.banner);
        top.add("Center", paramPanel);
        top.add("South", buttonPanel);
        top.add("West", new JLabel("            "));
        top.add("East", new JLabel("            "));
        this.setContentPane(top);
        this.pack();
        this.okButton.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.resetButton) {
            this.setDefaults();
        } else if (source == this.saveButton) {
            this.saveToFile();
        } else if (source == this.okButton) {
            this.ok = true;
            this.setVisible(false);
        } else if (source == this.exitButton) {
            System.exit(0);
        }
    }

    @Override
    public void onSetupItemChanged(SetupEvent e) {
        String value = null;
        int idx = 0;
        while (idx < this.items.length) {
            Object o2;
            Object o1 = this.items[idx].getParameterObject();
            if (o1 == (o2 = e.getSource())) break;
            ++idx;
        }
        if (idx >= this.items.length) {
            return;
        }
        if (this.items[idx].type == 300) {
            value = Boolean.toString(this.items[idx].setupCheckBox.isSelected());
        } else if (this.items[idx].type == 100) {
            value = (String)this.items[idx].setupComboBox.getSelectedItem();
        } else if (this.items[idx].type == 200) {
            value = this.items[idx].setupTextField.getText();
        } else if (this.items[idx].type == 400) {
            int i = 0;
            while (i < this.items[idx].setupRadioButtons.length) {
                if (this.items[idx].setupRadioButtons[i].isSelected()) {
                    value = this.items[idx].setupRadioButtons[i].getText();
                    break;
                }
                ++i;
            }
        } else if (this.items[idx].type == 500 && this.fc.showOpenDialog(this) == 0) {
            value = this.fc.getSelectedFile().getPath();
        }
        this.c.setConfigurationParameter(idx, value);
    }

    private void setDefaults() {
        int i = 0;
        while (i < this.items.length) {
            this.items[i].setSelected(this.items[i].type, this.cSave.getConfigurationParameter(i));
            ++i;
        }
    }

    private void saveToFile() {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(this.appName) + ".cfg")));
            out.print(this.c.toString());
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Unable to save config to " + this.appName + ".cfg\n" + "Please ensure the file is writable.", "I/O Error", 0);
        }
    }

    public boolean showSetup(Frame f) {
        this.ok = false;
        this.setLocationRelativeTo(f);
        this.setVisible(true);
        return this.ok;
    }
}

