/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import javax.swing.UIManager;

public class SoftKeyboardExperiment {
    static final String APP_NAME = "SoftKeyboardExperiment";
    static final int PARAMETERS = 11;
    static final String[] PARTICIPANT_CODES = new String[]{"P00", "P01", "P02", "P03", "P04", "P05", "P06", "P07", "P08", "P09", "P10", "P11", "P12", "P13", "P14", "P15", "P16", "P17", "P18", "P19", "P20", "P21", "P22", "P23", "P24", "P25", "P26", "P27", "P28", "P29", "P30"};
    static final String[] CONDITION_CODE = new String[]{"C00"};
    static final String[] SESSION_CODES = new String[]{"S00", "S01", "S02", "S03", "S04", "S05", "S06", "S07", "S08", "S09", "S10", "S11", "S12", "S13", "S14", "S15", "S16", "S17", "S18", "S19", "S20", "S21", "S22", "S23", "S24", "S25", "S26", "S27", "S28", "S29", "S30"};
    static final String[] NUMBER_OF_PHRASES = new String[]{"5"};
    static final String[] PHRASES_FILE = new String[]{"phrases2.txt"};
    static final String[] DICTIONARY_FILE = new String[]{"d1phrases2-wordfreq.txt"};
    static final String[] SHOW_PRESENTED = new String[]{"true"};
    static final String[] KEYBOARD = new String[]{"Qwerty", "Opti", "Phone", "L4K", "Metropolis", "LKL (Lewis-Kennedy-LaLommia)", "Fitaly", "Custom (select below)"};
    static final String[] KEYBOARD_SCALE = new String[]{"1.00"};
    static final String[] WC_LIST_SIZE = new String[]{"0", "1", "3", "5"};
    static final String[] KEYBOARD_DEF_FILE = new String[1];
    static final String[] OTHER_FILES = new String[]{"phrases2.txt", "helloworld.txt", "quickbrownfox.txt", "phrases.txt", "d1phrases2-wordfreq.txt", "phrases2-wordfreq.txt", "dvorak.txt", "letters_on_two_keys.txt", "letters_on_six_keys_a.txt", "letters_on_six_keys_b.txt", "letters_on_six_keys_c.txt", "letters_on_six_keys_d.txt"};
    static final String[] KEYBOARD_NAME = new String[]{"QWERTY", "OPTI", "PHONE", "L4K", "METROPOLIS", "LKL", "FITALY", "CUSTOM"};

    public static void main(String[] args) throws IOException {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.windows.WindowsClassicLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] defaultParameters = new String[]{PARTICIPANT_CODES[0], CONDITION_CODE[0], SESSION_CODES[0], NUMBER_OF_PHRASES[0], PHRASES_FILE[0], DICTIONARY_FILE[0], SHOW_PRESENTED[0], KEYBOARD[0], KEYBOARD_SCALE[0], KEYBOARD_DEF_FILE[0], WC_LIST_SIZE[0]};
        Configuration c = Configuration.readConfigurationData(APP_NAME, defaultParameters, OTHER_FILES);
        if (c == null) {
            SoftKeyboardExperimentGui.errorExit(String.format("Error reading configuration data from %s.cfg!", APP_NAME));
        }
        SetupItemInfo[] sii = new SetupItemInfo[]{new SetupItemInfo(100, "Participant code ", PARTICIPANT_CODES), new SetupItemInfo(200, "Condition code ", CONDITION_CODE), new SetupItemInfo(100, "Session code ", SESSION_CODES), new SetupItemInfo(200, "Number of phrases ", NUMBER_OF_PHRASES), new SetupItemInfo(200, "Phrases file ", PHRASES_FILE), new SetupItemInfo(200, "Dictionary file ", DICTIONARY_FILE), new SetupItemInfo(300, "Show presented text during input ", SHOW_PRESENTED), new SetupItemInfo(100, "Keyboard ", KEYBOARD), new SetupItemInfo(200, "Keyboard scale", KEYBOARD), new SetupItemInfo(500, "Custom keyboard ", KEYBOARD_DEF_FILE), new SetupItemInfo(400, "Word completion list size (words)", WC_LIST_SIZE)};
        Setup s = new Setup(null, c, APP_NAME, sii);
        s.showSetup(null);
        SoftKeyboardExperimentGui screen = new SoftKeyboardExperimentGui(c);
        screen.setDefaultCloseOperation(3);
        screen.setTitle(APP_NAME);
        screen.pack();
        int w = screen.getWidth();
        int h = screen.getHeight();
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension d = t.getScreenSize();
        screen.setLocation((d.width - w) / 2, (d.height - h) / 2);
        screen.setVisible(true);
    }
}

