/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.Scanner;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonListener;

class SoftKeyboardExperimentGui
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 42L;
    final String SD1_HEADER = "";
    final String SD2_HEADER = "App,Participant,Condition,Keyboard,Keyboard_scale,Session,Block,Phrase,Min_keystrokes,Keystrokes,Efficiency,Characters,Time,MSD,Speed_(wpm),Error_rate_(%),KSPC\n";
    final Font F16 = new Font("sansserif", 0, 16);
    final int QWERTY = 100;
    final int PHONE = 150;
    final int OPTI = 200;
    final int L4K = 250;
    final int METROPOLIS = 300;
    final int LKL = 400;
    final int FITALY = 500;
    final int CUSTOM = 600;
    final int[] MODE_ARRAY = new int[]{100, 200, 150, 250, 300, 400, 500, 600};
    BufferedWriter sd1File;
    BufferedWriter sd2File;
    ArrayList<Sample> samples;
    String phrasesFile;
    String dictionaryFile;
    boolean showPresented;
    boolean newPhrase;
    Random r = new Random();
    JTextField text1;
    JTextField text2;
    JButton[] wordCompletion;
    SoftKeyboard softKeyboard;
    String[] phrases;
    String presentedPhrase;
    StringBuilder transcribedPhrase;
    long t1;
    long t2;
    int keystrokeCount;
    int numberOfPhrases;
    int keyboardInt;
    double keyboardScale;
    String keyboardName;
    String keyboardDefFile;
    String appName;
    int pressesOfNext;
    String[] query;
    Key[] keyArray;
    Key[] letterKey;
    String currentWord;
    StringBuilder currentCode;
    boolean isAmbiguous;
    boolean usesWordCompletion;
    int wcListSize;
    String participantCode;
    String conditionCode;
    String sessionCode;
    String blockCode;
    String keyboard;
    String scaleString;
    Font FONT24 = new Font("monospaced", 1, 24);
    String FONT_FAMILY = "monospaced";
    int FONT_SIZE = 20;
    Color BACKGROUND = new Color(254, 254, 218);
    Color FOREGROUND = new Color(11, 11, 109);
    JDialog resultsDialog;
    JOptionPane resultsPane;
    JTextArea resultsArea;
    Configuration c;
    EncodedWord[] dictByCode;
    String[] mostFrequent;
    int[] wcOrder;
    int phraseCount;
    int minKeystrokes;
    double baseWidth;
    double baseHeight;
    Key[] qwertyKeyboard = new Key[]{new Key("Q", 0.0, 0.0, 1.0, 1.0), new Key("W", 1.0, 0.0, 1.0, 1.0), new Key("E", 2.0, 0.0, 1.0, 1.0), new Key("R", 3.0, 0.0, 1.0, 1.0), new Key("T", 4.0, 0.0, 1.0, 1.0), new Key("Y", 5.0, 0.0, 1.0, 1.0), new Key("U", 6.0, 0.0, 1.0, 1.0), new Key("I", 7.0, 0.0, 1.0, 1.0), new Key("O", 8.0, 0.0, 1.0, 1.0), new Key("P", 9.0, 0.0, 1.0, 1.0), new Key("A", 0.3333, 1.0, 1.0, 1.0), new Key("S", 1.3333, 1.0, 1.0, 1.0), new Key("D", 2.3333, 1.0, 1.0, 1.0), new Key("F", 3.3333, 1.0, 1.0, 1.0), new Key("G", 4.3333, 1.0, 1.0, 1.0), new Key("H", 5.3333, 1.0, 1.0, 1.0), new Key("J", 6.3333, 1.0, 1.0, 1.0), new Key("K", 7.3333, 1.0, 1.0, 1.0), new Key("L", 8.3333, 1.0, 1.0, 1.0), new Key("Z", 0.6666, 2.0, 1.0, 1.0), new Key("X", 1.6666, 2.0, 1.0, 1.0), new Key("C", 2.6666, 2.0, 1.0, 1.0), new Key("V", 3.6666, 2.0, 1.0, 1.0), new Key("B", 4.6666, 2.0, 1.0, 1.0), new Key("N", 5.6666, 2.0, 1.0, 1.0), new Key("M", 6.6666, 2.0, 1.0, 1.0), new Key("", 7.6666, 2.0, 1.0, 1.0), new Key("", 8.6666, 2.0, 1.0, 1.0), new Key("", 9.6666, 2.0, 1.0, 1.0), new Key("Space", 1.0, 3.0, 9.0, 1.0), new Key("Enter", 9.3333, 1.0, 2.0, 1.0), new Key("Bksp", 10.0, 0.0, 2.0, 1.0)};
    Key[] phoneKeyboard = new Key[]{new Key("Next", 0.0, 0.0, 1.0, 1.0), new Key("2 ABC", 1.0, 0.0, 1.0, 1.0), new Key("3 DEF", 2.0, 0.0, 1.0, 1.0), new Key("4 GHI", 0.0, 1.0, 1.0, 1.0), new Key("5 JKL", 1.0, 1.0, 1.0, 1.0), new Key("6 MNO", 2.0, 1.0, 1.0, 1.0), new Key("7 PQRS", 0.0, 2.0, 1.0, 1.0), new Key("8 TUV", 1.0, 2.0, 1.0, 1.0), new Key("9 WXYZ", 2.0, 2.0, 1.0, 1.0), new Key("Bksp", 0.0, 3.0, 1.0, 1.0), new Key("Space", 1.0, 3.0, 1.0, 1.0), new Key("Enter", 2.0, 3.0, 1.0, 1.0)};
    Key[] lettersOnFourKeysKeyboard = new Key[]{new Key("ABCDEFG", 0.0, 0.0, 1.0, 1.0), new Key("HIJKLMN", 1.0, 0.0, 1.0, 1.0), new Key("OPQRSTU", 2.0, 0.0, 1.0, 1.0), new Key("VWXYZ", 3.0, 0.0, 1.0, 1.0), new Key("Next", 0.0, 1.0, 1.0, 1.0), new Key("Bksp", 1.0, 1.0, 1.0, 1.0), new Key("Space", 2.0, 1.0, 1.0, 1.0), new Key("Enter", 3.0, 1.0, 1.0, 1.0)};
    Key[] optiKeyboard = new Key[]{new Key("Q", 0.0, 0.0, 1.0, 1.0), new Key("F", 1.0, 0.0, 1.0, 1.0), new Key("U", 2.0, 0.0, 1.0, 1.0), new Key("M", 3.0, 0.0, 1.0, 1.0), new Key("C", 4.0, 0.0, 1.0, 1.0), new Key("K", 5.0, 0.0, 1.0, 1.0), new Key("Z", 6.0, 0.0, 1.0, 1.0), new Key("Space", 0.0, 1.0, 2.0, 1.0), new Key("O", 2.0, 1.0, 1.0, 1.0), new Key("T", 3.0, 1.0, 1.0, 1.0), new Key("H", 4.0, 1.0, 1.0, 1.0), new Key("Space", 5.0, 1.0, 2.0, 1.0), new Key("", 7.0, 1.0, 1.5, 1.0), new Key("B", 0.0, 2.0, 1.0, 1.0), new Key("S", 1.0, 2.0, 1.0, 1.0), new Key("R", 2.0, 2.0, 1.0, 1.0), new Key("E", 3.0, 2.0, 1.0, 1.0), new Key("A", 4.0, 2.0, 1.0, 1.0), new Key("W", 5.0, 2.0, 1.0, 1.0), new Key("X", 6.0, 2.0, 1.0, 1.0), new Key("Space", 0.0, 3.0, 2.0, 1.0), new Key("I", 2.0, 3.0, 1.0, 1.0), new Key("N", 3.0, 3.0, 1.0, 1.0), new Key("D", 4.0, 3.0, 1.0, 1.0), new Key("Space", 5.0, 3.0, 2.0, 1.0), new Key("", 7.0, 3.0, 1.5, 1.0), new Key("J", 0.0, 4.0, 1.0, 1.0), new Key("P", 1.0, 4.0, 1.0, 1.0), new Key("V", 2.0, 4.0, 1.0, 1.0), new Key("G", 3.0, 4.0, 1.0, 1.0), new Key("L", 4.0, 4.0, 1.0, 1.0), new Key("Y", 5.0, 4.0, 1.0, 1.0), new Key("Bksp", 7.0, 0.0, 1.5, 1.0), new Key("Enter", 7.0, 2.0, 1.5, 1.0), new Key("", 6.0, 4.0, 1.0, 1.0), new Key("", 7.0, 4.0, 1.5, 1.0)};
    Key[] lewisKeyboard = new Key[]{new Key("Q", 0.0, 0.0, 1.0, 1.0), new Key("R", 1.0, 0.0, 1.0, 1.0), new Key("W", 2.0, 0.0, 1.0, 1.0), new Key("X", 3.0, 0.0, 1.0, 1.0), new Key("Y", 4.0, 0.0, 1.0, 1.0), new Key("Bksp", 5.0, 0.0, 2.0, 1.0), new Key("L", 0.0, 1.0, 1.0, 1.0), new Key("U", 1.0, 1.0, 1.0, 1.0), new Key("A", 2.0, 1.0, 1.0, 1.0), new Key("O", 3.0, 1.0, 1.0, 1.0), new Key("F", 4.0, 1.0, 1.0, 1.0), new Key("", 5.0, 1.0, 2.0, 1.0), new Key("T", 0.0, 2.0, 1.0, 1.0), new Key("H", 1.0, 2.0, 1.0, 1.0), new Key("E", 2.0, 2.0, 1.0, 1.0), new Key("N", 3.0, 2.0, 1.0, 1.0), new Key("G", 4.0, 2.0, 1.0, 1.0), new Key("Enter", 5.0, 2.0, 2.0, 1.0), new Key("V", 0.0, 3.0, 1.0, 1.0), new Key("D", 1.0, 3.0, 1.0, 1.0), new Key("I", 2.0, 3.0, 1.0, 1.0), new Key("S", 3.0, 3.0, 1.0, 1.0), new Key("P", 4.0, 3.0, 1.0, 1.0), new Key("", 5.0, 3.0, 2.0, 1.0), new Key("B", 0.0, 4.0, 1.0, 1.0), new Key("C", 1.0, 4.0, 1.0, 1.0), new Key("M", 2.0, 4.0, 1.0, 1.0), new Key("J", 3.0, 4.0, 1.0, 1.0), new Key("K", 4.0, 4.0, 1.0, 1.0), new Key("Z", 5.0, 4.0, 1.0, 1.0), new Key("", 6.0, 4.0, 1.0, 1.0), new Key("Space", 0.0, 5.0, 7.0, 1.0)};
    Key[] fitalyKeyboard = new Key[]{new Key("Z", 0.0, 0.0, 1.0, 1.0), new Key("V", 1.0, 0.0, 1.0, 1.0), new Key("C", 2.0, 0.0, 1.0, 1.0), new Key("H", 3.0, 0.0, 1.0, 1.0), new Key("W", 4.0, 0.0, 1.0, 1.0), new Key("K", 5.0, 0.0, 1.0, 1.0), new Key("Bksp", 6.0, 0.0, 2.0, 1.0), new Key("F", 0.0, 1.0, 1.0, 1.0), new Key("I", 1.0, 1.0, 1.0, 1.0), new Key("T", 2.0, 1.0, 1.0, 1.0), new Key("A", 3.0, 1.0, 1.0, 1.0), new Key("L", 4.0, 1.0, 1.0, 1.0), new Key("Y", 5.0, 1.0, 1.0, 1.0), new Key("", 6.0, 1.0, 1.0, 1.0), new Key("", 7.0, 1.0, 1.0, 1.0), new Key("Space", 0.0, 2.0, 2.0, 1.0), new Key("N", 2.0, 2.0, 1.0, 1.0), new Key("E", 3.0, 2.0, 1.0, 1.0), new Key("Space", 4.0, 2.0, 2.0, 1.0), new Key("Enter", 6.0, 2.0, 2.0, 1.0), new Key("G", 0.0, 3.0, 1.0, 1.0), new Key("D", 1.0, 3.0, 1.0, 1.0), new Key("O", 2.0, 3.0, 1.0, 1.0), new Key("R", 3.0, 3.0, 1.0, 1.0), new Key("S", 4.0, 3.0, 1.0, 1.0), new Key("B", 5.0, 3.0, 1.0, 1.0), new Key("", 6.0, 3.0, 1.0, 1.0), new Key("", 7.0, 3.0, 1.0, 1.0), new Key("Q", 0.0, 4.0, 1.0, 1.0), new Key("J", 1.0, 4.0, 1.0, 1.0), new Key("U", 2.0, 4.0, 1.0, 1.0), new Key("M", 3.0, 4.0, 1.0, 1.0), new Key("P", 4.0, 4.0, 1.0, 1.0), new Key("X", 5.0, 4.0, 1.0, 1.0), new Key("", 6.0, 4.0, 1.0, 1.0), new Key("", 7.0, 4.0, 1.0, 1.0)};
    Key[] metropolisKeyboard = new Key[]{new Key("J", 2.0, 0.0, 1.0, 1.0), new Key("B", 3.0, 0.0, 1.1, 1.0), new Key("Q", 0.5, 0.75, 1.0, 1.1), new Key("U", 1.5, 0.75, 1.0, 1.0), new Key("S", 2.5, 0.75, 1.0, 1.0), new Key("P", 3.5, 0.75, 1.0, 1.0), new Key("C", 4.5, 0.75, 1.0, 1.0), new Key("Bksp", 5.5, 0.75, 1.1, 1.1), new Key("F", 1.0, 1.5, 1.0, 1.0), new Key("O", 2.0, 1.5, 1.0, 1.0), new Key("T", 3.0, 1.5, 1.0, 1.0), new Key("H", 4.0, 1.5, 1.0, 1.0), new Key("V", 5.0, 1.5, 1.1, 1.0), new Key("G", 0.5, 2.25, 1.0, 1.0), new Key("R", 1.5, 2.25, 1.0, 1.0), new Key("Space", 2.5, 2.25, 1.0, 1.0), new Key("E", 3.5, 2.25, 1.0, 1.0), new Key("K", 4.5, 2.25, 1.0, 1.0), new Key("Enter", 5.5, 2.25, 1.1, 1.1), new Key("M", 0.0, 3.0, 1.0, 1.1), new Key("N", 1.0, 3.0, 1.0, 1.1), new Key("I", 2.0, 3.0, 1.0, 1.0), new Key("A", 3.0, 3.0, 1.0, 1.0), new Key("W", 4.0, 3.0, 1.0, 1.0), new Key("Z", 5.0, 3.0, 1.1, 1.1), new Key("D", 1.5, 3.75, 1.0, 1.1), new Key("L", 2.5, 3.75, 1.0, 1.1), new Key("Y", 3.5, 3.75, 1.0, 1.1), new Key("X", 4.5, 3.75, 1.1, 1.1)};

    SoftKeyboardExperimentGui(Configuration cArg) throws IOException {
        this.c = cArg;
        this.participantCode = this.c.getConfigurationParameter(0);
        this.conditionCode = this.c.getConfigurationParameter(1);
        this.sessionCode = this.c.getConfigurationParameter(2);
        this.numberOfPhrases = Integer.parseInt(this.c.getConfigurationParameter(3));
        this.phrasesFile = this.c.getConfigurationParameter(4);
        this.dictionaryFile = this.c.getConfigurationParameter(5);
        this.showPresented = Boolean.valueOf(this.c.getConfigurationParameter(6));
        this.keyboard = this.c.getConfigurationParameter(7);
        this.keyboardScale = Double.parseDouble(this.c.getConfigurationParameter(8));
        this.keyboardDefFile = this.c.getConfigurationParameter(9);
        this.wcListSize = Integer.valueOf(this.c.getConfigurationParameter(10));
        this.phraseCount = 0;
        this.usesWordCompletion = this.wcListSize > 0;
        int idx = 0;
        while (!this.keyboard.equals(SoftKeyboardExperiment.KEYBOARD[idx])) {
            ++idx;
        }
        if (idx == SoftKeyboardExperiment.KEYBOARD.length) {
            SoftKeyboardExperimentGui.errorExit(String.format("Error: can't find keyboard: %s", this.keyboard));
        } else {
            this.keyboardInt = this.MODE_ARRAY[idx];
            this.keyboardName = SoftKeyboardExperiment.KEYBOARD_NAME[idx];
        }
        this.appName = "SoftKeyboardExperiment";
        Scanner inFile = null;
        try {
            inFile = new Scanner(new File(this.phrasesFile));
        }
        catch (FileNotFoundException e) {
            SoftKeyboardExperimentGui.errorExit(String.format("Phrases file not found: %s", this.phrasesFile));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (inFile.hasNextLine()) {
            arrayList.add(inFile.nextLine());
        }
        this.phrases = arrayList.toArray(new String[0]);
        switch (this.keyboardInt) {
            case 100: {
                this.baseWidth = 50.0;
                this.baseHeight = 45.0;
                this.keyArray = this.qwertyKeyboard;
                break;
            }
            case 150: {
                this.baseWidth = 100.0;
                this.baseHeight = 45.0;
                this.keyArray = this.phoneKeyboard;
                break;
            }
            case 250: {
                this.baseWidth = 150.0;
                this.baseHeight = 45.0;
                this.keyArray = this.lettersOnFourKeysKeyboard;
                break;
            }
            case 200: {
                this.baseWidth = 50.0;
                this.baseHeight = 45.0;
                this.keyArray = this.optiKeyboard;
                break;
            }
            case 300: {
                this.baseWidth = 52.0;
                this.baseHeight = 48.0;
                this.keyArray = this.metropolisKeyboard;
                break;
            }
            case 400: {
                this.baseWidth = 50.0;
                this.baseHeight = 45.0;
                this.keyArray = this.lewisKeyboard;
                break;
            }
            case 500: {
                this.baseWidth = 50.0;
                this.baseHeight = 45.0;
                this.keyArray = this.fitalyKeyboard;
                break;
            }
            case 600: {
                this.loadCustomKeyboard(this.keyboardDefFile, this.keyboardScale);
            }
        }
        this.baseWidth *= this.keyboardScale;
        this.baseHeight *= this.keyboardScale;
        this.softKeyboard = new SoftKeyboard(this.keyArray, this.keyboardScale, this.baseWidth, this.baseHeight, this, this.keyboardInt);
        this.isAmbiguous = false;
        Key[] keyArray = this.keyArray;
        int n = this.keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Key k = keyArray[n2];
            if (k.isAmbiguous()) {
                this.isAmbiguous = true;
                break;
            }
            ++n2;
        }
        if (!this.usesWordCompletion && this.isAmbiguous) {
            SoftKeyboardExperimentGui.errorExit("Oops! Keyboard is ambiguous!\nWord completion list size must be > 0");
        }
        this.letterKey = this.getLetterKeys(this.keyArray);
        this.blockCode = "";
        int blockCodeNumber = 0;
        this.scaleString = String.format("Scale_%4.2f", this.keyboardScale);
        String base = "SoftKeyboardExperiment-" + this.participantCode + "-" + this.conditionCode + "-" + this.keyboardName + "-" + this.scaleString + "-" + this.sessionCode;
        String s1 = "";
        String s2 = "";
        do {
            this.blockCode = ++blockCodeNumber < 10 ? "B0" + blockCodeNumber : "B" + blockCodeNumber;
            s1 = String.valueOf(base) + "-" + this.blockCode + ".sd1";
            s2 = String.valueOf(base) + "-" + this.blockCode + ".sd2";
        } while (new File(s1).exists());
        try {
            this.sd1File = new BufferedWriter(new FileWriter(s1));
            this.sd2File = new BufferedWriter(new FileWriter(s2));
        }
        catch (IOException e) {
            SoftKeyboardExperimentGui.errorExit("I/O error: Can't open sd1/sd2/files");
        }
        try {
            this.sd1File.write("", 0, "".length());
            this.sd1File.flush();
            this.sd2File.write("App,Participant,Condition,Keyboard,Keyboard_scale,Session,Block,Phrase,Min_keystrokes,Keystrokes,Efficiency,Characters,Time,MSD,Speed_(wpm),Error_rate_(%),KSPC\n", 0, "App,Participant,Condition,Keyboard,Keyboard_scale,Session,Block,Phrase,Min_keystrokes,Keystrokes,Efficiency,Characters,Time,MSD,Speed_(wpm),Error_rate_(%),KSPC\n".length());
            this.sd2File.flush();
        }
        catch (IOException e) {
            System.err.println("ERROR WRITING TO DATA FILE!\n" + e);
            System.exit(1);
        }
        this.text1 = new JTextField(50);
        this.text1.setFocusable(false);
        this.text1.setFont(this.FONT24);
        this.text1.setBackground(new Color(254, 254, 218));
        this.text1.setForeground(new Color(11, 11, 109));
        JPanel text1Panel = new JPanel();
        text1Panel.setLayout(new FlowLayout(1));
        text1Panel.add(this.text1);
        text1Panel.setBorder(new TitledBorder(new EtchedBorder(), "Presented text"));
        this.text2 = new JTextField(50);
        this.text2.setEditable(true);
        this.text2.setFont(this.FONT24);
        this.text2.setBackground(this.BACKGROUND);
        this.text2.setForeground(this.FOREGROUND);
        JPanel text2Panel = new JPanel();
        text2Panel.setLayout(new FlowLayout(1));
        text2Panel.add(this.text2);
        text2Panel.setBorder(new TitledBorder(new EtchedBorder(), "Transcribed text"));
        int width = this.text2.getPreferredSize().width;
        int height = this.text2.getPreferredSize().height;
        JPanel wordCompletionPanel = new JPanel();
        if (this.usesWordCompletion) {
            this.loadDictionary(this.dictionaryFile);
            this.mostFrequent = EncodedWord.getMostFrequent(100, this.dictByCode);
            this.wcOrder = new int[this.wcListSize];
            int index = this.wcOrder.length / 2;
            int i = 0;
            while (i < this.wcOrder.length) {
                int sign = i % 2 == 1 ? -1 : 1;
                this.wcOrder[i] = index += i * sign;
                ++i;
            }
            wordCompletionPanel.setLayout(new GridLayout(0, this.wcListSize));
            this.wordCompletion = new JButton[this.wcListSize];
            i = 0;
            while (i < this.wordCompletion.length) {
                this.wordCompletion[i] = new JButton(" ");
                this.wordCompletion[i].addActionListener(this);
                this.wordCompletion[i].setActionCommand("word" + i);
                this.wordCompletion[i].setMargin(new Insets(0, 0, 0, 0));
                int fontSize = (int)((double)this.FONT_SIZE * this.keyboardScale);
                if (i == this.wcListSize / 2) {
                    this.wordCompletion[i].setFont(new Font("monospaced", 1, fontSize));
                } else {
                    this.wordCompletion[i].setFont(new Font("monospaced", 0, fontSize));
                }
                height = (int)this.wordCompletion[i].getPreferredSize().getHeight();
                this.wordCompletion[i].setPreferredSize(new Dimension(width / this.wcListSize, height));
                this.wordCompletion[i].setBackground(Color.LIGHT_GRAY);
                this.wordCompletion[i].setForeground(this.FOREGROUND);
                wordCompletionPanel.add(this.wordCompletion[i]);
                ++i;
            }
            wordCompletionPanel.setBorder(new TitledBorder(new EtchedBorder(), "Word completion list"));
        } else {
            wordCompletionPanel = null;
        }
        this.resultsArea = new JTextArea(15, 40);
        this.resultsArea.setFont(new Font("sansserif", 0, 16));
        this.resultsArea.setBackground(new JButton().getBackground());
        this.resultsPane = new JOptionPane(this.resultsArea, 1);
        this.resultsPane.setFont(new Font("sansserif", 0, 16));
        this.resultsDialog = this.resultsPane.createDialog(this, "Information");
        this.doNewPhrase();
        JPanel keyboardPanel = new JPanel();
        keyboardPanel.add(this.softKeyboard);
        keyboardPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 15, 15));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        p1.add(Box.createRigidArea(new Dimension(5, 10)));
        p1.add(text1Panel);
        p1.add(Box.createRigidArea(new Dimension(5, 10)));
        p1.add(text2Panel);
        p1.add(Box.createRigidArea(new Dimension(5, 10)));
        if (this.usesWordCompletion) {
            p1.add(wordCompletionPanel);
            p1.add(Box.createRigidArea(new Dimension(5, 10)));
        }
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)p1, "North");
        p.add((Component)keyboardPanel, "Center");
        this.setContentPane(p);
    }

    Key[] getLetterKeys(Key[] allKeys) {
        ArrayList<Key> tmp = new ArrayList<Key>();
        Key[] keyArray = allKeys;
        int n = allKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Key k = keyArray[n2];
            if (k.isLetterKey()) {
                tmp.add(k);
            }
            ++n2;
        }
        return tmp.toArray(new Key[0]);
    }

    void loadDictionary(String file) {
        Scanner inputFile = null;
        try {
            inputFile = new Scanner(new File(file));
        }
        catch (FileNotFoundException e) {
            SoftKeyboardExperimentGui.errorExit(String.format("Oops!\nCustom key definition file not found: %s\n", file));
        }
        ArrayList<EncodedWord> tmp = new ArrayList<EncodedWord>();
        while (inputFile.hasNext()) {
            String line = inputFile.nextLine();
            String[] tokens = line.trim().split("[, \t]+");
            if (tokens.length != 2) {
                SoftKeyboardExperimentGui.errorExit(String.format("Oops!\nData format error in key definition file! Line_read = %s\n", line));
            }
            String word = tokens[0].toLowerCase();
            int freq = Integer.parseInt(tokens[1]);
            tmp.add(new EncodedWord(word, freq, this.getCodeFromWord(word)));
        }
        inputFile.close();
        this.dictByCode = tmp.toArray(new EncodedWord[0]);
        Arrays.sort(this.dictByCode, new ByCode());
    }

    void doNewPhrase() {
        this.newPhrase = true;
        this.currentWord = "";
        this.currentCode = new StringBuilder();
        this.presentedPhrase = this.phrases[this.r.nextInt(this.phrases.length)];
        this.text1.setText(this.presentedPhrase);
        this.minKeystrokes = this.getMinKeystrokesPhrase(this.presentedPhrase);
        this.transcribedPhrase = new StringBuilder();
        this.text2.setText("");
        this.t1 = 0L;
        this.keystrokeCount = 0;
        this.samples = new ArrayList();
        this.pressesOfNext = 0;
        this.query = this.mostFrequent;
        this.setWCWords();
    }

    void loadCustomKeyboard(String fileArg, double scaleArg) {
        Scanner inFile = null;
        try {
            inFile = new Scanner(new File(fileArg));
        }
        catch (FileNotFoundException e) {
            SoftKeyboardExperimentGui.errorExit("Oops!\nCustom key definition file not found!\nFile: " + fileArg);
        }
        ArrayList<String> tmp = new ArrayList<String>();
        while (inFile.hasNextLine()) {
            String line = inFile.nextLine();
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            tmp.add(line);
        }
        inFile.close();
        String[] customData = tmp.toArray(new String[0]);
        if (customData.length < 2) {
            SoftKeyboardExperimentGui.errorExit("Oops!\nInvalid custom keyboard definition file!\nFile: " + fileArg);
        }
        this.keyboardName = customData[0].trim();
        String[] s = customData[1].trim().split("[, \t]+");
        if (s.length != 2) {
            SoftKeyboardExperimentGui.errorExit("Oops!\nInvalid custom keyboard definition file!\nFile: " + fileArg);
        }
        try {
            this.baseWidth = Integer.parseInt(s[0]);
            this.baseHeight = Integer.parseInt(s[1]);
        }
        catch (NumberFormatException e) {
            SoftKeyboardExperimentGui.errorExit("Oops!\nInvalid widht/height in custom keyboard definition file!\nFile: " + fileArg);
        }
        ArrayList<Key> keyDef = new ArrayList<Key>();
        int i = 2;
        while (i < customData.length) {
            s = customData[i].trim().split("[, \t]+");
            if (s.length != 5) {
                SoftKeyboardExperimentGui.errorExit("Oops!\nInvalid key data in custom keyboard definition file:\nFile: " + fileArg);
            }
            String keyText = s[0].trim();
            double x = Double.parseDouble(s[1].trim());
            double y = Double.parseDouble(s[2].trim());
            double width = Double.parseDouble(s[3].trim());
            double height = Double.parseDouble(s[4].trim());
            keyDef.add(new Key(keyText, x, y, width, height));
            ++i;
        }
        inFile.close();
        this.keyArray = keyDef.toArray(new Key[0]);
    }

    static void errorExit(String msg) {
        System.out.println(msg);
        JOptionPane.showMessageDialog(null, msg, "I/O Error", 0);
        System.exit(0);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.newPhrase) {
            this.newPhrase = false;
            if (!this.showPresented) {
                this.text1.setText("");
            }
        }
        String s = ((JButton)ae.getSource()).getText();
        String a = ((JButton)ae.getSource()).getActionCommand();
        char c = '?';
        if (s != null && s.length() > 0) {
            c = s.toLowerCase().charAt(0);
        }
        ++this.keystrokeCount;
        if (this.t1 == 0L) {
            this.t1 = System.currentTimeMillis();
        }
        this.t2 = System.currentTimeMillis() - this.t1;
        this.samples.add(new Sample(this.t2, s.toLowerCase()));
        if (a.indexOf("word") == 0) {
            this.pressesOfNext = 0;
            int idx = a.charAt(4) - 48;
            String wcWord = this.wordCompletion[idx].getText();
            if (wcWord.length() > 0) {
                this.transcribedPhrase.append(this.wordCompletion[idx].getText()).append(' ');
                this.currentWord = "";
                this.currentCode = new StringBuilder();
            }
            this.updateUI();
        } else if (s.equals("Enter")) {
            ++this.phraseCount;
            --this.keystrokeCount;
            String s1 = this.presentedPhrase.toLowerCase().trim();
            String s2 = this.text2.getText().toLowerCase().trim();
            MSD s1s2 = new MSD(s1, s2);
            int msd = s1s2.getMSD();
            double errorRate = s1s2.getErrorRateNew();
            StringBuilder resultsString = new StringBuilder();
            resultsString.append(" DATA COLLECTED:\n");
            resultsString.append(String.format("   Presented:\t\t%s\n", s1));
            resultsString.append(String.format("   Transcribed:\t\t%s\n", s2));
            resultsString.append(String.format("   Keystrokes:\t\t%d\n", this.keystrokeCount));
            resultsString.append(String.format("   Characters:\t\t%d (%.1f words)\n", s2.length(), (double)s2.length() / 5.0));
            resultsString.append(String.format("   Time:\t\t%.1f seconds (%.2f minutes)\n", (double)this.t2 / 1000.0, (double)this.t2 / 1000.0 / 60.0));
            resultsString.append(String.format("   MSD:\t\t%d\n\n", msd));
            resultsString.append(" PARTICIPANT PERFORMANCE:\n");
            resultsString.append(String.format("   Entry Speed:\t\t%.1f wpm\n", SoftKeyboardExperimentGui.wpm(s2, this.t2)));
            resultsString.append(String.format("   Error rate:\t\t%.1f%%\n", errorRate));
            resultsString.append(String.format("   KSPC:\t\t%.3f\n", (double)this.keystrokeCount / (double)s2.length()));
            if (errorRate == 0.0) {
                resultsString.append(String.format("   Efficiency:\t\t%.1f%%\n", 100.0 * (double)this.minKeystrokes / (double)this.keystrokeCount));
            } else {
                resultsString.append("   Efficiency:\t\t-\n");
            }
            this.resultsArea.setText(resultsString.toString());
            this.resultsDialog.setVisible(true);
            StringBuilder sd2Stuff = new StringBuilder();
            sd2Stuff.append(this.appName).append(',');
            sd2Stuff.append(this.participantCode).append(',');
            sd2Stuff.append(this.conditionCode).append(',');
            sd2Stuff.append(this.keyboardName).append(',');
            sd2Stuff.append(this.scaleString).append(',');
            sd2Stuff.append(this.sessionCode).append(',');
            sd2Stuff.append(this.blockCode).append(',');
            sd2Stuff.append(this.phraseCount).append(',');
            sd2Stuff.append(this.minKeystrokes).append(',');
            sd2Stuff.append(String.format("%d,", this.keystrokeCount));
            sd2Stuff.append((double)this.minKeystrokes / (double)this.keystrokeCount).append(',');
            sd2Stuff.append(String.format("%d,", s2.length()));
            sd2Stuff.append(String.format("%f,", (double)this.t2 / 1000.0));
            sd2Stuff.append(String.format("%d,", msd));
            sd2Stuff.append(String.format("%f,", SoftKeyboardExperimentGui.wpm(s2, this.t2)));
            sd2Stuff.append(String.format("%f,", errorRate));
            sd2Stuff.append(String.format("%f\n", (double)this.keystrokeCount / (double)s2.length()));
            StringBuilder sd1Stuff = new StringBuilder();
            sd1Stuff.append(this.presentedPhrase).append('\n');
            sd1Stuff.append(s2).append('\n');
            Iterator<Sample> it = this.samples.iterator();
            while (it.hasNext()) {
                sd1Stuff.append(it.next()).append('\n');
            }
            sd1Stuff.append('#').append('\n');
            try {
                this.sd1File.write(sd1Stuff.toString(), 0, sd1Stuff.length());
                this.sd1File.flush();
                this.sd2File.write(sd2Stuff.toString(), 0, sd2Stuff.length());
                this.sd2File.flush();
            }
            catch (IOException e) {
                SoftKeyboardExperimentGui.errorExit(String.format("ERROR WRITING TO DATA FILE! e=%s\n" + e, new Object[0]));
            }
            if (this.phraseCount == this.numberOfPhrases) {
                JLabel thankyou = new JLabel("End of block. Thank you.");
                thankyou.setFont(new Font("sansserif", 0, 16));
                JOptionPane.showMessageDialog(this, thankyou);
                try {
                    this.sd1File.close();
                    this.sd2File.close();
                }
                catch (IOException e) {
                    SoftKeyboardExperimentGui.errorExit(String.format("ERROR CLOSING TO DATA FILE! e=%s\n" + e, new Object[0]));
                }
                System.exit(0);
            } else {
                this.doNewPhrase();
            }
        } else if (s.equals("Bksp")) {
            this.pressesOfNext = 0;
            if (this.currentWord.length() == 0 && this.transcribedPhrase.length() > 1) {
                int idx = this.transcribedPhrase.length() - 2;
                while (idx > 0 && this.transcribedPhrase.charAt(idx) != ' ') {
                    --idx;
                }
                this.currentWord = this.transcribedPhrase.substring(idx).trim();
                this.currentCode = new StringBuilder(this.getCodeFromWord(this.currentWord));
                if (idx > 0) {
                    this.transcribedPhrase.delete(idx + 1, this.transcribedPhrase.length());
                } else {
                    this.transcribedPhrase.delete(0, this.transcribedPhrase.length());
                }
            } else if (this.currentWord.length() > 0) {
                this.currentWord = this.currentWord.substring(0, this.currentWord.length() - 1);
                this.currentCode = new StringBuilder(this.getCodeFromWord(this.currentWord));
            }
            this.updateUI();
        } else if (s.equals("Next")) {
            ++this.pressesOfNext;
            this.updateUI();
        } else if (!s.equals("")) {
            if (s.equals("Space")) {
                this.pressesOfNext = 0;
                if (this.isAmbiguous && this.wordCompletion[this.wcOrder[0]].getText().length() > 0) {
                    this.currentWord = this.wordCompletion[this.wcOrder[0]].getText();
                }
                this.transcribedPhrase.append(this.currentWord.toString()).append(' ');
                this.currentWord = "";
                this.currentCode = new StringBuilder();
                this.updateUI();
            } else {
                this.pressesOfNext = 0;
                this.currentCode.append(this.getCodeFromLetter(c));
                this.currentWord = this.getWordFromCode(this.currentCode.toString());
                this.updateUI();
            }
        }
    }

    void updateUI() {
        if (this.usesWordCompletion) {
            this.query = this.currentWord.length() == 0 ? this.mostFrequent : EncodedWord.getQuery(this.currentCode.toString(), this.dictByCode);
            this.setWCWords();
        }
        this.text2.setText(String.valueOf(this.transcribedPhrase.toString()) + this.currentWord.toString());
        this.text2.requestFocus();
    }

    char getCodeFromLetter(char letter) {
        char code = ' ';
        if (letter == ' ') {
            return code;
        }
        int i = 0;
        while (i < this.letterKey.length) {
            if (this.letterKey[i].label.toLowerCase().indexOf(letter) >= 0) {
                if (this.isAmbiguous) {
                    code = (char)(97 + i);
                    break;
                }
                code = letter;
                break;
            }
            ++i;
        }
        return code;
    }

    String getCodeFromWord(String wordStem) {
        if (this.isAmbiguous) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < wordStem.length()) {
                sb.append(this.getCodeFromLetter(wordStem.charAt(i)));
                ++i;
            }
            return sb.toString();
        }
        return wordStem;
    }

    String getWordFromCode(String codeStem) {
        String word = "";
        if (this.isAmbiguous) {
            String[] words = EncodedWord.getTentative(codeStem, this.dictByCode);
            if (words == null || words.length == 0) {
                int i = 0;
                while (i < codeStem.length()) {
                    word = String.valueOf(word) + "?";
                    ++i;
                }
            } else {
                word = words[0].substring(0, codeStem.length());
            }
        } else {
            word = codeStem;
        }
        return word;
    }

    void setWCWords() {
        if (this.wcListSize == 0) {
            return;
        }
        int offset = this.pressesOfNext * this.wcListSize;
        int i = 0;
        while (i < this.wordCompletion.length) {
            if (this.query != null && this.query.length > i + offset) {
                this.setWord(this.wordCompletion[this.wcOrder[i]], this.query[i + offset]);
            } else {
                this.wordCompletion[this.wcOrder[i]].setText("");
            }
            ++i;
        }
    }

    void setWord(JButton b, String word) {
        int fontStyle = b.getFont().getStyle();
        int fontSize = b.getFont().getSize();
        b.setFont(new Font(this.FONT_FAMILY, fontStyle, fontSize));
        this.setFont(b.getFont());
        double spaceAvailable = (int)(b.getSize().getWidth() - (double)(2 * b.getMargin().left));
        double spaceNeeded = this.getGraphics().getFontMetrics().stringWidth(word);
        while (spaceAvailable > 0.0 && spaceAvailable < spaceNeeded * 1.1) {
            fontSize = (int)((double)fontSize * 0.9);
            b.setFont(new Font(this.FONT_FAMILY, fontStyle, fontSize));
            this.setFont(b.getFont());
            spaceAvailable = (int)(b.getSize().getWidth() - (double)(2 * b.getMargin().left));
            spaceNeeded = this.getGraphics().getFontMetrics().stringWidth(word);
        }
        b.setText(word);
    }

    public int getMinKeystrokesPhrase(String phrase) {
        String[] word;
        if (!this.usesWordCompletion) {
            return phrase.length();
        }
        int min = 0;
        String[] stringArray = word = phrase.trim().split("[ ]+");
        int n = word.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            min += this.getMinKeystrokesWord(s.toLowerCase(), this.getCodeFromWord(s)).length();
            ++n2;
        }
        return min;
    }

    public String getMinKeystrokesWord(String word, String code) {
        String codeStem = "";
        int nextKeystrokes = 0;
        int wordPosition = this.dictByCode.length;
        int j = 0;
        while (j <= word.length()) {
            codeStem = code.substring(0, j);
            String[] query = codeStem.length() == 0 ? this.mostFrequent : EncodedWord.getQuery(codeStem, this.dictByCode);
            if (query != null && query.length > 0) {
                wordPosition = SoftKeyboardExperimentGui.getWordPosition(word, query);
            }
            if (wordPosition >= 0 && (nextKeystrokes = wordPosition / this.wcListSize) == 0) break;
            ++j;
        }
        StringBuilder keystrokes = new StringBuilder(codeStem);
        int i = 0;
        while (i < nextKeystrokes) {
            keystrokes.append('N');
            ++i;
        }
        keystrokes.append('S');
        return keystrokes.toString();
    }

    public static int getWordPosition(String word, String[] list) {
        int idx = 0;
        while (idx < list.length && !word.equals(list[idx])) {
            ++idx;
        }
        return idx == list.length ? -1 : idx;
    }

    public static double wpm(String text, long msTime) {
        double speed = text.length();
        speed = speed / ((double)msTime / 1000.0) * 12.0;
        return speed;
    }

    class Key {
        static final String SPACE = "Space";
        static final String ENTER = "Enter";
        static final String BACKSPACE = "Bksp";
        static final String NEXT = "Next";
        static final String EMPTY = "";
        String label;
        double x;
        double y;
        double w;
        double h;

        Key(String labelArg, double xArg, double yArg, double wArg, double hArg) {
            this.label = labelArg;
            this.x = xArg;
            this.y = yArg;
            this.w = wArg;
            this.h = hArg;
        }

        boolean isLetterKey() {
            return !this.label.equals(EMPTY) && !this.label.equals(SPACE) && !this.label.equals(ENTER) && !this.label.equals(BACKSPACE) && !this.label.equals(NEXT);
        }

        boolean isCommandKey() {
            return this.label.equals(ENTER) || this.label.equals(BACKSPACE) || this.label.equals(NEXT);
        }

        boolean isSpaceKey() {
            return this.label.equals(SPACE);
        }

        boolean isEmptyKey() {
            return this.label.equals(EMPTY);
        }

        boolean isAmbiguous() {
            return this.isLetterKey() && this.label.length() > 1;
        }
    }

    class MetropolisButtonUI
    extends ButtonUI {
        Insets insets;
        double scale;

        MetropolisButtonUI(double scaleArg) {
            this.scale = scaleArg;
            int topBottomInset = (int)Math.round(16.0 * this.scale);
            int leftRightInset = (int)Math.round(18.0 * this.scale);
            this.insets = new Insets(topBottomInset, leftRightInset, topBottomInset, leftRightInset);
        }

        @Override
        public void installUI(JComponent c) {
            AbstractButton b = (AbstractButton)c;
            BasicButtonListener listener = new BasicButtonListener(b);
            b.addMouseListener(listener);
        }

        @Override
        public void uninstallUI(JComponent c) {
            AbstractButton b = (AbstractButton)c;
            BasicButtonListener listener = new BasicButtonListener(b);
            b.removeMouseListener(listener);
        }

        public Insets getDefaultMargin(AbstractButton ab) {
            return this.insets;
        }

        public Insets getInsets(JComponent c) {
            return this.insets;
        }

        @Override
        public Dimension getMaximumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            Graphics g = c.getGraphics();
            FontMetrics fm = g.getFontMetrics();
            Dimension d = new Dimension();
            d.width = fm.getAscent() + this.insets.left + this.insets.right;
            d.height = fm.getAscent() + this.insets.top + this.insets.bottom;
            return d;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Color backgroundColor;
            Graphics2D g2 = (Graphics2D)g;
            AbstractButton b = (AbstractButton)c;
            ButtonModel bm = b.getModel();
            FontMetrics fm = g2.getFontMetrics();
            Color BLUE_LIGHT = Color.gray;
            Color BLUE_DARK = Color.lightGray;
            if (bm.isArmed()) {
                backgroundColor = BLUE_LIGHT;
                b.setCursor(new Cursor(12));
            } else {
                backgroundColor = bm.isPressed() ? BLUE_LIGHT : BLUE_DARK;
            }
            Dimension d = c.getPreferredSize();
            double x = d.width - 1;
            double y = d.height - 1;
            int[] nArray = new int[6];
            nArray[0] = 2;
            nArray[1] = 4;
            nArray[2] = 4;
            nArray[3] = 2;
            int[] xx = nArray;
            int[] nArray2 = new int[6];
            nArray2[1] = 1;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray2[4] = 3;
            nArray2[5] = 1;
            int[] yy = nArray2;
            int i = 0;
            while (i < xx.length) {
                xx[i] = (int)((double)xx[i] * (x / 4.0));
                yy[i] = (int)((double)yy[i] * (y / 4.0));
                ++i;
            }
            Polygon p = new Polygon(xx, yy, xx.length);
            g2.setColor(backgroundColor);
            g2.fillPolygon(p);
            g2.setColor(Color.black);
            g2.drawPolygon(p);
            g2.setColor(Color.black);
            Font f = fm.getFont();
            g2.setFont(new Font(f.getName(), 1, f.getSize()));
            String s = ((JButton)c).getText();
            int width = fm.stringWidth(s);
            int height = fm.getAscent();
            x = (d.width - width) / 2;
            y = (d.height - 2 + height - 2) / 2;
            g2.drawString(s, (int)x, (int)y);
        }

        @Override
        public boolean contains(JComponent c, int x, int y) {
            double w = c.getWidth();
            double h = c.getHeight();
            int[] nArray = new int[7];
            nArray[0] = 2;
            nArray[1] = 4;
            nArray[2] = 4;
            nArray[3] = 2;
            nArray[6] = 2;
            int[] xx = nArray;
            int[] nArray2 = new int[7];
            nArray2[1] = 1;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray2[4] = 3;
            nArray2[5] = 1;
            int[] yy = nArray2;
            int i = 0;
            while (i < xx.length) {
                xx[i] = (int)((double)xx[i] * (w / 4.0));
                yy[i] = (int)((double)yy[i] * (h / 4.0));
                ++i;
            }
            Polygon p = new Polygon(xx, yy, xx.length);
            return p.contains(x, y);
        }
    }

    private class Sample {
        private long time;
        private String key;

        Sample(long l, String s) {
            this.time = l;
            this.key = s;
        }

        public String toString() {
            if (this.key.equals(" ")) {
                this.key = "_";
            }
            return String.valueOf(this.key) + ", " + this.time;
        }
    }

    class SoftKeyboard
    extends JPanel
    implements ActionListener {
        static final long serialVersionUID = 42L;
        final int DEFAULT_FONT_SIZE = 16;
        final Color LETTER_BACKGROUND = new Color(0xBBBBBB);
        final Color NON_LETTER_BACKGROUND = new Color(0xCCCCCC);
        JButton[] keyButton;
        double baseWidth;
        double baseHeight;
        int mode;
        double fontScale;
        ActionEvent ae;

        public SoftKeyboard(Key[] keyArg, double fontScaleArg, double baseWidthArg, double baseHeightArg, ActionListener alArg, int modeArg) {
            Key[] key = keyArg;
            this.fontScale = fontScaleArg;
            this.keyButton = new JButton[keyArg.length];
            this.baseWidth = baseWidthArg;
            this.baseHeight = baseHeightArg;
            this.mode = modeArg;
            int width = 0;
            int height = 0;
            Key[] keyArray = key;
            int n = key.length;
            int n2 = 0;
            while (n2 < n) {
                Key k = keyArray[n2];
                width = (int)Math.max((double)width, k.x * this.baseWidth + k.w * this.baseWidth);
                height = (int)Math.max((double)height, k.y * this.baseHeight + k.h * this.baseHeight);
                ++n2;
            }
            Dimension d = new Dimension(width, height);
            int i = 0;
            while (i < this.keyButton.length) {
                this.keyButton[i] = new JButton(key[i].label);
                if (this.mode == 300) {
                    this.keyButton[i].setUI(new MetropolisButtonUI(this.fontScale));
                    this.keyButton[i].setOpaque(false);
                } else if (key[i].isLetterKey()) {
                    this.keyButton[i].setBackground(this.LETTER_BACKGROUND);
                } else {
                    this.keyButton[i].setBackground(this.NON_LETTER_BACKGROUND);
                }
                this.keyButton[i].setFont(new Font("sansserif", 1, (int)(16.0 * this.fontScale)));
                this.keyButton[i].setMargin(new Insets(0, 0, 0, 0));
                this.keyButton[i].addActionListener(alArg);
                this.keyButton[i].setBounds((int)(key[i].x * this.baseWidth), (int)(key[i].y * this.baseHeight), (int)(key[i].w * this.baseWidth), (int)(key[i].h * this.baseHeight));
                this.add(this.keyButton[i]);
                ++i;
            }
            this.setLayout(null);
            this.setPreferredSize(d);
            this.setMaximumSize(d);
        }

        public ActionEvent getActionEvent() {
            return this.ae;
        }

        public void setActionEvent(ActionEvent aeArg) {
            this.ae = aeArg;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.setActionEvent(ae);
        }
    }
}

