/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class Word
implements Comparable<Object> {
    protected String word;
    protected int freq;

    public Word(String w, int f) {
        this.word = w;
        this.freq = f;
    }

    public String getWord() {
        return this.word;
    }

    public int getFreq() {
        return this.freq;
    }

    public void incFreq() {
        ++this.freq;
    }

    public String toString() {
        return String.valueOf(this.word) + " " + this.freq;
    }

    public static Word[] loadDictionary(String fileName) {
        Scanner inFile = null;
        try {
            inFile = new Scanner(new File(fileName));
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found - " + fileName);
            Word.showError("File not found - " + fileName);
            System.exit(1);
        }
        ArrayList<Word> arrayList = new ArrayList<Word>();
        while (inFile.hasNextLine()) {
            String line = inFile.nextLine();
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() != 2) {
                System.out.println("Dictionary format error");
                Word.showError("Dictionary format error");
                System.exit(1);
            }
            String newWord = st.nextToken();
            int newFreq = Integer.parseInt(st.nextToken());
            arrayList.add(new Word(newWord, newFreq));
        }
        inFile.close();
        Word[] dict = new Word[arrayList.size()];
        dict = arrayList.toArray(dict);
        return dict;
    }

    private static void showError(String msg) {
        JOptionPane.showMessageDialog(null, msg, "I/O Error", 0);
    }

    public boolean equals(Word w) {
        return this.getWord().equals(w.getWord());
    }

    @Override
    public int compareTo(Object o) {
        return this.getWord().compareTo(((Word)o).getWord());
    }
}

