/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MSD {
    private String s1;
    private String s2;
    private int[][] d;

    public MSD(String s1Arg, String s2Arg) {
        this.s1 = s1Arg;
        this.s2 = s2Arg;
        this.buildMatrix();
    }

    private static int r(char a, char b) {
        if (a == b) {
            return 0;
        }
        return 1;
    }

    private void buildMatrix() {
        this.d = new int[this.s1.length() + 1][this.s2.length() + 1];
        if (this.s1.length() == 0 || this.s2.length() == 0) {
            this.d[this.s1.length()][this.s2.length()] = Math.max(this.s1.length(), this.s2.length());
            return;
        }
        int i = 0;
        while (i < this.s1.length() + 1) {
            this.d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j < this.s2.length() + 1) {
            this.d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= this.s1.length()) {
            j = 1;
            while (j <= this.s2.length()) {
                int a = this.d[i - 1][j] + 1;
                int b = this.d[i][j - 1] + 1;
                int c = this.d[i - 1][j - 1] + MSD.r(this.s1.charAt(i - 1), this.s2.charAt(j - 1));
                int m = Math.min(a, b);
                this.d[i][j] = m = Math.min(m, c);
                ++j;
            }
            ++i;
        }
    }

    public int[][] getMatrix() {
        return this.d;
    }

    public int getMSD() {
        return this.d[this.s1.length()][this.s2.length()];
    }

    public String getS1() {
        return this.s1;
    }

    public String getS2() {
        return this.s2;
    }

    public double getErrorRate() {
        return (double)this.getMSD() / (double)Math.max(this.s1.length(), this.s2.length()) * 100.0;
    }

    private void dumpMatrix() {
        int rows = this.d.length;
        int cols = this.d[0].length;
        String s11 = " " + this.s1;
        String s22 = " " + this.s2;
        System.out.print(" ");
        int k = 0;
        while (k < s22.length()) {
            System.out.print("  " + s22.substring(k, k + 1));
            ++k;
        }
        System.out.println();
        int i = 0;
        while (i < rows) {
            System.out.print(s11.substring(i, i + 1));
            int j = 0;
            while (j < cols) {
                String f = String.valueOf(this.d[i][j]);
                while (f.length() < 3) {
                    f = " " + f;
                }
                System.out.print(f);
                ++j;
            }
            if (i != rows - 1) {
                System.out.println();
            }
            ++i;
        }
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        String s2;
        String s1;
        boolean mOption = false;
        boolean aOption = false;
        boolean erOption = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-m")) {
                mOption = true;
            } else if (args[i].equals("-a")) {
                aOption = true;
            } else if (args[i].equals("-er")) {
                erOption = true;
            } else if (args[i].equals("?")) {
                MSD.usage();
            } else {
                MSD.usage();
            }
            ++i;
        }
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in), 1);
        System.out.println("============================");
        System.out.println("Minimum String Distance Demo");
        System.out.println("============================");
        System.out.println("Enter pairs of strings (^z to exit)");
        while ((s1 = stdin.readLine()) != null && (s2 = stdin.readLine()) != null) {
            MSD s1s2 = new MSD(s1, s2);
            System.out.println("MSD = " + s1s2.getMSD());
            if (erOption) {
                System.out.println(String.format("Error rate (old) = %.4f%%", s1s2.getErrorRate()));
                System.out.println(String.format("Error rate (new) = %.4f%%", s1s2.getErrorRateNew()));
            }
            if (mOption) {
                s1s2.dumpMatrix();
            }
            if (!aOption) continue;
            StringPair[] sp = s1s2.getAlignments();
            if (sp == null) {
                System.out.println("Outlier!  Alignments not available");
                continue;
            }
            System.out.println("Alignments: " + sp.length + ", " + "mean size: " + s1s2.meanAlignmentSize());
            int i2 = 0;
            while (i2 < sp.length) {
                if (i2 > 0) {
                    System.out.println("");
                }
                System.out.println(sp[i2].s1);
                System.out.println(sp[i2].s2);
                ++i2;
            }
            System.out.println("-------------");
        }
    }

    private static void usage() {
        String usageString = "usage: java MSD [-m] [-k] [-er]\n\nwhere -m  = output the MSD matrix\n      -a  = output the set of optimal alignments\n      -er = output the error rate";
        System.out.println(usageString);
        System.exit(0);
    }

    private static StringPair[] DoubleConcat(StringPair[] a, char c1, char c2, StringPair[] b) {
        StringPair[] returnvalue = new StringPair[a.length + b.length];
        int i = 0;
        while (i < a.length + b.length) {
            returnvalue[i] = new StringPair();
            ++i;
        }
        i = 0;
        while (i < a.length) {
            returnvalue[i].CopyConcat(a[i], c1, c2);
            ++i;
        }
        System.arraycopy(b, 0, returnvalue, a.length, b.length);
        return returnvalue;
    }

    private static StringPair[] doAlignments(String s1, String s2, int[][] d, int x, int y) {
        StringPair[] returnarray = new StringPair[]{};
        if (x == 0 && y == 0) {
            returnarray = new StringPair[]{new StringPair()};
            return returnarray;
        }
        if (x > 0 && y > 0) {
            if (d[x][y] == d[x - 1][y - 1] && s1.charAt(x - 1) == s2.charAt(y - 1)) {
                returnarray = MSD.DoubleConcat(MSD.doAlignments(s1, s2, d, x - 1, y - 1), s1.charAt(x - 1), s2.charAt(y - 1), returnarray);
            }
            if (d[x][y] == d[x - 1][y - 1] + 1) {
                returnarray = MSD.DoubleConcat(MSD.doAlignments(s1, s2, d, x - 1, y - 1), s1.charAt(x - 1), s2.charAt(y - 1), returnarray);
            }
        }
        if (x > 0 && d[x][y] == d[x - 1][y] + 1) {
            returnarray = MSD.DoubleConcat(MSD.doAlignments(s1, s2, d, x - 1, y), s1.charAt(x - 1), '-', returnarray);
        }
        if (y > 0 && d[x][y] == d[x][y - 1] + 1) {
            returnarray = MSD.DoubleConcat(MSD.doAlignments(s1, s2, d, x, y - 1), '-', s2.charAt(y - 1), returnarray);
        }
        return returnarray;
    }

    public StringPair[] getAlignments() {
        return MSD.doAlignments(this.s1, this.s2, this.d, this.s1.length(), this.s2.length());
    }

    public double meanAlignmentSize() {
        StringPair[] sp = this.getAlignments();
        double n = 0.0;
        int i = 0;
        while (i < sp.length) {
            n += (double)sp[i].s1.length();
            ++i;
        }
        return n / (double)sp.length;
    }

    public double getErrorRateNew() {
        return (double)this.getMSD() / this.meanAlignmentSize() * 100.0;
    }
}

