/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class TypingTestExperimentGui
extends JFrame
implements KeyListener {
    static final long serialVersionUID = 42L;
    final String SD1_HEADER = "";
    final String SD2_HEADER = "App,Participant,Condition,Session,Block,Keystrokes,Characters,Time_(s),MSD,Speed_(wpm),Error_rate_(%),KSPC\n";
    private String participantCode;
    private String conditionCode;
    private String sessionCode;
    private String blockCode;
    private String appName;
    private BufferedWriter sd1File;
    private BufferedWriter sd2File;
    private Vector<Sample> samples;
    private String phrasesFile;
    private boolean showPresented;
    private boolean newPhrase = true;
    private Random r = new Random();
    private JTextField presentedTextField;
    private JTextField transcribedTextField;
    private JTextArea results;
    private String[] phrases;
    private String presentedPhrase;
    private long t1;
    private long t2;
    private int count;
    private int phraseCount;
    private Font BIG = new Font("monospaced", 1, 24);
    private Color BACKGROUND = new Color(254, 254, 218);
    private Color FOREGROUND = new Color(11, 11, 109);
    Configuration c;

    TypingTestExperimentGui(Configuration cArg) {
        this.c = cArg;
        this.participantCode = this.c.getConfigurationParameter(0);
        this.conditionCode = this.c.getConfigurationParameter(1);
        this.sessionCode = this.c.getConfigurationParameter(2);
        this.phraseCount = Integer.parseInt(this.c.getConfigurationParameter(3));
        this.phrasesFile = this.c.getConfigurationParameter(4);
        this.showPresented = Boolean.valueOf(this.c.getConfigurationParameter(5));
        this.appName = "TypingTestExperiment";
        Scanner inFile = null;
        try {
            inFile = new Scanner(new File(this.phrasesFile));
        }
        catch (FileNotFoundException e) {
            this.showError("\nPhrases file not found - " + this.phrasesFile);
            System.exit(1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (inFile.hasNextLine()) {
            arrayList.add(inFile.nextLine());
        }
        this.phrases = arrayList.toArray(new String[arrayList.size()]);
        this.blockCode = "";
        int blockCodeNumber = 0;
        String base = "TypingTestExperiment-" + this.participantCode + "-" + this.conditionCode + "-" + this.sessionCode;
        String s1 = "";
        String s2 = "";
        do {
            this.blockCode = ++blockCodeNumber < 10 ? "B0" + blockCodeNumber : "B" + blockCodeNumber;
            s1 = String.valueOf(base) + "-" + this.blockCode + ".sd1";
            s2 = String.valueOf(base) + "-" + this.blockCode + ".sd2";
        } while (new File(s1).exists());
        try {
            this.sd1File = new BufferedWriter(new FileWriter(s1));
            this.sd2File = new BufferedWriter(new FileWriter(s2));
        }
        catch (IOException e) {
            System.out.println("I/O error: can't open sd1/sd2 data files");
            System.exit(0);
        }
        try {
            this.sd1File.write("", 0, "".length());
            this.sd1File.flush();
            this.sd2File.write("App,Participant,Condition,Session,Block,Keystrokes,Characters,Time_(s),MSD,Speed_(wpm),Error_rate_(%),KSPC\n", 0, "App,Participant,Condition,Session,Block,Keystrokes,Characters,Time_(s),MSD,Speed_(wpm),Error_rate_(%),KSPC\n".length());
            this.sd2File.flush();
        }
        catch (IOException e) {
            System.err.println("ERROR WRITING TO DATA FILE!\n" + e);
            System.exit(1);
        }
        this.presentedTextField = new JTextField(50);
        this.presentedTextField.setFocusable(false);
        this.presentedTextField.setFont(this.BIG);
        this.presentedTextField.setBackground(new Color(254, 254, 218));
        this.presentedTextField.setForeground(new Color(11, 11, 109));
        JPanel text1Panel = new JPanel();
        text1Panel.add(this.presentedTextField);
        text1Panel.setBorder(new TitledBorder(new EtchedBorder(), "Presented text"));
        this.transcribedTextField = new JTextField(50);
        this.transcribedTextField.setFont(this.BIG);
        this.transcribedTextField.setBackground(this.BACKGROUND);
        this.transcribedTextField.setForeground(this.FOREGROUND);
        JPanel text2Panel = new JPanel();
        text2Panel.add(this.transcribedTextField);
        text2Panel.setBorder(new TitledBorder(new EtchedBorder(), "Transcribed text"));
        this.transcribedTextField.setEditable(true);
        this.transcribedTextField.addKeyListener(this);
        this.results = new JTextArea(13, 50);
        this.results.setFocusable(false);
        this.results.setFont(new Font("monospaced", 1, 18));
        this.results.setBackground(this.BACKGROUND);
        this.results.setForeground(this.FOREGROUND);
        JPanel resultsPanel = new JPanel(new BorderLayout());
        resultsPanel.add((Component)this.results, "Center");
        EtchedBorder b1 = new EtchedBorder();
        Border b2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        resultsPanel.setBorder(new CompoundBorder(b1, b2));
        this.presentedPhrase = this.phrases[this.r.nextInt(this.phrases.length)];
        this.presentedTextField.setText(this.presentedPhrase);
        this.transcribedTextField.setText("");
        this.results.setText("");
        this.t1 = 0L;
        this.count = 0;
        this.samples = new Vector();
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        p1.add(Box.createRigidArea(new Dimension(5, 10)));
        p1.add(text1Panel);
        p1.add(Box.createRigidArea(new Dimension(5, 10)));
        p1.add(text2Panel);
        p1.add(Box.createRigidArea(new Dimension(5, 10)));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)p1, "North");
        p.add((Component)resultsPanel, "South");
        this.setContentPane(p);
    }

    void showError(String msg) {
        JOptionPane.showMessageDialog(null, msg, "I/O Error", 0);
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (this.newPhrase) {
            this.newPhrase = false;
            if (!this.showPresented) {
                this.presentedTextField.setText("");
            }
        }
        ++this.count;
        if (this.t1 == 0L) {
            this.t1 = System.currentTimeMillis();
        }
        int keyCode = ke.getKeyCode();
        String keyText = KeyEvent.getKeyText(keyCode);
        this.t2 = System.currentTimeMillis() - this.t1;
        this.samples.addElement(new Sample(this.t2, keyText.toLowerCase()));
        if (keyCode == 10) {
            this.newPhrase = true;
            --this.count;
            String s1 = this.presentedPhrase.toLowerCase();
            String s2 = this.transcribedTextField.getText().toLowerCase();
            MSD s1s2 = new MSD(s1, s2);
            int msd = s1s2.getMSD();
            StringBuilder resultsString = new StringBuilder();
            resultsString.append(" DATA COLLECTED:\n");
            resultsString.append(String.format("   Presented:   %s\n", s1));
            resultsString.append(String.format("   Transcribed: %s\n", s2));
            resultsString.append(String.format("   Keystrokes:  %d\n", this.count));
            resultsString.append(String.format("   Characters:  %d (%.1f words)\n", s2.length(), (double)s2.length() / 5.0));
            resultsString.append(String.format("   Time:        %.2f s (%.1f minutes)\n", (double)this.t2 / 1000.0, (double)this.t2 / 1000.0 / 60.0));
            resultsString.append(String.format("   MSD:         %d\n\n", msd));
            resultsString.append(" PARTICIPANT PERFORMANCE:\n");
            resultsString.append(String.format("   Entry Speed: %.2f wpm\n", TypingTestExperimentGui.wpm(s2, this.t2)));
            resultsString.append(String.format("   Error rate:  %.2f%%\n", s1s2.getErrorRateNew()));
            resultsString.append(String.format("   KSPC:        %.4f\n", (double)this.count / (double)s2.length()));
            this.results.setText(resultsString.toString());
            StringBuilder sd2Stuff = new StringBuilder();
            sd2Stuff.append(this.appName).append(',');
            sd2Stuff.append(this.participantCode).append(',');
            sd2Stuff.append(this.conditionCode).append(',');
            sd2Stuff.append(this.sessionCode).append(',');
            sd2Stuff.append(this.blockCode).append(',');
            sd2Stuff.append(this.count).append(',');
            sd2Stuff.append(s2.length()).append(',');
            sd2Stuff.append((double)this.t2 / 1000.0).append(',');
            sd2Stuff.append(msd).append(',');
            sd2Stuff.append(TypingTestExperimentGui.wpm(s2, this.t2)).append(',');
            sd2Stuff.append(s1s2.getErrorRateNew()).append(',');
            sd2Stuff.append((double)this.count / (double)s2.length()).append('\n');
            StringBuilder sd1Stuff = new StringBuilder();
            sd1Stuff.append(this.presentedPhrase).append('\n');
            sd1Stuff.append(s2).append('\n');
            int i = 0;
            while (i < this.samples.size()) {
                sd1Stuff.append(this.samples.elementAt(i)).append('\n');
                ++i;
            }
            sd1Stuff.append('#').append('\n');
            try {
                this.sd1File.write(sd1Stuff.toString(), 0, sd1Stuff.length());
                this.sd1File.flush();
                this.sd2File.write(sd2Stuff.toString(), 0, sd2Stuff.length());
                this.sd2File.flush();
            }
            catch (IOException e) {
                System.err.println("ERROR WRITING TO DATA FILE!\n" + e);
                System.exit(1);
            }
            if (--this.phraseCount == 0) {
                JLabel thankyou = new JLabel("End of block. Thank you.");
                thankyou.setFont(new Font("sansserif", 0, 16));
                JOptionPane.showMessageDialog(this, thankyou);
                try {
                    this.sd1File.close();
                    this.sd2File.close();
                }
                catch (IOException e) {
                    System.err.println("ERROR CLOSING DATA FILES!\n" + e);
                    System.exit(1);
                }
                System.exit(0);
            }
            this.samples = new Vector();
            this.presentedPhrase = this.phrases[this.r.nextInt(this.phrases.length)];
            this.presentedTextField.setText(this.presentedPhrase);
            this.transcribedTextField.setText("");
            this.t1 = 0L;
            this.count = 0;
        }
    }

    public static double wpm(String text, long msTime) {
        double speed = text.length();
        speed = speed / ((double)msTime / 1000.0) * 12.0;
        return speed;
    }

    private class Sample {
        private long time;
        private String key;

        Sample(long l, String s) {
            this.time = l;
            this.key = s;
        }

        public String toString() {
            return String.valueOf(this.time) + " " + this.key;
        }
    }
}

