package ca.yorku.cse.mack.tilttarget;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.Spinner;
import android.widget.Toast;

public class TiltTargetSetup extends Activity
{
	private Spinner spinParticipant;
	private Spinner spinSession, spinBlock, spinGroup, spinCondition, spinSequencesPerBlock, spinTargetsPerSequence;
	private Spinner spinKeyboard;
	private Spinner spinOrderOfControl, spinTiltGain;
	private Spinner spinDwellTime, spinSamplingRate;
	private CheckBox checkVibrotactileFeedback;
	private CheckBox checkAuditoryFeedback;
		
	String[] participantCode = { "P00", "P01", "P02", "P03", "P04", "P05", 
		"P06", "P07", "P08", "P09", "P10", "P11", "P12", "P13", "P14", "P15", 
		"P16", "P17", "P18", "P19", "P20", "P21", "P22", "P23", "P24", "P25" };		
	String[] sessionCode = { "S00",
		"S01", "S02", "S03", "S04", "S05", "S06", "S07", "S08", "S09", "S10",
		"S11", "S12", "S13", "S14", "S15", "S16", "S17", "S18", "S19", "S20",
		"S21", "S22", "S23", "S24", "S25" };
	String[] blockCode = { "(auto)" };
	String[] groupCode = { "G00",
		"G01", "G02", "G03", "G04", "G05", "G06", "G07", "G08", "G09", "G10", 
		"G11", "G12", "G13", "G14", "G15", "G16", "G17", "G18", "G19", "G20", 
		"G21", "G22", "G23", "G24", "G25" };	
	String[] conditionCode = { "C00",
		"C01", "C02", "C03", "C04", "C05", "C06", "C07", "C08", "C09", "C10", 
		"C11", "C12", "C13", "C14", "C15", "C16", "C17", "C18", "C19", "C20", 
		"C21", "C22", "C23", "C24", "C25" };
	String[] sequencesPerBlockArray = { "5", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10" };
	String[] targetsPerSequenceArray = { "10", "1", "2", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50" };
	String[] keyboardArray = { "5x3", "5x3", "4x10" };
	String[] dwellTimeArray = { "500", "100", "200", "300", "400", "500", "600", "700", "800", "900", "1000" };
	
	String[] samplingRateArray = { "Game", "Normal", "UI", "Game", "Fastest" };
	
	// ORDER OF CONTROL
	final static String VELOCITY = "Velocity";
	final static String POSITION = "Position";
	String[] orderOfControlArray = { VELOCITY, VELOCITY, POSITION };
	
	// GAIN
	final static String VERY_LOW = "Very low";
	final static String LOW = "Low";
	final static String MEDIUM = "Medium";
	final static String HIGH = "High";
	final static String VERY_HIGH = "Very high";
	String[] gainArray = { MEDIUM, VERY_LOW, LOW, MEDIUM, HIGH, VERY_HIGH };
	String gainString;
	// somewhat arbitrary mappings for gain by order of control
	final static int[] GAIN_ARG_POSITION_CONTROL = { 5, 10, 20, 40, 80 };
	final static int[] GAIN_ARG_VELOCITY_CONTROL = { 25, 50, 100, 200, 400 };

	boolean vibrotactileFeedback = true;
	boolean auditoryFeedback = false;

	SharedPreferences sp;
	SharedPreferences.Editor spe;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.setup);
        	
		sp = this.getPreferences(MODE_PRIVATE);
		
		// load preferences
		sp = this.getPreferences(MODE_PRIVATE);
		participantCode[0] = sp.getString("participantCode", participantCode[0]);
		sessionCode[0] = sp.getString("sessionCode", sessionCode[0]);
		// block code initialized in main activity (based on existing filenames)
		groupCode[0] = sp.getString("groupCode", groupCode[0]);
		conditionCode[0] = sp.getString("conditionCode", conditionCode[0]);
		sequencesPerBlockArray[0] = sp.getString("sequencesPerBlock", sequencesPerBlockArray[0]);
		targetsPerSequenceArray[0] = sp.getString("targetsPerSequence", targetsPerSequenceArray[0]);
		keyboardArray[0] = sp.getString("keyboard", keyboardArray[0]);
		orderOfControlArray[0] = sp.getString("orderOfControl", orderOfControlArray[0]);
		gainArray[0] = sp.getString("gain", gainArray[0]);
		dwellTimeArray[0] = sp.getString("dwellTime", dwellTimeArray[0]);
		samplingRateArray[0] = sp.getString("samplingRate", samplingRateArray[0]);		
		vibrotactileFeedback = sp.getBoolean("vibrotactileFeedback", vibrotactileFeedback);
		auditoryFeedback = sp.getBoolean("auditoryFeedback", auditoryFeedback);			

		// get references to widget elements
		spinParticipant = (Spinner)findViewById(R.id.paramPart);
    	spinSession = (Spinner)findViewById(R.id.paramSess);
    	spinBlock = (Spinner)findViewById(R.id.paramBlock);
    	spinGroup = (Spinner)findViewById(R.id.paramGroup);
    	spinCondition = (Spinner)findViewById(R.id.paramCondition);
    	spinSequencesPerBlock = (Spinner)findViewById(R.id.paramSequencesPerBlock);
    	spinTargetsPerSequence = (Spinner)findViewById(R.id.paramTargetsPerSequence);
    	spinKeyboard = (Spinner)findViewById(R.id.paramKeyboard);
    	spinOrderOfControl = (Spinner)findViewById(R.id.paramOrderOfControl);
    	spinTiltGain = (Spinner)findViewById(R.id.paramTiltGain);
       	spinDwellTime = (Spinner)findViewById(R.id.paramDwellTime);
       	spinSamplingRate = (Spinner)findViewById(R.id.paramSamplingRate);
    	checkVibrotactileFeedback = (CheckBox)findViewById(R.id.paramVibrotactileFeedback);
    	checkAuditoryFeedback = (CheckBox)findViewById(R.id.paramAuditoryFeedback);
    	
    	// initialise spinner adapters
    	ArrayAdapter<CharSequence> adapterPC
    		= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, participantCode);
    	spinParticipant.setAdapter(adapterPC);
    	
    	ArrayAdapter<CharSequence> adapterSS
			= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, sessionCode);
    	spinSession.setAdapter(adapterSS);
    	
    	ArrayAdapter<CharSequence> adapterB
			= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, blockCode);
    	spinBlock.setAdapter(adapterB);
    	
    	ArrayAdapter<CharSequence> adapterG
			= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, groupCode);
    	spinGroup.setAdapter(adapterG);
    	
    	ArrayAdapter<CharSequence> adapterC
			= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, conditionCode);
    	spinCondition.setAdapter(adapterC);
    	
    	ArrayAdapter<CharSequence> adapterSPB
			= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, sequencesPerBlockArray);
    	spinSequencesPerBlock.setAdapter(adapterSPB);
    	
    	ArrayAdapter<CharSequence> adapterTPS
			= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, targetsPerSequenceArray);
    	spinTargetsPerSequence.setAdapter(adapterTPS);
    	
    	ArrayAdapter<CharSequence> adapterK
			= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, keyboardArray);
    	spinKeyboard.setAdapter(adapterK);
 
    	ArrayAdapter<CharSequence> adapterOOC
		= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, orderOfControlArray);    	
    	spinOrderOfControl.setAdapter(adapterOOC);
    	
    	ArrayAdapter<CharSequence> adapterTG
		= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, gainArray);    	
    	spinTiltGain.setAdapter(adapterTG);
    	   	
    	ArrayAdapter<CharSequence> adapterDT
			= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, dwellTimeArray);
    	spinDwellTime.setAdapter(adapterDT);
    	
    	ArrayAdapter<CharSequence> adapterSR
			= new ArrayAdapter<CharSequence>(this, R.layout.spinnerstyle, samplingRateArray);
    	spinSamplingRate.setAdapter(adapterSR);
    	
		checkVibrotactileFeedback.setChecked(vibrotactileFeedback);
		checkAuditoryFeedback.setChecked(auditoryFeedback);
    }
    
    /**	Called when the "OK" button is pressed. */
    public void clickOK(View view)
    {
    	// get user's choices
    	String part = participantCode[spinParticipant.getSelectedItemPosition()];
    	String sess = sessionCode[spinSession.getSelectedItemPosition()];
    	//String block = blockCode[spinBlock.getSelectedItemPosition()];
    	String group = groupCode[spinGroup.getSelectedItemPosition()];
    	String condition = conditionCode[spinCondition.getSelectedItemPosition()];
    	int sequencesPerBlock = Integer.parseInt(sequencesPerBlockArray[spinSequencesPerBlock.getSelectedItemPosition()]);
    	int targetsPerSequence = Integer.parseInt(targetsPerSequenceArray[spinTargetsPerSequence.getSelectedItemPosition()]);
    	String keyboard = keyboardArray[spinKeyboard.getSelectedItemPosition()];
       	String orderOfControl = orderOfControlArray[spinOrderOfControl.getSelectedItemPosition()];
       	String gainString = gainArray[spinTiltGain.getSelectedItemPosition()];
		// actual gain value depends on order of control
		int gain = getGain(orderOfControl, gainString);	
       	int dwellTime = Integer.parseInt(dwellTimeArray[spinDwellTime.getSelectedItemPosition()]);
       	
       	int samplingRate = -1;
       	String delay = (String)spinSamplingRate.getSelectedItem();
       	if (delay.equals("Normal"))
      		samplingRate = SensorManager.SENSOR_DELAY_NORMAL;
       	else if (delay.equals("UI"))
      		samplingRate = SensorManager.SENSOR_DELAY_UI;
       	else if (delay.equals("Game"))
      		samplingRate = SensorManager.SENSOR_DELAY_GAME;
       	else if (delay.equals("Fastest"))
     		samplingRate = SensorManager.SENSOR_DELAY_FASTEST;
       	
    	//String selectionMode = selectionModeArray[spinSelectionMode.getSelectedItemPosition()];
    	boolean vibrotactileFeedback = checkVibrotactileFeedback.isChecked();
    	boolean auditoryFeedback = checkAuditoryFeedback.isChecked();
    	
    	// TUTORIAL NOTE: Activities are created by calling zero-parameter constructors.
    	// It is not possible to directly pass arguments to Activities.
    	// Instead, primitive values can be "bundled" and passed.
    	Bundle b = new Bundle();
    	b.putString("participantCode", part);
    	b.putString("sessionCode", sess);
    	//b.putString("blockCode", block);    	
    	b.putString("groupCode", group);    	
    	b.putString("conditionCode", condition);    	
    	b.putInt("sequencesPerBlock", sequencesPerBlock);    	
    	b.putInt("targetsPerSequence", targetsPerSequence);    	
    	b.putString("keyboard", keyboard);
    	b.putString("orderOfControl", orderOfControl);
    	b.putInt("tiltGain", gain);
    	b.putInt("dwellTime", dwellTime);
    	b.putInt("samplingRate", samplingRate);
    	b.putBoolean("vibrotactileFeedback", vibrotactileFeedback);
    	b.putBoolean("auditoryFeedback", auditoryFeedback);
    	
    	// start experiment activity
    	Intent i = new Intent(getApplicationContext(), TiltTargetActivity.class);
    	i.putExtras(b);
    	startActivity(i);
		finish();
    }
    
    /**	Called when the "Save" button is pressed. */
    public void clickSave(View view)
    {
		spe = sp.edit();
		spe.putString("participantCode", participantCode[spinParticipant.getSelectedItemPosition()]);
		spe.putString("sessionCode", sessionCode[spinSession.getSelectedItemPosition()]);
		spe.putString("groupCode", groupCode[spinGroup.getSelectedItemPosition()]);
		spe.putString("conditionCode", conditionCode[spinCondition.getSelectedItemPosition()]);
		spe.putString("sequencesPerBlock", sequencesPerBlockArray[spinSequencesPerBlock.getSelectedItemPosition()]);		
		spe.putString("targetsPerSequence", targetsPerSequenceArray[spinTargetsPerSequence.getSelectedItemPosition()]);
		spe.putString("keyboard", keyboardArray[spinKeyboard.getSelectedItemPosition()]);
		spe.putString("orderOfControl", orderOfControlArray[spinOrderOfControl.getSelectedItemPosition()]);
		spe.putString("gain", gainArray[spinTiltGain.getSelectedItemPosition()]);
		spe.putString("dwellTime", dwellTimeArray[spinDwellTime.getSelectedItemPosition()]);
		spe.putString("samplingRate", samplingRateArray[spinSamplingRate.getSelectedItemPosition()]);
		spe.putBoolean("vibrotactileFeedback", checkVibrotactileFeedback.isChecked());		
		spe.putBoolean("auditoryFeedback", checkAuditoryFeedback.isChecked());
		spe.commit();
		Toast.makeText(this, "Preferences saved!", Toast.LENGTH_SHORT).show();
    }
    
    /**	Called when the "Exit" button is pressed. */
    public void clickExit(View view)
    {
    	super.onDestroy(); // cleanup
	    this.finish(); // terminate
    } 
    
    // convoluted way to get gain (should probably use a key-value Map)
    public int getGain(String orderOfControl, String gainArg)
    {
    	int gain = -1;
    	if (orderOfControl.equals(VELOCITY))
    	{
    		if (gainArg.equals(VERY_LOW))
    			gain = GAIN_ARG_VELOCITY_CONTROL[0];
    		else if (gainArg.equals(LOW))
    			gain = GAIN_ARG_VELOCITY_CONTROL[1];
    		else if (gainArg.equals(MEDIUM))
    			gain = GAIN_ARG_VELOCITY_CONTROL[2];
    		else if (gainArg.equals(HIGH))
    			gain = GAIN_ARG_VELOCITY_CONTROL[3];
    		else if (gainArg.equals(VERY_HIGH))
    			gain = GAIN_ARG_VELOCITY_CONTROL[4];
    	}
    	else if (orderOfControl.equals(POSITION))
    	{
    		if (gainArg.equals(VERY_LOW))
    			gain = GAIN_ARG_POSITION_CONTROL[0];
    		else if (gainArg.equals(LOW))
    			gain = GAIN_ARG_POSITION_CONTROL[1];
    		else if (gainArg.equals(MEDIUM))
    			gain = GAIN_ARG_POSITION_CONTROL[2];
    		else if (gainArg.equals(HIGH))
    			gain = GAIN_ARG_POSITION_CONTROL[3];
    		else if (gainArg.equals(VERY_HIGH))
    			gain = GAIN_ARG_POSITION_CONTROL[4];
    	}    
    	//Log.i("MYDEBUG", "orderOfControl=" + orderOfControl + ", gainArg=" + gainArg + ", gain=" + gain);
    	return gain;
    }
}
