import york.*;

public class BaseSA
{
	public static void main( String[] args )
	{
		TSP tsp = new TSP(args[0]);
		Tour sa = new Tour(tsp);

		int previousValue;

		for (int i = 0; i < 10; i++)
		{
			sa.twoOpt();
			sa.update();
		}
		sa.setBest();

		YorkWriter writer = new YorkWriter(args[1]);
		previousValue = sa.getCurrentLength();
		York.println(previousValue);

		double baseTemp, currentTemp, deltaE;
		int maxTemperatureSteps = 100;
		int maxIterations = 200000;
		double mu = Double.parseDouble(args[2]);

		baseTemp = (-Double.parseDouble(args[3]) * sa.getCurrentLength()) / Math.log(0.5);
		currentTemp = baseTemp;

		int last = -40;

		for (int i = 0; i < maxTemperatureSteps; i++)
		{
			for (int j = 0; j < maxIterations; j++)
			{
				sa.twoOpt();
				deltaE = sa.getImprovement();

				if (deltaE >= 0)
					sa.update();
				else if (Math.random() < Math.exp(deltaE/currentTemp))
					sa.update();
			}
			sa.backToBest();

			last++;
			if (previousValue == sa.getCurrentLength())
			{
				if (last >= 10)
				{
					currentTemp = currentTemp * 1.2;
					last = 0;
				}
				else
				{
					currentTemp = currentTemp*mu;
				}
			}
			else
			{
				currentTemp = currentTemp * mu;
				previousValue = sa.getCurrentLength();
			}

			York.print(i, "3");
			York.println(sa.getCurrentLength(), "10");
		}
		writer.println(sa.getCurrentLength());
		writer.close();
//		sa.printTour();
	}
}
