import york.*;

public class SAGA
{
	public static void main (String[] args)
	{
		TSP tsp = new TSP(args[0]);
		Tour saga1 = new Tour(tsp);
		Tour saga2 = new Tour(tsp);

		int previousValue;

		for (int i = 0; i < 10; i++)
		{
			saga1.twoOpt();
			saga1.update();

			saga2.twoOpt();
			saga2.update();
		}
		saga1.setBest(true);
		saga2.setBest(true);

		YorkWriter writer = new YorkWriter(args[1]);
		York.print(saga1.getCurrentLength(), "10");
		York.println(saga2.getCurrentLength(), "10");
		previousValue = saga1.getCurrentLength() + saga2.getCurrentLength();

		double baseTemp, currentTemp, deltaE;
		int maxTemperatureSteps = 100;
		int maxIterations = 200000;
		double mu = Double.parseDouble(args[2]);

		baseTemp = (-Double.parseDouble(args[3]) 
					* 0.5 * (saga1.getCurrentLength() + saga2.getCurrentLength()) ) 
						/ Math.log(0.5);
		currentTemp = baseTemp;

		double common = Double.parseDouble(args[4]);
		int last = -40;

		for (int i = 0; i < maxTemperatureSteps; i++)
		{
			for (int j = 0; j < maxIterations/2; j++)
			{
				saga1.twoOpt(saga2, common);
				deltaE = saga1.getImprovement();

				if (deltaE >= 0)
					saga1.update();
				else if (Math.random() < Math.exp(deltaE/currentTemp))
					saga1.update();

				saga2.twoOpt(saga1, common);
				deltaE = saga2.getImprovement();

				if (deltaE >= 0)
					saga2.update();
				else if (Math.random() < Math.exp(deltaE/currentTemp))
					saga2.update();
			}
			saga1.backToBest(true);
			saga2.backToBest(true);

			last++;
			if (previousValue == saga1.getCurrentLength()+saga2.getCurrentLength())
			{
				if (last >= 10)
				{
					currentTemp = currentTemp * 1.2;
					last = 0;
				}
				else
				{
					currentTemp = currentTemp*mu;
				}
			}
			else
			{
				currentTemp = currentTemp * mu;
				previousValue = saga1.getCurrentLength()+saga2.getCurrentLength();
			}

			York.print(i, "3");
			York.print(saga1.getCurrentLength(), "10");
			York.println(saga2.getCurrentLength(), "10");
		}

		if (saga1.getCurrentLength() < saga2.getCurrentLength())
			writer.println(saga1.getCurrentLength());
		else
			writer.println(saga2.getCurrentLength());

		writer.close();
//		sa.printTour("sa.txt");
	}
}
