import york.*;

public class TSP
{
	private int N;
	private int[] xCoord;
	private int[] yCoord;
	private int[][] distances;

	public TSP (String file)
	{
		YorkReader reader = new YorkReader(file);
		N = reader.readInt();
		xCoord = new int[N];
		yCoord = new int[N];

		for (int i = 0; i < N; i++)
		{
			reader.readInt();
			xCoord[i] = (int) reader.readDouble();
			yCoord[i] = (int) reader.readDouble();
		}
		reader.close();

		if (N < 3800)
		{
			distances = new int[N][N];
			makeDistances();
		}
		else
			distances = new int[1][1];
	}

	private void makeDistances ()
	{
		double xDist, yDist, dist;

		for (int i = 0; i < N; i++)
		{
			for (int j = 0; j < N; j++)
			{
				xDist = xCoord[i] - xCoord[j];
				yDist = yCoord[i] - yCoord[j];
				dist = Math.sqrt(xDist*xDist + yDist*yDist);

				distances[i][j] = (int) Math.floor(dist + 0.5);
			}
		}
	}

	public int getN ()
	{
		return N;
	}
	
	public int getDistance (int first, int second)
	{
		if (N < 3800)
		{
			return distances[first][second];
		}
		else
		{
			double xDist, yDist, dist;
			
			xDist = xCoord[first] - xCoord[second];
			yDist = yCoord[first] - yCoord[second];
			dist = Math.sqrt(xDist*xDist + yDist*yDist);

			return (int) Math.floor(dist + 0.5);
		}
	}

	public int getLength (int[] array)
	{
		int total = 0;

		if (N < 3800)
		{
			for (int i = 1; i < N; i++)
				total += distances[array[i-1]][array[i]];
			total += distances[array[N-1]][array[0]];
		}
		else
		{
			for (int i = 1; i < N; i++)
				total += getDistance(array[i-1], array[i]);
			total += getDistance(array[N-1], array[0]);
		}

		return total;
	}
}