/*
 * Decompiled with CFR 0.152.
 */
public class AbstractPlayingCard {
    int cardNumber = 52;
    int suitNumber = 4;
    int rankNumber = 13;
    private String suitName = "";
    private String rankName = "";
    private String cardName = "";
    private String colorName = "";
    public static String[] SUITS = new String[]{"Clubs", "Diamonds", "Hearts", "Spades"};

    AbstractPlayingCard(int number) {
        this.cardNumber = number >= 0 && number <= 52 ? number : 52;
        this.rankNumber = this.cardNumber % 13;
        this.suitNumber = this.cardNumber / 13;
        this.setSuitName(this.suitNumber);
        this.setRankName(this.rankNumber);
        this.setCardName();
        this.setColorName();
    }

    void setCardName() {
        this.cardName = this.cardNumber < 0 || this.cardNumber > 51 ? "Joker" : this.rankName + " of " + this.suitName;
    }

    void setColorName() {
        this.colorName = this.cardNumber < 0 || this.cardNumber > 51 ? "" : (this.suitNumber == 0 || this.suitNumber == 3 ? "black" : "red");
    }

    void setSuitName(int num) {
        this.suitName = num >= 0 && num <= 3 ? SUITS[num] : "";
    }

    void setRankName(int num) {
        this.rankName = num == 0 ? "Ace" : (num >= 1 && num <= 9 ? "" + (num + 1) : (num == 10 ? "Jack" : (num == 11 ? "Queen" : (num == 12 ? "King" : ""))));
    }

    public int getCardNumber() {
        return this.cardNumber;
    }

    public int getRankNumber() {
        return this.rankNumber;
    }

    public int getSuitNumber() {
        return this.suitNumber;
    }

    public String getCardName() {
        return this.cardName;
    }

    public String getColorName() {
        return this.colorName;
    }

    public String getRankName() {
        return this.rankName;
    }

    public String getSuitName() {
        return this.suitName;
    }
}

