/*
 * Decompiled with CFR 0.152.
 */
public class AbstractPlayingCardIdea {
    private String suitName = null;
    private String rankName = null;
    private String colorName = null;
    private String standingName = null;
    private boolean consistent = true;

    AbstractPlayingCardIdea() {
    }

    boolean checkColorSuitConsistency() {
        if (this.colorName == null || this.suitName == null) {
            return true;
        }
        return (!this.colorName.equals("black") || !this.suitName.equals("Diamonds") && !this.suitName.equals("Hearts")) && (!this.colorName.equals("red") || !this.suitName.equals("Clubs") && !this.suitName.equals("Spades"));
    }

    boolean checkRankStandingConsistency() {
        if (this.rankName == null || this.standingName == null) {
            return true;
        }
        if (this.standingName.equals("Joker") && (this.rankName == null || this.rankName.equals("Joker"))) {
            return true;
        }
        if (this.standingName.equals("face") && (this.rankName.equals("Jack") || this.rankName.equals("Queen") || this.rankName.equals("King"))) {
            return true;
        }
        return !this.standingName.equals("spot") || !this.rankName.equals("Jack") && !this.rankName.equals("Queen") && !this.rankName.equals("King") && !this.rankName.equals("Joker");
    }

    AbstractPlayingCardIdea copy() {
        AbstractPlayingCardIdea result = new AbstractPlayingCardIdea();
        if (result != null) {
            result.setColorName(this.getColorName());
            result.setRankName(this.getRankName());
            result.setSuitName(this.getSuitName());
            result.setStandingName(this.getStandingName());
        }
        return result;
    }

    public String getColorName() {
        return this.colorName;
    }

    public String getRankName() {
        return this.rankName;
    }

    public String getSuitName() {
        return this.suitName;
    }

    public String getStandingName() {
        return this.standingName;
    }

    public boolean isConsistent() {
        return this.consistent;
    }

    boolean isConsistentWithAnyAbstractCard() {
        return this.colorName == null && this.rankName == null && this.standingName == null && this.suitName == null;
    }

    boolean isConsistentWith(AbstractPlayingCard card) {
        if (this.standingName != null && this.standingName.equals("Joker") && !card.getSuitName().equals("")) {
            return false;
        }
        if (this.standingName != null && this.standingName.equals("face") && !card.getRankName().equals("Jack") && !card.getRankName().equals("Queen") && !card.getRankName().equals("King")) {
            return false;
        }
        if (this.standingName != null && this.standingName.equals("spot") && (card.getRankName().equals("Jack") || card.getRankName().equals("Queen") || card.getRankName().equals("King") || card.getColorName().equals(""))) {
            return false;
        }
        if (this.colorName != null && !this.colorName.equals(card.getColorName())) {
            return false;
        }
        if (this.rankName != null && !this.rankName.equals(card.getRankName())) {
            return false;
        }
        return this.suitName == null || this.suitName.equals(card.getSuitName());
    }

    boolean isConsistentWith(PlayingCard card) {
        return this.isConsistentWith(card.getAbstractCard());
    }

    boolean isFullySpecified() {
        if (!this.consistent || this.standingName == null) {
            return false;
        }
        if (this.standingName.equals("Joker")) {
            return true;
        }
        return this.rankName != null && this.suitName != null;
    }

    AbstractPlayingCardIdea mergeWith(AbstractPlayingCardIdea other) {
        if (other == null) {
            return null;
        }
        AbstractPlayingCardIdea result = other.copy();
        String otherColor = other.getColorName();
        String otherStanding = other.getStandingName();
        String otherRank = other.getRankName();
        String otherSuit = other.getSuitName();
        if (otherColor == null) {
            result.setColorName(this.colorName);
        } else if (this.colorName != null && !this.colorName.equals(otherColor)) {
            return null;
        }
        if (otherStanding == null) {
            result.setStandingName(this.standingName);
        } else if (this.standingName != null && !this.standingName.equals(otherStanding)) {
            return null;
        }
        if (otherRank == null) {
            result.setRankName(this.rankName);
        } else if (this.rankName != null && !this.rankName.equals(otherRank)) {
            return null;
        }
        if (otherSuit == null) {
            result.setSuitName(this.suitName);
        } else if (this.suitName != null && !this.suitName.equals(otherSuit)) {
            return null;
        }
        if (result.isConsistent()) {
            return result;
        }
        return null;
    }

    void setColorName(String color) {
        this.colorName = color;
        if (this.suitName == null) {
            return;
        }
        this.consistent = this.consistent && this.checkColorSuitConsistency();
    }

    boolean setFeature(String feature, String featureValue) {
        if (feature == null) {
            return this.consistent;
        }
        if (feature.equals("color")) {
            this.setColorName(featureValue);
        } else if (feature.equals("rank")) {
            this.setRankName(featureValue);
        } else if (feature.equals("suit")) {
            this.setSuitName(featureValue);
        } else if (feature.equals("standing")) {
            this.setStandingName(featureValue);
        }
        return this.consistent;
    }

    void setRankName(String rank) {
        if (rank == null) {
            return;
        }
        if (this.rankName == null) {
            this.rankName = rank;
            if (this.standingName == null) {
                this.standingName = this.rankName.equals("Joker") ? "Joker" : (this.rankName.equals("Jack") || this.rankName.equals("Queen") || this.rankName.equals("King") ? "face" : "spot");
            } else {
                this.consistent = this.consistent && this.checkRankStandingConsistency();
            }
        } else if (!rank.equals(this.rankName)) {
            this.consistent = false;
        }
    }

    void setSuitName(String suit) {
        if (suit == null) {
            return;
        }
        if (this.suitName == null) {
            this.suitName = suit;
            if (this.colorName == null) {
                if (this.suitName.equals("Diamonds") || this.suitName.equals("Hearts")) {
                    this.colorName = "red";
                } else if (this.suitName.equals("Clubs") || this.suitName.equals("Spades")) {
                    this.colorName = "black";
                }
            } else {
                this.consistent = this.consistent && this.checkColorSuitConsistency();
            }
        } else if (!suit.equals(this.suitName)) {
            this.consistent = false;
        }
    }

    void setStandingName(String standing) {
        if (standing == null) {
            return;
        }
        if (this.standingName == null) {
            this.standingName = standing;
            this.consistent = this.consistent && this.checkRankStandingConsistency();
        } else if (!standing.equals(this.standingName)) {
            this.consistent = false;
        }
    }
}

