/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Card
extends JButton
implements MouseListener,
MouseMotionListener,
ChangeListener {
    private String cardName = null;
    private ImageIcon frontImage;
    private ImageIcon backImage;
    private int frontShowing = 1;
    private boolean stacked = false;
    private CardTable table;
    private CardAgent2 agent;

    Card(String frontFileName, String backFileName) {
        this.frontImage = new ImageIcon(frontFileName);
        this.backImage = new ImageIcon(backFileName);
        this.setIcon(this.frontImage);
        this.setSize(this.frontImage.getIconWidth(), this.frontImage.getIconHeight());
        this.frontShowing = 1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    Card(String frontFileName, String backFileName, int xPos, int yPos) {
        this(frontFileName, backFileName);
        this.setLocation(xPos, yPos);
    }

    Card(String frontFileName, String backFileName, short xPos, short yPos) {
        this(frontFileName, backFileName);
        this.setLocation(xPos, yPos);
    }

    public String getCardName() {
        return this.cardName;
    }

    public CardTable getContext() {
        return this.table;
    }

    public CardAgent2 getAgent() {
        return this.agent;
    }

    public boolean isFrontShowing() {
        return this.frontShowing == 1;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isShiftDown()) {
            this.table.movePileContaining(this, e.getX(), e.getY());
        } else {
            this.table.moveCard(this, e);
            this.setStacked(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isControlDown()) {
            this.turnOver();
        }
        this.table.findPiles();
        this.agent.cardIndicated(this);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.table.findPiles();
    }

    public boolean overlaps(Card otherCard) {
        return this.getBounds().intersects(otherCard.getBounds());
    }

    public void setCardName(String newName) {
        this.cardName = newName;
    }

    public void setContext(CardTable tabl) {
        this.table = tabl;
    }

    public void setAgent(CardAgent2 agnt) {
        this.agent = agnt;
    }

    public void setStacked(boolean value) {
        this.stacked = value;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.isSelected() && this.getModel().isPressed()) {
            this.setSelected(true);
        }
    }

    public void turnDown() {
        this.frontShowing = 0;
        this.setIcon(this.backImage);
    }

    public void turnOver() {
        this.frontShowing = 1 - this.frontShowing;
        if (this.frontShowing == 1) {
            this.setIcon(this.frontImage);
        } else {
            this.setIcon(this.backImage);
        }
    }

    public void turnUp() {
        this.frontShowing = 1;
        this.setIcon(this.frontImage);
    }
}

