/*
 * Decompiled with CFR 0.152.
 */
import asd.ASDDecider;
import asd.ASDGrammar;
import asd.ASDParser;
import asd.ASDPhraseNode;
import java.awt.Point;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CardAgent2 {
    private CardTable table = null;
    private PlayingCardDeck deck = null;
    private ASDParser parser = null;
    private Cardgram2Semantics semantics = null;
    private CardAgent2Effectors effectors = null;
    private ASDDecider decider = null;
    private JTextField utteranceField = null;
    private JTextArea outputPane = null;
    private String command = null;
    private String aggregation = "null";
    private String direction = "null";
    private String orientation = "null";
    private String where = "null";
    private HashMap what = null;
    private String structureType = "null";
    private String number = "null";
    private String quantity = "null";
    private String which = "null";
    private String inclusivity = "null";
    private String actualWhich = "quantified";
    private String referentType = "null";
    private ArrayList<PlayingCard> referentCards = null;
    private ArrayList<CardPile> referentPiles = null;
    private boolean commandNeedsMoreThanOneCard = false;
    private boolean newCardIndicated = false;
    private boolean cardIsInAPile = false;
    private boolean newPointIndicated = false;
    private boolean lastIncludedAllCardsExplicitly = true;
    private Point lastPointIndicated = null;
    private boolean sentenceUsedExplicitDeictic = false;
    private boolean cardsMoved = false;
    private boolean eachUsed = false;
    private String lastTypeReferredTo = "null";
    private final String EXPECTED_REFERENT_TYPES = "A1 A2 A3A5 A4A6 D1 D2 D3D4 D5 E1 Q1Q2 Q3Q4 Q5 Q6";
    private ArrayList<PlayingCard> cardsIndicated = null;
    private ArrayList<CardPile> pilesIndicated = null;
    private ArrayList<PlayingCard> lastCardsAttendedTo = null;
    private ArrayList<CardPile> lastPilesAttendedTo = null;

    public CardAgent2(CardTable t) throws URISyntaxException {
        this.table = t;
        this.semantics = new Cardgram2Semantics();
        this.parser = new ASDParser(this.semantics);
        this.parser.setSaveUniquelyParsedSubphrases(false);
        this.semantics.setParser(this.parser);
        this.parser.useGrammar("Cardgram2.grm");
        this.effectors = new CardAgent2Effectors(this, this.table);
    }

    public void setOutputPane(JTextArea out) {
        this.outputPane = out;
    }

    public void setUtteranceField(JTextField field) {
        this.utteranceField = field;
    }

    public void initialize() {
        this.table.clear();
        this.deck = new PlayingCardDeck(2, "png");
        this.deck.setAgent(this);
        this.deck.setCardTable(this.table);
        this.deck.setHomePosition(20, 40);
        this.deck.stackUp();
        this.referentPiles = this.table.getPiles();
    }

    private void echoInput(String input) {
        if (this.outputPane != null) {
            this.outputPane.append("You: " + input + "\n");
        }
    }

    private void outputMessage(String m) {
        if (this.outputPane != null) {
            this.outputPane.append("CardWorld: " + m + "\n");
        }
    }

    public void cardIndicated(Card givenCard) {
        if (!this.newCardIndicated) {
            this.cardsIndicated = new ArrayList(1);
            this.lastCardsAttendedTo = new ArrayList(1);
            this.pilesIndicated = new ArrayList(1);
            this.lastPilesAttendedTo = new ArrayList(1);
            this.newCardIndicated = true;
        }
        if (!this.cardsIndicated.contains(givenCard)) {
            this.cardsIndicated.add((PlayingCard)givenCard);
            this.lastCardsAttendedTo.add((PlayingCard)givenCard);
        }
    }

    public void cardsMoved(boolean value) {
        this.cardsMoved = value;
    }

    public void pointIndicated(Point mousePoint) {
        this.newPointIndicated = true;
        this.lastPointIndicated = mousePoint;
    }

    public ArrayList<PlayingCard> listCardsInPile(CardPile givenPile) {
        ArrayList<PlayingCard> cardList = new ArrayList<PlayingCard>(13);
        if (givenPile == null) {
            return cardList;
        }
        Iterator<Card> it = givenPile.getIterator();
        while (it.hasNext()) {
            PlayingCard nextCard = (PlayingCard)it.next();
            cardList.add(nextCard);
        }
        return cardList;
    }

    public ArrayList<PlayingCard> listCardsInPiles(ArrayList<CardPile> givenPiles) {
        ArrayList<PlayingCard> cardList = new ArrayList<PlayingCard>(13);
        if (givenPiles == null) {
            return cardList;
        }
        for (CardPile nextPile : givenPiles) {
            Iterator<Card> cardIterator = nextPile.getIterator();
            while (cardIterator.hasNext()) {
                PlayingCard nextCard = (PlayingCard)cardIterator.next();
                if (cardList.contains(nextCard)) continue;
                cardList.add(nextCard);
            }
        }
        return cardList;
    }

    public ArrayList<CardPile> listPilesContainingCards(ArrayList<PlayingCard> givenCards) {
        ArrayList<CardPile> pilesList = new ArrayList<CardPile>(1);
        if (givenCards == null) {
            return pilesList;
        }
        this.table.findPiles();
        for (PlayingCard nextCard : givenCards) {
            CardPile whatPile = this.table.whichPileHas(nextCard);
            if (pilesList.contains(whatPile)) continue;
            pilesList.add(whatPile);
        }
        return pilesList;
    }

    public ArrayList<PlayingCard> listCardsConsistentWithIdea(ArrayList<PlayingCard> givenCards, AbstractPlayingCardIdea idea) {
        if (givenCards == null) {
            return new ArrayList<PlayingCard>(1);
        }
        ArrayList<PlayingCard> cardList = new ArrayList<PlayingCard>(givenCards.size());
        for (PlayingCard nextCard : givenCards) {
            if (idea != null && !idea.isConsistentWith(nextCard)) continue;
            cardList.add(nextCard);
        }
        return cardList;
    }

    public CardPile findOnlyMultiCardPileAmong(ArrayList<CardPile> givenPiles) {
        CardPile result = null;
        boolean found = false;
        for (CardPile nextPile : givenPiles) {
            if (nextPile == null || nextPile.size() <= 1) continue;
            if (found) {
                return null;
            }
            result = nextPile;
            found = true;
        }
        return result;
    }

    public void interpretCommand(String givenCommand) throws URISyntaxException {
        if (this.newCardIndicated && this.cardsIndicated != null && this.cardsIndicated.size() > 0) {
            this.pilesIndicated = this.listPilesContainingCards(this.cardsIndicated);
            this.lastPilesAttendedTo = this.listPilesContainingCards(this.cardsIndicated);
        }
        ArrayList<String> expected = new ArrayList<String>(1);
        expected.add("SENTENCE");
        this.outputPane.setText(null);
        this.echoInput(givenCommand);
        String command = givenCommand.trim().toLowerCase();
        while (command.length() > 0 && !Character.isLetter(command.charAt(command.length() - 1)) && !Character.isDigit(command.charAt(command.length() - 1))) {
            command = command.substring(0, command.length() - 1);
        }
        if (command.length() == 0) {
            return;
        }
        ASDGrammar lexicon = this.parser.lexicon();
        String[] words = command.split("\\s");
        Pattern p = Pattern.compile("[0-9]+");
        boolean unknownWord = false;
        for (int n = 0; n < words.length; ++n) {
            Matcher m = p.matcher(words[n]);
            if (m.matches() || lexicon.lookupWord(words[n]) != null) continue;
            this.outputMessage("Unknown word \"" + words[n] + "\"");
            unknownWord = true;
        }
        if (unknownWord) {
            return;
        }
        this.sentenceUsedExplicitDeictic = false;
        this.parser.initialize(command, expected);
        boolean commandUnderstood = false;
        while (!commandUnderstood && this.parser.parse()) {
            Object nodeValue = this.parser.phraseStructure().nextNode().value();
            ArrayList clauseValues = null;
            if (nodeValue instanceof ArrayList) {
                clauseValues = (ArrayList)nodeValue;
            } else {
                System.err.println("CardAgent2 146: Semantic value of command is not an ArrayList<HashMap> as expected.");
                commandUnderstood = false;
            }
            commandUnderstood = this.interpretClauses(clauseValues);
        }
        this.newCardIndicated = false;
        this.newPointIndicated = false;
        if (this.actualWhich.equals("deictic") && !this.aggregation.equals("each")) {
            this.eachUsed = false;
        }
        if (!this.sentenceUsedExplicitDeictic) {
            this.lastPointIndicated = null;
        }
        if (commandUnderstood) {
            this.outputMessage("OK");
        } else {
            this.outputMessage("Command not understood.");
        }
        this.utteranceField.setText("");
    }

    private boolean interpretClauses(ArrayList clauses) throws URISyntaxException {
        for (Object nextClauseSemantics : clauses) {
            if (nextClauseSemantics instanceof HashMap && this.interpretClause((HashMap)nextClauseSemantics)) continue;
            return false;
        }
        return true;
    }

    private boolean interpretClause(HashMap clauseFeatures) throws URISyntaxException {
        if (!this.findReferents(clauseFeatures)) {
            return false;
        }
        if (this.commandNeedsMoreThanOneCard) {
            if (!this.interpretMultiCardCommand()) {
                return false;
            }
        } else if (this.command.equals("turn")) {
            if (!this.interpretTurnCommand()) {
                return false;
            }
        } else if (this.command.equals("put")) {
            if (!this.interpretPutCommand()) {
                return false;
            }
        } else {
            this.outputMessage("Unexpected type of command.");
            return false;
        }
        this.lastTypeReferredTo = this.referentType;
        if (this.eachUsed && this.number.equals("plural")) {
            this.eachUsed = false;
        }
        if (this.referentCards != null) {
            this.lastCardsAttendedTo = this.referentCards;
        } else if (this.lastPilesAttendedTo != null && this.lastPilesAttendedTo.size() > 0) {
            this.lastCardsAttendedTo = this.listCardsInPiles(this.lastPilesAttendedTo);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean interpretMultiCardCommand() {
        block35: {
            Iterator<CardPile> it;
            block38: {
                block36: {
                    block37: {
                        if (!this.referentType.equals("null") && !this.referentType.equals("pile")) break block36;
                        if (!this.aggregation.equals("null") && !this.aggregation.equals("each")) break block37;
                        if (this.aggregation.equals("each") && this.referentPiles.size() == 1) {
                            this.outputMessage("I assume you mean all of the piles.");
                            this.referentPiles = this.table.getPiles();
                            if (this.referentPiles.size() == 1) {
                                this.outputMessage("There is only one pile.");
                            }
                        }
                        this.lastPilesAttendedTo = new ArrayList(4);
                        if (this.referentPiles.size() == 1) {
                            CardPile pile = this.referentPiles.get(0);
                            if (this.commandNeedsMoreThanOneCard && pile.size() == 1) {
                                this.outputMessage("Warning: That pile has only one card.");
                            }
                        }
                        it = this.referentPiles.iterator();
                        break block38;
                    }
                    if (!this.aggregation.equals("together")) break block35;
                    Point pointIndicated = this.lastPointIndicated;
                    PlayingCard oneCardInResultPile = (PlayingCard)this.referentPiles.get(0).getCard(0);
                    if (this.referentType.equals("pile") && this.referentPiles.size() == 1) {
                        this.outputMessage("That's only one pile.");
                    }
                    this.lastPilesAttendedTo = new ArrayList(4);
                    if (this.where.equals("null") || this.lastPointIndicated == null) {
                        pointIndicated = this.referentPiles.get(0).getHomePosition();
                    }
                    for (CardPile pile : this.referentPiles) {
                        this.effectors.turnEachCardInPile(pile, this.orientation);
                        this.effectors.stackUpPileAt(pile, pointIndicated);
                    }
                    this.lastPointIndicated = pointIndicated;
                    this.table.findPiles();
                    CardPile newPile = this.table.whichPileHasCard(oneCardInResultPile);
                    if (newPile == null) {
                        System.err.println("CardAgent2 565: No result pile was found.");
                        return false;
                    }
                    if (this.command.equals("shuffle")) {
                        this.effectors.shufflePile(newPile);
                    }
                    if (this.command.equals("spread")) {
                        this.lastPilesAttendedTo.add(this.effectors.spreadOutPileAt(newPile, this.lastPointIndicated));
                        break block35;
                    } else {
                        this.effectors.stackUpPileAt(newPile, this.lastPointIndicated);
                        this.lastPilesAttendedTo.add(newPile);
                    }
                    break block35;
                }
                if (!this.referentType.equals("card")) return true;
                CardPile relevantPile = null;
                PlayingCard oneCardInResultPile = null;
                Point pointIndicated = null;
                if (this.referentCards == null || this.referentCards.size() == 0) {
                    this.referentCards = this.lastCardsAttendedTo;
                }
                if (this.referentCards == null || this.referentCards.size() == 0) {
                    if (this.referentPiles.size() != 1) {
                        this.outputMessage("I don't know which cards you mean.");
                        return false;
                    }
                    relevantPile = this.referentPiles.get(0);
                    pointIndicated = relevantPile.getHomePosition();
                    oneCardInResultPile = (PlayingCard)relevantPile.getCard(0);
                } else {
                    if (this.referentCards.size() <= 1) {
                        this.outputMessage("I don't know how to " + this.command + " single cards, only two or more.");
                        return false;
                    }
                    relevantPile = new CardPile(this.referentCards.size());
                    oneCardInResultPile = this.referentCards.get(0);
                    Iterator<PlayingCard> it2 = this.referentCards.iterator();
                    while (it2.hasNext()) {
                        relevantPile.addCard(it2.next());
                    }
                    relevantPile.setCardTable(this.table);
                    pointIndicated = new Point(oneCardInResultPile.getX(), oneCardInResultPile.getY());
                    relevantPile.setHomePosition(pointIndicated);
                }
                this.effectors.turnEachCardInPile(relevantPile, this.orientation);
                if (!this.where.equals("null") && this.lastPointIndicated != null) {
                    pointIndicated = this.lastPointIndicated;
                } else if (this.lastPointIndicated == null) {
                    this.lastPointIndicated = pointIndicated;
                }
                if (this.command.equals("shuffle")) {
                    if (pointIndicated != null) {
                        this.effectors.stackUpPileAt(relevantPile, pointIndicated);
                    } else {
                        this.effectors.stackUpPileAt(relevantPile, this.deck.getHomePosition());
                        relevantPile.setHomePosition(this.deck.getHomePosition());
                    }
                    this.effectors.shufflePile(relevantPile);
                    this.referentCards = this.listCardsInPile(relevantPile);
                } else if (this.command.equals("spread")) {
                    this.effectors.spreadOutPileAt(relevantPile, pointIndicated);
                } else if (this.command.equals("stack")) {
                    this.effectors.stackUpPileAt(relevantPile, pointIndicated);
                } else if (this.command.equals("shuffle") && this.aggregation.equals("together")) {
                    this.effectors.stackUpPileAt(relevantPile, pointIndicated);
                }
                this.table.findPiles();
                this.lastPilesAttendedTo = new ArrayList(1);
                this.lastPilesAttendedTo.add(this.table.whichPileHas(oneCardInResultPile));
                this.lastCardsAttendedTo = this.listCardsInPiles(this.lastPilesAttendedTo);
                return true;
            }
            while (it.hasNext()) {
                CardPile pile = it.next();
                if (this.orientation != "null") {
                    this.effectors.turnEachCardInPile(pile, this.orientation);
                }
                if (this.command.equals("spread")) {
                    if (this.where.equals("null") || this.lastPointIndicated == null) {
                        this.lastPilesAttendedTo.add(this.effectors.spreadOutPile(pile));
                        continue;
                    }
                    this.lastPilesAttendedTo.add(this.effectors.spreadOutPileAt(pile, this.lastPointIndicated));
                    continue;
                }
                if (this.command.equals("shuffle")) {
                    this.lastPilesAttendedTo.add(this.effectors.shufflePile(pile));
                    continue;
                }
                if (!this.command.equals("stack")) continue;
                if (this.where.equals("null") || this.lastPointIndicated == null) {
                    this.lastPilesAttendedTo.add(this.effectors.stackUpPile(pile));
                    continue;
                }
                this.lastPilesAttendedTo.add(this.effectors.stackUpPileAt(pile, this.lastPointIndicated));
            }
        }
        this.lastCardsAttendedTo = this.listCardsInPiles(this.lastPilesAttendedTo);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean interpretPutCommand() {
        if (this.referentType.equals("null") || this.referentType.equals("pile")) {
            if (this.aggregation.equals("null") || this.aggregation.equals("each")) {
                if (this.aggregation.equals("each") && this.referentPiles.size() == 1) {
                    this.outputMessage("I assume you mean all of the piles.");
                    this.referentPiles = this.table.getPiles();
                    if (this.referentPiles.size() == 1) {
                        this.outputMessage("There is only one pile.");
                    }
                }
                this.lastPilesAttendedTo = new ArrayList(4);
                for (CardPile pile : this.referentPiles) {
                    if (this.orientation != "null") {
                        this.effectors.turnEachCardInPile(pile, this.orientation);
                    }
                    if (!this.where.equals("null") && this.lastPointIndicated != null) {
                        this.lastPilesAttendedTo.add(this.effectors.stackUpPileAt(pile, this.lastPointIndicated));
                        continue;
                    }
                    this.outputMessage("I don't know where to put them.");
                    return false;
                }
            } else if (this.aggregation.equals("together")) {
                Point pointIndicated = this.lastPointIndicated;
                if (this.referentType.equals("pile") && this.referentPiles.size() == 1) {
                    this.outputMessage("That's only one pile.");
                }
                CardPile firstPile = this.referentPiles.get(0);
                Card firstCard = firstPile.getCard(0);
                this.lastPilesAttendedTo = new ArrayList(4);
                if (!this.where.equals("null") && this.lastPointIndicated == null) {
                    this.outputMessage("I don't know where to put them.");
                    return false;
                }
                if (this.where.equals("null")) {
                    pointIndicated = firstPile.getHomePosition();
                }
                for (CardPile pile : this.referentPiles) {
                    if (firstPile == null) {
                        firstPile = pile;
                    }
                    this.effectors.turnEachCardInPile(pile, this.orientation);
                    this.effectors.stackUpPileAt(pile, pointIndicated);
                }
                this.table.findPiles();
                CardPile newPile = null;
                if (pointIndicated != null) {
                    newPile = this.table.whichPileHasCard(firstCard);
                }
                if (newPile == null) {
                    System.err.println("CardAgent2 728: No pile was found at the point indicated.");
                    return false;
                }
                this.effectors.stackUpPileAt(newPile, pointIndicated);
                this.lastPilesAttendedTo.add(newPile);
                this.lastPointIndicated = pointIndicated;
            }
            this.lastCardsAttendedTo = this.listCardsInPiles(this.lastPilesAttendedTo);
            return true;
        }
        if (!this.referentType.equals("card")) return true;
        CardPile relevantPile = null;
        PlayingCard oneCardInResultPile = null;
        Point pointIndicated = this.lastPointIndicated;
        if (this.referentCards == null || this.referentCards.size() == 0) {
            this.referentCards = this.lastCardsAttendedTo;
        }
        if (this.referentCards == null || this.referentCards.size() == 0) {
            if (this.referentPiles.size() != 1) {
                this.outputMessage("I don't know which cards you mean.");
                return false;
            }
            relevantPile = this.referentPiles.get(0);
            oneCardInResultPile = (PlayingCard)relevantPile.getCard(0);
        } else {
            oneCardInResultPile = this.referentCards.get(0);
            if (this.lastPointIndicated != null) {
                pointIndicated = this.lastPointIndicated;
            } else {
                if (!this.aggregation.equals("together")) {
                    this.outputMessage("I don't know where you want to put them.");
                    return false;
                }
                this.lastPointIndicated = pointIndicated = new Point(oneCardInResultPile.getX(), oneCardInResultPile.getY());
            }
            relevantPile = new CardPile(this.referentCards.size());
            Iterator<PlayingCard> it = this.referentCards.iterator();
            while (it.hasNext()) {
                relevantPile.addCard(it.next());
            }
            relevantPile.setCardTable(this.table);
            relevantPile.setHomePosition(pointIndicated);
        }
        if (this.orientation != null && !this.orientation.equals("null")) {
            this.effectors.turnEachCardInPile(relevantPile, this.orientation);
        }
        this.effectors.stackUpPileAt(relevantPile, pointIndicated);
        this.table.findPiles();
        this.lastPilesAttendedTo = new ArrayList(1);
        this.lastPilesAttendedTo.add(this.table.whichPileHas(oneCardInResultPile));
        this.lastCardsAttendedTo = this.listCardsInPiles(this.lastPilesAttendedTo);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean interpretTurnCommand() {
        Iterator<CardPile> it;
        block31: {
            Iterator<PlayingCard> it2;
            PlayingCard c;
            block30: {
                if (this.direction.equals("null")) {
                    this.direction = this.orientation.equals("null") ? "over" : this.orientation;
                } else if (!(this.direction.equals("down") || this.direction.equals("over") || this.direction.equals("up"))) {
                    return false;
                }
                if (this.referentType.equals("null")) {
                    this.outputMessage("I don't know whether you want to turn the entire pile or just that one card.");
                    return false;
                }
                if (this.referentType.equals("card")) {
                    if (this.number.equals("singular") && this.quantity.equals("one")) {
                        if (this.referentCards.size() == 1) {
                            PlayingCard c2 = this.referentCards.get(0);
                            if (!this.where.equals("null") && this.lastPointIndicated != null) {
                                this.effectors.turnCard(c2, this.direction, this.lastPointIndicated);
                                return true;
                            }
                            this.effectors.turnCard(c2, this.direction);
                            return true;
                        }
                        if (this.referentCards.size() == 0 && this.referentPiles.size() == 1) {
                            CardPile p = this.referentPiles.get(0);
                            this.effectors.turnEachCardInPile(p, this.direction);
                            return true;
                        }
                        this.outputMessage("I'm not sure which of those cards you want to turn.");
                        return false;
                    }
                    if (!this.number.equals("plural")) {
                        if (!this.quantity.equals("several")) return true;
                    }
                    if (this.referentCards != null && this.referentCards.size() > 0) {
                        c = null;
                        it2 = this.referentCards.iterator();
                        break block30;
                    } else {
                        if (this.referentPiles == null) return true;
                        Iterator<CardPile> it3 = this.referentPiles.iterator();
                        while (true) {
                            if (!it3.hasNext()) {
                                this.lastPilesAttendedTo = this.referentPiles;
                                return true;
                            }
                            CardPile p = it3.next();
                            this.effectors.turnEachCardInPile(p, this.direction);
                        }
                    }
                }
                if (!this.referentType.equals("pile")) return true;
                if (!this.aggregation.equals("together")) {
                    if (this.referentPiles == null) {
                        this.outputMessage("I don't know which pile(s) you want me to turn.");
                        return false;
                    }
                    this.lastPilesAttendedTo = new ArrayList(4);
                    it = this.referentPiles.iterator();
                    break block31;
                } else {
                    if (this.referentPiles.size() == 1) {
                        this.outputMessage("That's only one pile.");
                    }
                    this.lastPilesAttendedTo = new ArrayList(4);
                    if (this.where.equals("null")) {
                        this.lastPointIndicated = this.referentPiles.get(0).getHomePosition();
                    } else if (this.lastPointIndicated == null) {
                        this.outputMessage("I don't know where you mean.");
                        return false;
                    }
                    for (CardPile pile : this.referentPiles) {
                        this.effectors.turnPile(pile, this.direction);
                        this.effectors.stackUpPileAt(pile, this.lastPointIndicated);
                    }
                    CardPile newPile = this.table.getPileAt(this.lastPointIndicated);
                    if (newPile != null) {
                        this.lastPilesAttendedTo.add(newPile);
                        return true;
                    }
                    System.err.println("CardAgent2 620: No pile was found at the point indicated.");
                    return false;
                }
            }
            while (it2.hasNext()) {
                c = it2.next();
                if (!this.where.equals("null") && this.lastPointIndicated != null) {
                    this.effectors.turnCard(c, this.direction, this.lastPointIndicated);
                    continue;
                }
                this.effectors.turnCard(c, this.direction);
            }
            this.lastPilesAttendedTo = null;
            boolean samePile = false;
            CardPile p = null;
            it2 = this.referentCards.iterator();
            if (it2.hasNext()) {
                c = it2.next();
                p = this.table.whichPileHasCard(c);
                samePile = true;
            }
            while (samePile && it2.hasNext()) {
                c = it2.next();
                if (p == this.table.whichPileHasCard(c)) continue;
                samePile = false;
            }
            if (!samePile) return true;
            this.lastPilesAttendedTo = new ArrayList(1);
            this.lastPilesAttendedTo.add(p);
            return true;
        }
        while (it.hasNext()) {
            CardPile pile = it.next();
            ArrayList<CardPile> newPiles = this.effectors.turnPile(pile, this.direction);
            CardPile newPile = newPiles.get(0);
            if (!this.where.equals("null") && this.lastPointIndicated != null) {
                this.effectors.stackUpPileAt(newPile, this.lastPointIndicated);
                continue;
            }
            this.lastPilesAttendedTo.add(newPile);
        }
        if (this.where.equals("null")) return true;
        if (this.lastPointIndicated == null) return true;
        this.table.findPiles();
        CardPile newPile = this.table.getPileAt(this.lastPointIndicated);
        if (newPile != null) {
            this.effectors.stackUpPileAt(newPile, this.lastPointIndicated);
            this.lastPilesAttendedTo.add(newPile);
            return true;
        }
        System.err.println("CardAgent2 583: No pile was found at the point indicated.");
        return false;
    }

    private boolean findReferents(HashMap clauseFeatures) throws URISyntaxException {
        this.command = (String)clauseFeatures.get("command");
        if (this.command == null) {
            return false;
        }
        this.direction = (String)clauseFeatures.get("direction");
        if (this.direction == null) {
            this.direction = "null";
        }
        this.orientation = (String)clauseFeatures.get("orientation");
        if (this.orientation == null) {
            this.orientation = "null";
        }
        this.where = (String)clauseFeatures.get("where");
        if (this.where == null) {
            this.where = "null";
        } else {
            if (this.where.equals("here")) {
                if (!this.newPointIndicated && !this.newCardIndicated) {
                    this.outputMessage("I don't know where you are referring to.");
                    return false;
                }
                if (!this.newPointIndicated && this.lastCardsAttendedTo != null && this.lastCardsAttendedTo.size() == 1) {
                    this.lastPointIndicated = this.lastCardsAttendedTo.get(0).getLocation();
                }
            } else if (this.lastPointIndicated == null) {
                if (this.lastCardsAttendedTo != null && this.lastCardsAttendedTo.size() > 0) {
                    this.lastPointIndicated = this.lastCardsAttendedTo.get(0).getLocation();
                } else if (this.lastPilesAttendedTo != null && this.lastPilesAttendedTo.size() == 1) {
                    CardPile lastPile = this.lastPilesAttendedTo.get(0);
                    this.lastPointIndicated = lastPile.getHomePosition();
                }
            }
            this.sentenceUsedExplicitDeictic = true;
        }
        this.what = (HashMap)clauseFeatures.get("what");
        AbstractPlayingCardIdea cardIdea = (AbstractPlayingCardIdea)this.what.get("abstractPlayingCardIdea");
        if (cardIdea != null) {
            System.out.println("\nAbstractPlayingCardIdea = " + cardIdea.getColorName() + " " + cardIdea.getRankName() + " " + cardIdea.getSuitName() + " " + cardIdea.getStandingName());
        }
        this.structureType = (String)this.what.get("structureType");
        if (this.structureType == null) {
            this.structureType = "null";
        }
        this.aggregation = (String)clauseFeatures.get("aggregation");
        String nounPhraseAggregation = (String)this.what.get("aggregation");
        if (this.aggregation == null) {
            this.aggregation = nounPhraseAggregation;
        }
        if (this.aggregation == null) {
            this.aggregation = "null";
        }
        this.number = (String)this.what.get("number");
        this.quantity = (String)this.what.get("quantity");
        this.which = (String)this.what.get("which");
        if (this.which == null) {
            this.which = "null";
        }
        this.inclusivity = (String)this.what.get("inclusivity");
        if (this.inclusivity == null) {
            this.inclusivity = "null";
        }
        this.actualWhich = "quantified";
        if (this.eachUsed && (!this.structureType.equals("null") && !this.lastTypeReferredTo.equals("null") && !this.structureType.equals(this.lastTypeReferredTo) || this.aggregation.equals("together") || this.which.equals("deictic") && this.newCardIndicated)) {
            this.eachUsed = false;
        }
        this.eachUsed = this.eachUsed || this.aggregation.equals("each") && this.number.equals("singular");
        this.referentType = this.structureType;
        if (this.referentType.equals("null")) {
            this.referentType = this.lastTypeReferredTo;
        }
        this.referentCards = null;
        this.referentPiles = null;
        this.commandNeedsMoreThanOneCard = this.command.equals("shuffle") || this.command.equals("spread") || this.command.equals("stack");
        this.referentCards = new ArrayList(13);
        this.referentPiles = new ArrayList(4);
        this.decider = new ASDDecider();
        this.decider.useNetwork("CardDecisionNet2.grm");
        StringBuilder decBuilder = new StringBuilder(150);
        decBuilder.append("command:" + this.command);
        decBuilder.append(" structureType:" + this.structureType);
        decBuilder.append(" lastType:" + this.lastTypeReferredTo);
        decBuilder.append(" number:" + this.number);
        decBuilder.append(" eachUsed:" + this.eachUsed);
        decBuilder.append(" needs2orMore:" + this.commandNeedsMoreThanOneCard);
        decBuilder.append(" which:");
        if (this.which.equals("null")) {
            decBuilder.append("quantified");
        } else {
            decBuilder.append(this.which);
        }
        decBuilder.append(" newCardIndicated:" + this.newCardIndicated);
        decBuilder.append(" lastCardAttendedTo:");
        if (this.lastCardsAttendedTo == null) {
            decBuilder.append("null");
        } else {
            decBuilder.append("notNull");
        }
        decBuilder.append(" lastPilesAttendedTo:");
        if (this.lastPilesAttendedTo == null) {
            decBuilder.append("0");
        } else {
            int s = this.lastPilesAttendedTo.size();
            if (s < 2) {
                decBuilder.append("" + s);
            } else {
                decBuilder.append("2orMore");
            }
        }
        CardPile p = this.table.findOnlyMultiCardPile();
        decBuilder.append(" onlyOneMultiCardPile:" + (p != null));
        System.out.println("\n" + String.valueOf(decBuilder));
        String[] structureTypes = "A1 A2 A3A5 A4A6 D1 D2 D3D4 D5 E1 Q1Q2 Q3Q4 Q5 Q6".split("\\s");
        ArrayList<String> expectedReferentTypes = new ArrayList<String>(structureTypes.length);
        for (int j = 0; j < structureTypes.length; ++j) {
            expectedReferentTypes.add(structureTypes[j]);
        }
        this.decider.initialize(decBuilder.toString(), expectedReferentTypes);
        boolean searchResult = this.decider.parse();
        if (!searchResult) {
            this.outputMessage("I don't know what you are referring to.");
            return false;
        }
        ASDPhraseNode structure = this.decider.decisionStructure();
        String referentDecision = structure.nextNode().word();
        System.out.println("Decision network search result = " + referentDecision);
        if (referentDecision.equals("A1")) {
            this.referentType = "card";
            if ((cardIdea == null || cardIdea.isConsistentWithAnyAbstractCard()) && this.lastCardsAttendedTo.size() > 1) {
                this.outputMessage("I don't know which card you are referring to.");
                return false;
            }
            this.referentCards = this.listCardsConsistentWithIdea(this.lastCardsAttendedTo, cardIdea);
            if (this.referentCards.size() > 1) {
                this.outputMessage("I don't know which of those cards you are referring to.");
                this.referentCards = null;
                return false;
            }
            if (this.referentCards.size() == 0) {
                ArrayList<PlayingCard> candidateCards = this.listCardsInPiles(this.lastPilesAttendedTo);
                this.referentCards = this.listCardsConsistentWithIdea(candidateCards, cardIdea);
                if (this.referentCards.size() != 1) {
                    this.outputMessage("I don't know which of those cards you are referring to.");
                    this.referentCards = null;
                    return false;
                }
            }
            this.actualWhich = "anaphoric";
            this.lastCardsAttendedTo = this.referentCards;
            this.lastIncludedAllCardsExplicitly = false;
            return true;
        }
        if (referentDecision.equals("A2")) {
            if (!this.structureType.equals("card") && this.lastPilesAttendedTo != null && this.lastPilesAttendedTo.size() == 1) {
                this.referentType = "pile";
                CardPile ref = null;
                ref = this.lastPilesAttendedTo.get(0);
                this.referentPiles.add(ref);
                this.actualWhich = "anaphoric";
                this.lastIncludedAllCardsExplicitly = false;
                this.actualWhich = "anaphoric";
                return true;
            }
            if (this.lastCardsAttendedTo != null && this.lastCardsAttendedTo.size() > 0) {
                this.referentPiles = this.listPilesContainingCards(this.lastCardsAttendedTo);
                if (this.referentPiles.size() == 1) {
                    this.referentType = "pile";
                    this.actualWhich = "anaphoric";
                    return true;
                }
                this.outputMessage("I don't know which pile you are referring to.");
                return false;
            }
        } else {
            if (referentDecision.equals("A3A5")) {
                if (this.lastCardsAttendedTo != null && this.lastCardsAttendedTo.size() > 0) {
                    if (this.lastCardsAttendedTo.size() == 1) {
                        CardPile pp = this.table.whichPileHasCard(this.lastCardsAttendedTo.get(0));
                        if (this.number.equals("plural") && pp.size() == 1) {
                            this.outputMessage("I don't know which cards you are referring to.");
                            return false;
                        }
                        this.referentPiles = new ArrayList(1);
                        this.referentPiles.add(pp);
                        this.referentCards = this.listCardsConsistentWithIdea(this.listCardsInPiles(this.referentPiles), cardIdea);
                        if (this.referentCards.size() == 0) {
                            this.outputMessage("I don't know which you are referring to.");
                            return false;
                        }
                        this.referentType = "card";
                        this.actualWhich = "anaphoric";
                        return true;
                    }
                    this.referentCards = this.listCardsConsistentWithIdea(this.lastCardsAttendedTo, cardIdea);
                    if (this.referentCards.size() == 0) {
                        this.outputMessage("I don't know which you are referring to.");
                        return false;
                    }
                    this.lastCardsAttendedTo = this.referentCards;
                    this.referentType = "card";
                    this.actualWhich = "anaphoric";
                    return true;
                }
                if (this.lastPilesAttendedTo != null) {
                    this.referentType = "card";
                    this.actualWhich = "anaphoric";
                    ArrayList<PlayingCard> cardList = this.listCardsInPiles(this.lastPilesAttendedTo);
                    this.referentCards = this.listCardsConsistentWithIdea(cardList, cardIdea);
                    if (this.referentCards.size() == 0) {
                        this.outputMessage("I don't know which you are referring to.");
                        return false;
                    }
                    if (this.referentCards.size() == this.table.numberOfCards()) {
                        this.lastIncludedAllCardsExplicitly = true;
                    }
                    return true;
                }
                if (this.lastIncludedAllCardsExplicitly) {
                    this.referentType = "card";
                    this.actualWhich = "anaphoric";
                    ArrayList<PlayingCard> allCards = this.table.getCards();
                    this.referentCards = this.listCardsConsistentWithIdea(allCards, cardIdea);
                    if (this.referentCards.size() == 0) {
                        this.outputMessage("I don't know which you are referring to.");
                        return false;
                    }
                    return true;
                }
                this.outputMessage("I don't know which you are referring to.");
                return false;
            }
            if (referentDecision.equals("A4A6")) {
                if (this.lastPilesAttendedTo == null || this.lastPilesAttendedTo.size() == 0) {
                    this.outputMessage("I don't know what you are referring to.");
                    return false;
                }
                if (this.lastPilesAttendedTo.size() > 1) {
                    this.actualWhich = "anaphoric";
                    this.referentPiles = this.lastPilesAttendedTo;
                    this.lastIncludedAllCardsExplicitly = false;
                } else {
                    this.outputMessage("I assume you're referring to all the piles.");
                    this.referentPiles = this.table.getPiles();
                    this.lastPilesAttendedTo = this.referentPiles;
                    this.actualWhich = "quantified";
                }
                this.referentType = "pile";
                return true;
            }
            if (referentDecision.equals("D1")) {
                this.referentType = "card";
                if ((cardIdea == null || cardIdea.isConsistentWithAnyAbstractCard()) && this.cardsIndicated.size() > 1) {
                    this.outputMessage("I don't know which card you are referring to.");
                    return false;
                }
                this.referentCards = this.listCardsConsistentWithIdea(this.cardsIndicated, cardIdea);
                if (this.referentCards.size() > 1) {
                    this.outputMessage("I don't know which of those cards you are referring to.");
                    this.referentCards = null;
                    return false;
                }
                if (this.referentCards.size() == 0) {
                    ArrayList<PlayingCard> candidateCards = this.listCardsInPiles(this.pilesIndicated);
                    this.referentCards = this.listCardsConsistentWithIdea(candidateCards, cardIdea);
                    if (this.referentCards.size() == 0) {
                        this.outputMessage("I don't know which card you are referring to.");
                        this.referentCards = null;
                        return false;
                    }
                    if (this.referentCards.size() > 1) {
                        this.outputMessage("I don't know which of those cards you are referring to.");
                        this.referentCards = null;
                        return false;
                    }
                }
                this.lastCardsAttendedTo = this.referentCards;
                this.cardsIndicated.remove(this.cardsIndicated.get(0));
                if (this.cardsIndicated.size() == 0) {
                    this.newCardIndicated = false;
                }
                this.actualWhich = "deictic";
                this.lastIncludedAllCardsExplicitly = false;
                return true;
            }
            if (referentDecision.equals("D2")) {
                this.referentPiles = this.listPilesContainingCards(this.cardsIndicated);
                if (this.referentPiles.size() == 0) {
                    this.outputMessage("I don't know which pile you are referring to.");
                    return false;
                }
                if (this.referentPiles.size() > 1) {
                    CardPile onlyPile = this.findOnlyMultiCardPileAmong(this.referentPiles);
                    if (onlyPile == null) {
                        this.outputMessage("I don't know which of those piles you are referring to.");
                        return false;
                    }
                    this.referentPiles = new ArrayList(1);
                    this.referentPiles.add(onlyPile);
                }
                this.actualWhich = "deictic";
                this.referentType = "pile";
                this.lastIncludedAllCardsExplicitly = false;
                this.lastCardsAttendedTo = this.cardsIndicated;
                this.cardsIndicated = new ArrayList(1);
                this.newCardIndicated = false;
                this.lastPilesAttendedTo = this.referentPiles;
                return true;
            }
            if (referentDecision.equals("D3D4")) {
                if (this.cardsIndicated.size() == 1) {
                    this.referentType = "card";
                    CardPile currentPile = this.table.whichPileHasCard(this.cardsIndicated.get(0));
                    this.referentPiles = new ArrayList(1);
                    this.referentPiles.add(currentPile);
                    this.lastPilesAttendedTo = this.referentPiles;
                    ArrayList<PlayingCard> candidateCards = this.listCardsInPiles(this.referentPiles);
                    this.referentCards = this.listCardsConsistentWithIdea(candidateCards, cardIdea);
                    if (this.referentCards.size() == 0) {
                        this.outputMessage("I don't know which cards you are referring to.");
                        return false;
                    }
                    this.lastCardsAttendedTo = this.referentCards;
                    this.newCardIndicated = false;
                    this.cardsIndicated = new ArrayList(1);
                    this.actualWhich = "deictic";
                    this.lastIncludedAllCardsExplicitly = false;
                    return true;
                }
                if (this.cardsIndicated.size() > 1) {
                    this.referentType = "card";
                    this.actualWhich = "deictic";
                    this.lastIncludedAllCardsExplicitly = false;
                    this.referentCards = cardIdea == null || cardIdea.isConsistentWithAnyAbstractCard() ? this.cardsIndicated : this.listCardsConsistentWithIdea(this.cardsIndicated, cardIdea);
                }
                if (this.referentCards.size() == 0) {
                    this.outputMessage("I don't know which card(s) you are referring to.");
                    return false;
                }
                this.lastCardsAttendedTo = this.cardsIndicated;
                this.newCardIndicated = false;
                this.cardsIndicated = new ArrayList(1);
                return true;
            }
            if (referentDecision.equals("D5")) {
                this.referentPiles = this.listPilesContainingCards(this.cardsIndicated);
                if (this.referentPiles.size() > 1) {
                    this.actualWhich = "deictic";
                    this.referentType = "pile";
                    this.lastIncludedAllCardsExplicitly = false;
                    this.lastCardsAttendedTo = this.cardsIndicated;
                    this.newCardIndicated = false;
                    this.cardsIndicated = new ArrayList(1);
                    return true;
                }
                if (this.referentPiles.size() == 1) {
                    this.outputMessage("You only pointed to one pile; I'll assume you want them all.");
                    this.actualWhich = "quantified";
                    this.actualWhich = "deictic";
                    this.referentType = "pile";
                    this.table.findPiles();
                    this.referentPiles = this.table.getPiles();
                    this.lastIncludedAllCardsExplicitly = false;
                    this.lastCardsAttendedTo = this.table.getCards();
                    this.newCardIndicated = false;
                    this.cardsIndicated = new ArrayList(1);
                    return true;
                }
            } else {
                if (referentDecision.equals("Q1Q2")) {
                    this.referentType = "card";
                    this.actualWhich = "quantified";
                    if (cardIdea == null || cardIdea.isConsistentWithAnyAbstractCard()) {
                        this.lastIncludedAllCardsExplicitly = true;
                    }
                    ArrayList<PlayingCard> allCards = this.table.getCards();
                    this.referentCards = this.listCardsConsistentWithIdea(allCards, cardIdea);
                    if (this.referentCards.size() == 0) {
                        this.outputMessage("I don't know which cards you are referring to.");
                        return false;
                    }
                    return true;
                }
                if (referentDecision.equals("Q3Q4")) {
                    this.referentType = "pile";
                    this.actualWhich = "quantified";
                    this.referentPiles = this.table.getPiles();
                    if (this.referentPiles.size() > 1) {
                        this.referentType = "pile";
                        this.lastIncludedAllCardsExplicitly = false;
                    } else {
                        this.lastIncludedAllCardsExplicitly = this.number.equals("plural");
                    }
                    return true;
                }
                if (referentDecision.equals("Q5")) {
                    this.referentType = "card";
                    this.actualWhich = "quantified";
                    if (cardIdea == null || cardIdea.isConsistentWithAnyAbstractCard()) {
                        PlayingCard cd = null;
                        cd = this.lastCardsAttendedTo != null && this.lastCardsAttendedTo.size() == 1 ? this.lastCardsAttendedTo.get(0) : this.table.findOnlySingletonCard();
                        if (cd == null) {
                            this.outputMessage("I don't know which card you are referring to.");
                            return false;
                        }
                        this.referentCards = new ArrayList(1);
                        this.referentCards.add(cd);
                        this.lastCardsAttendedTo = new ArrayList(1);
                        this.lastCardsAttendedTo.add(cd);
                        this.lastIncludedAllCardsExplicitly = false;
                        return true;
                    }
                    if (cardIdea.isFullySpecified()) {
                        ArrayList<PlayingCard> allCards = this.table.getCards();
                        this.referentCards = this.listCardsConsistentWithIdea(allCards, cardIdea);
                        if (this.referentCards.size() != 1) {
                            this.outputMessage("I don't know which of those cards you are referring to.");
                            return false;
                        }
                        return true;
                    }
                    this.referentCards = this.listCardsConsistentWithIdea(this.lastCardsAttendedTo, cardIdea);
                    if (this.referentCards.size() != 1) {
                        this.outputMessage("I don't know which of those cards you are referring to.");
                        this.referentCards = null;
                        return false;
                    }
                    this.actualWhich = "anaphoric";
                    this.lastIncludedAllCardsExplicitly = false;
                    return true;
                }
                if (referentDecision.equals("Q6")) {
                    this.referentType = "pile";
                    this.actualWhich = "quantified";
                    this.referentPiles = new ArrayList(1);
                    this.referentPiles.add(this.table.findOnlyMultiCardPile());
                    this.lastPilesAttendedTo = this.referentPiles;
                    this.lastIncludedAllCardsExplicitly = false;
                    return true;
                }
                if (referentDecision.equals("E1")) {
                    this.outputMessage("I don't know how to " + this.command + " individual cards.");
                    return false;
                }
                this.outputMessage("I don't know what you are referring to.");
                return false;
            }
        }
        return true;
    }
}

