/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;

public class CardAgent2Effectors {
    private CardAgent2 agent = null;
    private CardTable table = null;

    CardAgent2Effectors(CardAgent2 a, CardTable t) {
        this.agent = a;
        this.table = t;
    }

    public void addCard(Card c, int xPos, int yPos) {
        this.table.addCard(c, xPos, yPos);
        c.repaint();
    }

    public void movePileContaining(Card givenCard, int deltaX, int deltaY) {
        CardPile pile = this.table.whichPileHasCard(givenCard);
        if (pile == null) {
            return;
        }
        Iterator<Card> it = pile.getIterator();
        while (it.hasNext()) {
            Card c = it.next();
            int newX = c.getX() + deltaX;
            int newY = c.getY() + deltaY;
            CardTable table = c.getContext();
            table.removeCard(c);
            table.addCard(c, newX, newY);
            c.setLocation(newX, newY);
        }
        this.agent.cardsMoved(true);
    }

    public CardPile shufflePile(CardPile p) {
        p.shuffle();
        return p;
    }

    public ArrayList<CardPile> spreadOutAllPiles() {
        ArrayList<CardPile> allPiles = this.table.getPiles();
        Iterator<CardPile> it = allPiles.iterator();
        while (it.hasNext()) {
            it.next().spreadOut(0.2);
        }
        return allPiles;
    }

    public CardPile spreadOutPile(CardPile pile) {
        Point home = pile.getHomePosition();
        return this.spreadOutPileAt(pile, home);
    }

    public CardPile spreadOutPileAt(CardPile pile, Point p) {
        if (pile != null) {
            pile.spreadOutAt(0.2, p);
        }
        return pile;
    }

    public CardPile spreadOutPileContaining(Card c) {
        return this.spreadOutPile(this.table.whichPileHasCard(c));
    }

    public CardPile spreadOutPileContainingAt(Card c, Point p) {
        return this.spreadOutPileAt(this.table.whichPileHasCard(c), p);
    }

    public ArrayList<CardPile> stackUpAllPiles() {
        ArrayList<CardPile> allPiles = this.table.getPiles();
        Iterator<CardPile> it = allPiles.iterator();
        while (it.hasNext()) {
            it.next().stackUp();
        }
        return allPiles;
    }

    public CardPile stackUpPile(CardPile pile) {
        Point home = pile.getHomePosition();
        return this.stackUpPileAt(pile, home);
    }

    public CardPile stackUpPileAt(CardPile pile, Point p) {
        if (pile != null) {
            pile.stackUpAt(p);
        }
        return pile;
    }

    public CardPile stackUpPileContaining(Card c) {
        return this.stackUpPile(this.table.whichPileHasCard(c));
    }

    public CardPile stackUpPileContainingAt(Card c, Point p) {
        return this.stackUpPileAt(this.table.whichPileHasCard(c), p);
    }

    public void turnCard(Card card, String direction) {
        if (direction == null) {
            card.turnOver();
        } else if (direction.equals("down")) {
            card.turnDown();
        } else if (direction.equals("over")) {
            card.turnOver();
        } else if (direction.equals("up")) {
            card.turnUp();
        }
    }

    public void turnCard(Card card, String direction, Point p) {
        if (p != null) {
            this.turnCard(card, direction);
            this.table.moveCard(card, p);
        }
    }

    public void turnEachCardInPile(CardPile pile, String direction) {
        if (direction == null) {
            return;
        }
        if (direction.equals("down")) {
            pile.turnDownEach();
        } else if (direction.equals("up")) {
            pile.turnUpEach();
        } else if (direction.equals("over")) {
            pile.turnOverEach();
        }
    }

    public ArrayList<CardPile> turnPile(CardPile pile, String direction) {
        ArrayList<CardPile> result = new ArrayList<CardPile>(1);
        if (direction == null) {
            pile.turnOver();
            result.add(pile);
        } else if (direction.equals("down")) {
            result = this.turnDownEachInPile(pile);
        } else if (direction.equals("up")) {
            result = this.turnUpEachInPile(pile);
        } else if (direction.equals("over")) {
            pile.turnOver();
            result.add(pile);
        }
        return result;
    }

    public ArrayList<CardPile> turnDownEachInPile(CardPile pile) {
        ArrayList<CardPile> result = new ArrayList<CardPile>(1);
        if (pile != null) {
            pile.turnDownEach();
            result.add(pile);
        }
        return result;
    }

    public ArrayList<CardPile> turnDownEachInPileContaining(Card c) {
        return this.turnDownEachInPile(this.table.whichPileHasCard(c));
    }

    public ArrayList<CardPile> turnOverEachInPile(CardPile pile) {
        ArrayList<CardPile> result = new ArrayList<CardPile>(1);
        if (pile != null) {
            pile.turnOverEach();
            result.add(pile);
        }
        return result;
    }

    public ArrayList<CardPile> turnOverEachInPileContaining(Card c) {
        return this.turnOverEachInPile(this.table.whichPileHasCard(c));
    }

    public ArrayList<CardPile> turnOverPile(CardPile pile) {
        ArrayList<CardPile> result = new ArrayList<CardPile>(1);
        if (pile != null) {
            pile.turnOver();
            result.add(pile);
        }
        return result;
    }

    public ArrayList<CardPile> turnOverPileContaining(Card c) {
        return this.turnOverPile(this.table.whichPileHasCard(c));
    }

    public ArrayList<CardPile> turnUpEachInPile(CardPile pile) {
        ArrayList<CardPile> result = new ArrayList<CardPile>(1);
        if (pile != null) {
            pile.turnUpEach();
            result.add(pile);
        }
        return result;
    }

    public ArrayList<CardPile> turnUpEachInPileContaining(Card c) {
        return this.turnUpEachInPile(this.table.whichPileHasCard(c));
    }
}

