/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

public class CardGroup {
    ArrayList<Card> cardsInGroup = null;
    private String groupName = null;
    private CardAgent2 groupAgent = null;

    CardGroup() {
        this.cardsInGroup = new ArrayList(13);
    }

    CardGroup(int capacity) {
        this.cardsInGroup = new ArrayList(capacity);
    }

    CardGroup(Collection<Card> givenCards) {
        this.cardsInGroup = new ArrayList<Card>(givenCards);
    }

    CardGroup(Collection<Card> givenCards, String givenName) {
        this(givenCards);
        this.groupName = givenName;
    }

    public void addCard(Card newCard) {
        if (!this.cardsInGroup.contains(newCard)) {
            this.cardsInGroup.add(newCard);
        }
    }

    public void addCard(int position, Card newCard) {
        if (!this.cardsInGroup.contains(newCard)) {
            this.cardsInGroup.add(position, newCard);
        }
    }

    public boolean containsCard(Card givenCard) {
        return this.cardsInGroup.contains(givenCard);
    }

    public Card getCard(int j) {
        if (j >= 0 && j < this.cardsInGroup.size()) {
            return this.cardsInGroup.get(j);
        }
        return null;
    }

    public Iterator<Card> getIterator() {
        return this.cardsInGroup.iterator();
    }

    public String getName() {
        return this.groupName;
    }

    public CardAgent2 getAgent() {
        return this.groupAgent;
    }

    public boolean removeCard(Card givenCard) {
        if (this.cardsInGroup.contains(givenCard)) {
            this.cardsInGroup.remove(givenCard);
            return true;
        }
        return false;
    }

    public void setCard(int j, Card newValue) {
        if (j >= 0 && j < this.cardsInGroup.size()) {
            this.cardsInGroup.set(j, newValue);
        }
    }

    public void setName(String newName) {
        this.groupName = newName;
    }

    public void setAgent(CardAgent2 newAgent) {
        this.groupAgent = newAgent;
    }

    public int size() {
        return this.cardsInGroup.size();
    }

    public void shuffle() {
        int nCards;
        Random generator = new Random();
        int n = nCards = this.size();
        Card selectedCard = null;
        while (n > 1) {
            int positionSelected = generator.nextInt(n);
            if (positionSelected >= --n) continue;
            selectedCard = this.cardsInGroup.get(positionSelected);
            this.cardsInGroup.set(positionSelected, this.cardsInGroup.get(n));
            this.cardsInGroup.set(n, selectedCard);
        }
    }
}

