/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;

public class CardPile
extends CardGroup {
    private CardTable table = null;
    private Point pileHome = null;
    private final double pixelOffset = 0.2;

    CardPile() {
    }

    CardPile(Point p) {
        this.setHomePosition(p);
    }

    CardPile(int capacity) {
        super(capacity);
    }

    CardPile(int capacity, Point p) {
        super(capacity);
        this.setHomePosition(p);
    }

    public CardTable getCardTable() {
        return this.table;
    }

    public Point getHomePosition() {
        return this.pileHome;
    }

    public boolean isStacked() {
        boolean pileIsStacked = true;
        Iterator it = this.cardsInGroup.iterator();
        while (pileIsStacked && it.hasNext()) {
            pileIsStacked = pileIsStacked && ((Card)it.next()).isStacked();
        }
        return pileIsStacked;
    }

    public ArrayList<CardPile> partition() {
        if (this.table == null) {
            return null;
        }
        if (this.size() == 0) {
            return new ArrayList<CardPile>(0);
        }
        ArrayList<Rectangle> cardBounds = new ArrayList<Rectangle>(this.size());
        Iterator<Card> it = super.getIterator();
        while (it.hasNext()) {
            Card thisCard = it.next();
            cardBounds.add(thisCard.getBounds());
        }
        int[] leaderPosition = new int[this.size()];
        for (int p = 0; p < this.size(); ++p) {
            leaderPosition[p] = -1;
        }
        for (int curr = 1; curr < this.size(); ++curr) {
            Rectangle current = (Rectangle)cardBounds.get(curr);
            boolean firstOverlap = true;
            for (int prev = curr - 1; prev >= 0; --prev) {
                Rectangle previous = (Rectangle)cardBounds.get(prev);
                if (!current.intersects(previous)) continue;
                int leader = prev;
                while (leaderPosition[leader] != -1) {
                    leader = leaderPosition[leader];
                }
                if (firstOverlap) {
                    leaderPosition[leader] = curr;
                    firstOverlap = false;
                    continue;
                }
                if (leader == curr) continue;
                leaderPosition[leader] = curr;
            }
        }
        CardPile[] newCardPile = new CardPile[this.size()];
        int numberOfPiles = 0;
        for (int p = this.size() - 1; p >= 0; --p) {
            Card thisCard = this.getCard(p);
            if (leaderPosition[p] == -1) {
                newCardPile[p] = new CardPile();
                newCardPile[p].setCardTable(this.getCardTable());
                newCardPile[p].addCard(thisCard);
                ++numberOfPiles;
                continue;
            }
            newCardPile[p] = null;
            int leader = leaderPosition[p];
            while (leaderPosition[leader] != -1) {
                leader = leaderPosition[leader];
            }
            newCardPile[leader].addCard(0, thisCard);
        }
        ArrayList<CardPile> result = new ArrayList<CardPile>(numberOfPiles);
        for (int p = 0; p < this.size(); ++p) {
            if (newCardPile[p] == null) continue;
            CardPile pile = newCardPile[p];
            result.add(pile);
            pile.setHomePosition(pile.getCard(0).getLocation());
        }
        return result;
    }

    public void setCardTable(CardTable newTable) {
        this.table = newTable;
    }

    public void setHomePosition(Point newPosition) {
        this.pileHome = newPosition;
    }

    public void setHomePosition(int newX, int newY) {
        this.pileHome = new Point(newX, newY);
    }

    @Override
    public void shuffle() {
        super.shuffle();
        Iterator<Card> it = super.getIterator();
        while (it.hasNext()) {
            Card thisCard = it.next();
            if (thisCard.getContext() != this.table) continue;
            this.table.removeCard(thisCard);
            this.table.addCard(thisCard, thisCard.getX(), thisCard.getY());
        }
    }

    public boolean spreadOut(double relativeWidth) {
        Card thisCard;
        if (this.table == null || this.size() == 0) {
            return false;
        }
        if (this.pileHome == null) {
            this.setHomePosition(this.getCard(this.size() - 1).getLocation());
        }
        int deltaX = (int)(relativeWidth * (double)this.getCard(0).getWidth() + 0.5);
        int xPos = (int)this.pileHome.getX();
        int yPos = (int)this.pileHome.getY();
        Iterator<Card> it = super.getIterator();
        while (it.hasNext()) {
            thisCard = it.next();
            if (thisCard.getContext() == this.table) {
                this.table.removeCard(thisCard);
            }
            thisCard.setStacked(false);
        }
        it = super.getIterator();
        while (it.hasNext()) {
            thisCard = it.next();
            this.table.addCard(thisCard, xPos, yPos);
            xPos += deltaX;
        }
        return true;
    }

    public boolean spreadOutAt(double relativeWidth, Point newHome) {
        Point oldHome = this.pileHome;
        this.pileHome = newHome;
        if (this.spreadOut(relativeWidth)) {
            return true;
        }
        this.pileHome = oldHome;
        return false;
    }

    public boolean stackUp() {
        if (this.table == null || this.size() == 0) {
            return false;
        }
        if (this.pileHome == null) {
            this.setHomePosition(this.getCard(0).getLocation());
        }
        double xPos = this.pileHome.getX();
        double yPos = this.pileHome.getY();
        Iterator<Card> it = super.getIterator();
        while (it.hasNext()) {
            Card thisCard = it.next();
            if (thisCard.getContext() == this.table) {
                this.table.removeCard(thisCard);
            }
            thisCard.setStacked(true);
        }
        double offset = 0.0;
        it = super.getIterator();
        while (it.hasNext()) {
            this.table.addCard(it.next(), (int)(xPos - offset), (int)(yPos - offset));
            offset += 0.2;
        }
        this.getCard(this.size() - 1).repaint();
        return true;
    }

    public boolean stackUpAt(Point newHome) {
        Point oldHome = this.pileHome;
        this.pileHome = newHome;
        if (this.stackUp()) {
            return true;
        }
        this.pileHome = oldHome;
        return false;
    }

    public boolean stackUpAt(int x, int y) {
        return this.stackUpAt(new Point(x, y));
    }

    public boolean turnDownEach() {
        if (this.table == null || this.size() == 0) {
            return false;
        }
        Iterator<Card> it = super.getIterator();
        while (it.hasNext()) {
            Card thisCard = it.next();
            thisCard.turnDown();
        }
        return true;
    }

    public void turnOver() {
        if (this.table == null || this.size() == 0) {
            return;
        }
        ArrayList<Card> queue = new ArrayList<Card>(this.size());
        Card c2 = null;
        boolean isStacked = true;
        while (this.size() > 0) {
            c2 = (Card)this.cardsInGroup.remove(this.size() - 1);
            this.table.removeCard(c2);
            queue.add(c2);
            isStacked = isStacked && c2.isStacked();
        }
        for (Card c2 : queue) {
            c2.turnOver();
            this.table.addCard(c2, c2.getX(), c2.getY());
            this.cardsInGroup.add(c2);
        }
        if (isStacked) {
            this.stackUp();
        }
    }

    public boolean turnOverEach() {
        if (this.table == null || this.size() == 0) {
            return false;
        }
        Iterator<Card> it = super.getIterator();
        while (it.hasNext()) {
            Card thisCard = it.next();
            thisCard.turnOver();
        }
        return true;
    }

    public boolean turnUpEach() {
        if (this.table == null || this.size() == 0) {
            return false;
        }
        Iterator<Card> it = super.getIterator();
        while (it.hasNext()) {
            Card thisCard = it.next();
            thisCard.turnUp();
        }
        return true;
    }
}

