/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

class CardTable
extends JPanel
implements MouseListener {
    private CardAgent2 agent;
    private CardWorldFrame2 window = null;
    private ArrayList<Card> displayedCards;
    private ArrayList<CardPile> currentPiles = null;
    Color backgroundColor = Color.green;

    public CardTable() {
        this.setBackground(this.backgroundColor);
        this.setLayout(null);
        this.setDoubleBuffered(false);
        this.displayedCards = new ArrayList();
        this.addMouseListener(this);
    }

    public void addCard(Card card, int x, int y) {
        card.setAgent(this.agent);
        this.add((Component)card, 0);
        card.setContext(this);
        card.setLocation(x, y);
        this.displayedCards.add(card);
        this.agent.cardsMoved(true);
        card.repaint();
    }

    void clear() {
        this.removeAll();
        this.repaint();
        this.displayedCards = new ArrayList();
        this.revalidate();
        this.repaint();
    }

    public CardPile findOnlyMultiCardPile() {
        this.findPiles();
        CardPile lastMultiCardPile = null;
        int n = 0;
        for (CardPile pile : this.currentPiles) {
            if (pile.size() <= 1) continue;
            ++n;
            lastMultiCardPile = pile;
        }
        if (n == 1) {
            return lastMultiCardPile;
        }
        return null;
    }

    public PlayingCard findOnlySingletonCard() {
        this.findPiles();
        CardGroup lastSingletonCardPile = null;
        int n = 0;
        for (CardPile pile : this.currentPiles) {
            if (pile.size() != 1) continue;
            ++n;
            lastSingletonCardPile = pile;
        }
        if (n == 1) {
            return (PlayingCard)lastSingletonCardPile.getCard(0);
        }
        return null;
    }

    public void findPiles() {
        CardPile allCards = new CardPile(this.displayedCards.size());
        allCards.setCardTable(this);
        for (PlayingCard playingCard : this.displayedCards) {
            allCards.addCard(playingCard);
        }
        this.currentPiles = allCards.partition();
    }

    public PlayingCard getTopCardAt(Point position) {
        Component comp = this.getComponentAt(position);
        if (comp instanceof PlayingCard) {
            return (PlayingCard)comp;
        }
        return null;
    }

    public ArrayList<PlayingCard> getCards() {
        if (this.displayedCards == null) {
            return null;
        }
        ArrayList<PlayingCard> result = new ArrayList<PlayingCard>(this.displayedCards.size());
        for (int pos = 0; pos < this.displayedCards.size(); ++pos) {
            result.add((PlayingCard)this.displayedCards.get(pos));
        }
        return result;
    }

    public CardPile getPileAt(Point position) {
        PlayingCard c = this.getTopCardAt(position);
        if (c == null) {
            return null;
        }
        return this.whichPileHasCard(c);
    }

    public ArrayList<CardPile> getPiles() {
        if (this.currentPiles == null) {
            return null;
        }
        ArrayList<CardPile> result = new ArrayList<CardPile>(this.currentPiles.size());
        for (int pos = 0; pos < this.currentPiles.size(); ++pos) {
            result.add(this.currentPiles.get(pos));
        }
        return result;
    }

    public CardAgent2 getAgent() {
        return this.agent;
    }

    boolean isDisplaying(PlayingCard card) {
        return this.displayedCards.contains(card);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public boolean isCardInAMultiCardPile(PlayingCard card) {
        return this.whichPileHasCard(card).size() > 1;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.agent.pointIndicated(e.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void moveCard(Card c, MouseEvent e) {
        int newX = c.getX() + e.getX();
        int newY = c.getY() + e.getY();
        this.removeCard(c);
        this.addCard(c, newX, newY);
        c.setLocation(newX, newY);
    }

    public void moveCard(Card c, Point p) {
        int newX = (int)p.getX();
        int newY = (int)p.getY();
        this.removeCard(c);
        this.addCard(c, newX, newY);
        c.setLocation(newX, newY);
    }

    public void movePileContaining(Card givenCard, int deltaX, int deltaY) {
        CardPile pile = this.whichPileHas((PlayingCard)givenCard);
        if (pile == null) {
            return;
        }
        Iterator<Card> it = pile.getIterator();
        while (it.hasNext()) {
            Card c = it.next();
            int newX = c.getX() + deltaX;
            int newY = c.getY() + deltaY;
            this.removeCard(c);
            this.addCard(c, newX, newY);
            c.setLocation(newX, newY);
        }
        this.agent.cardsMoved(true);
    }

    public int numberOfCards() {
        return this.displayedCards.size();
    }

    public int numberOfPiles() {
        return this.numberOfPiles(true);
    }

    public int numberOfPiles(boolean findBeforeCount) {
        if (findBeforeCount) {
            this.findPiles();
        }
        return this.currentPiles.size();
    }

    public void removeCard(Card card) {
        if (card == null) {
            return;
        }
        this.remove(card);
        this.displayedCards.remove(card);
        card.setContext(null);
        this.agent.cardsMoved(true);
        this.repaint();
    }

    public void setAgent(CardAgent2 a) {
        this.agent = a;
    }

    void setWindow(CardWorldFrame2 win) {
        this.window = win;
    }

    void toggleBackgroundColor() {
        this.backgroundColor = this.backgroundColor == Color.green ? Color.white : Color.green;
        this.setBackground(this.backgroundColor);
    }

    public CardPile whichPileHasCard(Card card) {
        this.findPiles();
        return this.whichPileHas(card);
    }

    public CardPile whichPileHas(Card card) {
        if (this.currentPiles == null || this.currentPiles.size() == 0) {
            return null;
        }
        for (CardPile pile : this.currentPiles) {
            if (!pile.containsCard(card)) continue;
            return pile;
        }
        return null;
    }
}

