/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class CardWorldFrame2
extends JFrame {
    static String VERSION = "2.0";
    private CardAgent2 agent;
    private CardTable cardTable;
    private JTextArea outputPane;
    private JTextField utteranceField;
    static final int DEFAULT_FRAME_WIDTH = 800;
    static final int DEFAULT_FRAME_HEIGHT = 600;
    static final int DEFAULT_PANEL_HEIGHT = 400;
    static final Font FONT = new Font("Monospaced", 1, 14);
    private JPanel pane;
    private JScrollPane panelScrollPane;
    private JScrollPane bottomScrollPane;

    public CardWorldFrame2(CardAgent2 agnt, CardTable t) {
        this.agent = agnt;
        this.cardTable = t;
        this.setTitle("CardWorld 2025");
        this.addWindowListener(new WindowCloser(this, this));
        this.setDefaultCloseOperation(2);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        WindowMenu windowMenu = new WindowMenu(this);
        windowMenu.setMnemonic(87);
        menuBar.add(windowMenu);
        HelpMenu hMenu = new HelpMenu(this);
        hMenu.setMnemonic(72);
        menuBar.add(hMenu);
        this.cardTable.setWindow(this);
        this.setSize(800, 600);
        this.cardTable.setMinimumSize(new Dimension(800, 400));
        this.panelScrollPane = new JScrollPane(this.cardTable);
        this.panelScrollPane.setPreferredSize(new Dimension(800, 400));
        this.pane = new JPanel(new BorderLayout());
        this.pane.setLayout(new BoxLayout(this.pane, 1));
        this.pane.add((Component)this.panelScrollPane, "Center");
        this.utteranceField = new JTextField(40);
        this.utteranceField.setFont(FONT);
        this.utteranceField.setSize(800, 10);
        this.utteranceField.addActionListener(new UtteranceFieldListener(this, this));
        this.pane.add(new LabeledTextField("Input? ", this.utteranceField));
        this.outputPane = new JTextArea();
        this.outputPane.setFont(FONT);
        this.bottomScrollPane = new JScrollPane(this.outputPane);
        this.bottomScrollPane.setPreferredSize(new Dimension(800, 20));
        this.pane.add(this.bottomScrollPane);
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        contentPane.add(this.pane);
        this.setVisible(true);
    }

    void close() {
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    JTextArea getOutputPane() {
        return this.outputPane;
    }

    JTextField getUtteranceField() {
        return this.utteranceField;
    }

    private void utteranceFieldChanged() throws URISyntaxException {
        String command = this.utteranceField.getText();
        this.agent.interpretCommand(command);
    }

    void showAboutInfo() throws FileNotFoundException, IOException {
        CardWorldAboutWindow w = new CardWorldAboutWindow("CardWorld2Documentation.txt");
    }

    class WindowCloser
    extends WindowAdapter {
        CardWorldFrame2 window;

        WindowCloser(CardWorldFrame2 this$0, CardWorldFrame2 w) {
            this.window = w;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.window.setVisible(false);
            this.window.dispose();
            System.exit(0);
        }
    }

    private class UtteranceFieldListener
    implements ActionListener {
        private CardWorldFrame2 window;

        UtteranceFieldListener(CardWorldFrame2 cardWorldFrame2, CardWorldFrame2 w) {
            this.window = w;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.window.utteranceFieldChanged();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private class LabeledTextField
    extends JPanel {
        LabeledTextField(String labelText, JTextField textField) {
            this.setMaximumSize(new Dimension(800, 10));
            this.setLayout(new BoxLayout(this, 0));
            JLabel label = new JLabel(labelText);
            textField.setFont(FONT);
            this.add(label);
            this.add(textField);
        }
    }
}

