/*
 * Decompiled with CFR 0.152.
 */
package semanticvalues;

import semanticvalues.ModifierSemantics;
import semanticvalues.SemanticValue;

public class ModifiableSemantics
extends SemanticValue {
    public boolean isModifiable = true;
    protected ModifierSemantics modifiers = null;

    @Override
    public Object clone() {
        ModifiableSemantics result = (ModifiableSemantics)super.clone();
        if (this.modifiers != null) {
            result.modifiers = (ModifierSemantics)this.modifiers.clone();
        }
        return result;
    }

    @Override
    public SemanticValue modifyBy(String modifierName, SemanticValue modifierValue) {
        if (modifierName == null) {
            return null;
        }
        SemanticValue result = super.modifyBy(modifierName, modifierValue);
        if (result != null) {
            return result;
        }
        if (!this.isModifiable) {
            return null;
        }
        return this.modifyBy(new ModifierSemantics(modifierName, modifierValue));
    }

    public SemanticValue modifyBy(ModifierSemantics mod) {
        if (mod == null) {
            return this;
        }
        ModifiableSemantics result = (ModifiableSemantics)this.clone();
        ModifierSemantics mods = (ModifierSemantics)mod.clone();
        mods.otherModifiers = this.modifiers;
        result.modifiers = mods;
        return result;
    }

    public ModifierSemantics firstModifier() {
        return this.modifiers;
    }

    protected ModifierSemantics getModifierNamed(String name) {
        if (name == null || this.modifiers == null) {
            return null;
        }
        return this.modifiers.getModifierNamed(name);
    }

    public ModifierSemantics getOtherModifiers() {
        if (this.modifiers == null) {
            return null;
        }
        ModifierSemantics other = this.modifiers.otherModifiers;
        return other;
    }

    public SemanticValue getValueOfModifierNamed(String name) {
        ModifierSemantics modifier = this.getModifierNamed(name);
        if (modifier == null) {
            return null;
        }
        return modifier.getValue();
    }

    public void removeModifierNamed(String name) {
        if (name == null || this.modifiers == null) {
            return;
        }
        if (this.modifiers.modifierName.equals(name)) {
            this.modifiers = this.modifiers.otherModifiers;
            return;
        }
        this.modifiers.removeOtherModifierNamed(name);
    }

    public boolean setValueOfModifierNamed(String name, SemanticValue newValue) {
        ModifierSemantics modifier = this.getModifierNamed(name);
        if (modifier == null) {
            return false;
        }
        modifier.setValue(newValue);
        return true;
    }

    public void setModifiers(ModifierSemantics newValue) {
        this.modifiers = newValue;
    }
}

