/*
 * Decompiled with CFR 0.152.
 */
package semanticvalues;

import semanticvalues.SemanticValue;

public class ModifierSemantics
extends SemanticValue {
    String modifierName;
    SemanticValue modifierValue;
    ModifierSemantics otherModifiers = null;

    public ModifierSemantics(String givenName, SemanticValue newMod) {
        this.modifierName = givenName;
        this.modifierValue = newMod;
        this.otherModifiers = null;
    }

    protected ModifierSemantics(String givenName, SemanticValue newMod, ModifierSemantics others) {
        this.modifierName = givenName;
        this.modifierValue = newMod;
        this.otherModifiers = others;
    }

    @Override
    public Object clone() {
        ModifierSemantics newOtherModifiers = null;
        if (this.otherModifiers != null) {
            newOtherModifiers = (ModifierSemantics)this.otherModifiers.clone();
        }
        return new ModifierSemantics(this.modifierName, (SemanticValue)this.modifierValue.clone(), newOtherModifiers);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ModifierSemantics otherMod = (ModifierSemantics)other;
        if (!this.modifierName.equals(otherMod.modifierName)) {
            return false;
        }
        if (!this.modifierValue.equals(otherMod.modifierValue)) {
            return false;
        }
        if (this.otherModifiers == null) {
            return otherMod.otherModifiers == null;
        }
        return this.otherModifiers.equals(otherMod.otherModifiers);
    }

    public ModifierSemantics getModifierNamed(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals(this.modifierName)) {
            return this;
        }
        if (this.otherModifiers == null) {
            return null;
        }
        return this.otherModifiers.getModifierNamed(name);
    }

    public void removeOtherModifierNamed(String name) {
        if (name == null || this.otherModifiers == null) {
            return;
        }
        if (this.otherModifiers.modifierName.equals(name)) {
            this.otherModifiers = this.otherModifiers.otherModifiers;
            return;
        }
        this.otherModifiers.removeOtherModifierNamed(name);
    }

    public String getName() {
        return this.modifierName;
    }

    public SemanticValue getValue() {
        return this.modifierValue;
    }

    public void setValue(SemanticValue newValue) {
        this.modifierValue = newValue;
    }
}

