/*
 * Decompiled with CFR 0.152.
 */
package semanticvalues;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class SemanticValue
implements Cloneable {
    public Object clone() {
        try {
            Object result = super.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Class<?> thisClass = this.getClass();
        if (thisClass != other.getClass()) {
            return false;
        }
        Class<?> semanticValueClass = null;
        try {
            semanticValueClass = Class.forName("semanticvalues.SemanticValue");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        AccessibleObject currentField = null;
        for (Class<?> currentClass = thisClass; currentClass != null && currentClass != semanticValueClass; currentClass = currentClass.getSuperclass()) {
            AccessibleObject[] fields = currentClass.getDeclaredFields();
            if (fields == null) continue;
            AccessibleObject.setAccessible(fields, true);
            for (int j = 0; j < fields.length; ++j) {
                currentField = fields[j];
                if (Modifier.isStatic(((Field)currentField).getModifiers())) continue;
                try {
                    if (!(((Field)currentField).get(this) == null ? ((Field)currentField).get(other) != null : !((Field)currentField).get(this).equals(((Field)currentField).get(other)))) continue;
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    public SemanticValue modifyBy(SemanticValue modifier) {
        Class<?> thisClass = this.getClass();
        AccessibleObject currentField = null;
        Class<?> modifierClass = modifier.getClass();
        Class<?> semanticValueClass = null;
        try {
            semanticValueClass = Class.forName("semanticvalues.SemanticValue");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        boolean fieldFound = false;
        Class<?> currentClass = thisClass;
        while (!fieldFound && currentClass != null && currentClass != semanticValueClass) {
            AccessibleObject[] fields = currentClass.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int j = 0; !fieldFound && j < fields.length; ++j) {
                currentField = fields[j];
                if (!((Field)currentField).getType().isAssignableFrom(modifierClass)) continue;
                fieldFound = true;
            }
            if (fieldFound) continue;
            currentClass = currentClass.getSuperclass();
        }
        if (!fieldFound) {
            return null;
        }
        SemanticValue result = (SemanticValue)this.clone();
        try {
            ((Field)currentField).set(result, modifier);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
            result = null;
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
            result = null;
        }
        return result;
    }

    public SemanticValue modifyBy(String memberName, SemanticValue modifier) {
        Class<?> thisClass = this.getClass();
        AccessibleObject currentField = null;
        Class<?> semanticValueClass = null;
        try {
            semanticValueClass = Class.forName("semanticvalues.SemanticValue");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        boolean fieldFound = false;
        Class<?> currentClass = thisClass;
        while (!fieldFound && currentClass != null && currentClass != semanticValueClass) {
            AccessibleObject[] fields = currentClass.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int j = 0; !fieldFound && j < fields.length; ++j) {
                currentField = fields[j];
                if (!((Field)currentField).getName().equals(memberName)) continue;
                fieldFound = true;
            }
            if (fieldFound) continue;
            currentClass = currentClass.getSuperclass();
        }
        if (!fieldFound) {
            return null;
        }
        SemanticValue result = (SemanticValue)this.clone();
        try {
            ((Field)currentField).set(result, modifier);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
            result = null;
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
            result = null;
        }
        return result;
    }

    public SemanticValue simplify() {
        return this;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indentString) {
        Class<?> thisClass = this.getClass();
        AccessibleObject currentField = null;
        Class<?> semanticValueClass = null;
        try {
            semanticValueClass = Class.forName("semanticvalues.SemanticValue");
        }
        catch (ClassNotFoundException e) {
            return "Class SemanticValue not found";
        }
        Object result = thisClass.getName() + ":";
        if (indentString.length() == 0) {
            indentString = "   ";
        }
        for (Class<?> currentClass = thisClass; currentClass != null && currentClass != semanticValueClass; currentClass = currentClass.getSuperclass()) {
            AccessibleObject[] fields = currentClass.getDeclaredFields();
            if (fields == null) continue;
            AccessibleObject.setAccessible(fields, true);
            for (int j = 0; j < fields.length; ++j) {
                currentField = fields[j];
                try {
                    if (((Field)currentField).get(this) == null || Modifier.isStatic(((Field)currentField).getModifiers())) continue;
                    result = (String)result + "\n" + indentString + ((Field)currentField).getName() + " = ";
                    Class<?> currentFieldClass = ((Field)currentField).get(this).getClass();
                    if (semanticValueClass.isAssignableFrom(currentFieldClass)) {
                        result = (String)result + ((SemanticValue)((Field)currentField).get(this)).toString(indentString + "   ");
                        continue;
                    }
                    result = (String)result + String.valueOf(((Field)currentField).get(this)) + ";";
                    continue;
                }
                catch (IllegalAccessException e) {
                    result = e.toString();
                }
            }
        }
        return result;
    }
}

