/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDGrammar;
import asd.ASDGrammarNode;
import asd.ASDGrammarSuccessor;
import asd.ASDInputException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class ASDCheck {
    public static void main(String[] args) throws IOException, ASDInputException, URISyntaxException {
        int wordCount = 0;
        int nodeCount = 0;
        int edgeCount = 0;
        if (args.length == 0) {
            System.out.println("Usage should be: java asd/ASDCheck grammarFileName");
            System.exit(0);
        }
        String fileName = args[0];
        ASDGrammar grammar = new ASDGrammar(fileName, false, true);
        Set<Map.Entry<String, ArrayList<ASDGrammarNode>>> entrySet = grammar.lexicon().entrySet();
        for (Map.Entry<String, ArrayList<ASDGrammarNode>> e : entrySet) {
            ++wordCount;
            ArrayList<ASDGrammarNode> instances = e.getValue();
            if (instances == null || instances.size() == 0) {
                System.out.println("Word \"" + String.valueOf(e.getKey()) + "\" has no instances.");
                continue;
            }
            for (ASDGrammarNode gNode : instances) {
                ++nodeCount;
                if (!gNode.isInitial() && !gNode.hasIncomingEdges()) {
                    System.out.println("Non-initial node (" + String.valueOf(e.getKey()) + " " + gNode.instance() + ") has no incoming edges.");
                }
                if (gNode.isFinal()) continue;
                ArrayList<ASDGrammarSuccessor> successors = gNode.successors();
                if (successors == null || successors.size() == 0) {
                    System.out.println("Non-final node (" + String.valueOf(e.getKey()) + " " + gNode.instance() + ") has no outgoing edges.");
                    continue;
                }
                for (ASDGrammarSuccessor s : successors) {
                    ASDGrammarNode successorNode = grammar.lookupInstance(s);
                    if (successorNode == null) continue;
                    ++edgeCount;
                }
            }
        }
        System.out.println("\nWords & phrase types:   " + wordCount);
        System.out.println("Nodes (instances):      " + nodeCount);
        System.out.println("Valid edges:            " + edgeCount);
    }
}

