/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDDeciderChoice;
import asd.ASDDeciderStack;
import asd.ASDDeciderStackFrame;
import asd.ASDDeciderState;
import asd.ASDGrammar;
import asd.ASDGrammarNode;
import asd.ASDGrammarSuccessor;
import asd.ASDPhraseNode;
import asd.ASDSemantics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;

public class ASDDecider
implements ASDSemantics {
    public String ANYTHING = "ANYTHING";
    public String CLOSEQUOTE = "\"";
    public String DUMMYWORD = ASDGrammar.DUMMYWORD;
    public String NOADVANCE;
    public String NO = this.NOADVANCE = "B";
    public String NUMBER = "NUMBER";
    public String OPENQUOTE = "\"";
    public String QUIT = "Q";
    public String SPACECHARS = " \t\n\r";
    public String SPECIALCHARS = ",.;:?!$@#%&*()[]{}+=<>/~\\";
    public String STRING = "STRING";
    public String SUCCEED = "S";
    public static String UNKNOWN = "UNKNOWN";
    private static final char INITIAL = 'I';
    private static final char FINAL = 'F';
    private static final char DUMMY = 'D';
    private static final char NONDUMMY = 'N';
    private String stringToBeParsed;
    private Stack<ASDDeciderState> backstack;
    private ArrayList<String> expectedTypes;
    private ASDGrammar ASDLexicon;
    private int currentParseStepNumber;
    private ASDDeciderState state;
    private ASDSemantics semantics;
    private Object application;

    public ASDDecider() {
        this.semantics = null;
        this.application = null;
    }

    public ASDDecider(Object app) {
        this.semantics = this;
        this.application = app;
    }

    public ASDDecider(Object app, ASDSemantics semanticsInstance) {
        this.semantics = semanticsInstance;
        this.application = app;
    }

    public ASDPhraseNode currentNode() {
        return this.state.currentNode;
    }

    public ArrayList<String> expectedTypes() {
        return this.expectedTypes;
    }

    public HashMap<String, Object> features() {
        return this.state.features;
    }

    public Object get(String featureName) {
        return this.state.features.get(featureName);
    }

    public ASDGrammar lexicon() {
        return this.ASDLexicon;
    }

    public ASDPhraseNode decisionStructure() {
        return this.state.decisionStructure;
    }

    public int parseStepNumber() {
        return this.currentParseStepNumber;
    }

    public void set(String featureName, Object value) {
        this.state.features.put(featureName, value);
    }

    public Object valueOf(String featureName) {
        return this.state.features.get(featureName);
    }

    public void initialize(String aString, ArrayList<String> expected) {
        this.stringToBeParsed = aString;
        this.backstack = new Stack();
        this.expectedTypes = expected;
        this.currentParseStepNumber = 0;
        this.state = new ASDDeciderState();
        this.state.beginning = 0;
        this.state.features = new HashMap(10);
        this.state.currentChoices = null;
        this.state.decisionStructure = this.segment(aString);
        this.state.decisionValues = this.createDecisionSet(aString);
        this.state.currentNode = this.state.decisionStructure;
        this.state.subphraseStack = new ASDDeciderStack();
        this.state.nextNodeSubphrase = null;
        this.state.advanceCase = (char)32;
    }

    public String advance() {
        if (this.state.currentChoices == null) {
            this.state.currentChoices = this.choices(true, null);
        }
        if (this.state.currentChoices.size() == 0) {
            return this.NOADVANCE;
        }
        ASDDeciderChoice tryChoice = this.state.currentChoices.remove(0);
        this.state.advanceCase = tryChoice.advanceType;
        if (this.state.currentChoices.size() > 0) {
            this.state.nextNodeSubphrase = this.state.currentNode.nextNode() != null ? this.state.currentNode.nextNode().subphrase() : null;
            this.backstack.push((ASDDeciderState)this.state.clone());
        }
        if (this.state.advanceCase == 'F') {
            String val = this.advanceFinal(tryChoice.completedType);
            if (val == this.NOADVANCE || val == this.QUIT) {
                return val;
            }
        } else {
            String resultOfAction;
            if (this.state.advanceCase == 'N') {
                this.advanceNonDummy(tryChoice.nextNode);
            } else if (this.state.advanceCase == 'D') {
                this.advanceDummy(tryChoice.nextNode);
            } else if (this.state.advanceCase == 'I') {
                this.advanceInitial(tryChoice.nextNode);
            }
            String action = tryChoice.nextNode.semanticAction();
            if (this.semantics != null && action != null && action.length() > 0 && ((resultOfAction = this.semantics.semanticAction(action)) == this.NOADVANCE || resultOfAction == this.QUIT)) {
                return resultOfAction;
            }
        }
        ++this.currentParseStepNumber;
        return this.SUCCEED;
    }

    void advanceDummy(ASDGrammarNode tryNode) {
        ASDPhraseNode dummy = new ASDPhraseNode();
        dummy.setWord(this.DUMMYWORD);
        dummy.setInstance(tryNode);
        dummy.setNextNode(this.state.currentNode.nextNode());
        if (this.backstack.empty()) {
            this.state.currentNode.setNextNode(dummy);
        } else {
            ASDPhraseNode temp = (ASDPhraseNode)this.state.decisionStructure.clone();
            this.state.decisionStructure = temp;
            for (ASDPhraseNode oldNode = this.state.decisionStructure; oldNode != this.state.currentNode; oldNode = oldNode.nextNode()) {
                ASDPhraseNode prev = temp;
                temp = (ASDPhraseNode)oldNode.clone();
                prev.setNextNode(temp);
            }
            temp.setNextNode(dummy);
        }
        this.state.currentNode = dummy;
        this.state.currentChoices = null;
    }

    String advanceFinal(String phraseType) {
        ASDPhraseNode oldNode;
        String val = this.state.currentNode.instance().semanticValue();
        Object computedValue = null;
        Object computedString = null;
        computedValue = this.semantics != null && val != null && val.length() > 0 ? this.semantics.semanticValue(val) : val;
        if (computedValue instanceof String && (computedValue == this.NOADVANCE || computedValue == this.QUIT)) {
            return (String)computedValue;
        }
        ASDPhraseNode prev = this.state.decisionStructure;
        for (int j = 1; j < this.state.beginning; ++j) {
            prev = prev.nextNode();
        }
        ASDPhraseNode first = prev.nextNode();
        ASDPhraseNode newNode = new ASDPhraseNode();
        newNode.setWord(phraseType);
        newNode.setValue(computedValue);
        newNode.setNextNode(this.state.currentNode.nextNode());
        ASDPhraseNode temp = (ASDPhraseNode)first.clone();
        newNode.setSubphrase(temp);
        for (oldNode = first; oldNode != this.state.currentNode; oldNode = oldNode.nextNode()) {
            prev = temp;
            temp = (ASDPhraseNode)oldNode.clone();
            prev.setNextNode(temp);
        }
        temp.setNextNode(null);
        temp = (ASDPhraseNode)this.state.decisionStructure.clone();
        oldNode = this.state.decisionStructure;
        this.state.decisionStructure = temp;
        while (oldNode.nextNode() != first) {
            oldNode = oldNode.nextNode();
            prev = temp;
            temp = (ASDPhraseNode)oldNode.clone();
            prev.setNextNode(temp);
        }
        temp.setNextNode(newNode);
        this.state.currentNode = temp;
        ASDDeciderStackFrame popped = (ASDDeciderStackFrame)this.state.subphraseStack.pop();
        this.state.features = popped.features;
        this.state.beginning = popped.beginning;
        this.state.currentChoices = this.done() ? null : this.choices(false, null);
        return this.SUCCEED;
    }

    void advanceInitial(ASDGrammarNode tryNode) {
        this.state.currentNode = this.state.currentNode.nextNode();
        this.state.currentNode.setWord(tryNode.word());
        this.state.currentNode.setInstance(tryNode);
        this.state.subphraseStack.push(new ASDDeciderStackFrame(this.state.beginning, this.state.features));
        this.state.beginning = 0;
        for (ASDPhraseNode node = this.state.decisionStructure; node != this.state.currentNode; node = node.nextNode()) {
            ++this.state.beginning;
        }
        this.state.features = new HashMap(10);
        this.state.currentChoices = null;
    }

    void advanceNonDummy(ASDGrammarNode tryNode) {
        this.state.currentNode = this.state.currentNode.nextNode();
        this.state.currentNode.setWord(tryNode.word());
        this.state.currentNode.setInstance(tryNode);
        this.state.currentChoices = null;
    }

    public boolean backup() {
        if (this.backstack.empty()) {
            return false;
        }
        this.state = this.backstack.pop();
        if (this.state.currentNode.nextNode() != null && this.state.currentNode.nextNode().subphrase() != this.state.nextNodeSubphrase) {
            if (this.state.advanceCase == 'D') {
                ArrayList<ASDGrammarNode> dummyNodes = new ArrayList<ASDGrammarNode>(10);
                for (int j = 0; j < this.state.currentChoices.size(); ++j) {
                    ASDDeciderChoice choice = this.state.currentChoices.get(j);
                    if (choice.advanceType != 'D') continue;
                    dummyNodes.add(choice.nextNode);
                }
                this.state.currentChoices = this.choices(true, dummyNodes);
            } else {
                for (int j = this.state.currentChoices.size() - 1; j >= 0; --j) {
                    ASDDeciderChoice choice = this.state.currentChoices.get(j);
                    if (choice.advanceType == 'D') continue;
                    this.state.currentChoices.remove(j);
                }
            }
        }
        ++this.currentParseStepNumber;
        return true;
    }

    public String bracketPhrase() {
        return this.bracketPhrase(this.state.decisionStructure.nextNode());
    }

    public String bracketPhrase(ASDPhraseNode p) {
        if (p.nextNode() == null) {
            if (p.subphrase() == null) {
                return p.word();
            }
            return this.bracketPhrase(p.subphrase());
        }
        int nonDummyCount = 0;
        ASDPhraseNode nonDummyNode = null;
        for (ASDPhraseNode node = p; node != null; node = node.nextNode()) {
            if (node.word().equals(this.DUMMYWORD)) continue;
            if (nonDummyCount == 0) {
                nonDummyCount = 1;
                nonDummyNode = node;
                continue;
            }
            nonDummyCount = 2;
        }
        if (nonDummyCount == 1) {
            if (nonDummyNode.subphrase() == null) {
                return nonDummyNode.word();
            }
            return this.bracketPhrase(nonDummyNode.subphrase());
        }
        StringBuffer buffer = new StringBuffer(100);
        int ch = 40;
        for (ASDPhraseNode next = p; next != null; next = next.nextNode()) {
            if (next.subphrase() == null) {
                String nextWord = next.word();
                if (!nextWord.equals(this.DUMMYWORD)) {
                    buffer.append((char)ch);
                    buffer.append(nextWord);
                }
            } else {
                buffer.append((char)ch);
                buffer.append(this.bracketPhrase(next.subphrase()));
            }
            ch = 32;
        }
        buffer.append(')');
        return buffer.toString();
    }

    ArrayList<ASDDeciderChoice> choices(boolean includeDummies, ArrayList<ASDGrammarNode> dummies) {
        boolean initialsIn = false;
        if (this.state.currentNode == this.state.decisionStructure) {
            ArrayList<ASDDeciderChoice> result = this.initialsForTypes(this.state.decisionValues, this.expectedTypes);
            return result;
        }
        ArrayList<ASDDeciderChoice> result = new ArrayList<ASDDeciderChoice>(10);
        ASDGrammarNode grammarNode = this.state.currentNode.instance();
        if (grammarNode == null) {
            System.out.println("*** grammarNode unexpectedly null in ASDDecider choices");
            System.exit(0);
        }
        if (grammarNode.isFinal()) {
            ASDDeciderChoice choice = new ASDDeciderChoice();
            choice.advanceType = (char)70;
            choice.completedType = grammarNode.phraseType();
            result.add(choice);
            return result;
        }
        ASDPhraseNode next = this.state.currentNode.nextNode();
        ArrayList<String> types = grammarNode.successorTypes();
        ArrayList<ASDGrammarSuccessor> successors = grammarNode.successors();
        if (successors == null) {
            System.out.println("*** successors unexpectedly null for ASD grammar entry for word\n'" + grammarNode.word() + "' and instance " + grammarNode.instance());
            System.exit(0);
        }
        for (int j = 0; j < successors.size(); ++j) {
            ASDGrammarNode successorState;
            ASDGrammarSuccessor successor = successors.get(j);
            if (successor.getWord().equals(this.DUMMYWORD)) {
                if (!includeDummies) continue;
                successorState = this.ASDLexicon.lookupInstance(successor);
                boolean includeState = false;
                if (dummies == null) {
                    includeState = true;
                } else {
                    for (int k = 0; !includeState && k < dummies.size(); ++k) {
                        if (successorState != dummies.get(k)) continue;
                        includeState = true;
                    }
                }
                if (!includeState) continue;
                ASDDeciderChoice choice = new ASDDeciderChoice();
                choice.advanceType = (char)68;
                choice.nextNode = successorState;
                result.add(choice);
                continue;
            }
            if (next == null || !this.state.decisionValues.contains(successor.getWord())) continue;
            successorState = this.ASDLexicon.lookupInstance(successor);
            ASDDeciderChoice choice = new ASDDeciderChoice();
            choice.advanceType = (char)78;
            choice.nextNode = successorState;
            result.add(choice);
        }
        return result;
    }

    public HashSet<String> createDecisionSet(String aString) {
        HashSet<String> decisionValues = new HashSet<String>(aString.length());
        StringTokenizer tokenizer = new StringTokenizer(aString, this.SPACECHARS, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            decisionValues.add(token);
        }
        return decisionValues;
    }

    public boolean done() {
        boolean result = false;
        if (this.state.currentNode == this.state.decisionStructure) {
            int n = this.expectedTypes.size();
            String word = this.state.decisionStructure.nextNode().word();
            for (int j = 0; !result && j < n; ++j) {
                if (!this.expectedTypes.get(j).equals(word)) continue;
                result = true;
            }
        }
        return result;
    }

    ArrayList<ASDDeciderChoice> initialsForTypes(HashSet<String> decValues, ArrayList expected) {
        ArrayList<ASDDeciderChoice> result = new ArrayList<ASDDeciderChoice>(5);
        for (String token : decValues) {
            ArrayList<ASDGrammarNode> tokenEntry = this.ASDLexicon.lookupWord(token);
            if (tokenEntry == null) continue;
            for (int index = 0; index < tokenEntry.size(); ++index) {
                ASDDeciderChoice choice;
                ASDGrammarNode wordInstance = tokenEntry.get(index);
                if (!wordInstance.isInitial()) continue;
                ArrayList<String> beginsTypes = wordInstance.beginsTypes();
                if (beginsTypes == null) {
                    choice = new ASDDeciderChoice();
                    choice.advanceType = (char)73;
                    choice.nextNode = wordInstance;
                    result.add(choice);
                    continue;
                }
                boolean noMatch = true;
                if (expected == null) {
                    noMatch = false;
                } else {
                    for (int expectedIndex = 0; noMatch && expectedIndex < expected.size(); ++expectedIndex) {
                        String expectedType = (String)expected.get(expectedIndex);
                        for (int beginsIndex = 0; noMatch && beginsIndex < beginsTypes.size(); ++beginsIndex) {
                            if (!expectedType.equals(beginsTypes.get(beginsIndex))) continue;
                            noMatch = false;
                        }
                    }
                }
                if (noMatch) continue;
                choice = new ASDDeciderChoice();
                choice.advanceType = (char)73;
                choice.nextNode = wordInstance;
                result.add(choice);
            }
        }
        return result;
    }

    public boolean parse() {
        String advanceResult;
        while ((advanceResult = this.advance()) != this.QUIT) {
            if (advanceResult == this.SUCCEED) {
                if (!this.done()) continue;
                return true;
            }
            if (advanceResult == this.NOADVANCE) {
                if (this.backup()) continue;
                return false;
            }
            System.out.println("Invalid result of ASDDecider advance():" + advanceResult);
            System.exit(0);
        }
        return false;
    }

    public int parse(int maxSteps) {
        int steps;
        for (steps = 0; steps < maxSteps; ++steps) {
            String advanceResult = this.advance();
            if (advanceResult == this.QUIT) {
                return -steps;
            }
            if (advanceResult == this.SUCCEED) {
                if (!this.done()) continue;
                return steps;
            }
            if (advanceResult == this.NOADVANCE) {
                if (this.backup()) continue;
                return -steps;
            }
            System.out.println("Invalid result of ASDDecider advance(maxSteps):" + advanceResult);
            System.exit(0);
        }
        return -steps;
    }

    public void raiseFeatures() {
        if (!(this.currentNode().value() instanceof Map)) {
            return;
        }
        Set entries = ((Map)this.currentNode().value()).entrySet();
        for (Map.Entry entry : entries) {
            this.set((String)entry.getKey(), entry.getValue());
        }
    }

    public String raiseFeaturesChecking() {
        if (!(this.currentNode().value() instanceof Map)) {
            return this.QUIT;
        }
        Set entries = ((Map)this.currentNode().value()).entrySet();
        for (Map.Entry entry : entries) {
            String feature = (String)entry.getKey();
            Object existingValue = this.valueOf(feature);
            if (existingValue != null && !existingValue.equals(entry.getValue())) {
                return this.NOADVANCE;
            }
            this.set((String)entry.getKey(), entry.getValue());
        }
        return this.SUCCEED;
    }

    ASDPhraseNode segment(String aString) {
        ASDPhraseNode decisionStructure = new ASDPhraseNode();
        decisionStructure.setWord("nil");
        ASDPhraseNode lastNode = decisionStructure;
        String lastToken = "";
        StringTokenizer tokenizer = new StringTokenizer(aString, this.SPACECHARS, true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() > 0) {
                ASDPhraseNode newNode = new ASDPhraseNode();
                newNode.setWord(token);
                lastNode.setNextNode(newNode);
                lastNode = newNode;
            }
            lastToken = token;
        }
        return decisionStructure;
    }

    @Override
    public String semanticAction(String action) {
        Method m = null;
        try {
            m = this.application.getClass().getMethod(action, null);
        }
        catch (NoSuchMethodException e) {
            System.out.println("Error invoking method " + action);
            return null;
        }
        if (m != null) {
            try {
                return (String)m.invoke(this.application, (Object[])null);
            }
            catch (InvocationTargetException e) {
                System.out.println("InvocationTargetException invoking method \"" + action + "\"");
                return null;
            }
            catch (IllegalAccessException e) {
                System.out.println("IllegalAccessException invoking method " + action);
                return null;
            }
        }
        return null;
    }

    @Override
    public Object semanticValue(String value) {
        boolean numericValue = true;
        long integerValue = 0L;
        try {
            integerValue = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            numericValue = false;
        }
        if (numericValue) {
            return integerValue;
        }
        if (value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return value.substring(1, value.length() - 1);
        }
        Method m = null;
        try {
            m = this.application.getClass().getMethod(value, null);
        }
        catch (NoSuchMethodException e) {
            System.out.println("No such method found: " + value);
            return null;
        }
        if (m != null) {
            try {
                return m.invoke(this.application, (Object[])null);
            }
            catch (InvocationTargetException e) {
                System.out.println("InvocationTargetException invoking method \"" + value + "\"");
                return null;
            }
            catch (IllegalAccessException e) {
                System.out.println("IllegalAccessException invoking method " + value);
                return null;
            }
        }
        return null;
    }

    public void setANYTHING(String newValue) {
        this.ANYTHING = newValue;
    }

    public void setCLOSEQUOTE(String newValue) {
        this.CLOSEQUOTE = newValue;
    }

    public void setNOADVANCE(String newValue) {
        this.NO = this.NOADVANCE = newValue;
    }

    public void setDUMMYWORD(String newValue) {
        this.DUMMYWORD = newValue;
    }

    public void setNUMBER(String newValue) {
        this.NUMBER = newValue;
    }

    public void setOPENQUOTE(String newValue) {
        this.OPENQUOTE = newValue;
    }

    public void setQUIT(String newValue) {
        this.QUIT = newValue;
    }

    public void setSPACECHARS(String newValue) {
        this.SPACECHARS = newValue;
    }

    public void setSPECIALCHARS(String newValue) {
        this.SPECIALCHARS = newValue;
    }

    public void setSTRING(String newValue) {
        this.STRING = newValue;
    }

    public void setSUCCEED(String newValue) {
        this.SUCCEED = newValue;
    }

    public void setUNKNOWN(String newValue) {
        UNKNOWN = newValue;
    }

    public void showTree() {
        this.state.decisionStructure.showTree(this.state.currentNode);
    }

    public void stepParse(int maxSteps) {
        int steps = 0;
        BufferedReader keyboard = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("\nInitial decision structure:");
        this.showTree();
        block4: while (steps < maxSteps) {
            System.out.print("\nStep " + ++steps + ": ");
            String advanceResult = this.advance();
            if (advanceResult == this.QUIT) {
                System.out.println("parse quit with structure:");
                this.showTree();
                return;
            }
            if (advanceResult == this.SUCCEED) {
                String in;
                System.out.println("parse advanced to:");
                this.showTree();
                if (this.done()) {
                    System.out.println("\nSuccessful parse in " + steps + " steps, to:");
                    this.showTree();
                    in = null;
                    do {
                        System.out.print("\nDo you want to try for an alternative parse (y or n)? ");
                        try {
                            in = keyboard.readLine();
                        }
                        catch (IOException e) {
                            System.out.println("IOException occurred in ASDDecider stepParse");
                            System.exit(0);
                        }
                        if (in.equalsIgnoreCase("y")) continue block4;
                    } while (!in.equalsIgnoreCase("n"));
                    return;
                }
                System.out.print("\nPress Enter key to advance the parse. ");
                try {
                    in = keyboard.readLine();
                }
                catch (IOException e) {
                    System.out.println("IOException occurred in ASDDecider stepParse");
                    System.exit(0);
                }
                continue;
            }
            if (advanceResult == this.NOADVANCE) {
                if (this.backup()) {
                    System.out.println("parse backed up to:");
                    this.showTree();
                    continue;
                }
                System.out.println("failed parse in " + steps + " steps, left with:");
                this.showTree();
                return;
            }
            System.out.println("Invalid result of ASDDecider advance(maxSteps):" + advanceResult);
            return;
        }
    }

    public boolean useNetwork(ASDGrammar network) {
        if (network == null) {
            return false;
        }
        this.ASDLexicon = network;
        if (!this.ASDLexicon.nodesWithIncomingEdgesMarked()) {
            this.ASDLexicon.markNodesWithIncomingEdges();
        }
        return true;
    }

    public boolean useNetwork(String fileName) throws URISyntaxException {
        try {
            this.ASDLexicon = new ASDGrammar(fileName, false, true);
        }
        catch (IOException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }
}

