/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDDigraphEdge;
import asd.ASDDigraphNode;
import asd.ASDEditEdge;
import asd.ASDEditNode;
import asd.ASDEditor;
import asd.ASDGrammar;
import asd.ASDGrammarNode;
import asd.ASDGrammarSuccessor;
import asd.ASDWordEntry;
import digraphs.Digraph;
import digraphs.DigraphEdge;
import digraphs.DigraphNode;
import java.awt.Container;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ASDDigraph
extends Digraph {
    private ASDGrammar grammar;
    private ASDEditor editor;
    private Container graphicPanel;

    ASDDigraph() {
        EdgeClassName = "asd.ASDDigraphEdge";
    }

    ASDDigraph(String fileName, Container panel) throws IOException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, URISyntaxException {
        this(new ASDGrammar(fileName, true), panel);
    }

    ASDDigraph(ASDGrammar givenGrammar, Container panel) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this();
        this.setGrammar(givenGrammar);
        this.setPanel(panel);
        HashMap<String, ArrayList<ASDGrammarNode>> lexicon = this.grammar.lexicon();
        Set<Map.Entry<String, ArrayList<ASDGrammarNode>>> entrySet = lexicon.entrySet();
        for (Map.Entry<String, ArrayList<ASDGrammarNode>> e : entrySet) {
            ArrayList<ASDGrammarNode> instances = e.getValue();
            for (ASDGrammarNode gNode : instances) {
                ASDDigraphNode dNode = this.addDigraphNode(gNode);
                if (panel == null) continue;
                ASDEditNode eNode = new ASDEditNode(gNode, this.getPanel(), gNode.getXCoordinate(), gNode.getYCoordinate());
                dNode.setEditNode(eNode);
                eNode.setDigraphNode(dNode);
            }
        }
        ArrayList nodes = super.getNodes();
        for (ASDDigraphNode dNode : nodes) {
            ASDGrammarNode gNode = dNode.getGrammarNode();
            if (gNode.isFinal()) continue;
            ArrayList<ASDGrammarSuccessor> successors = gNode.successors();
            for (ASDGrammarSuccessor s : successors) {
                ASDDigraphEdge newEdge;
                ASDGrammarNode nextgNode = this.grammar.lookupInstance(s);
                ASDDigraphNode nextdNode = null;
                for (ASDDigraphNode d : nodes) {
                    if (d.getGrammarNode() != nextgNode) continue;
                    nextdNode = d;
                    break;
                }
                if ((newEdge = (ASDDigraphEdge)super.addEdgeFromNodeToNode((DigraphNode)dNode, nextdNode)) == null) continue;
                newEdge.setGrammarSuccessor(s);
                if (panel == null) continue;
                ASDEditEdge newEditEdge = new ASDEditEdge(panel, s.getXCoordinate(), s.getYCoordinate());
                newEdge.setEditEdge(newEditEdge);
                newEditEdge.setDigraphEdge(newEdge);
                newEditEdge.setGrammarSuccessor(s);
            }
        }
    }

    ASDDigraphNode addDigraphNode(ASDGrammarNode gNode) {
        ASDDigraphNode newNode = new ASDDigraphNode(gNode);
        this.digraphNodes.add(newNode);
        return newNode;
    }

    ASDDigraphEdge addEdgeFromTo(ASDGrammarSuccessor successor, int nodeIndex1, int nodeIndex2) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ASDDigraphEdge newEdge = (ASDDigraphEdge)super.addEdgeFromTo(nodeIndex1, nodeIndex2);
        if (newEdge == null) {
            return newEdge;
        }
        newEdge.setGrammarSuccessor(successor);
        if (this.getPanel() != null) {
            ASDEditEdge newEditEdge = new ASDEditEdge(this.getPanel(), successor.getXCoordinate(), successor.getYCoordinate());
            newEdge.setEditEdge(newEditEdge);
            newEditEdge.setGrammarSuccessor(successor);
        }
        return newEdge;
    }

    ASDDigraphEdge addEdgeFromNodeToNode(ASDDigraphNode node1, ASDDigraphNode node2) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (node1 == null || node2 == null) {
            return null;
        }
        ASDDigraphEdge result = (ASDDigraphEdge)super.addEdgeFromNodeToNode((DigraphNode)node1, (DigraphNode)node2);
        ASDGrammarNode gNode1 = node1.getGrammarNode();
        ArrayList<ASDGrammarSuccessor> successors = gNode1.successors();
        int newSuccessorNumber = successors.size() + 1;
        ASDGrammarNode gNode2 = node2.getGrammarNode();
        ASDEditEdge eEdge = new ASDEditEdge(null);
        eEdge.setDigraphEdge(result);
        result.setEditEdge(eEdge);
        ASDGrammarSuccessor successor = new ASDGrammarSuccessor(gNode2.word(), gNode2.instance());
        eEdge.setGrammarSuccessor(successor);
        result.setGrammarSuccessor(successor);
        successors.add(successor);
        return result;
    }

    private ASDDigraphEdge addTemporaryEdgeFromNodeToNode(ASDDigraphNode node1, ASDDigraphNode node2) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (node1 == null || node2 == null) {
            return null;
        }
        ASDDigraphEdge result = (ASDDigraphEdge)super.addEdgeFromNodeToNode((DigraphNode)node1, (DigraphNode)node2);
        return result;
    }

    void expandBegins() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ASDGrammarNode gNode;
        ASDDigraph copy = this.shallowCopyDigraph();
        ArrayList<ASDDigraphNode> initials = new ArrayList<ASDDigraphNode>(this.numberOfNodes());
        ArrayList<ASDDigraphNode> finals = new ArrayList<ASDDigraphNode>(this.numberOfNodes());
        for (ASDDigraphNode dNode : copy.getNodes()) {
            gNode = dNode.getGrammarNode();
            if (gNode.isInitial()) {
                initials.add(dNode);
            }
            if (!gNode.isFinal()) continue;
            finals.add(dNode);
        }
        for (ASDDigraphNode dNode : finals) {
            gNode = dNode.getGrammarNode();
            String type = gNode.phraseType();
            for (ASDDigraphNode dNode2 : initials) {
                ASDGrammarNode gNode2 = dNode2.getGrammarNode();
                if (!type.equals(gNode2.word())) continue;
                copy.addTemporaryEdgeFromNodeToNode(dNode, dNode2);
            }
        }
        for (ASDDigraphNode dNode : initials) {
            ArrayList<String> types = dNode.beginsDirectly();
            ASDGrammarNode gNode2 = dNode.getGrammarNode();
            gNode2.setBeginsTypes(types);
        }
    }

    ASDDigraphNode lookupNode(String word, String instance) {
        ASDGrammarNode gNode = this.grammar.lookupInstance(new ASDGrammarSuccessor(word, instance));
        if (gNode != null) {
            for (ASDDigraphNode dNode : this.getNodes()) {
                if (dNode.getGrammarNode() != gNode) continue;
                return dNode;
            }
        }
        return null;
    }

    void mergeInGrammar(String fileName, Container panel) throws IOException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, URISyntaxException {
        this.mergeInGrammar(new ASDGrammar(fileName, true), panel);
    }

    void mergeInGrammar(ASDGrammar otherGrammar, Container panel) throws IOException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        HashMap<String, ArrayList<ASDGrammarNode>> otherLexicon = otherGrammar.lexicon();
        Set<Map.Entry<String, ArrayList<ASDGrammarNode>>> otherEntrySet = otherLexicon.entrySet();
        for (Map.Entry<String, ArrayList<ASDGrammarNode>> e : otherEntrySet) {
            String word = e.getKey();
            ArrayList<ASDGrammarNode> instances = e.getValue();
            ArrayList<ASDGrammarNode> wordEntry = this.grammar.lookupWord(word);
            if (wordEntry == null) {
                wordEntry = new ArrayList(instances.size());
                this.grammar.lexicon().put(word, wordEntry);
            }
            int increment = wordEntry.size();
            for (ASDGrammarNode oldGNode : instances) {
                if (increment > 0) {
                    int oldInstanceNumber = Integer.parseInt(oldGNode.instance());
                    oldGNode.setInstance("" + (oldInstanceNumber + increment));
                }
                if (oldGNode.isFinal()) continue;
                ArrayList<ASDGrammarSuccessor> successors = oldGNode.successors();
                for (ASDGrammarSuccessor s : successors) {
                    String sWord = s.getWord();
                    ArrayList<ASDGrammarNode> sWordEntry = this.grammar.lookupWord(sWord);
                    if (sWordEntry == null || sWordEntry.size() <= 0) continue;
                    int sIncrement = sWordEntry.size();
                    String sInstance = s.getInstance();
                    int oldSInstanceNumber = Integer.parseInt(sInstance);
                    s.setInstance("" + (oldSInstanceNumber + sIncrement));
                }
            }
        }
        ArrayList<ASDDigraphNode> newNodes = new ArrayList<ASDDigraphNode>();
        for (Map.Entry<String, ArrayList<ASDGrammarNode>> e : otherEntrySet) {
            String word = e.getKey();
            ArrayList<ASDGrammarNode> newInstances = this.grammar.lookupWord(word);
            ArrayList<ASDGrammarNode> oldInstances = e.getValue();
            for (ASDGrammarNode gNode : oldInstances) {
                newInstances.add(gNode);
                ASDDigraphNode dNode = this.addDigraphNode(gNode);
                newNodes.add(dNode);
                if (panel == null) continue;
                ASDEditNode eNode = new ASDEditNode(gNode, this.getPanel(), gNode.getXCoordinate(), gNode.getYCoordinate());
                dNode.setEditNode(eNode);
                eNode.setDigraphNode(dNode);
            }
        }
        for (ASDDigraphNode dNode : newNodes) {
            ASDGrammarNode gNode = dNode.getGrammarNode();
            if (gNode.isFinal()) continue;
            ArrayList<ASDGrammarSuccessor> successors = gNode.successors();
            for (ASDGrammarSuccessor s : successors) {
                ASDDigraphEdge newEdge;
                ASDGrammarNode nextgNode = this.grammar.lookupInstance(s);
                ASDDigraphNode nextdNode = null;
                for (ASDDigraphNode d : newNodes) {
                    if (d.getGrammarNode() != nextgNode) continue;
                    nextdNode = d;
                    break;
                }
                if ((newEdge = (ASDDigraphEdge)super.addEdgeFromNodeToNode((DigraphNode)dNode, nextdNode)) == null) continue;
                newEdge.setGrammarSuccessor(s);
                if (panel == null) continue;
                ASDEditEdge newEditEdge = new ASDEditEdge(panel, s.getXCoordinate(), s.getYCoordinate());
                newEdge.setEditEdge(newEditEdge);
                newEditEdge.setDigraphEdge(newEdge);
                newEditEdge.setGrammarSuccessor(s);
            }
        }
    }

    void removeEdge(ASDDigraphEdge e) {
        if (e == null) {
            return;
        }
        ASDGrammarSuccessor s = e.getGrammarSuccessor();
        ASDGrammarNode gNode = ((ASDDigraphNode)e.getFromNode()).getGrammarNode();
        ArrayList<ASDGrammarSuccessor> successors = gNode.successors();
        int pos = successors.indexOf(s);
        successors.remove(pos);
        super.removeEdge((DigraphEdge)e);
    }

    void removeNode(ASDDigraphNode n) {
        String word;
        ArrayList<ASDGrammarNode> entries;
        int entryIndex;
        if (n == null) {
            return;
        }
        ASDGrammarNode gNode2 = n.getGrammarNode();
        if (gNode2 == null) {
            System.out.println("null grammar node");
            System.exit(0);
        }
        if ((entryIndex = (entries = this.grammar.lookupWord(word = gNode2.word())).indexOf(gNode2)) < 0) {
            System.out.println("grammar node not found");
            System.exit(0);
        }
        String instance = null;
        entries.remove(entryIndex);
        super.removeNode((DigraphNode)n);
        int instanceIndex = 1;
        for (ASDGrammarNode gNode2 : entries) {
            word = gNode2.word();
            ASDDigraphNode dNode = this.lookupNode(word, gNode2.instance());
            instance = "" + instanceIndex;
            gNode2.setInstance(instance);
            ASDEditNode eNode = dNode.getEditNode();
            eNode.setText(word + " " + instance);
            ArrayList edgesIn = dNode.getInEdges();
            if (edgesIn != null) {
                for (ASDDigraphEdge dEdge : edgesIn) {
                    ASDGrammarSuccessor successor = dEdge.getGrammarSuccessor();
                    successor.setInstance(instance);
                }
            }
            ++instanceIndex;
        }
    }

    void saveToFile(String fileName) throws IOException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this.saveToFile(fileName, true);
    }

    void saveToFile(String fileName, boolean optimize) throws IOException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        FileWriter writer = new FileWriter(fileName);
        PrintWriter outStream = new PrintWriter(writer);
        this.expandBegins();
        this.grammar.computeSuccessorTypes();
        ArrayList<ASDWordEntry> entryList = new ArrayList<ASDWordEntry>(this.grammar.lexicon().size());
        Set<Map.Entry<String, ArrayList<ASDGrammarNode>>> entrySet = this.grammar.lexicon().entrySet();
        for (Map.Entry<String, ArrayList<ASDGrammarNode>> e : entrySet) {
            String word = e.getKey();
            ArrayList<ASDGrammarNode> instances = e.getValue();
            entryList.add(new ASDWordEntry(word, instances));
        }
        Object[] sortedList = entryList.toArray();
        Arrays.sort(sortedList);
        for (int j = 0; j < sortedList.length; ++j) {
            ASDWordEntry entry = (ASDWordEntry)sortedList[j];
            String word = entry.getWord();
            ArrayList<ASDGrammarNode> instances = entry.getInstances();
            outStream.println("(" + word + " (");
            for (ASDGrammarNode node : instances) {
                outStream.print(node.toString(optimize));
            }
            outStream.println("))");
            outStream.println();
        }
        writer.close();
    }

    private ASDDigraph shallowCopyDigraph() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ASDDigraph result = new ASDDigraph();
        result.setGrammar(this.getGrammar());
        ArrayList dNodes = this.getNodes();
        for (ASDDigraphNode node : dNodes) {
            ASDGrammarNode oldGNode = node.getGrammarNode();
            result.addDigraphNode(this.getGrammar().lookupInstance(new ASDGrammarSuccessor(oldGNode.word(), oldGNode.instance())));
        }
        ArrayList edges = this.getEdges();
        for (ASDDigraphEdge edge : edges) {
            ASDDigraphNode fromNode = (ASDDigraphNode)edge.getFromNode();
            ASDDigraphNode toNode = (ASDDigraphNode)edge.getToNode();
            int fromNodeIndex = -1;
            for (ASDDigraphNode dNode : dNodes) {
                ++fromNodeIndex;
                if (dNode != fromNode) continue;
                break;
            }
            int toNodeIndex = -1;
            for (ASDDigraphNode dNode : dNodes) {
                ++toNodeIndex;
                if (dNode != toNode) continue;
                break;
            }
            result.addEdgeFromTo(edge.getGrammarSuccessor(), fromNodeIndex, toNodeIndex);
        }
        return result;
    }

    ASDEditor getEditor() {
        return this.editor;
    }

    void setEditor(ASDEditor newEditor) {
        this.editor = newEditor;
    }

    ASDGrammar getGrammar() {
        return this.grammar;
    }

    void setGrammar(ASDGrammar newGrammar) {
        this.grammar = newGrammar;
    }

    Container getPanel() {
        return this.graphicPanel;
    }

    void setPanel(Container newPanel) {
        this.graphicPanel = newPanel;
    }
}

