/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDDigraphEdge;
import asd.ASDDigraphNode;
import asd.ASDEditNode;
import asd.ASDEditor;
import asd.ASDGrammarSuccessor;
import asd.EditEdgeMenu;
import asd.PopupListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ASDEditEdge
extends JRadioButton
implements MouseMotionListener,
ChangeListener {
    static final int SIZE = 12;
    private Container context;
    private ASDEditor editor;
    private ASDGrammarSuccessor successor;
    private ASDDigraphEdge dEdge;

    ASDEditEdge(Container given) {
        this.context = given;
        this.addMouseMotionListener(this);
        this.addChangeListener(this);
        this.addMouseListener(new PopupListener(new EditEdgeMenu(this)));
        this.setOpaque(false);
    }

    ASDEditEdge(Container given, int xPos, int yPos) {
        this(given);
        this.setLocation(xPos, yPos);
        this.setSize(12, 12);
    }

    Container getContext() {
        return this.context;
    }

    ASDEditor getEditor() {
        return this.editor;
    }

    ASDEditNode getFromNode() {
        return ((ASDDigraphNode)this.getDigraphEdge().getFromNode()).getEditNode();
    }

    ASDEditNode getToNode() {
        return ((ASDDigraphNode)this.getDigraphEdge().getToNode()).getEditNode();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.context.remove(this);
        this.context.add((Component)this, 0);
        int newX = this.getX() + e.getX();
        int newY = this.getY() + e.getY();
        this.setLocation(newX, newY);
        this.successor.setXCoordinate((short)newX);
        this.successor.setYCoordinate((short)newY);
        this.editor.setGrammarChanged(true);
        this.context.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    void setEditor(ASDEditor givenEditor) {
        this.editor = givenEditor;
    }

    void setContext(Container c) {
        this.context = c;
    }

    void setDefaultCoordinates() {
        ASDEditNode eNode1 = ((ASDDigraphNode)this.dEdge.getFromNode()).getEditNode();
        ASDEditNode eNode2 = ((ASDDigraphNode)this.dEdge.getToNode()).getEditNode();
        short x1 = eNode1.rightConnectorX();
        short y1 = eNode1.rightConnectorY();
        short x2 = eNode2.leftConnectorX();
        short y2 = eNode2.leftConnectorY();
        if (eNode1 != eNode2) {
            this.setPosition((x1 + x2) / 2 - 6, (y1 + y2) / 2 - 6);
        } else {
            this.setPosition((x1 + x2) / 2 - 6, y1 - eNode1.getHeight() - 6);
        }
        this.successor.setXCoordinate((short)this.getX());
        this.successor.setYCoordinate((short)this.getY());
    }

    void setPosition(int newX, int newY) {
        Insets insets = this.context.getInsets();
        this.setBounds(newX + insets.left, newY + insets.top, 12, 12);
    }

    ASDDigraphEdge getDigraphEdge() {
        return this.dEdge;
    }

    void setDigraphEdge(ASDDigraphEdge newEdge) {
        this.dEdge = newEdge;
    }

    ASDGrammarSuccessor getGrammarSuccessor() {
        return this.successor;
    }

    void setGrammarSuccessor(ASDGrammarSuccessor s) {
        this.successor = s;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.isSelected() && this.getModel().isPressed()) {
            this.editor.edgeSelected(this);
        } else if (!this.isSelected() && this.getModel().isPressed()) {
            this.setSelected(true);
        }
    }
}

