/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDDigraphEdge;
import asd.ASDDigraphNode;
import asd.ASDEditor;
import asd.ASDGrammarNode;
import asd.EditNodeMenu;
import asd.PopupListener;
import asd.RightLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ASDEditNode
extends JToggleButton
implements MouseListener,
MouseMotionListener,
ChangeListener {
    private final int VERTICAL_PAD = 10;
    private ASDDigraphNode dNode;
    private ASDGrammarNode gNode;
    private ASDEditor editor;
    private Container context;
    private RightLabel rightLabel;
    private PopupListener popupListener;

    ASDEditNode(ASDGrammarNode grammarNode, Container given) {
        super(" " + grammarNode.word() + " " + grammarNode.instance() + "     .");
        this.gNode = grammarNode;
        this.context = given;
        this.addMouseListener(this);
        this.popupListener = new PopupListener(new EditNodeMenu(this));
        this.addMouseListener(this.popupListener);
        this.addChangeListener(this);
        this.addMouseMotionListener(this);
        if (grammarNode.isInitial()) {
            this.setBackground(Color.yellow);
            this.setBorder(BorderFactory.createLineBorder(Color.yellow, 1));
        } else {
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        }
        if (grammarNode.isFinal()) {
            this.initializeRightLabel(grammarNode.phraseType() + "     .");
        }
    }

    ASDEditNode(ASDGrammarNode grammarNode, Container given, int xPos, int yPos) {
        this(grammarNode, given);
        this.setPosition((short)xPos, (short)yPos);
    }

    ASDEditNode(ASDGrammarNode grammarNode, Container given, short xPos, short yPos) {
        this(grammarNode, given);
        this.setPosition(xPos, yPos);
    }

    void changePopupMenu() {
        this.removeMouseListener(this.popupListener);
        this.popupListener = new PopupListener(new EditNodeMenu(this));
        this.addMouseListener(this.popupListener);
    }

    Container getContext() {
        return this.context;
    }

    ASDGrammarNode getGrammarNode() {
        return this.gNode;
    }

    void setGrammarNode(ASDGrammarNode g) {
        this.gNode = g;
    }

    ASDDigraphNode getDigraphNode() {
        return this.dNode;
    }

    void setDigraphNode(ASDDigraphNode d) {
        this.dNode = d;
    }

    ASDEditor getEditor() {
        return this.editor;
    }

    RightLabel getRightLabel() {
        return this.rightLabel;
    }

    private void initializeRightLabel(String text) {
        if (text != null && text.length() > 0) {
            this.rightLabel = new RightLabel(this, text);
        }
    }

    boolean isFinal() {
        return this.gNode.isFinal();
    }

    boolean isSingleton() {
        return this.dNode.isSingleton();
    }

    short leftConnectorX() {
        return (short)this.getX();
    }

    short leftConnectorY() {
        return (short)(this.getY() + this.getHeight() / 2);
    }

    short rightConnectorX() {
        return (short)(this.getX() + this.getWidth());
    }

    short rightConnectorY() {
        return (short)(this.getY() + this.getHeight() / 2);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!e.isShiftDown()) {
            this.move(this, e);
        } else {
            ArrayList connectedNodes = this.dNode.connectedNodes();
            if (connectedNodes.size() == 0) {
                this.move(this, e);
            } else {
                for (ASDDigraphNode dNode2 : connectedNodes) {
                    ASDEditNode eNode2 = dNode2.getEditNode();
                    this.move(eNode2, e);
                }
            }
        }
        this.getEditor().setGrammarChanged(true);
        this.getContext().repaint();
    }

    private void move(ASDEditNode eNode, MouseEvent e) {
        eNode.getContext().remove(eNode);
        eNode.getContext().add((Component)eNode, 0);
        int newX = eNode.getX() + e.getX();
        int newY = eNode.getY() + e.getY();
        eNode.setLocation(newX, newY);
        ASDGrammarNode gNode = eNode.getGrammarNode();
        gNode.setXCoordinate((short)newX);
        gNode.setYCoordinate((short)newY);
        RightLabel rightLabel = eNode.getRightLabel();
        if (rightLabel != null) {
            eNode.getContext().remove(rightLabel);
            eNode.getContext().add((Component)rightLabel, 0);
            rightLabel.setLocation(newX + eNode.getWidth() + 10, newY + eNode.getInsets().top);
        }
        ASDDigraphNode dNode = eNode.getDigraphNode();
        Iterator it = dNode.getInEdges().iterator();
        while (it.hasNext()) {
            ((ASDDigraphEdge)((Object)it.next())).getEditEdge().setDefaultCoordinates();
        }
        it = dNode.getOutEdges().iterator();
        while (it.hasNext()) {
            ((ASDDigraphEdge)((Object)it.next())).getEditEdge().setDefaultCoordinates();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isControlDown()) {
            this.getEditor().toggleListSelected();
        }
        this.getEditor().nodeSelected(this);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.rightLabel != null) {
            this.rightLabel.repaint();
        }
    }

    void setContext(Container newPanel) {
        this.context = newPanel;
    }

    void setEditor(ASDEditor newEditor) {
        this.editor = newEditor;
        this.setContext(newEditor.getNetPanel());
    }

    void setPosition(int newX, int newY) {
        Insets insets = this.getContext().getInsets();
        insets = this.getContext().getInsets();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int stringWidth = metrics.stringWidth(this.getText());
        int stringHeight = metrics.getHeight();
        this.setBounds(newX + insets.left, newY + insets.top, stringWidth + this.getInsets().left + this.getInsets().right, stringHeight + insets.top + insets.bottom + 10);
        if (this.rightLabel != null) {
            this.rightLabel.setPosition(newX, newY);
        }
    }

    void setRightLabel(String text) {
        if (this.context != null && this.rightLabel != null) {
            this.context.remove(this.rightLabel);
        }
        if (text != null && text.length() > 0) {
            this.rightLabel = new RightLabel(this, text);
            if (this.context != null) {
                this.context.add((Component)this.rightLabel, 0);
                this.rightLabel.setPosition(this.getX(), this.getY());
            }
        } else {
            this.rightLabel = null;
        }
        if (this.context != null) {
            this.context.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.getModel().isPressed() && !this.isSelected()) {
            this.setSelected(true);
        }
    }

    void updateColor() {
        if (this.gNode.isInitial()) {
            this.setBackground(Color.yellow);
            this.setBorder(BorderFactory.createLineBorder(Color.yellow, 1));
        } else {
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        }
    }

    void updateGrammarNode() {
        this.gNode.setXCoordinate((short)this.getX());
        this.gNode.setYCoordinate((short)this.getY());
    }
}

