/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDDigraph;
import asd.ASDDigraphEdge;
import asd.ASDDigraphNode;
import asd.ASDEditEdge;
import asd.ASDEditNode;
import asd.ASDEditorFrame;
import asd.ASDFileFilter;
import asd.ASDGrammar;
import asd.ASDGrammarNode;
import asd.ASDGrammarSuccessor;
import asd.ASDInputException;
import asd.ASDTextEditorFrame;
import asd.EdgeList;
import asd.EdgeListModel;
import asd.EdgeListSelectionListener;
import asd.NetPanel;
import asd.PhraseTypeFieldListener;
import asd.RadioListener;
import asd.WordInstanceChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ASDEditor {
    private File currentDirectory;
    private String inputFileName = "newGrammar.grm";
    static final String VERSION = "1.11";
    static final String WINDOW_TITLE = "ASD Grammar Editor (v.1.11): ";
    private static final String DEFAULT_FILE_NAME = "newGrammar.grm";
    private ASDDigraph grammarDigraph = new ASDDigraph(new ASDGrammar(), null);
    private boolean grammarChanged;
    private ASDEditorFrame window;
    private NetPanel netPanel;
    private WordInstanceChooser chooser1;
    private WordInstanceChooser chooser2;
    private int listSelected = 1;
    private JRadioButton leftListButton;
    private JRadioButton rightListButton;
    static final int LEFT_LIST = 1;
    static final int RIGHT_LIST = 2;
    private JList edgeList;
    private JTextField phraseTypeField;
    private ASDEditEdge eEdgeSelected;
    private ASDEditNode eNodeSelected1;
    private ASDEditNode eNodeSelected2;
    private String wordSelected1;
    private String instanceSelected1;
    private String wordSelected2;
    private String instanceSelected2;
    private ASDGrammarNode grammarNodeBeingEdited;
    private String fieldBeingEdited;
    private String oldTextBeingEdited;

    public static void main(String[] args) throws IOException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, URISyntaxException {
        String inFile = null;
        if (args.length > 0) {
            inFile = args[0];
            new ASDEditor(inFile);
        } else {
            new ASDEditor();
        }
    }

    ASDEditor() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this.setGrammarChanged(false);
        this.chooser1 = new WordInstanceChooser(this, this.getGrammar());
        this.chooser2 = new WordInstanceChooser(this, this.getGrammar());
        this.netPanel = new NetPanel(this);
        this.netPanel.setLayout(null);
        this.grammarDigraph.setPanel(this.netPanel);
        this.leftListButton = new JRadioButton("left list/node");
        this.leftListButton.setActionCommand("left");
        this.leftListButton.setSelected(true);
        this.rightListButton = new JRadioButton("right list/node");
        this.rightListButton.setActionCommand("right");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.leftListButton);
        buttonGroup.add(this.rightListButton);
        RadioListener buttonListener = new RadioListener(this);
        this.leftListButton.addActionListener(buttonListener);
        this.rightListButton.addActionListener(buttonListener);
        this.phraseTypeField = new JTextField(10);
        this.phraseTypeField.addActionListener(new PhraseTypeFieldListener(this));
        this.setPhraseTypeField(null);
        this.edgeList = new EdgeList(this);
        this.currentDirectory = new File(".", "");
        this.setGrammarChanged(false);
        this.window = new ASDEditorFrame(this, this.chooser1, this.chooser2, this.netPanel, this.leftListButton, this.rightListButton);
        this.window.setTitle(WINDOW_TITLE + this.inputFileName);
        this.window.setVisible(true);
    }

    ASDEditor(String fileName) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, URISyntaxException {
        this();
        this.inputFileName = fileName;
        boolean successfulLoad = true;
        try {
            this.grammarDigraph = new ASDDigraph(this.inputFileName, (Container)this.netPanel);
        }
        catch (ASDInputException e) {
            JOptionPane.showMessageDialog(this.window, e.getMessage(), "Syntax error in grammar file " + this.inputFileName, 0);
            successfulLoad = false;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.window, this.inputFileName + " not found", "Couldn't load grammar file.", 0);
            successfulLoad = false;
        }
        if (successfulLoad) {
            this.window.newOrUpdatedGrammar(true);
        }
    }

    void addEdge() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (this.eNodeSelected1 != null && this.eNodeSelected1.getDigraphNode().getGrammarNode().isFinal()) {
            JOptionPane.showMessageDialog(this.window, "Edges cannot be added from a final node.\n(The left node selected is a final node.)");
            return;
        }
        if (this.eNodeSelected1 == null || this.eNodeSelected2 == null) {
            JOptionPane.showMessageDialog(this.window, "First select two nodes that the edge should connect.\nThen try again.");
            return;
        }
        ASDDigraphEdge dEdge = this.grammarDigraph.addEdgeFromNodeToNode(this.eNodeSelected1.getDigraphNode(), this.eNodeSelected2.getDigraphNode());
        this.setGrammarChanged(true);
        ASDEditEdge eEdge = dEdge.getEditEdge();
        eEdge.setContext(this.netPanel);
        this.netPanel.addEdge(eEdge);
        eEdge.setDefaultCoordinates();
        this.edgeList = new EdgeList(this, new EdgeListModel(this.eNodeSelected1.getDigraphNode()));
        this.edgeList.getSelectionModel().addListSelectionListener(new EdgeListSelectionListener(this));
        ArrayList edges = this.eNodeSelected1.getDigraphNode().getOutEdges();
        int index = edges.indexOf((Object)eEdge.getDigraphEdge());
        this.edgeList.setSelectedIndex(index);
        this.window.edgeListChanged();
    }

    void addInstance() {
        if (this.listSelected == 1) {
            if (this.wordSelected1 == null) {
                JOptionPane.showMessageDialog(this.window, "First select a word.\nThen try again.");
                return;
            }
            this.addInstanceOf(this.wordSelected1, this.chooser1);
        } else if (this.listSelected == 2) {
            if (this.wordSelected2 == null) {
                JOptionPane.showMessageDialog(this.window, "First select a word.\nThen try again.");
                return;
            }
            this.addInstanceOf(this.wordSelected2, this.chooser2);
        }
    }

    void addInstanceOf(String word, WordInstanceChooser chooser) {
        int initialOption;
        if (word == null) {
            JOptionPane.showMessageDialog(this.window, "A word must be selected first.");
            return;
        }
        boolean initialInstance = false;
        boolean finalInstance = false;
        String phraseTypeEnded = null;
        ArrayList<ASDGrammarNode> wordEntry = this.getGrammar().lookupWord(word);
        if (wordEntry == null) {
            JOptionPane.showMessageDialog(this.window, "A serious error has occurred in ASDEditor.addInstanceOf\nPlease inform jmason@yorku.ca of this error.");
            return;
        }
        if (chooser == this.chooser1) {
            if (!this.leftListButton.isSelected()) {
                this.leftListButton.doClick();
            }
        } else if (chooser == this.chooser2 && !this.rightListButton.isSelected()) {
            this.rightListButton.doClick();
        }
        if ((initialOption = JOptionPane.showConfirmDialog(this.window, "Can the new instance BEGIN a phrase?")) == 2) {
            return;
        }
        if (initialOption == 0) {
            initialInstance = true;
        }
        while (true) {
            finalInstance = false;
            phraseTypeEnded = JOptionPane.showInputDialog(this.window, (Object)"If the instance ends a phrase, what TYPE of phrase does it end?");
            if (phraseTypeEnded == null) break;
            if ((phraseTypeEnded = phraseTypeEnded.trim()).length() == 0) {
                phraseTypeEnded = null;
                break;
            }
            finalInstance = true;
            if (Character.isLetter(phraseTypeEnded.charAt(0))) break;
            JOptionPane.showMessageDialog(this.window, "Phrase type names must begin with letters");
        }
        ArrayList<ASDGrammarSuccessor> successors = null;
        String instanceNumber = "" + (wordEntry.size() + 1);
        if (!finalInstance) {
            successors = new ArrayList<ASDGrammarSuccessor>();
        }
        ASDGrammarNode gNode = new ASDGrammarNode(word, instanceNumber, initialInstance, null, successors, null, phraseTypeEnded, null, null);
        ASDDigraphNode dNode = this.grammarDigraph.addDigraphNode(gNode);
        ASDEditNode eNode = null;
        eNode = this.listSelected == 1 && this.eNodeSelected1 != null ? new ASDEditNode(gNode, (Container)this.getNetPanel(), this.eNodeSelected1.getX() + 10, this.eNodeSelected1.getY() + 10) : (this.listSelected == 2 && this.eNodeSelected2 != null ? new ASDEditNode(gNode, (Container)this.getNetPanel(), this.eNodeSelected2.getX() + 10, this.eNodeSelected2.getY() + 10) : new ASDEditNode(gNode, (Container)this.getNetPanel(), 5, 5));
        dNode.setEditNode(eNode);
        eNode.setDigraphNode(dNode);
        this.netPanel.addNode(eNode);
        wordEntry.add(gNode);
        this.setGrammarChanged(true);
        if (chooser == this.chooser1 && this.eNodeSelected1 != null) {
            if (this.eEdgeSelected != null && this.eEdgeSelected.getFromNode() == this.eNodeSelected1) {
                this.eEdgeSelected.setSelected(false);
                this.eEdgeSelected.repaint();
                this.eEdgeSelected = null;
            }
            if (this.eNodeSelected1 != this.eNodeSelected2) {
                this.eNodeSelected1.setSelected(false);
                this.eNodeSelected1.repaint();
            }
        } else if (chooser == this.chooser2 && this.eNodeSelected2 != null) {
            if (this.eEdgeSelected != null && this.eEdgeSelected.getToNode() == this.eNodeSelected2) {
                this.eEdgeSelected.setSelected(false);
                this.eEdgeSelected.repaint();
                this.eEdgeSelected = null;
            }
            if (this.eNodeSelected2 != this.eNodeSelected1) {
                this.eNodeSelected2.setSelected(false);
                this.eNodeSelected2.repaint();
            }
        }
        if (chooser == this.chooser1) {
            this.wordSelected1 = word;
            this.instanceSelected1 = instanceNumber;
            this.eNodeSelected1 = eNode;
        } else if (chooser == this.chooser2) {
            this.wordSelected2 = word;
            this.instanceSelected2 = instanceNumber;
            this.eNodeSelected2 = eNode;
        }
        this.window.choosersChanged();
        if (chooser == this.chooser1) {
            if (!this.leftListButton.isSelected()) {
                this.leftListButton.doClick();
            }
        } else if (chooser == this.chooser2 && !this.rightListButton.isSelected()) {
            this.rightListButton.doClick();
        }
        eNode.setSelected(true);
        eNode.repaint();
    }

    String addWord() {
        String newWord = null;
        do {
            if ((newWord = JOptionPane.showInputDialog(this.window, (Object)"What is the new word or PHRASE TYPE?")) != null) continue;
            return null;
        } while ((newWord = newWord.trim()).length() == 0);
        if (this.getGrammar().lookupWord(newWord) != null) {
            JOptionPane.showMessageDialog(this.window, "\"" + newWord + "\" is already in the grammar");
            return null;
        }
        this.getGrammar().lexicon().put(newWord, new ArrayList());
        this.setGrammarChanged(true);
        this.window.newOrUpdatedGrammar(true);
        return newWord;
    }

    void addWord(WordInstanceChooser chooser) {
        String newWord = this.addWord();
        if (newWord != null) {
            chooser.setWordSelected(newWord, true);
            this.wordInstanceChooserChanged(chooser);
        }
    }

    void changedText(String newText) {
        if (this.grammarNodeBeingEdited == null) {
            return;
        }
        if (this.oldTextBeingEdited.equals(newText)) {
            return;
        }
        if (this.fieldBeingEdited.equals("action")) {
            this.grammarNodeBeingEdited.setSemanticAction(newText);
        } else if (this.fieldBeingEdited.equals("value")) {
            this.grammarNodeBeingEdited.setSemanticValue(newText);
        }
        this.setGrammarChanged(true);
        this.grammarNodeBeingEdited = null;
        this.fieldBeingEdited = null;
        this.oldTextBeingEdited = null;
    }

    void clearNetPanel() {
        this.netPanel.clear();
        boolean choosersChanged = false;
        if (this.eNodeSelected1 != null) {
            this.eNodeSelected1.setSelected(false);
            this.eNodeSelected1 = null;
            this.instanceSelected1 = null;
            choosersChanged = true;
        }
        if (this.eNodeSelected2 != null) {
            this.eNodeSelected2.setSelected(false);
            this.eNodeSelected2 = null;
            this.instanceSelected2 = null;
            choosersChanged = true;
        }
        if (this.eEdgeSelected != null) {
            this.eEdgeSelected.setSelected(false);
            this.eEdgeSelected = null;
            choosersChanged = true;
        }
        if (choosersChanged) {
            this.window.choosersChanged();
        }
    }

    boolean closingGrammar() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        int option = JOptionPane.showConfirmDialog(this.window, "Do you want to save the grammar?", "The grammar has changed.", 1);
        if (option == 2) {
            return false;
        }
        if (option == 0) {
            return this.saveFile();
        }
        return true;
    }

    void closingWindow() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        int option = JOptionPane.showConfirmDialog(this.window, "Do you want to save the grammar?", "The grammar has changed.", 0);
        if (option == 0) {
            this.saveFile();
        }
    }

    void deleteEdge() {
        this.deleteEdge(this.eEdgeSelected);
    }

    void deleteEdge(ASDDigraphEdge d) {
        this.grammarDigraph.removeEdge(d);
        this.setGrammarChanged(true);
        this.edgeList = new EdgeList(this, new EdgeListModel(this.eNodeSelected1.getDigraphNode()));
        this.edgeList.getSelectionModel().addListSelectionListener(new EdgeListSelectionListener(this));
        this.window.edgeListChanged();
    }

    void deleteEdge(ASDEditEdge e) {
        if (e == null) {
            JOptionPane.showMessageDialog(this.window, "An edge must be selected for deletion first.");
            return;
        }
        if (e != this.eEdgeSelected) {
            e.doClick();
        }
        this.netPanel.removeEdge(e);
        this.eEdgeSelected = null;
        this.deleteEdge(e.getDigraphEdge());
    }

    void deleteEdge(int edgeIndex) {
        ASDEditEdge eEdge = null;
        if (edgeIndex >= 0) {
            ArrayList edges = this.eNodeSelected1.getDigraphNode().getOutEdges();
            ASDDigraphEdge dEdge = (ASDDigraphEdge)((Object)edges.get(edgeIndex));
            eEdge = dEdge.getEditEdge();
        }
        this.deleteEdge(eEdge);
    }

    void deleteInstance(String word, String givenInstance, WordInstanceChooser chooser) {
        if (givenInstance == null) {
            JOptionPane.showMessageDialog(this.window, "An instance/node must be selected for deletion first.");
            return;
        }
        ASDDigraphNode dNode = this.getGrammarDigraph().lookupNode(word, givenInstance);
        if (dNode.inDegree() > 0 || dNode.outDegree() > 0) {
            JOptionPane.showMessageDialog(this.window, "All edges connected with the node must be deleted first");
            return;
        }
        ASDEditNode eNode = dNode.getEditNode();
        boolean eNodeDeleted = this.deleteNode(eNode);
        if (eNodeDeleted) {
            chooser.setWordSelected(word, true);
        }
    }

    private void deleteNode(ASDDigraphNode dNode) {
        if (dNode == null) {
            JOptionPane.showMessageDialog(this.window, "A serious error has occurred in ASDEditor.deleteNode(ASDDigraphNode).\nPlease inform jmason@yorku.ca of this error.");
        } else {
            this.grammarDigraph.removeNode(dNode);
            this.setGrammarChanged(true);
            this.window.choosersChanged();
        }
    }

    boolean deleteNode(ASDEditNode eNode) {
        if (eNode == null) {
            JOptionPane.showMessageDialog(this.window, "No node (instance) has been selected for deletion.");
            return false;
        }
        ASDDigraphNode dNode = eNode.getDigraphNode();
        if (dNode.inDegree() > 0 || dNode.outDegree() > 0) {
            JOptionPane.showMessageDialog(this.window, "All edges connected with the node must be deleted first");
            return false;
        }
        this.nodeSelected(eNode);
        ASDGrammarNode gNode = eNode.getGrammarNode();
        if (eNode == this.eNodeSelected1) {
            this.eNodeSelected1 = null;
            this.instanceSelected1 = null;
        } else if (this.eNodeSelected1 != null && gNode.word().equals(this.wordSelected1)) {
            if (this.eEdgeSelected != null && (this.eEdgeSelected.getFromNode() == this.eNodeSelected1 || this.eEdgeSelected.getToNode() == this.eNodeSelected1)) {
                this.eEdgeSelected.setSelected(false);
                this.eEdgeSelected.repaint();
                this.eEdgeSelected = null;
            }
            this.eNodeSelected1.setSelected(false);
            this.eNodeSelected1.repaint();
            this.eNodeSelected1 = null;
            this.instanceSelected1 = null;
        }
        if (eNode == this.eNodeSelected2) {
            this.eNodeSelected2 = null;
            this.instanceSelected2 = null;
        } else if (this.eNodeSelected2 != null && gNode.word().equals(this.wordSelected2)) {
            if (this.eEdgeSelected != null && (this.eEdgeSelected.getFromNode() == this.eNodeSelected2 || this.eEdgeSelected.getToNode() == this.eNodeSelected2)) {
                this.eEdgeSelected.setSelected(false);
                this.eEdgeSelected.repaint();
                this.eEdgeSelected = null;
            }
            this.eNodeSelected2.setSelected(false);
            this.eNodeSelected2.repaint();
            this.eNodeSelected2 = null;
            this.instanceSelected2 = null;
        }
        this.netPanel.removeNode(eNode);
        this.deleteNode(eNode.getDigraphNode());
        return true;
    }

    void deleteWord(String word) {
        if (word == null) {
            JOptionPane.showMessageDialog(this.window, "A word must be selected for deletion first.");
            return;
        }
        ArrayList<ASDGrammarNode> wordEntry = this.getGrammar().lookupWord(word);
        if (wordEntry == null) {
            JOptionPane.showMessageDialog(this.window, "\"" + word + "\" is not in the grammar");
            return;
        }
        if (wordEntry.size() > 0) {
            JOptionPane.showMessageDialog(this.window, "All instances of the word must be deleted first.");
            return;
        }
        if (word.equals(this.wordSelected1)) {
            this.wordSelected1 = null;
        }
        if (word.equals(this.wordSelected2)) {
            this.wordSelected2 = null;
        }
        this.getGrammar().lexicon().remove(word);
        this.setGrammarChanged(true);
        this.window.newOrUpdatedGrammar(true);
    }

    private void deselectEdge(boolean updateEdgeList) {
        if (this.eEdgeSelected == null) {
            return;
        }
        this.eEdgeSelected.setSelected(false);
        this.eEdgeSelected.repaint();
        this.eEdgeSelected = null;
        if (updateEdgeList) {
            if (this.eNodeSelected1 != null) {
                this.edgeList = new EdgeList(this, new EdgeListModel(this.eNodeSelected1.getDigraphNode()));
                this.edgeList.getSelectionModel().addListSelectionListener(new EdgeListSelectionListener(this));
                this.setPhraseTypeField(this.eNodeSelected1.getGrammarNode().phraseType());
            } else {
                this.edgeList = new EdgeList(this);
                this.setPhraseTypeField(null);
            }
        }
        this.window.edgeListChanged();
    }

    private void deselectNodeHelp(ASDEditNode eNode) {
        if (eNode == null) {
            return;
        }
        if (this.eEdgeSelected != null) {
            ASDEditNode fromNode = this.eEdgeSelected.getFromNode();
            ASDEditNode toNode = this.eEdgeSelected.getToNode();
            if (eNode == toNode) {
                this.deselectEdge(true);
            } else if (eNode == fromNode) {
                if (fromNode != toNode) {
                    this.deselectEdge(false);
                } else {
                    this.deselectEdge(true);
                }
            }
        }
    }

    void edgeSelected(ASDEditEdge edge) {
        if (this.eEdgeSelected == edge) {
            return;
        }
        if (this.eEdgeSelected != null) {
            this.eEdgeSelected.getModel().setSelected(false);
            this.eEdgeSelected.getModel().setPressed(false);
        }
        this.eEdgeSelected = edge;
        ASDDigraphNode fromDNode = (ASDDigraphNode)this.eEdgeSelected.getDigraphEdge().getFromNode();
        ASDEditNode fromNode = fromDNode.getEditNode();
        ASDDigraphNode toDNode = (ASDDigraphNode)this.eEdgeSelected.getDigraphEdge().getToNode();
        ASDEditNode toNode = toDNode.getEditNode();
        this.rightListButton.doClick();
        if (toNode != this.eNodeSelected2) {
            if (!toNode.isSelected()) {
                this.nodeSelectedIndirectly(toNode);
            } else {
                this.nodeSelected(toNode);
            }
        }
        this.leftListButton.doClick();
        if (fromNode != this.eNodeSelected1) {
            if (fromNode != toNode) {
                this.nodeSelectedIndirectly(fromNode);
            } else {
                this.nodeSelected(fromNode);
            }
        }
        ASDDigraphNode dNode = fromNode.getDigraphNode();
        ArrayList outEdges = dNode.getOutEdges();
        int j = 0;
        for (j = 0; j < dNode.outDegree() && ((ASDDigraphEdge)((Object)outEdges.get(j))).getEditEdge() != this.eEdgeSelected; ++j) {
        }
        this.edgeList.setSelectedValue("" + (j + 1), true);
        this.window.edgeListChanged();
    }

    private void edgeSelectedFromList(ASDEditEdge edge) {
        if (!edge.isSelected()) {
            edge.doClick();
        }
    }

    void editAction(ASDEditNode eNode) {
        ASDGrammarNode gNode;
        if (eNode == null) {
            return;
        }
        this.grammarNodeBeingEdited = gNode = eNode.getGrammarNode();
        this.fieldBeingEdited = "action";
        String semanticAction = gNode.semanticAction();
        if (semanticAction == null) {
            semanticAction = "";
        }
        this.oldTextBeingEdited = semanticAction;
        ASDTextEditorFrame textWindow = new ASDTextEditorFrame(this, semanticAction);
        textWindow.setTitle("Editing semantic ACTION of instance: " + gNode.word() + " " + gNode.instance());
        textWindow.setVisible(true);
    }

    void editAction(String word, String instance) {
        if (word == null || instance == null) {
            JOptionPane.showMessageDialog(this.window, "A particular instance must be selected first");
            return;
        }
        ASDDigraphNode dNode = this.getGrammarDigraph().lookupNode(word, instance);
        ASDEditNode eNode = dNode.getEditNode();
        this.editAction(eNode);
    }

    void editValue(ASDEditNode eNode) {
        if (eNode == null) {
            JOptionPane.showMessageDialog(this.window, "A particular instance must be selected first");
            return;
        }
        ASDGrammarNode gNode = eNode.getGrammarNode();
        if (!gNode.isFinal()) {
            JOptionPane.showMessageDialog(this.window, "The instance is NOT FINAL; so it cannot have a semantic value.");
            return;
        }
        this.grammarNodeBeingEdited = gNode;
        this.fieldBeingEdited = "value";
        String semanticValue = gNode.semanticValue();
        if (semanticValue == null) {
            semanticValue = "";
        }
        this.oldTextBeingEdited = semanticValue;
        ASDTextEditorFrame textWindow = new ASDTextEditorFrame(this, semanticValue);
        textWindow.setTitle("Editing semantic VALUE of instance: " + gNode.word() + " " + gNode.instance());
        textWindow.setVisible(true);
    }

    void editValue(String word, String instance) {
        if (word == null || instance == null) {
            return;
        }
        ASDDigraphNode dNode = this.getGrammarDigraph().lookupNode(word, instance);
        ASDEditNode eNode = dNode.getEditNode();
        this.editValue(eNode);
    }

    void exitEditor() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (this.getGrammarChanged()) {
            if (this.closingGrammar()) {
                this.window.dispose();
                System.exit(0);
            }
        } else {
            this.window.dispose();
            System.exit(0);
        }
    }

    ASDGrammar getGrammar() {
        return this.grammarDigraph.getGrammar();
    }

    ASDDigraph getGrammarDigraph() {
        return this.grammarDigraph;
    }

    JList getEdgeList() {
        return this.edgeList;
    }

    String getInputFileName() {
        return this.inputFileName;
    }

    String getInstanceSelected1() {
        return this.instanceSelected1;
    }

    String getInstanceSelected2() {
        return this.instanceSelected2;
    }

    JPanel getPhraseTypeField() {
        JPanel result = new JPanel();
        JLabel fill = new JLabel("");
        fill.setPreferredSize(this.phraseTypeField.getPreferredSize());
        result.setLayout(new BorderLayout());
        if (this.instanceSelected1 == null) {
            result.add((Component)new JLabel("no left node selected"), "North");
            result.add(fill);
        } else if (this.eNodeSelected1.getGrammarNode().isFinal()) {
            result.add((Component)new JLabel("ends phrase of type  "), "North");
            result.add(this.phraseTypeField);
        } else {
            result.add((Component)new JLabel("left node  is  not  final"), "North");
            result.add(fill);
        }
        return result;
    }

    ASDEditNode getENodeSelected1() {
        return this.eNodeSelected1;
    }

    ASDEditNode getENodeSelected2() {
        return this.eNodeSelected2;
    }

    boolean getGrammarChanged() {
        return this.grammarChanged;
    }

    NetPanel getNetPanel() {
        return this.netPanel;
    }

    ASDEditorFrame getWindow() {
        return this.window;
    }

    String getWordSelected1() {
        return this.wordSelected1;
    }

    String getWordSelected2() {
        return this.wordSelected2;
    }

    private void hideComponentIncluding(ASDEditNode eNode) {
        if (eNode == null) {
            return;
        }
        ASDDigraphNode dNode1 = eNode.getDigraphNode();
        ArrayList connectedNodes = dNode1.connectedNodes();
        for (ASDDigraphNode dNode2 : connectedNodes) {
            ASDEditNode eNode2 = dNode2.getEditNode();
            ArrayList outEdges = dNode2.getOutEdges();
            for (ASDDigraphEdge dEdge : outEdges) {
                ASDEditEdge eEdge = dEdge.getEditEdge();
                if (eEdge == this.eEdgeSelected) {
                    this.eEdgeSelected.setSelected(false);
                    this.eEdgeSelected = null;
                }
                this.netPanel.removeEdge(eEdge);
            }
            ArrayList inEdges = dNode2.getInEdges();
            for (ASDDigraphEdge dEdge : inEdges) {
                ASDEditEdge eEdge = dEdge.getEditEdge();
                if (eEdge == this.eEdgeSelected) {
                    this.eEdgeSelected.setSelected(false);
                    this.eEdgeSelected = null;
                }
                this.netPanel.removeEdge(eEdge);
            }
            this.netPanel.removeNode(eNode2);
        }
        this.netPanel.removeNode(eNode);
        this.netPanel.repaint();
    }

    void hideNonSingletons() {
        ArrayList dNodes = this.grammarDigraph.getNodes();
        for (ASDDigraphNode dNode : dNodes) {
            ASDEditNode eNode;
            if (dNode.isSingleton() || !this.netPanel.isDisplaying(eNode = dNode.getEditNode())) continue;
            this.hideComponentIncluding(eNode);
        }
        boolean choosersChanged = false;
        if (this.eNodeSelected1 != null && !this.eNodeSelected1.isSingleton()) {
            this.eNodeSelected1.setSelected(false);
            this.eNodeSelected1 = null;
            this.instanceSelected1 = null;
            choosersChanged = true;
        }
        if (this.eNodeSelected2 != null && !this.eNodeSelected2.isSingleton()) {
            this.eNodeSelected2.setSelected(false);
            this.eNodeSelected2 = null;
            this.instanceSelected2 = null;
            choosersChanged = true;
        }
        if (choosersChanged) {
            this.window.choosersChanged();
        }
    }

    void hideSelectedComponents() {
        boolean choosersChanged = false;
        if (this.eNodeSelected1 != null) {
            this.hideComponentIncluding(this.eNodeSelected1);
            this.eNodeSelected1.setSelected(false);
            this.eNodeSelected1 = null;
            this.instanceSelected1 = null;
            choosersChanged = true;
        }
        if (this.eNodeSelected2 != null) {
            this.hideComponentIncluding(this.eNodeSelected2);
            this.eNodeSelected2.setSelected(false);
            this.eNodeSelected2 = null;
            this.instanceSelected2 = null;
            choosersChanged = true;
        }
        if (this.eEdgeSelected != null) {
            this.eEdgeSelected.setSelected(false);
            this.eEdgeSelected = null;
            choosersChanged = true;
        }
        if (choosersChanged) {
            this.window.choosersChanged();
        }
    }

    void hideSingletons() {
        ArrayList dNodes = this.grammarDigraph.getNodes();
        for (ASDDigraphNode dNode : dNodes) {
            if (!dNode.isSingleton()) continue;
            this.netPanel.removeNode(dNode.getEditNode());
        }
        this.netPanel.repaint();
        boolean choosersChanged = false;
        if (this.eNodeSelected1 != null && this.eNodeSelected1.isSingleton()) {
            this.eNodeSelected1.setSelected(false);
            this.eNodeSelected1 = null;
            this.instanceSelected1 = null;
            choosersChanged = true;
        }
        if (this.eNodeSelected2 != null && this.eNodeSelected2.isSingleton()) {
            this.eNodeSelected2.setSelected(false);
            this.eNodeSelected2 = null;
            this.instanceSelected2 = null;
            choosersChanged = true;
        }
        if (choosersChanged) {
            this.window.choosersChanged();
        }
    }

    private void loadFile(String fileName) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, URISyntaxException {
        this.inputFileName = fileName;
        boolean successfulLoad = true;
        try {
            this.grammarDigraph = new ASDDigraph(this.inputFileName, (Container)this.netPanel);
        }
        catch (ASDInputException e) {
            JOptionPane.showMessageDialog(this.window, e.getMessage(), "Syntax error in grammar file " + this.inputFileName, 0);
            successfulLoad = false;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.window, this.inputFileName + " not found", "Couldn't load grammar file.", 0);
            successfulLoad = false;
        }
        if (successfulLoad) {
            this.setPhraseTypeField(null);
            this.edgeList = new EdgeList(this);
            this.netPanel = new NetPanel(this);
            this.netPanel.setLayout(null);
            this.netPanel.setPreferredSize(new Dimension(800, 500));
            this.setSelectedNull();
            this.window.newOrUpdatedGrammar(true);
            this.setGrammarChanged(false);
        }
    }

    void loadNewFile() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, URISyntaxException {
        File file = null;
        String newFileName = null;
        boolean oldGrammarClosed = true;
        if (this.grammarChanged) {
            oldGrammarClosed = this.closingGrammar();
        }
        if (oldGrammarClosed) {
            JFileChooser chooser = new JFileChooser(this.currentDirectory);
            chooser.addChoosableFileFilter(new ASDFileFilter());
            int returnValue = chooser.showOpenDialog(this.window);
            if (returnValue == 0) {
                file = chooser.getSelectedFile();
                this.currentDirectory = chooser.getCurrentDirectory();
                newFileName = file.getName();
            }
            if (file != null && newFileName != null) {
                this.loadFile(this.currentDirectory.toString() + File.separator + newFileName);
            }
        }
    }

    void mergeInGrammar() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, URISyntaxException {
        File file = null;
        String newFileName = null;
        JFileChooser chooser = new JFileChooser(this.currentDirectory);
        File directory = null;
        chooser.addChoosableFileFilter(new ASDFileFilter());
        int returnValue = chooser.showOpenDialog(this.window);
        if (returnValue == 0) {
            file = chooser.getSelectedFile();
            directory = chooser.getCurrentDirectory();
            newFileName = file.getName();
        }
        if (file != null && newFileName != null) {
            if (newFileName.equals(this.inputFileName)) {
                JOptionPane.showMessageDialog(this.window, "The grammar file chosen is the same as\nthe one currently open.  They cannot be merged.");
                return;
            }
            this.mergeInGrammar(directory.toString() + File.separator + newFileName);
        }
    }

    void mergeInGrammar(String fileName) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, URISyntaxException {
        boolean successfulLoad = true;
        try {
            this.grammarDigraph.mergeInGrammar(fileName, (Container)this.netPanel);
        }
        catch (ASDInputException e) {
            JOptionPane.showMessageDialog(this.window, e.getMessage(), "Syntax error in grammar file " + fileName, 0);
            successfulLoad = false;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.window, fileName + " not found", "Couldn't load grammar file.", 0);
            successfulLoad = false;
        }
        if (successfulLoad) {
            this.setSelectedNull();
            this.edgeList = new EdgeList(this);
            this.netPanel.clear();
            this.window.newOrUpdatedGrammar(true);
            this.setGrammarChanged(true);
        }
    }

    void newEdgeSelected() {
        int edgeIndex = Integer.parseInt((String)this.edgeList.getSelectedValue()) - 1;
        ArrayList edges = this.eNodeSelected1.getDigraphNode().getOutEdges();
        ASDDigraphEdge dEdge = (ASDDigraphEdge)((Object)edges.get(edgeIndex));
        ASDEditEdge eEdge = dEdge.getEditEdge();
        this.edgeSelectedFromList(eEdge);
    }

    void newGrammar() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        boolean oldGrammarClosed = true;
        if (this.grammarChanged) {
            oldGrammarClosed = this.closingGrammar();
        }
        if (!oldGrammarClosed) {
            return;
        }
        this.grammarDigraph = new ASDDigraph(new ASDGrammar(), (Container)this.netPanel);
        this.inputFileName = DEFAULT_FILE_NAME;
        this.setPhraseTypeField(null);
        this.edgeList = new EdgeList(this);
        this.netPanel = new NetPanel(this);
        this.netPanel.setLayout(null);
        this.netPanel.setPreferredSize(new Dimension(800, 500));
        this.setGrammarChanged(false);
        this.setSelectedNull();
        this.window.newOrUpdatedGrammar(true);
    }

    void nodeSelected(ASDEditNode node) {
        if (this.listSelected == 1) {
            if (this.eNodeSelected1 != null && this.eNodeSelected1 == node) {
                return;
            }
            if (this.eNodeSelected1 != null) {
                this.deselectNodeHelp(this.eNodeSelected1);
                if (this.eNodeSelected1 != this.eNodeSelected2) {
                    this.eNodeSelected1.setSelected(false);
                    this.eNodeSelected1.repaint();
                }
            }
            this.eNodeSelected1 = node;
            this.eNodeSelected1.doClick();
            this.wordSelected1 = node.getGrammarNode().word();
            this.instanceSelected1 = node.getGrammarNode().instance();
            this.chooser1.setWordSelected(this.wordSelected1, false);
            this.chooser1.setInstanceSelected(this.instanceSelected1, false);
            this.edgeList = new EdgeList(this, new EdgeListModel(node.getDigraphNode()));
            this.edgeList.getSelectionModel().addListSelectionListener(new EdgeListSelectionListener(this));
            this.setPhraseTypeField(this.eNodeSelected1.getGrammarNode().phraseType());
            this.window.edgeListChanged();
        } else if (this.listSelected == 2) {
            if (this.eNodeSelected2 != null && this.eNodeSelected2 == node) {
                return;
            }
            if (this.eNodeSelected2 != null) {
                this.deselectNodeHelp(this.eNodeSelected2);
                if (this.eNodeSelected2 != this.eNodeSelected1) {
                    this.eNodeSelected2.setSelected(false);
                    this.eNodeSelected2.repaint();
                }
            }
            this.eNodeSelected2 = node;
            this.eNodeSelected2.doClick();
            this.wordSelected2 = node.getGrammarNode().word();
            this.instanceSelected2 = node.getGrammarNode().instance();
            this.chooser2.setWordSelected(this.wordSelected2, false);
            this.chooser2.setInstanceSelected(this.instanceSelected2, false);
        }
    }

    private void nodeSelectedIndirectly(ASDEditNode node) {
        if (!node.isSelected()) {
            this.nodeSelected(node);
        }
    }

    void phraseTypeFieldChanged() {
        String text = this.phraseTypeField.getText();
        ASDEditNode eNode = this.eNodeSelected1;
        if (eNode == null) {
            return;
        }
        ASDGrammarNode gNode = eNode.getGrammarNode();
        if (!gNode.isFinal()) {
            return;
        }
        gNode.setPhraseType(text);
        eNode.setRightLabel(text);
        this.setGrammarChanged(true);
    }

    void revert() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, URISyntaxException {
        FileReader reader;
        int existsOption;
        if (this.grammarDigraph.numberOfNodes() > 0 && !this.getGrammarChanged()) {
            JOptionPane.showMessageDialog(this.window, "The grammar has not changed since it was last loaded or saved.");
            return;
        }
        if (this.getGrammarChanged() && ((existsOption = JOptionPane.showConfirmDialog(this.window, "The grammar has changed.  Are you sure you want to\nreplace it with the last saved version?")) == 2 || existsOption == 1)) {
            return;
        }
        if (this.inputFileName == null) {
            JOptionPane.showMessageDialog(this.window, "There is no file currently being edited.");
            return;
        }
        try {
            reader = new FileReader(this.inputFileName);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.window, "There is no file with the current file name.");
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setGrammarChanged(false);
        this.loadFile(this.inputFileName);
    }

    void saveAsFile() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, URISyntaxException {
        if (this.grammarDigraph.getGrammar().lexicon().size() == 0) {
            JOptionPane.showMessageDialog(this.window, "There's nothing to save; the grammar is empty.");
            return;
        }
        String fileName = null;
        File file = null;
        File directory = null;
        JFileChooser chooser = new JFileChooser(this.currentDirectory);
        chooser.addChoosableFileFilter(new ASDFileFilter());
        int returnValue = chooser.showSaveDialog(this.window);
        if (returnValue == 0) {
            file = chooser.getSelectedFile();
            directory = chooser.getCurrentDirectory();
            fileName = file.getName();
        }
        if (file != null && fileName != null) {
            if (fileName.equals(this.inputFileName) && directory == this.currentDirectory) {
                this.saveFile(false);
            } else {
                FileReader reader = null;
                try {
                    reader = new FileReader(directory.toString() + File.separator + fileName);
                }
                catch (IOException e) {
                    reader = null;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    int existsOption = JOptionPane.showConfirmDialog(this.window, "Replace existing file with that name?");
                    if (existsOption == 2 || existsOption == 1) {
                        return;
                    }
                }
            }
            File oldDirectory = this.currentDirectory;
            this.currentDirectory = directory;
            String oldFileName = this.inputFileName;
            this.inputFileName = fileName;
            if (this.saveFile(true)) {
                this.loadFile(this.currentDirectory.toString() + File.separator + this.inputFileName);
            } else {
                this.currentDirectory = oldDirectory;
                this.inputFileName = oldFileName;
            }
        }
    }

    boolean saveFile() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return this.saveFile(false);
    }

    boolean saveFile(boolean fileNameChanged) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (this.grammarDigraph.getGrammar().lexicon().size() == 0) {
            JOptionPane.showMessageDialog(this.window, "There's nothing to save; the grammar is empty.");
            return false;
        }
        if (!fileNameChanged && !this.getGrammarChanged()) {
            JOptionPane.showMessageDialog(this.window, "The grammar has not changed since it was last loaded or saved.");
            return false;
        }
        int optimizeOption = JOptionPane.showConfirmDialog(this.window, "Optimize the grammar file for parsing?");
        boolean optimize = true;
        if (optimizeOption == 2) {
            JOptionPane.showMessageDialog(this.window, "The file save has been cancelled.");
            return false;
        }
        if (optimizeOption == 1) {
            optimize = false;
        }
        boolean successfulSave = true;
        try {
            String directory = this.currentDirectory.toString();
            String fullFileName = directory + File.separator + this.inputFileName;
            if (!fileNameChanged) {
                this.grammarDigraph.saveToFile(this.inputFileName, optimize);
            } else {
                this.grammarDigraph.saveToFile(directory + File.separator + this.inputFileName, optimize);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.window, "File name: " + this.inputFileName, "Error trying to save grammar file.", 0);
            successfulSave = false;
        }
        if (successfulSave) {
            this.setGrammarChanged(false);
        }
        return successfulSave;
    }

    void setGrammarChanged(boolean b) {
        this.grammarChanged = b;
    }

    void setListSelected(int listNumber) {
        this.listSelected = listNumber;
    }

    void setPhraseTypeField(String t) {
        if (t != null) {
            this.phraseTypeField.setText(t);
        } else {
            this.phraseTypeField.setText("");
        }
    }

    private void setSelectedNull() {
        this.deselectEdge(false);
        if (this.eNodeSelected1 != null) {
            this.eNodeSelected1.setSelected(false);
            this.eNodeSelected1.repaint();
        }
        if (this.eNodeSelected2 != null && this.eNodeSelected2 != this.eNodeSelected1) {
            this.eNodeSelected2.setSelected(false);
            this.eNodeSelected2.repaint();
        }
        this.eNodeSelected1 = null;
        this.eNodeSelected2 = null;
        this.wordSelected1 = null;
        this.instanceSelected1 = null;
        this.wordSelected2 = null;
        this.instanceSelected1 = null;
        this.setPhraseTypeField(null);
    }

    void showAboutInfo() {
        JOptionPane.showMessageDialog(this.window, "ASDEditor version 1.11\nAuthor: James A. Mason\nEmail: jmason@yorku.ca\nhttp://www.yorku.ca/jmason/");
    }

    void showAll() {
        this.netPanel.clear();
        ArrayList dNodes = this.grammarDigraph.getNodes();
        for (ASDDigraphNode dNode : dNodes) {
            ASDEditNode eNode = dNode.getEditNode();
            this.netPanel.addNode(eNode);
        }
        ArrayList dEdges = this.grammarDigraph.getEdges();
        for (ASDDigraphEdge dEdge : dEdges) {
            ASDEditEdge eEdge = dEdge.getEditEdge();
            this.netPanel.addEdge(eEdge);
        }
    }

    void showAllNonSingletons() {
        ArrayList dNodes = this.grammarDigraph.getNodes();
        for (ASDDigraphNode dNode : dNodes) {
            ASDEditNode eNode;
            if (dNode.isSingleton() || this.netPanel.isDisplaying(eNode = dNode.getEditNode())) continue;
            this.showComponentConnectedTo(eNode);
        }
    }

    void showAllSingletons() {
        ArrayList dNodes = this.grammarDigraph.getNodes();
        for (ASDDigraphNode dNode : dNodes) {
            if (!dNode.isSingleton()) continue;
            ASDEditNode eNode = dNode.getEditNode();
            this.netPanel.addNode(eNode);
        }
        this.netPanel.repaint();
    }

    void showComponentConnectedTo(ASDEditNode eNode) {
        if (this.netPanel.isDisplaying(eNode)) {
            return;
        }
        ASDDigraphNode dNode = eNode.getDigraphNode();
        ArrayList connectedNodes = dNode.connectedNodes();
        for (ASDDigraphNode dNode2 : connectedNodes) {
            ASDEditNode eNode2 = dNode2.getEditNode();
            if (this.netPanel.isDisplaying(eNode2)) continue;
            this.netPanel.addNode(eNode2);
            ArrayList outEdges = dNode2.getOutEdges();
            for (ASDDigraphEdge dEdge : outEdges) {
                ASDEditEdge eEdge = dEdge.getEditEdge();
                this.netPanel.addEdge(eEdge);
            }
            ArrayList inEdges = dNode2.getInEdges();
            for (ASDDigraphEdge dEdge : inEdges) {
                ASDEditEdge eEdge = dEdge.getEditEdge();
                this.netPanel.addEdge(eEdge);
            }
        }
        if (!this.netPanel.isDisplaying(eNode)) {
            this.netPanel.addNode(eNode);
        }
        this.netPanel.repaint();
    }

    boolean toggleFinal(ASDEditNode eNode) {
        ASDGrammarNode gNode = eNode.getGrammarNode();
        this.nodeSelectedIndirectly(eNode);
        if (gNode.isFinal()) {
            gNode.setSuccessors(new ArrayList<ASDGrammarSuccessor>());
            gNode.setSuccessorTypes(null);
            gNode.setSemanticValue(null);
            gNode.setPhraseType(null);
            eNode.setRightLabel(null);
        } else {
            if (gNode.successors().size() > 0) {
                JOptionPane.showMessageDialog(this.window, "All outgoing edges must be deleted first");
                return false;
            }
            String phraseTypeEnded = JOptionPane.showInputDialog(this.window, (Object)"What TYPE of phrase ends at the node?");
            if (phraseTypeEnded != null && (phraseTypeEnded = phraseTypeEnded.trim()).length() == 0) {
                phraseTypeEnded = null;
            }
            if (phraseTypeEnded == null) {
                return false;
            }
            gNode.setSuccessors(null);
            gNode.setSuccessorTypes(null);
            gNode.setSemanticValue("");
            gNode.setPhraseType(phraseTypeEnded);
            if (eNode == this.eNodeSelected1) {
                this.setPhraseTypeField(phraseTypeEnded);
            }
            eNode.setRightLabel(phraseTypeEnded);
        }
        if (this.eNodeSelected1 == eNode) {
            this.window.edgeListChanged();
        }
        this.setGrammarChanged(true);
        return true;
    }

    void toggleFinal(String word, String instance, WordInstanceChooser chooser) {
        if (word == null || instance == null) {
            JOptionPane.showMessageDialog(this.window, "A particular instance must be selected first");
            return;
        }
        ASDDigraphNode dNode = this.getGrammarDigraph().lookupNode(word, instance);
        ASDEditNode eNode = dNode.getEditNode();
        if (this.toggleFinal(eNode)) {
            chooser.setWordSelected(word, true);
            chooser.setInstanceSelected(instance, true);
        }
    }

    void toggleInitial(ASDEditNode eNode) {
        this.nodeSelectedIndirectly(eNode);
        ASDGrammarNode gNode = eNode.getGrammarNode();
        gNode.setBegins(!gNode.isInitial());
        eNode.updateColor();
        eNode.repaint();
        this.setGrammarChanged(true);
    }

    void toggleInitial(String word, String instance, WordInstanceChooser chooser) {
        if (word == null || instance == null) {
            JOptionPane.showMessageDialog(this.window, "A particular instance must be selected first");
            return;
        }
        ASDDigraphNode dNode = this.getGrammarDigraph().lookupNode(word, instance);
        ASDEditNode eNode = dNode.getEditNode();
        this.toggleInitial(eNode);
        chooser.setWordSelected(word, true);
        chooser.setInstanceSelected(instance, true);
    }

    void toggleListSelected() {
        if (this.listSelected == 1) {
            this.rightListButton.doClick();
        } else {
            this.leftListButton.doClick();
        }
    }

    void wordInstanceChooserChanged(WordInstanceChooser chooser) {
        ASDEditNode eNodeSelected = null;
        String wordSelected = chooser.getWordSelected();
        String instanceSelected = chooser.getInstanceSelected();
        if (instanceSelected == null) {
            if (chooser == this.chooser1) {
                this.wordSelected1 = wordSelected;
                this.instanceSelected1 = instanceSelected;
                if (!this.leftListButton.isSelected()) {
                    this.leftListButton.doClick();
                }
                if (this.eNodeSelected1 != null) {
                    this.deselectNodeHelp(this.eNodeSelected1);
                    if (this.eNodeSelected1 != this.eNodeSelected2) {
                        this.eNodeSelected1.setSelected(false);
                        this.eNodeSelected1.repaint();
                    }
                    this.eNodeSelected1 = null;
                }
                this.edgeList = new EdgeList(this);
                this.window.edgeListChanged();
            } else if (chooser == this.chooser2) {
                this.wordSelected2 = wordSelected;
                this.instanceSelected2 = instanceSelected;
                if (!this.rightListButton.isSelected()) {
                    this.rightListButton.doClick();
                }
                if (this.eNodeSelected2 != null) {
                    this.deselectNodeHelp(this.eNodeSelected2);
                    if (this.eNodeSelected2 != this.eNodeSelected1) {
                        this.eNodeSelected2.setSelected(false);
                        this.eNodeSelected2.repaint();
                    }
                    this.eNodeSelected2 = null;
                }
            }
        } else {
            ASDDigraphNode dNode = this.getGrammarDigraph().lookupNode(wordSelected, instanceSelected);
            ASDEditNode eNode = dNode.getEditNode();
            if (!this.netPanel.isDisplaying(eNode)) {
                this.showComponentConnectedTo(eNode);
            }
            if (chooser == this.chooser1) {
                eNodeSelected = this.eNodeSelected1;
                this.wordSelected1 = wordSelected;
                this.instanceSelected1 = instanceSelected;
                this.eNodeSelected1 = eNode;
                if (!this.leftListButton.isSelected()) {
                    this.leftListButton.doClick();
                }
            } else if (chooser == this.chooser2) {
                eNodeSelected = this.eNodeSelected2;
                this.wordSelected2 = wordSelected;
                this.instanceSelected2 = instanceSelected;
                this.eNodeSelected2 = eNode;
                if (!this.rightListButton.isSelected()) {
                    this.rightListButton.doClick();
                }
            }
            if (eNodeSelected != null) {
                this.deselectNodeHelp(eNodeSelected);
                if (eNodeSelected != this.eNodeSelected1 && eNodeSelected != this.eNodeSelected2) {
                    eNodeSelected.setSelected(false);
                    eNodeSelected.repaint();
                }
            }
            if (!eNode.isSelected()) {
                eNode.setSelected(true);
                eNode.repaint();
            }
            if (chooser == this.chooser1) {
                this.edgeList = new EdgeList(this, new EdgeListModel(dNode));
                this.edgeList.getSelectionModel().addListSelectionListener(new EdgeListSelectionListener(this));
                this.setPhraseTypeField(eNode.getGrammarNode().phraseType());
                this.window.edgeListChanged();
            }
        }
    }
}

