/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDEditor;
import asd.EditMenu;
import asd.FileMenu;
import asd.HelpMenu;
import asd.NetPanel;
import asd.ViewMenu;
import asd.WordInstanceChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

class ASDEditorFrame
extends JFrame {
    static final int DEFAULT_FRAME_WIDTH = 800;
    static final int DEFAULT_FRAME_HEIGHT = 600;
    static final int DEFAULT_PANEL_HEIGHT = 1000;
    static final int MAIN_DIVIDER_LOCATION = 120;
    static final int LEFT_DIVIDER_LOCATION = 300;
    static final int TOP_MIDDLE_DIVIDER_LOCATION = 35;
    static final int RIGHT_DIVIDER_LOCATION = 450;
    private final String EDGES_LABEL = " > Edges >";
    private ASDEditor editor;
    private WordInstanceChooser chooser1;
    private WordInstanceChooser chooser2;
    private JScrollPane edgeListScrollPane;
    private JScrollPane panelScrollPane;
    private JPanel radioPanel;
    private JPanel bottomPanel;
    private JSplitPane topLeftSplitPane;
    private JSplitPane topMiddleSplitPane;
    private JSplitPane topSplitPane;
    private JSplitPane mainSplitPane;
    private NetPanel netPanel;

    public ASDEditorFrame(ASDEditor givenEditor, WordInstanceChooser c1, WordInstanceChooser c2, NetPanel panel, JRadioButton button1, JRadioButton button2) {
        this.editor = givenEditor;
        this.chooser1 = c1;
        this.chooser2 = c2;
        this.netPanel = panel;
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        FileMenu fMenu = new FileMenu(this);
        fMenu.setMnemonic(70);
        menuBar.add(fMenu);
        EditMenu eMenu = new EditMenu(this);
        eMenu.setMnemonic(69);
        menuBar.add(eMenu);
        ViewMenu vMenu = new ViewMenu(this);
        vMenu.setMnemonic(86);
        menuBar.add(vMenu);
        HelpMenu hMenu = new HelpMenu(this);
        hMenu.setMnemonic(72);
        menuBar.add(hMenu);
        this.setSize(800, 600);
        this.netPanel.setMinimumSize(new Dimension(800, 1000));
        this.addWindowListener(new WindowCloser(this, this));
        this.setDefaultCloseOperation(2);
        this.radioPanel = new JPanel();
        this.radioPanel.add(new JLabel("Selecting from:"));
        this.radioPanel.add(button1);
        this.radioPanel.add(button2);
        this.newOrUpdatedGrammar(false);
    }

    void choosersChanged() {
        this.chooser1.setGrammar(this.editor.getGrammar());
        this.chooser2.setGrammar(this.editor.getGrammar());
        String word = this.editor.getWordSelected1();
        String instance = "";
        if (word != null) {
            instance = this.editor.getInstanceSelected1();
            if (instance != null) {
                this.chooser1.setWordSelected(word, false);
                this.chooser1.setInstanceSelected(instance, true);
            } else {
                this.chooser1.setWordSelected(word, true);
            }
        }
        if ((word = this.editor.getWordSelected2()) != null) {
            instance = this.editor.getInstanceSelected2();
            if (instance != null) {
                this.chooser2.setWordSelected(word, false);
                this.chooser2.setInstanceSelected(instance, false);
            } else {
                this.chooser2.setWordSelected(word, true);
            }
        }
        this.newOrUpdatedGrammar(true);
    }

    void edgeListChanged() {
        JPanel labeledEdgeList = new JPanel();
        labeledEdgeList.setLayout(new BorderLayout());
        labeledEdgeList.add((Component)new JLabel(" > Edges >"), "North");
        this.edgeListScrollPane = new JScrollPane(this.editor.getEdgeList());
        labeledEdgeList.add(this.edgeListScrollPane);
        this.topMiddleSplitPane = new JSplitPane(0, this.editor.getPhraseTypeField(), labeledEdgeList);
        this.topMiddleSplitPane.setDividerLocation(35);
        this.topLeftSplitPane = new JSplitPane(1, this.chooser1.getGraphic(), this.topMiddleSplitPane);
        this.topLeftSplitPane.setDividerLocation(300);
        this.topSplitPane = new JSplitPane(1, this.topLeftSplitPane, this.chooser2.getGraphic());
        this.topSplitPane.setDividerLocation(450);
        this.mainSplitPane = new JSplitPane(0, this.topSplitPane, this.bottomPanel);
        this.mainSplitPane.setDividerLocation(120);
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        contentPane.add(this.mainSplitPane);
        this.setVisible(true);
    }

    public void newOrUpdatedGrammar(boolean tellEditor) {
        this.setTitle("ASD Grammar Editor (v.1.11): " + this.editor.getInputFileName());
        this.chooser1.setGrammar(this.editor.getGrammar());
        this.chooser2.setGrammar(this.editor.getGrammar());
        String word = this.editor.getWordSelected1();
        String instance = "";
        if (word != null) {
            this.chooser1.setWordSelected(word, tellEditor);
            instance = this.editor.getInstanceSelected1();
            if (instance != null) {
                this.chooser1.setInstanceSelected(instance, tellEditor);
            }
        }
        if ((word = this.editor.getWordSelected2()) != null) {
            this.chooser2.setWordSelected(word, tellEditor);
            instance = this.editor.getInstanceSelected2();
            if (instance != null) {
                this.chooser2.setInstanceSelected(instance, tellEditor);
            }
        }
        this.panelScrollPane = new JScrollPane(this.editor.getNetPanel());
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.add((Component)this.radioPanel, "North");
        this.bottomPanel.add((Component)this.panelScrollPane, "Center");
        this.edgeListChanged();
    }

    ASDEditor getEditor() {
        return this.editor;
    }

    private class WindowCloser
    extends WindowAdapter {
        ASDEditorFrame window;

        public WindowCloser(ASDEditorFrame aSDEditorFrame, ASDEditorFrame w) {
            this.window = w;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ASDEditor editor = this.window.getEditor();
            if (!editor.getGrammarChanged()) {
                System.exit(0);
            }
            try {
                editor.closingWindow();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            System.exit(0);
        }
    }
}

