/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDGrammarNode;
import asd.ASDGrammarReader;
import asd.ASDGrammarSuccessor;
import asd.ASDInputException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ASDGrammar {
    public static String DUMMYWORD = "$$";
    private HashMap<String, ArrayList<ASDGrammarNode>> table;
    private boolean incomingMarked = false;

    public ASDGrammar() {
        this.table = new HashMap();
    }

    public ASDGrammar(String fileName, boolean includeCoords) throws IOException, ASDInputException, MalformedURLException, URISyntaxException {
        ASDGrammarReader reader = null;
        try {
            reader = new ASDGrammarReader(fileName, includeCoords);
        }
        catch (IOException e) {
            System.out.println("File " + fileName + " could not be opened.");
            throw e;
        }
        this.table = reader.getGrammar();
        reader.close();
        this.incomingMarked = false;
    }

    public ASDGrammar(String fileName, boolean includeCoords, boolean markIncoming) throws IOException, ASDInputException, MalformedURLException, URISyntaxException {
        this(fileName, includeCoords);
        if (markIncoming) {
            this.markNodesWithIncomingEdges();
        }
    }

    void computeSuccessorTypes() {
        Set<String> typesRecognized = this.phraseTypes();
        Set<Map.Entry<String, ArrayList<ASDGrammarNode>>> entrySet = this.table.entrySet();
        for (Map.Entry<String, ArrayList<ASDGrammarNode>> e : entrySet) {
            ArrayList<ASDGrammarNode> instances = e.getValue();
            for (ASDGrammarNode gNode : instances) {
                if (gNode.isFinal()) {
                    gNode.setSuccessorTypes(null);
                    continue;
                }
                ArrayList<ASDGrammarSuccessor> successors = gNode.successors();
                HashSet<String> successorTypes = new HashSet<String>(successors.size());
                for (ASDGrammarSuccessor s : successors) {
                    String word = s.getWord();
                    if (!typesRecognized.contains(word)) continue;
                    successorTypes.add(word);
                }
                gNode.setSuccessorTypes(new ArrayList<String>(successorTypes));
            }
        }
    }

    public HashMap<String, ArrayList<ASDGrammarNode>> lexicon() {
        return this.table;
    }

    public ASDGrammarNode lookupInstance(ASDGrammarSuccessor successor) {
        ASDGrammarNode result = successor.getNode();
        if (result != null) {
            return result;
        }
        ArrayList<ASDGrammarNode> instances = this.lookupWord(successor.getWord());
        if (instances == null) {
            return null;
        }
        String instanceSought = successor.getInstance();
        for (int j = 0; j < instances.size(); ++j) {
            result = instances.get(j);
            if (!result.instance().equals(instanceSought)) continue;
            successor.setNode(result);
            return result;
        }
        return null;
    }

    public ArrayList<ASDGrammarNode> lookupWord(String word) {
        return this.table.get(word);
    }

    public void markNodesWithIncomingEdges() {
        Set<Map.Entry<String, ArrayList<ASDGrammarNode>>> entrySet = this.table.entrySet();
        for (Map.Entry<String, ArrayList<ASDGrammarNode>> e : entrySet) {
            ArrayList<ASDGrammarNode> instances = e.getValue();
            if (instances == null) continue;
            for (ASDGrammarNode gNode : instances) {
                ArrayList<ASDGrammarSuccessor> successors;
                if (gNode.isFinal() || (successors = gNode.successors()) == null) continue;
                for (ASDGrammarSuccessor s : successors) {
                    ASDGrammarNode successorNode = this.lookupInstance(s);
                    if (successorNode != null) {
                        successorNode.setHasIncoming(true);
                        continue;
                    }
                    System.out.println("(" + e.getKey() + " " + gNode.instance() + ") has edge to non-existent node (" + s.getWord() + " " + s.getInstance() + ").");
                }
            }
        }
        this.incomingMarked = true;
    }

    public boolean nodesWithIncomingEdgesMarked() {
        return this.incomingMarked;
    }

    public Set<String> phraseTypes() {
        HashSet<String> result = new HashSet<String>();
        Set<Map.Entry<String, ArrayList<ASDGrammarNode>>> entrySet = this.table.entrySet();
        for (Map.Entry<String, ArrayList<ASDGrammarNode>> e : entrySet) {
            ArrayList<ASDGrammarNode> instances = e.getValue();
            for (ASDGrammarNode gNode : instances) {
                String phraseType = gNode.phraseType();
                if (phraseType == null) continue;
                result.add(phraseType);
            }
        }
        return result;
    }

    public static void setDUMMYWORD(String newValue) {
        DUMMYWORD = newValue;
    }

    public void setNodesWithIncomingEdgesNotMarked() {
        this.incomingMarked = false;
    }

    public boolean uniqueInstance(String word) {
        ArrayList<ASDGrammarNode> wordEntry = this.lookupWord(word);
        return wordEntry != null && wordEntry.size() == 1;
    }
}

