/*
 * Decompiled with CFR 0.152.
 */
package asd;

import asd.ASDGrammarSuccessor;
import java.util.ArrayList;
import java.util.Iterator;

public class ASDGrammarNode {
    private static final int BUFFER_CAPACITY = 80;
    protected String nodeWord;
    protected String nodeInstance;
    protected boolean nodeBegins;
    protected ArrayList<String> nodeBeginsTypes;
    protected ArrayList<ASDGrammarSuccessor> nodeSuccessors;
    protected ArrayList<String> nodeSuccessorTypes;
    protected String nodePhraseType;
    protected String nodeSemanticValue;
    protected String nodeSemanticAction;
    protected short xCoordinate;
    protected short yCoordinate;
    protected boolean hasIncoming = false;

    public ASDGrammarNode(String word, String instance, boolean begins, ArrayList<String> beginsTypes, ArrayList<ASDGrammarSuccessor> successors, ArrayList<String> successorTypes, String phraseType, String semanticValue, String semanticAction) {
        this.nodeWord = word;
        this.nodeInstance = instance;
        this.nodeBegins = begins;
        this.nodeBeginsTypes = beginsTypes;
        this.nodeSuccessors = successors;
        this.nodeSuccessorTypes = successorTypes;
        this.nodePhraseType = phraseType;
        this.nodeSemanticValue = semanticValue;
        this.nodeSemanticAction = semanticAction;
        this.xCoordinate = 0;
        this.yCoordinate = 0;
    }

    public ArrayList<String> beginsTypes() {
        if (this.nodeBegins) {
            return this.nodeBeginsTypes;
        }
        return null;
    }

    public short getXCoordinate() {
        return this.xCoordinate;
    }

    public short getYCoordinate() {
        return this.yCoordinate;
    }

    public String instance() {
        return this.nodeInstance;
    }

    public boolean isFinal() {
        return this.nodeSuccessors == null;
    }

    public boolean isInitial() {
        return this.nodeBegins;
    }

    public String phraseType() {
        if (this.isFinal()) {
            return this.nodePhraseType;
        }
        return null;
    }

    public String semanticAction() {
        return this.nodeSemanticAction;
    }

    public String semanticValue() {
        return this.nodeSemanticValue;
    }

    public ArrayList<ASDGrammarSuccessor> successors() {
        return this.nodeSuccessors;
    }

    public ArrayList<String> successorTypes() {
        return this.nodeSuccessorTypes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean optimize) {
        StringBuffer buffer = new StringBuffer(80);
        buffer.append("  (").append(this.instance()).append(' ');
        if (this.isInitial()) {
            ArrayList<String> beginsTypes = this.beginsTypes();
            if (!optimize || beginsTypes == null) {
                buffer.append("T ");
            } else {
                buffer.append('(');
                Iterator<String> j = beginsTypes.iterator();
                while (j.hasNext()) {
                    buffer.append(j.next());
                    if (!j.hasNext()) continue;
                    buffer.append(' ');
                }
                buffer.append(") ");
            }
        } else {
            buffer.append("nil ");
        }
        if (this.isFinal()) {
            buffer.append(this.phraseType());
            String value = this.semanticValue();
            buffer.append(" '");
            if (value != null && value.length() > 0) {
                buffer.append(value);
            }
            buffer.append("' ");
        } else {
            buffer.append('(');
            Iterator<Object> it = this.successors().iterator();
            while (it.hasNext()) {
                ASDGrammarSuccessor s = it.next();
                buffer.append('(').append(s.getWord()).append(' ').append(s.getInstance()).append(' ').append(s.getXCoordinate()).append(' ').append(s.getYCoordinate()).append(')');
                if (!it.hasNext()) continue;
                buffer.append(' ');
            }
            buffer.append(')');
            if (optimize) {
                buffer.append(" (");
                it = this.successorTypes().iterator();
                while (it.hasNext()) {
                    buffer.append((String)it.next());
                    if (!it.hasNext()) continue;
                    buffer.append(' ');
                }
                buffer.append(") ");
            } else if (this.successorTypes().size() > 0) {
                buffer.append(" T ");
            } else {
                buffer.append(" nil ");
            }
        }
        String action = this.semanticAction();
        buffer.append('\'');
        if (action != null && action.length() > 0) {
            buffer.append(action);
        }
        buffer.append("' ");
        buffer.append(this.getXCoordinate()).append(' ').append(this.getYCoordinate());
        buffer.append(")\n");
        return buffer.toString();
    }

    public String word() {
        return this.nodeWord;
    }

    boolean hasIncomingEdges() {
        return this.hasIncoming;
    }

    void setBegins(boolean begins) {
        this.nodeBegins = begins;
    }

    void setBeginsTypes(ArrayList<String> beginsTypes) {
        this.nodeBeginsTypes = beginsTypes;
    }

    void setHasIncoming(boolean has) {
        this.hasIncoming = has;
    }

    void setInstance(String instance) {
        this.nodeInstance = instance;
    }

    void setPhraseType(String phraseType) {
        this.nodePhraseType = phraseType;
    }

    void setSemanticAction(String semanticAction) {
        this.nodeSemanticAction = semanticAction;
    }

    void setSemanticValue(String semanticValue) {
        this.nodeSemanticValue = semanticValue;
    }

    void setSuccessors(ArrayList<ASDGrammarSuccessor> successors) {
        this.nodeSuccessors = successors;
    }

    void setSuccessorTypes(ArrayList<String> successorTypes) {
        this.nodeSuccessorTypes = successorTypes;
    }

    void setWord(String word) {
        this.nodeWord = word;
    }

    void setXCoordinate(short x) {
        this.xCoordinate = x;
    }

    void setYCoordinate(short y) {
        this.yCoordinate = y;
    }
}

